/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.T4PartnerPair;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.PatchInstallFailedException;
import com.sun.patchpro.manipulators.SunOSRmtT4ControllerInstallerPrtl;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.util.InteractiveSessionException;
import com.sun.patchpro.util.LineParser;
import com.sun.patchpro.util.TelnetSession;
import java.util.Enumeration;
import java.util.Vector;

public class SunOSRmtT4PPOSImageInstaller
extends SunOSRmtT4ControllerInstallerPrtl {
    private LineParser lp = new LineParser();
    private T4PartnerPair t4PartnerPair = null;
    private PatchID patchID = null;
    private String lastSetOfSessionMessages = null;

    public SunOSRmtT4PPOSImageInstaller(Manipulator manipulator, PatchProProperties patchProProperties) throws InstallFailedException {
        super(manipulator, patchProProperties);
        this.t4PartnerPair = (T4PartnerPair)manipulator.getHost();
    }

    public void install() {
        block13: {
            this.initializeProgress(0.0, 5.0);
            try {
                System.gc();
                this.patchDirectoryFile = this.extractPatch();
            }
            catch (Exception exception) {
                this.log.printStackTrace(this, 2, exception);
                this.issueFail(new PatchInstallFailedException(57));
                return;
            }
            this.incrementProgress(1.0);
            try {
                if (this.debug) {
                    System.out.println("Install command procedure for 6120 partner pair at " + this.t4PartnerPair.getMasterControllerIP());
                    try {
                        this.patchID = this.getPatchIDByFWVersion(this.properties.getProperty("patchpro.T4PP.controller.package", "SUNWc6120"), this.getFirmwareVersion());
                        this.setAuditRecordData(this.patchID, this.getHardwareComponentsToUpdate());
                    }
                    catch (InteractiveSessionException interactiveSessionException) {
                        // empty catch block
                    }
                    this.incrementProgress(3.0);
                    break block13;
                }
                try {
                    this.patchID = this.getPatchIDByFWVersion(this.properties.getProperty("patchpro.T4PP.controller.package", "SUNWc6120"), this.getFirmwareVersion());
                    System.gc();
                    this.getControllerFirmwareImages();
                }
                catch (InteractiveSessionException interactiveSessionException) {
                    this.incrementProgress(3.0);
                    throw new InteractiveSessionException(interactiveSessionException.getMessage());
                }
                this.incrementProgress(1.0);
                try {
                    System.gc();
                    this.uploadFirmwareImages(this.t4PartnerPair.getMasterControllerIP());
                }
                catch (InteractiveSessionException interactiveSessionException) {
                    this.incrementProgress(2.0);
                    throw new InteractiveSessionException(interactiveSessionException.getMessage());
                }
                this.incrementProgress(1.0);
                try {
                    System.gc();
                    this.applyControllerFirmwareImages(this.t4PartnerPair.getMasterControllerIP());
                }
                catch (InteractiveSessionException interactiveSessionException) {
                    this.incrementProgress(1.0);
                    throw new InteractiveSessionException(interactiveSessionException.getMessage());
                }
                this.incrementProgress(1.0);
                System.gc();
                this.applyLoopCardFirmwareImages(this.t4PartnerPair.getMasterControllerIP());
                this.setAuditRecordData(this.patchID, this.getHardwareComponentsToUpdate());
            }
            catch (InteractiveSessionException interactiveSessionException) {
                System.gc();
                this.log.printStackTrace(this, 2, interactiveSessionException);
                this.issueFail(new PatchInstallFailedException(interactiveSessionException.getMessage()));
                System.out.println("Interactive Session Diagnostic Messages:\n" + interactiveSessionException.getMessage());
            }
        }
        this.incrementProgress(1.0);
    }

    private void applyControllerFirmwareImages(String string) throws InteractiveSessionException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        Enumeration enumeration = null;
        HardwareComponent hardwareComponent = null;
        Vector<String> vector = new Vector<String>();
        if (this.getControllerImage() != null && this.getLevel2Image() != null) {
            TelnetSession telnetSession = null;
            try {
                enumeration = this.getHardwareComponentsToUpdate();
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        hardwareComponent = (HardwareComponent)enumeration.nextElement();
                        vector.addElement(hardwareComponent.getLocator());
                    }
                    if (!(vector.contains("u1ctr") || vector.contains("u2ctr") || vector.contains("u3ctr") || vector.contains("u4ctr"))) {
                        return;
                    }
                    if (!vector.contains("u1ctr")) {
                        throw new Exception("Unable to continue with the automated process to upgrade the controllers since u1ctr was not recommended for upgrade");
                    }
                    if (!(vector.contains("u1ctr") && vector.contains("u2ctr") || vector.contains("u1ctr") && vector.contains("u3ctr") || vector.contains("u1ctr") && vector.contains("u4ctr"))) {
                        throw new Exception("Unable to continue with the automated process to upgrade the controllers since an unrecognized controller pair was detected.");
                    }
                }
                n = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.setautomode.controller.limit", "300")));
                n4 = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.downloadl1fw.controller.limit", "600")));
                n3 = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.downloadl2fw.controller.limit", "600")));
                n2 = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.downloadl3fw.controller.limit", "600")));
                string2 = this.properties.getProperty("patchpro.userid", "root");
                telnetSession = this.getInstanceOfTelnetSession(string, string2, string3 = this.getPassword(string));
                if (telnetSession == null) {
                    throw new InteractiveSessionException("Unable to establish a telnet session with host " + string);
                }
                if (!telnetSession.expectedResponse("set bootmode auto\r", "<2>", n)) {
                    this.lastSetOfSessionMessages = telnetSession.getAllSessionMessages();
                    if (!this.isPatternFound("<2>", this.lastSetOfSessionMessages)) {
                        this.log.println(this, 2, "The amount of time reserved to set the bootmode to auto has expired.");
                        throw new Exception("Expected : \"<2>\" prompt not detected after \"set bootmode auto\" issued.\n\nSession output:\n" + this.lastSetOfSessionMessages);
                    }
                }
                if (!telnetSession.expectedResponse("cd /\r", "<3>", 5000)) {
                    this.lastSetOfSessionMessages = telnetSession.getAllSessionMessages();
                    if (!this.isPatternFound("<3>", this.lastSetOfSessionMessages)) {
                        this.log.println(this, 2, "Cannot change to theroot directory.");
                        throw new Exception("Cannot change to the root directory to learn if the firmware image file exists to upgrade controllers.\n\nSession output:\n" + this.lastSetOfSessionMessages);
                    }
                }
                if (!telnetSession.expectedResponse("ls\r", this.getControllerImage(), 5000)) {
                    this.lastSetOfSessionMessages = telnetSession.getAllSessionMessages();
                    if (!this.isPatternFound(this.getControllerImage(), this.lastSetOfSessionMessages)) {
                        this.log.println(this, 2, "The controller image that was uploaded is not present on the storage array.");
                        throw new Exception(this.getControllerImage() + " image was not found." + "\n\nSession output:\n" + this.lastSetOfSessionMessages);
                    }
                }
                if (!telnetSession.expectedResponse("ls\r", this.getLevel2Image(), 5000)) {
                    this.lastSetOfSessionMessages = telnetSession.getAllSessionMessages();
                    if (!this.isPatternFound(this.getLevel2Image(), this.lastSetOfSessionMessages)) {
                        this.log.println(this, 2, "The level 2 image that was uploaded is not present on the storage array.");
                        throw new Exception(this.getLevel2Image() + " image was not found." + "\n\nSession output:\n" + this.lastSetOfSessionMessages);
                    }
                }
                if (!telnetSession.expectedResponse("ep download " + this.getControllerImage() + "\r", "<6>", n2)) {
                    this.lastSetOfSessionMessages = telnetSession.getAllSessionMessages();
                    if (!this.isPatternFound("<6>", this.lastSetOfSessionMessages)) {
                        this.log.println(this, 2, "The amount of time reserved to set the boot image via \"ep download <image>\" has expired");
                        throw new Exception("Expected : \"<6>\" prompt not detected after \"ep download " + this.getControllerImage() + "\" issued." + "\n\nSession output:\n" + this.lastSetOfSessionMessages);
                    }
                }
                if (telnetSession.getAllSessionMessages().indexOf("failed") != -1) {
                    this.log.println(this, 2, "ep download " + this.getControllerImage() + " did not complete successfully");
                    throw new Exception("Could not write EPROM image to controller.\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                }
                if (!telnetSession.expectedResponse("ep download " + this.getLevel2Image() + "\r", "<7>", n3)) {
                    this.lastSetOfSessionMessages = telnetSession.getAllSessionMessages();
                    if (!this.isPatternFound("<7>", this.lastSetOfSessionMessages)) {
                        this.log.println(this, 2, "The amount of time reserved to set the boot image via \"ep download <image>\" has expired");
                        throw new Exception("Expected : \"<7>\" prompt not detected after \"ep download " + this.getLevel2Image() + "\" issued." + "\n\nSession output:\n" + this.lastSetOfSessionMessages);
                    }
                }
                if (telnetSession.getAllSessionMessages().indexOf("failed") != -1) {
                    this.log.println(this, 2, "ep download " + this.getLevel2Image() + " did not complete successfully");
                    throw new Exception("Could not write EPROM image to controller.\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                }
                int n5 = 8;
                if (this.getLevel1Image() != null) {
                    if (!telnetSession.expectedResponse("ls\r", this.getLevel1Image(), 5000)) {
                        this.lastSetOfSessionMessages = telnetSession.getAllSessionMessages();
                        if (!this.isPatternFound(this.getLevel1Image(), this.lastSetOfSessionMessages)) {
                            this.log.println(this, 2, "The level 1 image that was uploaded is not present on the storage array.");
                            throw new Exception(this.getLevel1Image() + " image was not found." + "\n\nSession output:\n" + this.lastSetOfSessionMessages);
                        }
                    }
                    if (!telnetSession.expectedResponse("ep download " + this.getLevel1Image() + "\r", "<" + ++n5 + ">", n4)) {
                        this.lastSetOfSessionMessages = telnetSession.getAllSessionMessages();
                        if (!this.isPatternFound("<" + n5 + ">", this.lastSetOfSessionMessages)) {
                            this.log.println(this, 2, "The amount of time reserved to set the boot image via \"ep download <image>\" has expired");
                            throw new Exception("Expected : \"<" + n5 + ">" + "\" prompt not detected after \"ep download " + this.getLevel1Image() + "\" issued." + "\n\nSession output:\n" + this.lastSetOfSessionMessages);
                        }
                    }
                    if (telnetSession.getAllSessionMessages().indexOf("failed") != -1) {
                        this.log.println(this, 2, "ep download " + this.getLevel1Image() + " did not complete successfully");
                        throw new Exception("Could not write EPROM image to controller.\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                    }
                    ++n5;
                }
                if (!telnetSession.expectedResponse("sys stat\r", "<" + n5 + ">", 5000)) {
                    this.log.println(this, 2, "Cannot issue the \"sys stat\" command to to view controller master/altMaster assignments.");
                    throw new Exception("Unable to reboot system because the \"sys stat\" command is not functional.\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                }
                string4 = telnetSession.getSessionMessages();
                string5 = this.getLine("ONLINE     Master", string4);
                if (string5 != null) {
                    string6 = this.lp.getTokenNumberFromLeft(string5, 0);
                    this.log.println(this, 7, "The Master Unit is u" + string6);
                    string5 = this.getLine("ONLINE     AlterM", string4);
                    if (string5 == null) {
                        this.log.println(this, 2, "Cannot reboot the storage array since the Alternate Master controller is not ONLINE.");
                        throw new Exception("The Alternate Master is not ONLINE. Cannot reboot Partner Pair.\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                    }
                } else {
                    this.log.println(this, 2, "Cannot reboot the storage array since the Master controller is not ONLINE.");
                    throw new Exception("Master controller is not online. Cannot reboot Partner Pair.\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                }
                string7 = this.lp.getTokenNumberFromLeft(string5, 0);
                this.log.println(this, 7, "The Alternate Master Unit is u" + string7);
                telnetSession.disconnect();
                telnetSession = null;
                this.failOverMaster(string6, string, string2, string3);
                this.failOverMaster(string7, string, string2, string3);
            }
            catch (Exception exception) {
                this.log.printStackTrace(this, 2, exception);
                this.incrementProgress(1.0);
                throw new InteractiveSessionException(exception.getMessage());
            }
            finally {
                if (telnetSession != null) {
                    telnetSession.disconnect();
                }
            }
        }
    }
}

