/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.PatchInstallFailedException;
import com.sun.patchpro.manipulators.SunOSRmtT4DiskDriveInstallerPrtl;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.util.InteractiveSessionException;

public class SunOSRmtT4PPFujitsuFirmwareInstaller
extends SunOSRmtT4DiskDriveInstallerPrtl {
    public SunOSRmtT4PPFujitsuFirmwareInstaller(Manipulator manipulator, PatchProProperties patchProProperties) throws InstallFailedException {
        super(manipulator, patchProProperties);
    }

    public void install() {
        block10: {
            this.initializeProgress(0.0, 4.0);
            try {
                this.patchDirectoryFile = this.extractPatch();
            }
            catch (Exception exception) {
                this.log.printStackTrace(this, 2, exception);
                this.issueFail(new PatchInstallFailedException(57));
                return;
            }
            this.incrementProgress(1.0);
            try {
                if (this.debug) {
                    System.out.println("Apply disk drive command procedure for 6120 partner pair at " + this.manipulator.getHost().getAddress());
                    this.incrementProgress(2.0);
                    break block10;
                }
                PatchID patchID = null;
                System.out.println("Preparing Fujitsu disk firmware update.");
                System.gc();
                try {
                    this.getDiskDriveFirmwareImages();
                    String[] stringArray = this.getListOfFirmwareVersions(this.getRIDProvided());
                    for (int i = 0; i < stringArray.length && (patchID = this.getPatchIDByFWVersion(this.getDiskDrivePackage(this.getRIDProvided()), stringArray[i])) == null; ++i) {
                    }
                }
                catch (InteractiveSessionException interactiveSessionException) {
                    this.incrementProgress(2.0);
                    throw new InteractiveSessionException(interactiveSessionException.getMessage());
                }
                this.incrementProgress(1.0);
                System.out.println("Start Fujitsu disk firmware update.");
                try {
                    System.out.println("Uploading firmware to 6120.");
                    System.gc();
                    this.uploadFirmwareImages(this.manipulator.getHost().getAddress());
                }
                catch (InteractiveSessionException interactiveSessionException) {
                    this.incrementProgress(1.0);
                    throw new InteractiveSessionException(interactiveSessionException.getMessage());
                }
                this.incrementProgress(1.0);
                System.out.println("Updating disks.");
                System.gc();
                this.applyDiskDriveFirmwareImage(this.manipulator.getHost().getAddress());
                this.setAuditRecordData(patchID, this.getHardwareComponentsToUpdate());
            }
            catch (InteractiveSessionException interactiveSessionException) {
                this.log.printStackTrace(this, 2, interactiveSessionException);
                this.issueFail(new PatchInstallFailedException(interactiveSessionException.getMessage()));
            }
        }
        this.incrementProgress(1.0);
    }
}

