/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.PatchInstallFailedException;
import com.sun.patchpro.manipulators.SunOSRmtT4ControllerInstallerPrtl;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.util.InteractiveSessionException;
import com.sun.patchpro.util.TelnetSession;
import java.util.Enumeration;
import java.util.Vector;

public class SunOSRmtT4OSImageInstaller
extends SunOSRmtT4ControllerInstallerPrtl {
    private PatchID patchID = null;
    private String lastSetOfSessionMessages = null;

    public SunOSRmtT4OSImageInstaller(Manipulator manipulator, PatchProProperties patchProProperties) throws InstallFailedException {
        super(manipulator, patchProProperties);
    }

    public void install() {
        block11: {
            this.initializeProgress(0.0, 5.0);
            try {
                this.patchDirectoryFile = this.extractPatch();
            }
            catch (Exception exception) {
                this.log.printStackTrace(this, 2, exception);
                this.issueFail(new PatchInstallFailedException(57));
                return;
            }
            this.incrementProgress(1.0);
            try {
                if (this.debug) {
                    System.out.println("Install command procedure for 6120 single brick at " + this.manipulator.getHost().getAddress());
                    try {
                        this.patchID = this.getPatchIDByFWVersion(this.properties.getProperty("patchpro.T4.controller.package", "SUNWc6120"), this.getFirmwareVersion());
                    }
                    catch (InteractiveSessionException interactiveSessionException) {
                        // empty catch block
                    }
                    this.incrementProgress(3.0);
                    break block11;
                }
                try {
                    this.patchID = this.getPatchIDByFWVersion(this.properties.getProperty("patchpro.T4.controller.package", "SUNWc6120"), this.getFirmwareVersion());
                    this.getControllerFirmwareImages();
                }
                catch (InteractiveSessionException interactiveSessionException) {
                    this.incrementProgress(3.0);
                    throw new InteractiveSessionException(interactiveSessionException.getMessage());
                }
                this.incrementProgress(1.0);
                try {
                    this.uploadFirmwareImages(this.manipulator.getHost().getAddress());
                }
                catch (InteractiveSessionException interactiveSessionException) {
                    this.incrementProgress(2.0);
                    throw new InteractiveSessionException(interactiveSessionException.getMessage());
                }
                this.incrementProgress(1.0);
                this.applyControllerFirmwareImages(this.manipulator.getHost().getAddress());
                this.incrementProgress(1.0);
                this.applyLoopCardFirmwareImages(this.manipulator.getHost().getAddress());
                this.setAuditRecordData(this.patchID, this.getHardwareComponentsToUpdate());
            }
            catch (InteractiveSessionException interactiveSessionException) {
                this.log.printStackTrace(this, 2, interactiveSessionException);
                this.issueFail(new PatchInstallFailedException(interactiveSessionException.getMessage()));
                System.out.println("Interactive Session Diagnostic Messages:\n" + interactiveSessionException.getMessage());
            }
        }
        this.incrementProgress(1.0);
    }

    private void applyControllerFirmwareImages(String string) throws InteractiveSessionException {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        Object var10_10 = null;
        Object var11_11 = null;
        Object var12_12 = null;
        boolean bl3 = false;
        Enumeration enumeration = null;
        HardwareComponent hardwareComponent = null;
        Vector<String> vector = new Vector<String>();
        enumeration = this.getHardwareComponentsToUpdate();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                hardwareComponent = (HardwareComponent)enumeration.nextElement();
                vector.addElement(hardwareComponent.getLocator());
            }
            if (!vector.contains("u1ctr")) {
                return;
            }
        }
        if (this.getControllerImage() != null && this.getLevel2Image() != null) {
            TelnetSession telnetSession = null;
            try {
                n = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.setautomode.controller.limit", "300")));
                n4 = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.downloadl1fw.controller.limit", "600")));
                n3 = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.downloadl2fw.controller.limit", "600")));
                n2 = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.downloadl3fw.controller.limit", "600")));
                string2 = this.properties.getProperty("patchpro.userid", "root");
                string3 = this.getPassword(string);
                telnetSession = this.getInstanceOfTelnetSession(string, string2, string3);
                if (telnetSession == null) {
                    throw new InteractiveSessionException("Unable to establish a telnet session with host " + string);
                }
                if (!telnetSession.expectedResponse("set bootmode auto\r", "<2>", n)) {
                    this.lastSetOfSessionMessages = telnetSession.getAllSessionMessages();
                    if (!this.isPatternFound("<2>", this.lastSetOfSessionMessages)) {
                        this.log.println(this, 2, "The amount of time reserved to set the bootmode to auto has expired.");
                        throw new Exception("Expected : \"<2>\" prompt not detected after \"set bootmode auto\" issued.\n\nSession output:\n" + this.lastSetOfSessionMessages);
                    }
                }
                if (!telnetSession.expectedResponse("cd /\r", "<3>", 10000)) {
                    this.lastSetOfSessionMessages = telnetSession.getAllSessionMessages();
                    if (!this.isPatternFound("<3>", this.lastSetOfSessionMessages)) {
                        this.log.println(this, 2, "Cannot change to theroot directory.");
                        throw new Exception("Cannot change to the root directory to learn if the firmware image file exists to upgrade controller related firmware.\n\nSession output:\n" + this.lastSetOfSessionMessages);
                    }
                }
                if (!telnetSession.expectedResponse("ls\r", this.getControllerImage(), 5000)) {
                    this.lastSetOfSessionMessages = telnetSession.getAllSessionMessages();
                    if (!this.isPatternFound(this.getControllerImage(), this.lastSetOfSessionMessages)) {
                        this.log.println(this, 2, "The controller image that was uploaded is not present on the storage array.");
                        throw new Exception(this.getControllerImage() + " image was not found." + "\n\nSession output:\n" + this.lastSetOfSessionMessages);
                    }
                }
                if (!telnetSession.expectedResponse("ls\r", this.getLevel2Image(), 5000)) {
                    this.lastSetOfSessionMessages = telnetSession.getAllSessionMessages();
                    if (!this.isPatternFound(this.getLevel2Image(), this.lastSetOfSessionMessages)) {
                        this.log.println(this, 2, "The level2 image that was uploaded is not present on the storage array.");
                        throw new Exception(this.getLevel2Image() + " image was not found." + "\n\nSession output:\n" + this.lastSetOfSessionMessages);
                    }
                }
                if (!telnetSession.expectedResponse("ep download " + this.getControllerImage() + "\r", "<6>", n2)) {
                    this.lastSetOfSessionMessages = telnetSession.getAllSessionMessages();
                    if (!this.isPatternFound("<6>", this.lastSetOfSessionMessages)) {
                        this.log.println(this, 2, "The amount of time reserved to set the boot image via \"ep download <image>\" has expired");
                        throw new Exception("Expected : \"<6>\" prompt not detected after \"ep download " + this.getControllerImage() + "\" issued." + "\n\nSession output:\n" + this.lastSetOfSessionMessages);
                    }
                }
                if (telnetSession.getAllSessionMessages().indexOf("failed") != -1) {
                    this.log.println(this, 2, "ep download " + this.getControllerImage() + " did not complete successfully");
                    throw new Exception("Could not write EPROM image to controller.\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                }
                if (!telnetSession.expectedResponse("ep download " + this.getLevel2Image() + "\r", "<7>", n3)) {
                    this.lastSetOfSessionMessages = telnetSession.getAllSessionMessages();
                    if (!this.isPatternFound("<7>", this.lastSetOfSessionMessages)) {
                        this.log.println(this, 2, "The amount of time reserved to set the level 2 image via \"ep download <image>\" has expired");
                        throw new Exception("Expected : \"<7>\" prompt not detected after \"ep download " + this.getLevel2Image() + "\" issued." + "\n\nSession output:\n" + this.lastSetOfSessionMessages);
                    }
                }
                if (telnetSession.getAllSessionMessages().indexOf("failed") != -1) {
                    this.log.println(this, 2, "ep download " + this.getLevel2Image() + " did not complete successfully");
                    throw new Exception("Could not write EPROM image to controller.\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                }
                if (this.getLevel1Image() != null) {
                    if (!telnetSession.expectedResponse("ls\r", this.getLevel1Image(), 5000)) {
                        this.lastSetOfSessionMessages = telnetSession.getAllSessionMessages();
                        if (!this.isPatternFound(this.getLevel1Image(), this.lastSetOfSessionMessages)) {
                            this.log.println(this, 2, "The level 1 image that was uploaded is not present on the storage array.");
                            throw new Exception(this.getLevel1Image() + " image was not found." + "\n\nSession output:\n" + this.lastSetOfSessionMessages);
                        }
                    }
                    if (!telnetSession.expectedResponse("ep download " + this.getLevel1Image() + "\r", "<9>", n4)) {
                        this.lastSetOfSessionMessages = telnetSession.getAllSessionMessages();
                        if (!this.isPatternFound("<9>", this.lastSetOfSessionMessages)) {
                            this.log.println(this, 2, "The amount of time reserved to set the boot image via \"ep download <image>\" has expired");
                            throw new Exception("Expected : \"<9>\" prompt not detected after \"ep download " + this.getLevel1Image() + "\" issued." + "\n\nSession output:\n" + this.lastSetOfSessionMessages);
                        }
                    }
                    if (telnetSession.getAllSessionMessages().indexOf("failed") != -1) {
                        this.log.println(this, 2, "ep download " + this.getLevel1Image() + " did not complete successfully");
                        throw new Exception("Could not write EPROM image to controller.\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                    }
                }
                telnetSession.send("reset -y\r", 60000);
                telnetSession.disconnect();
                telnetSession = null;
                this.waitForEstablishedConnection(string, string2, string3);
            }
            catch (Exception exception) {
                this.log.printStackTrace(this, 2, exception);
                throw new InteractiveSessionException(exception.getMessage());
            }
            finally {
                if (telnetSession != null) {
                    telnetSession.disconnect();
                }
            }
        }
    }
}

