/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.host.Host;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.SunOSRmtInstallerPrtl;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.CommandSession;
import com.sun.patchpro.util.InteractiveSessionException;
import com.sun.patchpro.util.TelnetSession;

public abstract class SunOSRmtT4InstallerPrtl
extends SunOSRmtInstallerPrtl {
    private static final String FIRMWARE_IMAGE_DIRECTORY = "/var/sadm/swimages/";
    private static final String EXPECTED_PREFIX_MESSAGE = "Installation of <";
    private static final String FIRMWARE_REPOSITORY_PROMPT = "Please Enter Patch Location Pathname";
    private static final String NETRC_DIRECTORY_PROMPT = "Enter Your Home Directory Path";
    private static final String FTP_USER_PROMPT = "Enter ftp user";
    private static final String FTP_PASSWORD_PROMPT = "Enter ftp password";
    private static final String LOGIN_INCORRECT_MSG = "Login failed";
    private static final String CLEANING_UP_MSG = "Cleaning Up Temporary Files...";
    private static final String PASSWORD_FILE_SUFFIX = "pw";
    protected static final int RETRY_LIMIT = 100;
    private CommandSession commandSession = null;
    private Host host = null;
    protected PatchProProperties properties = null;

    public SunOSRmtT4InstallerPrtl(Manipulator manipulator, PatchProProperties patchProProperties) throws InstallFailedException {
        super(manipulator, patchProProperties);
        this.properties = patchProProperties;
        this.host = manipulator.getHost();
    }

    protected void uploadFirmwareImages(String string) throws InteractiveSessionException {
        CommandSession commandSession = null;
        try {
            int n = 0;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            n = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.uploaddata.storagearray.limit", "1800")));
            string4 = this.properties.getProperty("patchpro.userid", "root");
            string5 = this.getPassword(string);
            string3 = this.activePatch.getPatchID().getPatchID();
            string2 = FIRMWARE_IMAGE_DIRECTORY + string3;
            commandSession = new CommandSession();
            commandSession.start("/sbin/sh " + string2 + "/6120.sh ppro");
            if (!commandSession.expectedResponse(string + "\n", FIRMWARE_REPOSITORY_PROMPT, 10000)) {
                commandSession.cleanup();
                this.log.println(this, 2, "Problem detected while running the " + string2 + "/6120.sh script. The prompt for the firmware " + "repository was not detected.");
                throw new Exception("Expected : \"Please Enter Patch Location Pathname\" response did not occur.\n\nSession output:\n" + commandSession.getAllSessionMessages());
            }
            if (!commandSession.expectedResponse(string2 + "\n", NETRC_DIRECTORY_PROMPT, 20000)) {
                this.log.println(this, 2, "Problem detected while running the " + string2 + "/6120.sh script. The prompt for specifying the directory " + "where the .netrc file is to be created was not detected.");
                throw new Exception("Expected : \"Enter Your Home Directory Path\" response did not occur.\n\nSession output:\n" + commandSession.getAllSessionMessages());
            }
            if (!commandSession.expectedResponse("\n", FTP_USER_PROMPT, 5000)) {
                this.log.println(this, 2, "Problem detected while running the " + string2 + "/6120.sh script. The prompt for the FTP username was not detected.");
                throw new Exception("Expected : \"Enter ftp user\" prompt not detected.\n\nSession output:\n" + commandSession.getAllSessionMessages());
            }
            if (!commandSession.expectedResponse(string4 + "\n", FTP_PASSWORD_PROMPT, 5000)) {
                this.log.println(this, 2, "Problem detected while running the " + string2 + "/6120.sh script. The prompt for the FTP password was not detected.");
                throw new Exception("Expected : \"Enter ftp password\" prompt not detected.\n\nSession output:\n" + commandSession.getAllSessionMessages());
            }
            if (commandSession.expectedResponse(string5 + "\n", LOGIN_INCORRECT_MSG, 5000)) {
                this.log.println(this, 2, "Problem detected while running the " + string2 + "/6120.sh script. Unable to establish an FTP connection " + "with the username and password in effect.");
                throw new Exception("Expected : \"Login failed\" message was detected.\n\nSession output:\n" + commandSession.getAllSessionMessages());
            }
            if (commandSession.getAllSessionMessages().indexOf("Login incorrect") != -1 || commandSession.getAllSessionMessages().indexOf(LOGIN_INCORRECT_MSG) != -1) {
                this.log.println(this, 2, "Problem detected while running the " + string2 + "/6120.sh script. Unable to establish an FTP connection " + "with the username and password in effect.");
                throw new Exception("\n\nSession output:\n" + commandSession.getAllSessionMessages());
            }
            if (!commandSession.waitfor(CLEANING_UP_MSG, n * 4)) {
                this.log.println(this, 2, "Problem detected while running the " + string2 + "/6120.sh script. The time reserved for the upload process " + "has elapsed.");
                throw new Exception("Expected : FTP \"Cleaning Up Temporary Files...\" message was never detected\n\nSession output:\n" + commandSession.getAllSessionMessages());
            }
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 2, exception);
            throw new InteractiveSessionException(exception.getMessage());
        }
        finally {
            if (commandSession != null) {
                commandSession.cleanup();
            }
        }
    }

    protected void waitForEstablishedConnection(String string, String string2, String string3) throws Exception {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        TelnetSession telnetSession = null;
        telnetSession = new TelnetSession();
        telnetSession.connect(string, string2, string3);
        n = this.convertStringToInteger(this.properties.getProperty("patchpro.reconnect.controller.maxattempts", "100"));
        while (true) {
            try {
                telnetSession = new TelnetSession();
                telnetSession.connect(string, string2, string3);
                if (telnetSession.expectedResponse("port list\r", "offline", 5000)) {
                    bl = true;
                    telnetSession.disconnect();
                    telnetSession = null;
                    throw new Exception("The controller is not online.");
                }
                this.log.println(this, 7, "All controllers are ONLINE");
                telnetSession.disconnect();
                telnetSession = null;
            }
            catch (Exception exception) {
                if (bl) {
                    throw new Exception(exception.getMessage() + "\nSession:\n" + telnetSession.getAllSessionMessages());
                }
                if (telnetSession != null) {
                    telnetSession.disconnect();
                    telnetSession = null;
                }
                System.gc();
                this.log.println(this, 7, "Number of attempts to connect to master controller is " + ++n2);
                Thread.sleep(10000L);
                if (n2 < n) continue;
            }
            break;
        }
        if (n2 >= n) {
            throw new Exception("The amount of time reserved to reboot the storage array has expired.\nSession:\n" + telnetSession.getAllSessionMessages());
        }
    }
}

