/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.SoftwarePackage;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.SunOSRmtT4InstallerPrtl;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.InteractiveSessionException;
import com.sun.patchpro.util.TelnetSession;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public abstract class SunOSRmtT4DiskDriveInstallerPrtl
extends SunOSRmtT4InstallerPrtl {
    private static final String PASSWORD_FILE_SUFFIX = "pw";
    protected PatchProProperties properties = null;
    String[] ascendingVersions = null;
    String[] descendingVersions = null;
    private String diskDriveImage = null;
    private String diskFruModel = null;
    private String diskFruVersion = null;
    private String realizationProvided = null;

    public SunOSRmtT4DiskDriveInstallerPrtl(Manipulator manipulator, PatchProProperties patchProProperties) throws InstallFailedException {
        super(manipulator, patchProProperties);
        this.properties = patchProProperties;
    }

    protected void getDiskDriveFirmwareImages() throws InteractiveSessionException {
        Properties properties = null;
        SoftwarePackage softwarePackage = this.installFirmwarePackage();
        properties = softwarePackage.getPkginfo();
        this.manipulator.getHost().addSoftwarePackage(softwarePackage);
        this.setDiskDriveImage(properties.getProperty("SUNW_DISKDRIVE_NAME", null));
        this.setDiskFruModel(properties.getProperty("SUNW_DISK_MODEL", null));
        this.setDiskFruVersion(properties.getProperty("SUNW_DISK_VERSION", null));
        this.setRIDProvided(properties.getProperty("SUNW_RID_PROVIDED"));
    }

    protected Vector getListOfDiskDrives() {
        Enumeration enumeration = null;
        HardwareComponent hardwareComponent = null;
        Vector<String> vector = new Vector<String>();
        enumeration = this.getHardwareComponentsToUpdate();
        while (enumeration.hasMoreElements()) {
            hardwareComponent = (HardwareComponent)enumeration.nextElement();
            vector.addElement(hardwareComponent.getLocator());
        }
        return vector;
    }

    protected void applyDiskDriveFirmwareImage(String string) throws InteractiveSessionException {
        String string2 = null;
        String string3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        int n = 0;
        boolean bl = false;
        if (this.getDiskDriveImage() != null) {
            TelnetSession telnetSession = null;
            try {
                string2 = this.properties.getProperty("patchpro.userid", "root");
                n = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.downloadfw.diskdrive.limit", "600")));
                string3 = this.getPassword(string);
                telnetSession = this.getInstanceOfTelnetSession(string, string2, string3);
                if (telnetSession == null) {
                    throw new InteractiveSessionException("Unable to establish a telnet session with host " + string);
                }
                Vector vector = this.getListOfDiskDrives();
                if (vector.size() != 0) {
                    telnetSession.send("cd /\r", 1000);
                    if (!telnetSession.expectedResponse("ls\r", this.getDiskDriveImage(), 5000)) {
                        this.log.println(this, 2, "The disk drive image \"" + this.getDiskDriveImage() + "\" that was uploaded is " + "not present on the storage array.");
                        throw new Exception(this.getDiskDriveImage() + " image was not found." + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                    }
                    for (int i = 0; i < vector.size(); ++i) {
                        if (telnetSession.expectedResponse("disk download " + vector.elementAt(i) + " " + this.getDiskDriveImage() + "\r", "pass", n) || telnetSession.getAllSessionMessages().indexOf("fail") == -1) continue;
                        telnetSession.send("disk version " + vector.elementAt(i), 10000);
                        if (telnetSession.getSessionMessages().indexOf(this.getDiskFruModel()) != -1 && telnetSession.getSessionMessages().indexOf(this.getDiskFruVersion()) != -1) continue;
                        this.log.println(this, 2, "Unable to download " + this.getDiskDriveImage() + " image to " + vector.elementAt(i));
                        throw new Exception(this.getDiskDriveImage() + " image could not be downloaded");
                    }
                } else {
                    System.out.println("Unable to download firmware to drives ...");
                    if (telnetSession != null) {
                        telnetSession.disconnect();
                        telnetSession = null;
                    }
                    throw new Exception("There should have been at least one drive to update");
                }
                telnetSession.disconnect();
                telnetSession = null;
            }
            catch (Exception exception) {
                this.log.printStackTrace(this, 2, exception);
                throw new InteractiveSessionException(exception.getMessage());
            }
            finally {
                if (telnetSession != null) {
                    telnetSession.disconnect();
                }
            }
        }
    }

    protected String getDiskDrivePackage(String string) throws InteractiveSessionException {
        if (string.indexOf("ST336753F") != -1) {
            return this.properties.getProperty("patchpro.T4.st336753f.package", "SUNWnw748");
        }
        if (string.indexOf("ST336752F") != -1) {
            return this.properties.getProperty("patchpro.T4.st336752f.package", "SUNWsx201");
        }
        if (string.indexOf("ST373307F") != -1) {
            return this.properties.getProperty("patchpro.T4.st373307f.package", "SUNWsc702");
        }
        if (string.indexOf("ST314680F") != -1) {
            return this.properties.getProperty("patchpro.T4.st314680f.package", "SUNWsc701");
        }
        if (string.indexOf("ST373207F") != -1) {
            return this.properties.getProperty("patchpro.T4.st373207f.package", "SUNWmn001");
        }
        if (string.indexOf("ST314670F") != -1) {
            return this.properties.getProperty("patchpro.T4.st314670f.package", "SUNWmn001");
        }
        if (string.indexOf("ST330000F") != -1) {
            return this.properties.getProperty("patchpro.T4.st330000f.package", "SUNWmn001");
        }
        if (string.indexOf("ST373453F") != -1) {
            return this.properties.getProperty("patchpro.T4.st373453f.package", "SUNWsc702");
        }
        if (string.indexOf("MAS3367F") != -1) {
            return "SUNWfj004";
        }
        if (string.indexOf("MAP3735F") != -1) {
            return "SUNWfj002";
        }
        if (string.indexOf("MAP3147F") != -1) {
            return "SUNWfj003";
        }
        if (string.indexOf("MAS3735F") != -1) {
            return "SUNWfj005";
        }
        if (string.indexOf("MAT3073F") != -1) {
            return "SUNWfj994";
        }
        if (string.indexOf("MAT3147F") != -1) {
            return "SUNWfj999";
        }
        if (string.indexOf("MAT3300F") != -1) {
            return "SUNWfj998";
        }
        if (string.indexOf("MAU3036F") != -1) {
            return "SUNWfj997";
        }
        if (string.indexOf("MAU3073F") != -1) {
            return "SUNWfj996";
        }
        if (string.indexOf("MAU3147F") != -1) {
            return "SUNWfj995";
        }
        if (string.indexOf("DK32EJ72F") != -1) {
            return "SUNWht002";
        }
        if (string.indexOf("DK32EJ14F") != -1) {
            return "SUNWht001";
        }
        return null;
    }

    protected String[] getListOfFirmwareVersions(String string) throws InteractiveSessionException {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.manipulator.getHost().getHardwareComponents();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                HardwareComponent hardwareComponent = (HardwareComponent)enumeration.nextElement();
                if (hardwareComponent == null) continue;
                if (string.indexOf("ST336753F") != -1 && hardwareComponent.getProduct().equals("ST336753FSUN36G") && !vector.contains(hardwareComponent.getRevision())) {
                    vector.addElement(hardwareComponent.getRevision());
                }
                if (string.indexOf("ST373453F") != -1 && hardwareComponent.getProduct().equals("ST373453FSUN72G")) {
                    if (vector.contains(hardwareComponent.getRevision())) continue;
                    vector.addElement(hardwareComponent.getRevision());
                    continue;
                }
                if (string.indexOf("ST336752F") != -1 && hardwareComponent.getProduct().equals("ST336752FSUN36G")) {
                    if (vector.contains(hardwareComponent.getRevision())) continue;
                    vector.addElement(hardwareComponent.getRevision());
                    continue;
                }
                if (string.indexOf("ST373307F") != -1 && hardwareComponent.getProduct().equals("ST373307FSUN72G")) {
                    if (vector.contains(hardwareComponent.getRevision())) continue;
                    vector.addElement(hardwareComponent.getRevision());
                    continue;
                }
                if (string.indexOf("ST314680F") != -1 && hardwareComponent.getProduct().equals("ST314680FSUN146G")) {
                    if (vector.contains(hardwareComponent.getRevision())) continue;
                    vector.addElement(hardwareComponent.getRevision());
                    continue;
                }
                if (string.indexOf("ST373207F") != -1 && hardwareComponent.getProduct().equals("ST373207FSUN72G")) {
                    if (vector.contains(hardwareComponent.getRevision())) continue;
                    vector.addElement(hardwareComponent.getRevision());
                    continue;
                }
                if (string.indexOf("ST314670F") != -1 && hardwareComponent.getProduct().equals("ST314670FSUN146G")) {
                    if (vector.contains(hardwareComponent.getRevision())) continue;
                    vector.addElement(hardwareComponent.getRevision());
                    continue;
                }
                if (string.indexOf("ST330000F") != -1 && hardwareComponent.getProduct().equals("ST330000FSUN300G")) {
                    if (vector.contains(hardwareComponent.getRevision())) continue;
                    vector.addElement(hardwareComponent.getRevision());
                    continue;
                }
                if (string.indexOf("MAS3367F") != -1 && hardwareComponent.getProduct().equals("MAS3367F SUN36G")) {
                    if (vector.contains(hardwareComponent.getRevision())) continue;
                    vector.addElement(hardwareComponent.getRevision());
                    continue;
                }
                if (string.indexOf("MAS3735F") != -1 && hardwareComponent.getProduct().equals("MAS3735F SUN72G")) {
                    if (vector.contains(hardwareComponent.getRevision())) continue;
                    vector.addElement(hardwareComponent.getRevision());
                    continue;
                }
                if (string.indexOf("MAP3735F") != -1 && hardwareComponent.getProduct().equals("MAP3735F SUN72G")) {
                    if (vector.contains(hardwareComponent.getRevision())) continue;
                    vector.addElement(hardwareComponent.getRevision());
                    continue;
                }
                if (string.indexOf("MAP3147F") != -1 && hardwareComponent.getProduct().equals("MAP3147F SUN146G")) {
                    if (vector.contains(hardwareComponent.getRevision())) continue;
                    vector.addElement(hardwareComponent.getRevision());
                    continue;
                }
                if (string.indexOf("MAT3073F") != -1 && hardwareComponent.getProduct().equals("MAT3073F SUN72G")) {
                    if (vector.contains(hardwareComponent.getRevision())) continue;
                    vector.addElement(hardwareComponent.getRevision());
                    continue;
                }
                if (string.indexOf("MAT3147F") != -1 && hardwareComponent.getProduct().equals("MAT3147F SUN146G")) {
                    if (vector.contains(hardwareComponent.getRevision())) continue;
                    vector.addElement(hardwareComponent.getRevision());
                    continue;
                }
                if (string.indexOf("MAT3300F") != -1 && hardwareComponent.getProduct().equals("MAT3300F SUN300G")) {
                    if (vector.contains(hardwareComponent.getRevision())) continue;
                    vector.addElement(hardwareComponent.getRevision());
                    continue;
                }
                if (string.indexOf("MAU3036F") != -1 && hardwareComponent.getProduct().equals("MAU3036FCSUN36G")) {
                    if (vector.contains(hardwareComponent.getRevision())) continue;
                    vector.addElement(hardwareComponent.getRevision());
                    continue;
                }
                if (string.indexOf("MAU3073F") != -1 && hardwareComponent.getProduct().equals("MAU3073FCSUN72G")) {
                    if (vector.contains(hardwareComponent.getRevision())) continue;
                    vector.addElement(hardwareComponent.getRevision());
                    continue;
                }
                if (string.indexOf("MAU3147F") != -1 && hardwareComponent.getProduct().equals("MAU3147FCSUN146G")) {
                    if (vector.contains(hardwareComponent.getRevision())) continue;
                    vector.addElement(hardwareComponent.getRevision());
                    continue;
                }
                if (string.indexOf("DK32EJ72F") != -1 && hardwareComponent.getProduct().equals("DK32EJ72FSUN72G")) {
                    if (vector.contains(hardwareComponent.getRevision())) continue;
                    vector.addElement(hardwareComponent.getRevision());
                    continue;
                }
                if (string.indexOf("DK32EJ14F") == -1 || !hardwareComponent.getProduct().equals("DK32EJ14FSUN146G") || vector.contains(hardwareComponent.getRevision())) continue;
                vector.addElement(hardwareComponent.getRevision());
            }
        }
        if (vector.size() == 0) {
            throw new InteractiveSessionException("Unable to determine the disk drive version for a disk drive model associated with realization \"" + string + "\".");
        }
        Object[] objectArray = new String[vector.size()];
        this.descendingVersions = new String[vector.size()];
        vector.copyInto(objectArray);
        SunOSRmtT4DiskDriveInstallerPrtl.shellsort((String[])objectArray);
        this.descendingVersions = new String[objectArray.length];
        int n = objectArray.length - 1;
        for (int i = 0; i < objectArray.length; ++i) {
            this.descendingVersions[i] = objectArray[n--];
        }
        return this.descendingVersions;
    }

    protected static void shellsort(String[] stringArray) {
        int n = stringArray.length;
        for (int i = n / 2; i >= 1; i /= 2) {
            for (int j = i; j < n; ++j) {
                String string = stringArray[j];
                for (int k = j; k >= i && string.compareTo(stringArray[k - i]) < 0; k -= i) {
                    stringArray[k] = stringArray[k - i];
                }
                stringArray[k] = string;
            }
        }
    }

    protected void setDiskDriveImage(String string) {
        this.diskDriveImage = string;
    }

    protected void setDiskFruModel(String string) {
        this.diskFruModel = string;
    }

    protected void setDiskFruVersion(String string) {
        this.diskFruVersion = string;
    }

    protected void setRIDProvided(String string) {
        this.realizationProvided = string;
    }

    protected String getDiskDriveImage() {
        return this.diskDriveImage;
    }

    protected String getDiskFruModel() {
        return this.diskFruModel;
    }

    protected String getDiskFruVersion() {
        return this.diskFruVersion;
    }

    protected String getRIDProvided() {
        return this.realizationProvided;
    }
}

