/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.database.AuditRecord;
import com.sun.patchpro.database.DspFirmwareImageAuditRecord;
import com.sun.patchpro.database.FirmwareImageAuditRecord;
import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.SoftwarePackage;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.SunOSInstaller;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.util.CommandSession;
import com.sun.patchpro.util.InteractiveSessionException;
import com.sun.patchpro.util.TelnetSession;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class SunOSRmtInstallerPrtl
extends SunOSInstaller {
    private static final String EXPECTED_PREFIX_MESSAGE = "Installation of <";
    private static final String PASSWORD_FILE_SUFFIX = "pw";
    protected static final String CR = "\r";
    protected static final String NL = "\n";
    protected static final int ONE_SECOND = 1000;
    protected static final int FIVE_SECONDS = 5000;
    protected static final int TEN_SECONDS = 10000;
    protected static final int TWENTY_SECONDS = 20000;
    protected static final int THIRTY_SECONDS = 30000;
    protected static final int FIFTY_SECONDS = 50000;
    protected static final int ONE_MINUTE = 60000;
    protected static final int TWO_MINUTES = 120000;
    protected static final int FIVE_MINUTES = 300000;
    protected static final int TEN_MINUTES = 600000;
    protected static final int TWENTY_MINUTES = 1200000;
    protected static final int THIRTY_MINUTES = 1800000;
    protected static final int RETRY_LIMIT = 100;
    private CommandSession commandSession = null;
    private Host host = null;
    private PatchID oldPatch;
    private HardwareComponent[] components = null;
    private Vector hardwareComponentsToUpdate = new Vector();
    protected PatchProProperties properties = null;

    public SunOSRmtInstallerPrtl(Manipulator manipulator, PatchProProperties patchProProperties) throws InstallFailedException {
        super(manipulator, patchProProperties);
        this.properties = patchProProperties;
        this.host = manipulator.getHost();
        this.initializeHardwareList();
    }

    protected String getPassword(String string) throws IOException {
        String string2 = null;
        File file = new File(this.properties.getProperty("patchpro.password.directory", this.properties.getProperty("patchpro.installdir.ppro", "/opt/SUNWppro") + "/lib") + "/." + string + PASSWORD_FILE_SUFFIX);
        if (!file.exists() || !file.canRead()) {
            throw new IOException("Password file for \"" + string + "\" is not accessible");
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        string2 = bufferedReader.readLine();
        if (string2 == null || string2.length() == 0) {
            string2 = "";
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SoftwarePackage installFirmwarePackage() throws InteractiveSessionException {
        boolean bl = false;
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = "";
        string = this.properties.getProperty("SunOS.command.install.package", "/usr/sbin/pkgadd -d");
        string2 = this.properties.getProperty("patchpro.patch.install.directory", "/var/sadm/spool");
        string4 = this.activePatch.getPatchID().getPatchID();
        string5 = string + " " + string2 + "/" + string4 + " " + "all";
        if (this.debug) {
            System.out.println("Install command string: " + string5);
        }
        try {
            try {
                SoftwarePackage softwarePackage;
                Object object;
                System.gc();
                this.commandSession = new CommandSession();
                this.commandSession.expect("[y,n,?,q]", "y\n");
                this.commandSession.expect("[y,n,?]", "y\n");
                this.commandSession.expect("Hit <RETURN> to continue display", NL);
                this.commandSession.start(string5);
                this.commandSession.expectRemove("[y,n,?,q]");
                this.commandSession.expectRemove("[y,n,?]");
                this.commandSession.expectRemove("Hit <RETURN> to continue display");
                string6 = this.commandSession.getSessionMessages();
                if (this.debug) {
                    System.out.println("Messages from pkgadd: \n" + string6);
                }
                this.commandSession.stop();
                if (this.commandSession.getReturnValue() != 0) {
                    this.log.println(this, 2, "Unable to install the package that delivers the controller, loop card, L10N and web page files.");
                    throw new Exception("pkgadd exit code: " + this.commandSession.getReturnValue() + "\n\nSession output:\n" + this.commandSession.getAllSessionMessages());
                }
                String string7 = "";
                String string8 = "";
                StringTokenizer stringTokenizer = new StringTokenizer(string6, NL);
                while (stringTokenizer.hasMoreElements()) {
                    string7 = stringTokenizer.nextToken();
                    if (string7.indexOf("was successful") == -1) continue;
                    object = new String[3];
                    object = string7.split("[<>]");
                    string8 = object[1];
                    break;
                }
                if ((string8 = string8.trim()).length() == 0) {
                    this.log.println(this, 4, "Required package information cannot be determined to update the device at this time. Please use Revision Maintenance again to update this device.");
                    throw new InteractiveSessionException("\nNotice: Required package information cannot be determined to update the device \nat this time. Please use Revision Maintenance again to update this device.");
                }
                if (this.debug) {
                    System.out.println("PACKAGE NAME FOUND IS : " + string8);
                }
                object = "";
                String string9 = "";
                int n = 0;
                n = string8.indexOf(46);
                if (n == -1) {
                    string9 = "1";
                    object = string8;
                } else {
                    string9 = string8.substring(n + 1);
                    string9 = string9.trim();
                    object = string8.substring(0, n);
                }
                if (this.debug) {
                    System.out.println("PACKAGE VERSION: " + string9);
                    System.out.println("PACKAGE BASENAME: " + (String)object);
                }
                string3 = string2 + "/" + string4 + "/" + (String)object + "/" + "pkginfo";
                try {
                    SoftwarePackage softwarePackage2;
                    softwarePackage = softwarePackage2 = new SoftwarePackage((String)object, string9, new File(string3));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.log.println(this, 4, "Required package information cannot be determined to update the device at this time. Please use Revision Maintenance again to update this device.");
                    throw new Exception("\nNotice: Required package information cannot be determined to update the device \nat this time. Please use Revision Maintenance again to update this device.");
                }
                catch (Exception exception) {
                    this.log.println(this, 4, "Required package information cannot be determined to update the device at this time. Please use Revision Maintenance again to update this device.");
                    throw new Exception("\nNotice: Required package information cannot be determined to update the device \nat this time. Please use Revision Maintenance again to update this device.");
                }
                Object var22_24 = null;
                if (this.commandSession == null) return softwarePackage;
                this.commandSession.cleanup();
                return softwarePackage;
            }
            catch (Exception exception) {
                this.commandSession.stop();
                this.log.println(this, 2, "Problem encountered installing the package that delivers controller related files.");
                throw new InteractiveSessionException(exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var22_25 = null;
            if (this.commandSession == null) throw throwable;
            this.commandSession.cleanup();
            throw throwable;
        }
    }

    protected String getLine(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, NL);
        String string3 = null;
        String string4 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            if (string4.indexOf(string) == -1) continue;
            string3 = string4;
            break;
        }
        return string3;
    }

    protected int convertToMilliseconds(int n) {
        return n * 1000;
    }

    protected int convertStringToInteger(String string) {
        return new Integer(string);
    }

    public PatchID getPatchIDByFWVersion(String string, String string2) throws InteractiveSessionException {
        Object object;
        PatchID patchID = null;
        SoftwarePackage softwarePackage = null;
        Enumeration enumeration = this.host.getPrimaryHost().getSoftwarePackages();
        String string3 = null;
        while (enumeration.hasMoreElements()) {
            object = (SoftwarePackage)enumeration.nextElement();
            if (!((SoftwarePackage)object).getBasecode().equals(string) || string2.indexOf(((SoftwarePackage)object).getVersion()) == -1) continue;
            if (((SoftwarePackage)object).getInstance() > 0) {
                string3 = string + "." + ((SoftwarePackage)object).getInstance();
                continue;
            }
            string3 = string;
        }
        if (string3 == null) {
            return patchID;
        }
        softwarePackage = new SoftwarePackage(string3, string2);
        if (softwarePackage == null) {
            return patchID;
        }
        try {
            softwarePackage.populateInstalledPkginfo();
        }
        catch (Exception exception) {
            throw new InteractiveSessionException(exception.getMessage());
        }
        if (this.debug) {
            System.out.println("Retrieving the package instance for package " + string + " which provides version " + string2);
        }
        object = softwarePackage.getPkginfo().getProperty("SUNW_PATCHID", "none");
        if (this.debug) {
            System.out.println("The old patch that must be reinstalled is " + (String)object);
        }
        try {
            patchID = new PatchID((String)object);
        }
        catch (MalformedPatchException malformedPatchException) {
            throw new InteractiveSessionException(malformedPatchException.getMessage());
        }
        return patchID;
    }

    public void setAuditRecordData(PatchID patchID, Enumeration enumeration) {
        Object var3_3 = null;
        Vector vector = new Vector();
        this.oldPatch = patchID;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        if (vector.size() == 0) {
            this.components = new HardwareComponent[0];
        } else {
            this.components = new HardwareComponent[vector.size()];
            vector.copyInto(this.components);
        }
    }

    private HardwareComponent[] getTargetComponents() {
        return this.components;
    }

    public AuditRecord getAuditRecord() {
        if (this.manipulator.getHost().getType().compareTo("SunOS") == 0) {
            return new AuditRecord(this.manipulator.getHost(), this.manipulator.getPatch());
        }
        if (this.manipulator.getHost().getType().compareTo("DSP") == 0) {
            return new DspFirmwareImageAuditRecord(this.manipulator.getHost(), this.manipulator.getPatch(), this.components, this.oldPatch);
        }
        return new FirmwareImageAuditRecord(this.manipulator.getHost(), this.manipulator.getPatch(), this.components, this.oldPatch);
    }

    public TelnetSession getInstanceOfTelnetSession(String string, String string2, String string3) {
        TelnetSession telnetSession = null;
        int n = 0;
        int n2 = 10;
        while (true) {
            try {
                System.gc();
                telnetSession = new TelnetSession();
                telnetSession.connect(string, string2, string3);
                return telnetSession;
            }
            catch (Exception exception) {
                System.gc();
                this.debugging("Number of attempts to connect to host: " + string + " is " + ++n);
                try {
                    Thread.sleep(20000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (n < n2) continue;
                if (this.debug) {
                    System.out.println("Number of attempts (" + n + ") to connect to host " + string + " has been exceeded.");
                }
                return null;
            }
            break;
        }
    }

    public boolean isPatternFound(String string, String string2) {
        return string2.indexOf(string) != -1;
    }

    protected void initializeHardwareList() {
        Enumeration enumeration = null;
        HardwareComponent hardwareComponent = null;
        enumeration = this.manipulator.getTargetHardware();
        while (enumeration != null && enumeration.hasMoreElements()) {
            hardwareComponent = (HardwareComponent)enumeration.nextElement();
            this.hardwareComponentsToUpdate.addElement(hardwareComponent);
        }
    }

    protected Enumeration getHardwareComponentsToUpdate() {
        return this.hardwareComponentsToUpdate.elements();
    }

    protected String getFirmwareVersion(String string) {
        Enumeration enumeration = this.manipulator.getHost().getHardwareComponents();
        if (enumeration != null) {
            try {
                while (enumeration.hasMoreElements()) {
                    HardwareComponent hardwareComponent = (HardwareComponent)enumeration.nextElement();
                    if (hardwareComponent == null || !hardwareComponent.getProduct().equals(string)) continue;
                    return hardwareComponent.getRevision();
                }
            }
            catch (Exception exception) {
                this.log.println(this, 4, exception.getMessage());
            }
        }
        return "";
    }

    protected void reportHardwares() {
        Manipulator manipulator = this.getManipulator();
        System.out.println("\nTarget Hardware: ");
        Enumeration enumeration = manipulator.getTargetHardware();
        while (enumeration != null && enumeration.hasMoreElements()) {
            System.out.println("COMPONENT: " + ((HardwareComponent)enumeration.nextElement()).toString());
        }
        System.out.println("\nHost: " + manipulator.getHost());
        System.out.println("Host Components:");
        Enumeration enumeration2 = manipulator.getHost().getHardwareComponents();
        while (enumeration2 != null && enumeration2.hasMoreElements()) {
            System.out.println("COMPONENT: " + ((HardwareComponent)enumeration2.nextElement()).toString());
        }
        System.out.println("\nHW Components to update: ");
        enumeration2 = this.getHardwareComponentsToUpdate();
        while (enumeration2 != null && enumeration2.hasMoreElements()) {
            System.out.println("COMPONENT: " + ((HardwareComponent)enumeration2.nextElement()).toString());
        }
    }
}

