/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.host.DspHardwareComponent;
import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.PatchInstallFailedException;
import com.sun.patchpro.manipulators.SunOSRmtDSPInstallerPrtl;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.util.InteractiveSessionException;
import com.sun.patchpro.util.LineParser;
import com.sun.patchpro.util.SnmpEventReportDispatcherPool;
import com.sun.patchpro.util.SnmpTrapThread;
import com.sun.patchpro.util.SnmpUtilities;
import com.sun.patchpro.util.Spinner;
import com.sun.patchpro.util.TelnetSession;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.management.snmp.SnmpPduRequest;
import javax.management.snmp.SnmpPduTrap;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.manager.SnmpEventReportDispatcher;
import javax.management.snmp.manager.SnmpTrapListener;

public class SunOSRmtDSPOSImageInstaller
extends SunOSRmtDSPInstallerPrtl
implements SnmpTrapListener {
    private static final int DEFAULT_SNMP_PORT = 162;
    private static final boolean DEBUG_COMPONENT = false;
    boolean session_debug;
    PatchID patchID = null;
    SnmpEventReportDispatcher reportDispatcher = null;
    SnmpTrapThread trapThread = null;
    SnmpUtilities util = new SnmpUtilities();
    TelnetSession telnetSession = null;
    LineParser lp = new LineParser();
    ArrayList managementCards = new ArrayList();
    ArrayList storageResourceCards = new ArrayList();
    ArrayList switchFabricCards = new ArrayList();
    String sessionPrompt = null;
    String sessionMessages = null;
    String hostname = null;
    String username = null;
    String password = null;
    int snmpPort = 0;
    static final String PREFIX_AUTO_FAILBACK = "Auto-Failback";
    static final String PREFIX_AUTO_SAVE = "Auto-Save";
    static final String DISABLED = "disabled";
    static final String SHOW_AUTO_FAILBACK = "show auto-failback";
    static final String SHOW_AUTO_SAVE = "show auto-save";
    static final String AUTO_SAVE = "auto-save";
    static final String NO_AUTO_SAVE = "no auto-save";

    public SunOSRmtDSPOSImageInstaller(Manipulator manipulator, PatchProProperties patchProProperties) throws InstallFailedException {
        super(manipulator, patchProProperties);
        this.session_debug = this.isDebug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void install() {
        block12: {
            block11: {
                this.initializeProgress(0.0, 5.0);
                if (!this.setGlobalSnmpTrapListener()) {
                    return;
                }
                this.incrementProgress(1.0);
                if (!this.extractDSPPatch()) {
                    return;
                }
                this.incrementProgress(1.0);
                this.hostname = this.manipulator.getHost().getAddress();
                if (this.isInstallDebug()) {
                    this.stubInstallation();
                    break block11;
                }
                this.patchID = this.getPatchIDByFWVersion(this.properties.getProperty("patchpro.DSP.package", "SUNWdspf1"), this.getFirmwareVersion());
                this.message(this, "Preparing DSP firmware update.");
                this.prepareChassisCards();
                this.setup();
                System.gc();
                this.get_startup_status();
                System.gc();
                this.getPSX1000FirmwareImages();
                this.incrementProgress(1.0);
                this.message(this, "Start DSP firmware update.", 5);
                System.gc();
                this.upgradeStart();
                this.message("Uploading the firmware to DSP.");
                System.gc();
                this.uploadFirmwareImages(this.hostname);
                this.incrementProgress(1.0);
                System.gc();
                this.applyPSX1000FirmwareImages();
                this.setAuditRecordData(this.patchID, this.getHardwareComponentsToUpdate());
            }
            Object var4_1 = null;
            try {
                this.message(this, "Stop DSP firmware update.", 5);
                this.upgradeStop();
            }
            catch (InteractiveSessionException interactiveSessionException) {
                this.message("DSP firmware update stop failed:\n" + interactiveSessionException.getMessage());
            }
            break block12;
            {
                catch (InteractiveSessionException interactiveSessionException) {
                    System.gc();
                    String string = interactiveSessionException.getMessage();
                    this.printStackTrace(this, 2, interactiveSessionException);
                    string = "DSP firmware update halted:\n" + string;
                    this.issueFail(new PatchInstallFailedException(string));
                    Object var4_2 = null;
                    try {
                        this.message(this, "Stop DSP firmware update.", 5);
                        this.upgradeStop();
                    }
                    catch (InteractiveSessionException interactiveSessionException2) {
                        this.message("DSP firmware update stop failed:\n" + interactiveSessionException2.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                try {
                    this.message(this, "Stop DSP firmware update.", 5);
                    this.upgradeStop();
                }
                catch (InteractiveSessionException interactiveSessionException) {
                    this.message("DSP firmware update stop failed:\n" + interactiveSessionException.getMessage());
                }
                throw throwable;
            }
        }
        this.incrementProgress(1.0);
    }

    private void applyPSX1000FirmwareImages() throws InteractiveSessionException {
        if (this.getPSX1000Image1() != null) {
            try {
                Spinner spinner = Spinner.getInstance();
                this.message(this, "Updating MICs.");
                spinner.setInterval(5);
                this.updateMICs();
                this.message(this, "Rebooting MICs.");
                spinner.setInterval(10);
                this.rebootMICs();
                this.disableAutoSave();
                spinner.setInterval(15);
                if (this.storageResourceCards.size() > 0) {
                    this.shutdownAndReload_SRCs();
                }
                if (this.switchFabricCards.size() > 0) {
                    this.shutdownAndReload_SFCs();
                    this.enableNormalSFCs();
                    this.shutdownAndReload_SFCs();
                }
                spinner.setDefaultInterval();
            }
            catch (InteractiveSessionException interactiveSessionException) {
                throw interactiveSessionException;
            }
            catch (Exception exception) {
                throw new InteractiveSessionException("A failure was encountered while updating DSP firmware.", exception);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setup() throws InteractiveSessionException {
        String string = "";
        try {
            try {
                this.username = this.properties.getProperty("patchpro.userid", "root");
                this.password = this.getPassword(this.hostname);
                this.telnetSession = this.getInstanceOfTelnetSession(this.hostname, this.username, this.password);
                if (this.telnetSession == null) {
                    throw new InteractiveSessionException("Unable to establish a telnet session with host " + this.hostname);
                }
                this.sessionPrompt = this.getLine("# ", this.telnetSession.getAllSessionMessages());
                this.sessionPrompt = this.sessionPrompt.trim();
                if (this.session_debug) {
                    System.out.println("DSP Manipulator.setup(): DSP Session prompt is \"" + this.sessionPrompt + "\"");
                }
                this.telnetSession.send("cd /\r", 1000);
                if (!this.telnetSession.expectedResponse("dir\r", this.sessionPrompt, 30000)) {
                    this.log.println(this, 2, "The \"dir\" command did not complete within the expected amount of time.");
                    throw new Exception("The \"dir\" command did not complete within the expected amount of time.");
                }
                string = this.telnetSession.getAllSessionMessages();
                if (!this.spaceAvailable(string)) {
                    this.log.println(this, 2, "The required amount of space to upgrade the DSP is not available.");
                    throw new Exception("The required amount of space to upgrade the DSP is not available.");
                }
                Object var5_2 = null;
                if (this.telnetSession == null) return;
            }
            catch (Exception exception) {
                if (this.telnetSession == null) throw new InteractiveSessionException("Validity checking for DSP firmware upgrade failed.", exception);
                try {
                    this.telnetSession.send("delete " + this.getPSX1000Image1().toUpperCase() + "\r", 5000);
                    throw new InteractiveSessionException("Validity checking for DSP firmware upgrade failed.", exception);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw new InteractiveSessionException("Validity checking for DSP firmware upgrade failed.", exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (this.telnetSession == null) throw throwable;
            this.telnetSession.disconnect();
            throw throwable;
        }
        this.telnetSession.disconnect();
    }

    private boolean spaceAvailable(String string) throws Exception {
        String string2 = null;
        Integer n = null;
        int n2 = 0;
        int n3 = 0;
        if (this.session_debug) {
            System.out.println("DSP Manipulator.spaceAvailable(): Check if enough space is available for upgrade process.");
        }
        try {
            n2 = 10000000;
            if (this.session_debug) {
                System.out.println("DSP Manipulator.spaceAvailable():  ... Size of image is " + n2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.log.println(this, 2, "Unable to derive the size of the \"" + this.getPSX1000Image1().toUpperCase() + "\" image.");
            throw new Exception("Unable to derive the size of the \"" + this.getPSX1000Image1().toUpperCase() + "\" image.");
        }
        string2 = this.getLine("Bytes free", string);
        if (string2 == null) {
            if (this.session_debug) {
                System.out.println("Unable to determine if enough space is available to upgrade the DSP since the \"dir\" command did not provide amount of free bytes that were available.");
            }
            this.log.println(this, 2, "Unable to determine if enough space is available to upgrade the DSP since the \"dir\" command did not provide amount of free bytes that were available.");
            throw new Exception("Unable to determine if enough space is available to upgrade the DSP since the \"dir\" command did not provide amount of free bytes that were available.");
        }
        try {
            n = new Integer(this.lp.getTokenNumberFromLeft(string2, 2));
            n3 = n;
            if (this.session_debug) {
                System.out.println("DSP Manipulator.spaceAvailable():  ... Number of free bytes is " + n3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.log.println(this, 2, "Unable to derive the amount of available space using the \"dir\" command since the \"Bytes free\" information cannot be found.");
            throw new Exception("Unable to derive the amount of available space using the \"dir\" command since the \"Bytes free\" information cannot be found.");
        }
        if ((double)n2 * 2.5 > (double)n3) {
            if (this.session_debug) {
                System.out.println("Required amount of space for upgrade " + (double)n2 * 2.5 + " is greater than the amount of space that " + " is available " + n3);
            }
            return false;
        }
        if (this.session_debug) {
            System.out.println("Required amount of space for upgrade " + (double)n2 * 2.5 + " is less than or equal to the amount of space that " + " is available " + n3);
        }
        return true;
    }

    private void prepareChassisCards() throws InteractiveSessionException {
        Enumeration enumeration = null;
        Object var2_2 = null;
        enumeration = this.constructNewHWComponents();
        while (enumeration != null && enumeration.hasMoreElements()) {
            var2_2 = enumeration.nextElement();
            if (!(var2_2 instanceof DspHardwareComponent)) continue;
            DspHardwareComponent dspHardwareComponent = var2_2;
            String string = dspHardwareComponent.getDSPClass();
            if (string.indexOf("Storage Resource Card") != -1) {
                this.createStorageResourceCards(dspHardwareComponent);
                continue;
            }
            if (string.indexOf("Switch Fabric Card") != -1) {
                this.createSwitchFabricCards(dspHardwareComponent);
                continue;
            }
            if (string.indexOf("Management Card") == -1 && string.indexOf("Managment Card") == -1) continue;
            this.managementCards.add(dspHardwareComponent);
        }
        if (enumeration == null) {
            this.message(this, "No DSP components are identified for firmware update.");
        } else {
            int n = this.managementCards.size();
            String string = n + " MICs are identified for firmware update.";
            n = this.storageResourceCards.size();
            string = string + "\n" + n + " SRCs are identified for firmware update.";
            n = this.switchFabricCards.size();
            string = string + "\n" + n + " SFCs are identified for firmware update.";
            this.message(this, string);
        }
    }

    private void createStorageResourceCards(DspHardwareComponent dspHardwareComponent) throws InteractiveSessionException {
        if (dspHardwareComponent.getDSPState().compareTo("Normal") != 0) {
            throw new InteractiveSessionException("Source Storage Card at slot " + dspHardwareComponent.getLocator() + " is in an invalid state : " + dspHardwareComponent.getDSPState());
        }
        dspHardwareComponent.setIgnoreStatus(false);
        boolean bl = false;
        int n = SunOSRmtDSPOSImageInstaller.getSRCIndex(dspHardwareComponent);
        DspHardwareComponent[] dspHardwareComponentArray = this.storageResourceCards.toArray(new DspHardwareComponent[0]);
        for (int i = 0; i < dspHardwareComponentArray.length; ++i) {
            int n2 = SunOSRmtDSPOSImageInstaller.getSRCIndex(dspHardwareComponentArray[i]);
            if (n2 <= n) continue;
            this.storageResourceCards.add(i, dspHardwareComponent);
            bl = true;
            break;
        }
        if (!bl) {
            this.storageResourceCards.add(dspHardwareComponentArray.length, dspHardwareComponent);
        }
    }

    private void createSwitchFabricCards(DspHardwareComponent dspHardwareComponent) throws InteractiveSessionException {
        if (dspHardwareComponent.getDSPState().compareTo("Normal") == 0) {
            dspHardwareComponent.setIgnoreStatus(true);
        } else if (dspHardwareComponent.getDSPState().compareTo("Standing By") == 0) {
            dspHardwareComponent.setIgnoreStatus(false);
        } else {
            throw new InteractiveSessionException("Switch Fabric Card at slot " + dspHardwareComponent.getLocator() + " is in an invalid state : " + dspHardwareComponent.getDSPState());
        }
        this.switchFabricCards.add(dspHardwareComponent);
    }

    private void updateMICs() throws InteractiveSessionException {
        int n = 0;
        if (this.session_debug) {
            System.out.println("DSP Manipulator.updateMICs(): ");
        }
        n = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.upgrade.mics.limit", "1800")));
        String string = "upgrade -u\r";
        Vector vector = this.expectedUpgradeTraps();
        Vector vector2 = this.errorUpgradeTraps();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector3.addElement("Are you sure(y/n)?");
        vector4.addElement("y\r");
        this.retryDspCommand(this.hostname, string, vector, vector2, vector3, vector4, n, 1);
    }

    private void rebootMICs() throws InteractiveSessionException {
        int n = 0;
        if (this.session_debug) {
            System.out.println("DSP Manipulator.rebootMICs(): ");
        }
        n = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.warmreboot.mics.limit", "1800")));
        String string = "reboot warm\r";
        Vector vector = this.expectedRebootTraps();
        Vector vector2 = this.errorRebootTraps();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector3.addElement("Are you sure you want to reboot the MIC[N]?");
        vector4.addElement("y\r");
        vector3.addElement("OK to overwrite configuration file[Y]?");
        vector4.addElement("y\r");
        this.retryDspCommand(this.hostname, string, vector, vector2, vector3, vector4, n);
    }

    private void shutdownAndReload_SRCs() throws InteractiveSessionException {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        DspHardwareComponent dspHardwareComponent = null;
        String string = "";
        String string2 = "";
        int n = 0;
        int n2 = 0;
        if (this.session_debug) {
            System.out.println("DSP Manipulator.shutdownAndReload_SRCs(): ");
        }
        n = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.shutdown.card.limit", "1800")));
        n2 = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.reload.card.limit", "3600")));
        try {
            for (int i = 0; i < this.storageResourceCards.size(); ++i) {
                dspHardwareComponent = (DspHardwareComponent)this.storageResourceCards.get(i);
                if (dspHardwareComponent.getLocator().startsWith("Front")) {
                    string2 = dspHardwareComponent.getLocator().substring(5);
                } else if (dspHardwareComponent.getLocator().startsWith("Rear")) {
                    string2 = dspHardwareComponent.getLocator().substring(4);
                } else {
                    throw new Exception("Unexpected card slot locator detected: \"" + dspHardwareComponent.getLocator() + "\"");
                }
                this.message(this, "Updating the SRC in slot " + string2 + ".");
                vector = this.expectedShutdownCardTraps(string2);
                vector2 = this.errorShutdownCardTraps(string2);
                string = "shutdown card " + string2 + "\r";
                this.retryDspCommand(this.hostname, string, vector, vector2, vector3, vector4, n);
                Thread.sleep(120000L);
                string = "reload card " + string2 + "\r";
                vector = this.expectdReloadSRCCardTraps(string2);
                vector2 = this.errorReloadSRCCardTraps(string2);
                this.retryDspCommand(this.hostname, string, vector, vector2, vector3, vector4, n2);
                Thread.sleep(360000L);
            }
        }
        catch (Exception exception) {
            throw new InteractiveSessionException("Firmware update for SRCs failed.", exception);
        }
    }

    private void shutdownAndReload_SFCs() throws InteractiveSessionException {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        DspHardwareComponent dspHardwareComponent = null;
        String string = "";
        String string2 = "";
        int n = 0;
        int n2 = 0;
        if (this.session_debug) {
            System.out.println("DSP Manipulator.shutdownAndReload_SFCs(): ");
        }
        n = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.shutdown.card.limit", "1800")));
        n2 = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.reload.card.limit", "3600")));
        try {
            for (int i = 0; i < this.switchFabricCards.size(); ++i) {
                dspHardwareComponent = (DspHardwareComponent)this.switchFabricCards.get(i);
                if (dspHardwareComponent.getIgnoreStatus()) continue;
                if (dspHardwareComponent.getLocator().startsWith("Front")) {
                    string2 = dspHardwareComponent.getLocator().substring(5);
                } else if (dspHardwareComponent.getLocator().startsWith("Rear")) {
                    string2 = dspHardwareComponent.getLocator().substring(4);
                } else {
                    throw new Exception("Unexpected card slot locator detected: \"" + dspHardwareComponent.getLocator() + "\"");
                }
                this.message(this, "Updating the SFC in slot " + string2 + ".");
                vector = this.expectedShutdownCardTraps(string2);
                vector2 = this.errorShutdownCardTraps(string2);
                string = "shutdown card " + string2 + "\r";
                this.retryDspCommand(this.hostname, string, vector, vector2, vector3, vector4, n);
                vector = this.expectdReloadSFCCardTraps(string2);
                vector2 = this.errorReloadSFCCardTraps(string2);
                Thread.sleep(120000L);
                string = "reload card " + string2 + "\r";
                this.retryDspCommand(this.hostname, string, vector, vector2, vector3, vector4, n2);
                Thread.sleep(360000L);
            }
        }
        catch (Exception exception) {
            throw new InteractiveSessionException("Firmware update for SFCs failed", exception);
        }
    }

    private void enableNormalSFCs() throws InteractiveSessionException {
        DspHardwareComponent dspHardwareComponent = null;
        if (this.session_debug) {
            System.out.println("DSP Manipulator.enableNormalSFCs(): ");
        }
        try {
            for (int i = 0; i < this.switchFabricCards.size(); ++i) {
                dspHardwareComponent = (DspHardwareComponent)this.switchFabricCards.get(i);
                if (dspHardwareComponent.getIgnoreStatus()) {
                    dspHardwareComponent.setIgnoreStatus(false);
                    continue;
                }
                dspHardwareComponent.setIgnoreStatus(true);
            }
        }
        catch (Exception exception) {
            throw new InteractiveSessionException(exception);
        }
    }

    private Enumeration constructNewHWComponents() throws InteractiveSessionException {
        Object object;
        Enumeration enumeration = null;
        HardwareComponent hardwareComponent = null;
        DspHardwareComponent dspHardwareComponent = null;
        Vector<DspHardwareComponent> vector = new Vector<DspHardwareComponent>(0);
        String string = "";
        String string2 = "";
        enumeration = this.getHardwareComponentsToUpdate();
        if (enumeration != null) {
            object = this.getChassisStatus();
            while (enumeration.hasMoreElements()) {
                hardwareComponent = (HardwareComponent)enumeration.nextElement();
                if (!(hardwareComponent instanceof DspHardwareComponent)) continue;
                dspHardwareComponent = (DspHardwareComponent)hardwareComponent;
                string = dspHardwareComponent.getDSPClass();
                if (string.equals("Switch Fabric Card")) {
                    string2 = this.updateNewSFCStatus(dspHardwareComponent, (String)object);
                    dspHardwareComponent.setDSPState(string2);
                }
                vector.addElement(dspHardwareComponent);
            }
        }
        object = vector.elements();
        return object;
    }

    private String updateNewSFCStatus(DspHardwareComponent dspHardwareComponent, String string) {
        Object var3_3 = null;
        LineParser lineParser = new LineParser();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        try {
            if (dspHardwareComponent.getDSPClass().indexOf("Switch Fabric Card") != -1) {
                if (dspHardwareComponent.getLocator().startsWith("Front")) {
                    string2 = dspHardwareComponent.getLocator().substring(5);
                } else if (dspHardwareComponent.getLocator().startsWith("Rear")) {
                    string2 = dspHardwareComponent.getLocator().substring(4);
                }
                string2 = string2.trim();
                string3 = string2 + " " + "Switch Fabric Card";
                string4 = this.getLine(string3, string);
                if (!string4.equals("")) {
                    try {
                        string4 = lineParser.getTokenBetween(string4, "Card", "");
                        String string6 = lineParser.getTokenNumberFromLeft(string4, 1);
                        string4 = lineParser.getTokenBetween(string4, string6, "");
                        string5 = string4.trim();
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        this.log.println(this, 1, stringIndexOutOfBoundsException.getMessage());
                        this.log.printStackTrace(this, 7, stringIndexOutOfBoundsException);
                    }
                } else {
                    this.log.println(this, 2, "Cannot determine the state of the Switch Fabric Card.");
                }
            }
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 2, exception);
        }
        return string5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void configureSnmpServer(int n) throws InteractiveSessionException {
        try {
            block16: {
                try {
                    String string = this.manipulator.getHost().getAddress();
                    String string2 = this.manipulator.getHost().getPrimaryHost().getAddress();
                    this.username = this.properties.getProperty("patchpro.userid", "root");
                    this.password = this.getPassword(string);
                    this.telnetSession = this.getInstanceOfTelnetSession(string, this.username, this.password);
                    if (this.telnetSession == null) {
                        throw new InteractiveSessionException("Unable to establish a telnet session with host " + string);
                    }
                    if (!this.telnetSession.expectedResponse("configure\r", "(config)#", 5000)) {
                        if (!this.session_debug) throw new Exception("DSP \"configure\" command completed unsuccessfully");
                        System.out.println("DSP \"configure\" command completed unsuccessfully");
                        throw new Exception("DSP \"configure\" command completed unsuccessfully");
                    }
                    if (this.session_debug) {
                        System.out.println("DSP \"configure\" command completed successfully");
                    }
                    if (!this.telnetSession.expectedResponse("logging action trap all UPGRADE\r", "(config)#", 5000)) {
                        if (!this.session_debug) throw new Exception("DSP \"logging action trap all UPGRADE\" command completed unsuccessfully");
                        System.out.println("DSP \"logging action trap all UPGRADE\" command completed unsuccessfully");
                        throw new Exception("DSP \"logging action trap all UPGRADE\" command completed unsuccessfully");
                    }
                    if (this.session_debug) {
                        System.out.println("DSP \"logging action trap all UPGRADE\" command completed successfully");
                    }
                    if (!this.telnetSession.expectedResponse("logging action trap all MIC_Failover\r", "(config)#", 5000)) {
                        if (!this.session_debug) throw new Exception("DSP \"logging action trap all MIC_Failover\" command completed unsuccessfully");
                        System.out.println("DSP \"logging action trap all MIC_Failover\" command completed unsuccessfully");
                        throw new Exception("DSP \"logging action trap all MIC_Failover\" command completed unsuccessfully");
                    }
                    if (this.session_debug) {
                        System.out.println("DSP \"logging action trap all MIC_Failover\" command completed successfully");
                    }
                    if (!this.telnetSession.expectedResponse("logging action trap all HOT_SWAP\r", "(config)#", 5000)) {
                        if (!this.session_debug) throw new Exception("DSP \"logging action trap all HOT_SWAP\" command completed unsuccessfully");
                        System.out.println("DSP \"logging action trap all HOT_SWAP\" command completed unsuccessfully");
                        throw new Exception("DSP \"logging action trap all HOT_SWAP\" command completed unsuccessfully");
                    }
                    if (this.session_debug) {
                        System.out.println("DSP \"logging action trap all HOT_SWAP\" command completed successfully");
                    }
                    if (!this.telnetSession.expectedResponse("snmp-server host " + string2 + " version 2c public udp-port " + n + "\r", "(config)#", 5000)) {
                        if (!this.session_debug) throw new Exception("DSP \"snmp-server host " + string2 + " version 2c public udp-port " + n + "\" command completed unsuccessfully");
                        System.out.println("DSP \"snmp-server host " + string2 + " version 2c public udp-port " + n + "\" command completed unsuccessfully");
                        throw new Exception("DSP \"snmp-server host " + string2 + " version 2c public udp-port " + n + "\" command completed unsuccessfully");
                    }
                    if (this.session_debug) {
                        System.out.println("DSP \"snmp-server host " + string2 + " version 2c public udp-port " + n + "\" command completed successfully");
                    }
                    if (!this.telnetSession.expectedResponse("Snmp-server trap verbose\r", "(config)#", 5000)) {
                        if (!this.session_debug) throw new Exception("DSP \"Snmp-server trap verbose\" command completed unsuccessfully");
                        System.out.println("DSP \"Snmp-server trap verbose\" command completed unsuccessfully");
                        throw new Exception("DSP \"Snmp-server trap verbose\" command completed unsuccessfully");
                    }
                    if (!this.session_debug) break block16;
                    System.out.println("DSP \"Snmp-server trap verbose\" command completed successfully");
                }
                catch (Exception exception) {
                    throw new InteractiveSessionException("DSP SNMP server configuration failed.", exception);
                }
            }
            Object var5_5 = null;
            if (this.telnetSession == null) return;
            this.telnetSession.disconnect();
            return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (this.telnetSession == null) throw throwable;
            this.telnetSession.disconnect();
            throw throwable;
        }
    }

    public void processSnmpTrapV1(SnmpPduTrap snmpPduTrap) {
        SnmpVarBind[] snmpVarBindArray = snmpPduTrap.varBindList;
        try {
            for (int i = 0; i < snmpVarBindArray.length; ++i) {
                ArrayList arrayList = (ArrayList)this.util.svarToProperty(snmpVarBindArray[i]);
                this.processSnmpTrap(arrayList);
            }
        }
        catch (Exception exception) {
            this.debugging("processSnmpTrapV1: " + exception.getMessage());
        }
    }

    public void processSnmpTrapV2(SnmpPduRequest snmpPduRequest) {
        SnmpVarBind[] snmpVarBindArray = snmpPduRequest.varBindList;
        try {
            for (int i = 0; i < snmpVarBindArray.length; ++i) {
                ArrayList arrayList = (ArrayList)this.util.svarToProperty(snmpVarBindArray[i]);
                this.processSnmpTrap(arrayList);
            }
        }
        catch (Exception exception) {
            this.debugging("processSnmpTrapV2: " + exception.getMessage());
        }
    }

    private static int getSRCIndex(DspHardwareComponent dspHardwareComponent) throws InteractiveSessionException {
        String string = dspHardwareComponent.getLocator();
        String string2 = "x" + string;
        if (string.startsWith("Front")) {
            string2 = string.substring(5);
        } else if (string.startsWith("Rear")) {
            string2 = string.substring(4);
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InteractiveSessionException("Unexpected card slot locator detected: \"" + string + "\"");
        }
        return n;
    }

    private void upgradeStart() throws InteractiveSessionException {
        try {
            int n = 0;
            if (this.session_debug) {
                System.out.println("DSP Manipulator.upgradeStart(): ");
            }
            n = 60000;
            String string = "upgrade start\r";
            Vector vector = this.expectedUpgradeStartTraps();
            Vector vector2 = this.errorUpgradeStartTraps();
            Vector vector3 = new Vector();
            Vector vector4 = new Vector();
            this.issueDspCommand(this.hostname, string, vector, vector2, vector3, vector4, n, true);
        }
        catch (InteractiveSessionException interactiveSessionException) {
            this.debugging("SNMP traps for upgrade start command not received or failure traps got caught.\nVerify Auto-Failback/Auto-Save via CLI.");
            if (!this.autoFailbackDisabled()) {
                throw new InteractiveSessionException("upgrade start failed: Auto-Failback is not DISABLED.");
            }
            if (!this.autoSaveDisabled()) {
                throw new InteractiveSessionException("upgrade start failed: Auto-Save is not DISABLED.");
            }
        }
    }

    private void upgradeStop() throws InteractiveSessionException {
        try {
            int n = 0;
            if (this.session_debug) {
                System.out.println("DSP Manipulator.upgradeStop(): ");
            }
            n = 60000;
            String string = "upgrade stop\r";
            Vector vector = this.expectedUpgradeStopTraps();
            Vector vector2 = this.errorUpgradeStopTraps();
            Vector vector3 = new Vector();
            Vector vector4 = new Vector();
            this.issueDspCommand(this.hostname, string, vector, vector2, vector3, vector4, n, true);
        }
        catch (InteractiveSessionException interactiveSessionException) {
            this.debugging("SNMP traps for upgrade stop command not received or failure traps got caught.\nVerify Auto-Failback/Auto-Save via CLI.");
            if (this.autoFailbackDisabled()) {
                throw new InteractiveSessionException("upgrade stop failed: Auto-Failback is not ENABLED.");
            }
            if (this.autoSaveDisabled()) {
                throw new InteractiveSessionException("upgrade stop failed: Auto-Save is not ENABLED.");
            }
        }
    }

    private boolean autoFailbackDisabled() throws InteractiveSessionException {
        boolean bl = false;
        String string = this.executeInConfig(SHOW_AUTO_FAILBACK, 30000);
        string = string.trim();
        this.entry("autoFailbackDisabled");
        this.debugging(string);
        String string2 = this.getLine(PREFIX_AUTO_FAILBACK, string);
        if (string2 != null && string2.toLowerCase().indexOf(DISABLED) != -1) {
            bl = true;
        }
        String string3 = bl ? "Verified: Auto-Failback DISABLED" : "Verified: Auto-Failback ENABLED";
        this.debugging(string3);
        return bl;
    }

    public boolean autoSaveDisabled() throws InteractiveSessionException {
        boolean bl = false;
        String string = this.executeInConfig(SHOW_AUTO_SAVE, 30000);
        string = string.trim();
        this.entry("autoSaveDisabled");
        this.debugging(string);
        String string2 = this.getLine("Error:", string);
        if (string2 == null) {
            String string3 = this.getLine(PREFIX_AUTO_SAVE, string);
            if (string3 != null && string3.toLowerCase().indexOf(DISABLED) != -1) {
                bl = true;
            }
        } else {
            string = this.executeInConfig(NO_AUTO_SAVE, 30000);
            string = string.trim();
            this.debugging(string);
            String string4 = this.getLine("AutoSave", string);
            if (string4 == null) {
                string4 = this.getLine(PREFIX_AUTO_SAVE, string);
            }
            if (string4 != null && string4.toLowerCase().indexOf("already") != -1) {
                bl = true;
            } else {
                this.debugging("Verified via no auto-save: Auto-Save ENABLED");
                this.debugging("ENABLE back Auto-Save since Auto-Save was disabled during status verification.");
                string = this.executeInConfig(AUTO_SAVE, 30000);
                this.debugging(string);
                bl = false;
            }
        }
        String string5 = bl ? "Verified: Auto-Save DISABLED" : "Verified: Auto-Save ENABLED";
        this.debugging(string5);
        return bl;
    }

    public void disableAutoSave() throws InteractiveSessionException {
        String string = this.executeInConfig(NO_AUTO_SAVE, 30000);
        string = string.trim();
        this.debugging("DSPOSImageInstaller.disableAutoSave()");
        this.debugging(string);
        String string2 = this.getLine("AutoSave", string);
        if (string2 == null) {
            string2 = this.getLine(PREFIX_AUTO_SAVE, string);
        }
        if (string2 == null || string2.toLowerCase().indexOf(DISABLED) == -1) {
            throw new InteractiveSessionException("no auto-save failed: Auto-Save has not been DISABLED.");
        }
        this.debugging("Auto-Save has been DISABLED.");
    }

    private String getChassisStatus() throws InteractiveSessionException {
        String string = "";
        this.entry("getChassisStatus");
        this.debugging("\n\"show chassis\" command  issued \n");
        int n = 0;
        int n2 = 50000;
        boolean bl = false;
        do {
            ++n;
            try {
                string = this.execute("show chassis", n2);
                bl = true;
            }
            catch (InteractiveSessionException interactiveSessionException) {
                this.printStackTrace(this, 4, interactiveSessionException);
                n2 += 10000;
                if (n != 3) continue;
                throw interactiveSessionException;
            }
        } while (!bl && n < 3);
        this.exit("getChassisStatus");
        return string;
    }

    private void get_startup_status() throws InteractiveSessionException {
        int n = 150000;
        int n2 = 0;
        String string = "ps -ef";
        Runtime runtime = null;
        Process process = null;
        InputStream inputStream = null;
        StreamReader streamReader = null;
        StringBuffer stringBuffer = null;
        boolean bl = true;
        try {
            for (int i = 0; i < 10; ++i) {
                stringBuffer = new StringBuffer("");
                runtime = Runtime.getRuntime();
                process = runtime.exec(string);
                inputStream = process.getInputStream();
                streamReader = new StreamReader(inputStream, stringBuffer);
                streamReader.start();
                n2 = process.waitFor();
                streamReader.join(5000L);
                if (stringBuffer.toString().indexOf("get_startup") == -1) {
                    bl = false;
                    break;
                }
                stringBuffer = null;
                streamReader = null;
                runtime = null;
                process = null;
                inputStream = null;
                Thread.sleep(n);
            }
        }
        catch (Exception exception) {
            throw new InteractiveSessionException("Unexpected exception while determining whether the \"get_startup script\" is still running on the Service Processor.", exception);
        }
        if (bl) {
            throw new InteractiveSessionException("Unable to proceed with upgrading the DSP since the \"get_startup script\" is still running on the Service Processor.");
        }
    }

    private boolean setGlobalSnmpTrapListener() {
        boolean bl = false;
        try {
            int n = this.getSnmpTrapPort();
            SnmpEventReportDispatcherPool.addTrapListener(n, this);
            bl = true;
        }
        catch (SocketException socketException) {
            String string = "Failed to establish SNMP event report dispatcher.";
            this.critical(this, string);
            this.printStackTrace(this, 2, socketException);
            this.message("\n" + string);
            this.issueFail(new PatchInstallFailedException(string));
            this.incrementProgress(5.0);
        }
        return bl;
    }

    private boolean extractDSPPatch() {
        boolean bl = false;
        try {
            System.gc();
            this.patchDirectoryFile = this.extractPatch();
            bl = true;
        }
        catch (Exception exception) {
            String string = "Failed to extract DSP firmware patch.";
            this.critical(this, string);
            this.printStackTrace(this, 2, exception);
            this.issueFail(new PatchInstallFailedException(57));
            this.incrementProgress(4.0);
        }
        return bl;
    }

    private void stubInstallation() {
        this.message("\nStubbing firmware update for DSP " + this.getDSPIPAddr());
        try {
            PatchID patchID = this.getPatchIDByFWVersion(this.getPatchProProperties().getProperty("patchpro.DSP.package", "SUNWdspf1"), this.getFirmwareVersion());
            this.reportHardwares();
            Enumeration enumeration = this.constructNewHWComponents();
            this.setAuditRecordData(patchID, enumeration);
        }
        catch (InteractiveSessionException interactiveSessionException) {
            interactiveSessionException.printStackTrace();
        }
        this.incrementProgress(2.0);
    }

    private void reportDSPComponent(List list) {
        System.out.println("DSP hardware components: ");
        for (int i = 0; list != null && i < list.size(); ++i) {
            DspHardwareComponent dspHardwareComponent = (DspHardwareComponent)list.get(i);
            System.out.println("comp[" + i + "]: " + dspHardwareComponent.toString() + " *ignoreStatus: " + dspHardwareComponent.getIgnoreStatus());
        }
    }

    class StreamReader
    extends Thread {
        BufferedReader r;
        StringBuffer output;

        public StreamReader(InputStream inputStream, StringBuffer stringBuffer) {
            this.r = new BufferedReader(new InputStreamReader(inputStream));
            this.output = stringBuffer;
        }

        public void run() {
            try {
                String string;
                while ((string = this.r.readLine()) != null) {
                    this.output.append(string);
                }
            }
            catch (Throwable throwable) {
                System.out.println(throwable.getMessage());
            }
        }
    }
}

