/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.host.DSP;
import com.sun.patchpro.host.SoftwarePackage;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.SunOSRmtInstallerPrtl;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.CmdInput;
import com.sun.patchpro.util.CommandSession;
import com.sun.patchpro.util.InteractiveSessionException;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.StrUtil;
import com.sun.patchpro.util.TelnetSession;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public abstract class SunOSRmtDSPInstallerPrtl
extends SunOSRmtInstallerPrtl {
    private static final String FIRMWARE_IMAGE_DIRECTORY = "/var/sadm/swimages/";
    private static final String FIRMWARE_REPOSITORY_PROMPT = "Please Enter Patch Location Pathname";
    private static final String NETRC_DIRECTORY_PROMPT = "Enter Your Home Directory Path";
    private static final String FTP_USER_PROMPT = "Enter ftp user";
    private static final String FTP_PASSWORD_PROMPT = "Enter ftp password";
    private static final String LOGIN_INCORRECT_MSG = "Login failed";
    private static final String CLEANING_UP_MSG = "Cleaning Up Temporary Files...";
    private static final String PASSWORD_FILE_SUFFIX = "pw";
    private String psx1000Image1 = null;
    private String psx1000Image2 = null;
    private DSP dsp = null;
    private ByteArrayOutputStream currentBaos = null;
    private ByteArrayOutputStream sessionBaos = null;
    protected LocalizedMessages msgcat = null;
    private boolean session_debug;

    public SunOSRmtDSPInstallerPrtl(Manipulator manipulator, PatchProProperties patchProProperties) throws InstallFailedException {
        super(manipulator, patchProProperties);
        this.msgcat = new LocalizedMessages(patchProProperties.getLocale());
        this.dsp = (DSP)manipulator.getHost();
        this.currentBaos = new ByteArrayOutputStream();
        this.sessionBaos = new ByteArrayOutputStream();
        this.session_debug = this.isDebug();
    }

    protected void uploadFirmwareImages(String string) throws InteractiveSessionException {
        CommandSession commandSession = null;
        try {
            int n = 0;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            n = this.getFWUploadTime();
            string4 = this.getDSPUserName();
            string5 = this.getPassword(string);
            string3 = this.getPatch().getPatchID().getPatchID();
            string2 = FIRMWARE_IMAGE_DIRECTORY + string3;
            System.gc();
            commandSession = new CommandSession();
            commandSession.start("/sbin/sh " + string2 + "/dsp.sh ppro");
            System.gc();
            if (!commandSession.expectedResponse(string + "\n", FIRMWARE_REPOSITORY_PROMPT, 10000) && commandSession.getAllSessionMessages().indexOf(FIRMWARE_REPOSITORY_PROMPT) == -1) {
                commandSession.cleanup();
                this.log.println(this, 2, "Problem detected while running the " + string2 + "/dsp.sh script. The prompt for the firmware " + "repository was not detected.");
                throw new Exception("Expected : \"Please Enter Patch Location Pathname\" response did not occur.\n\nSession output:\n" + commandSession.getAllSessionMessages());
            }
            System.gc();
            if (!commandSession.expectedResponse(string2 + "\n", NETRC_DIRECTORY_PROMPT, 20000) && commandSession.getAllSessionMessages().indexOf(NETRC_DIRECTORY_PROMPT) == -1) {
                this.log.println(this, 2, "Problem detected while running the " + string2 + "/dsp.sh script. The prompt for specifying the directory " + "where the .netrc file is to be created was not detected.");
                throw new Exception("Expected : \"Enter Your Home Directory Path\" response did not occur.\n\nSession output:\n" + commandSession.getAllSessionMessages());
            }
            System.gc();
            if (!commandSession.expectedResponse("\n", FTP_USER_PROMPT, 5000) && commandSession.getAllSessionMessages().indexOf(FTP_USER_PROMPT) == -1) {
                this.log.println(this, 2, "Problem detected while running the " + string2 + "/dsp.sh script. The prompt for the FTP username was not detected.");
                throw new Exception("Expected : \"Enter ftp user\" prompt not detected.\n\nSession output:\n" + commandSession.getAllSessionMessages());
            }
            System.gc();
            if (!commandSession.expectedResponse(string4 + "\n", FTP_PASSWORD_PROMPT, 5000) && commandSession.getAllSessionMessages().indexOf(FTP_PASSWORD_PROMPT) == -1) {
                this.log.println(this, 2, "Problem detected while running the " + string2 + "/dsp.sh script. The prompt for the FTP password was not detected.");
                throw new Exception("Expected : \"Enter ftp password\" prompt not detected.\n\nSession output:\n" + commandSession.getAllSessionMessages());
            }
            System.gc();
            if (commandSession.expectedResponse(string5 + "\n", LOGIN_INCORRECT_MSG, 5000)) {
                this.log.println(this, 2, "Problem detected while running the " + string2 + "/dsp.sh script. Unable to establish an FTP connection " + "with the username and password in effect.");
                throw new Exception("Expected : \"Login failed\" message was detected.\n\nSession output:\n" + commandSession.getAllSessionMessages());
            }
            System.gc();
            if (commandSession.getAllSessionMessages().indexOf("Login incorrect") != -1 || commandSession.getAllSessionMessages().indexOf(LOGIN_INCORRECT_MSG) != -1) {
                this.log.println(this, 2, "Problem detected while running the " + string2 + "/dsp.sh script. Unable to establish an FTP connection " + "with the username and password in effect.");
                throw new Exception("\n\nSession output:\n" + commandSession.getAllSessionMessages());
            }
            if (!commandSession.waitfor(CLEANING_UP_MSG, n) && commandSession.getAllSessionMessages().indexOf(CLEANING_UP_MSG) == -1) {
                this.log.println(this, 2, "Problem detected while running the " + string2 + "/dsp.sh script. The time reserved for the upload process " + "has elapsed.");
                throw new Exception("Expected : FTP \"Cleaning Up Temporary Files...\" message was never detected\n\nSession output:\n" + commandSession.getAllSessionMessages());
            }
        }
        catch (Exception exception) {
            this.printStackTrace(this, 2, exception);
            throw new InteractiveSessionException(exception);
        }
        finally {
            if (commandSession != null) {
                commandSession.cleanup();
            }
        }
    }

    protected void getPSX1000FirmwareImages() throws InteractiveSessionException {
        Properties properties = null;
        try {
            SoftwarePackage softwarePackage = this.installFirmwarePackage();
            properties = softwarePackage.getPkginfo();
            this.manipulator.getHost().addSoftwarePackage(softwarePackage);
            this.setPSX1000Image1(properties.getProperty("SUNW_DSPIMAGE1_NAME", null));
            this.setPSX1000Image2(properties.getProperty("SUNW_DSPIMAGE2_NAME", null));
        }
        catch (Exception exception) {
            throw new InteractiveSessionException(exception.getMessage());
        }
    }

    protected void setPSX1000Image1(String string) {
        this.psx1000Image1 = string;
    }

    protected String getPSX1000Image1() {
        return this.psx1000Image1;
    }

    protected void setPSX1000Image2(String string) {
        this.psx1000Image2 = string;
    }

    protected String getPSX1000Image2() {
        return this.psx1000Image2;
    }

    public void processSnmpTrap(ArrayList arrayList) throws InteractiveSessionException {
        Object var2_2 = null;
        try {
            switch ((Integer)arrayList.get(1)) {
                case 0: {
                    if (this.session_debug) {
                        System.out.println("SNMP Type : 0");
                        System.out.println("Value: " + (Long)arrayList.get(0));
                    }
                    break;
                }
                case 5: {
                    if (this.session_debug) {
                        System.out.println("SNMP Type : 5");
                        System.out.println("Value: " + (Long)arrayList.get(0));
                    }
                    break;
                }
                case 8: {
                    if (this.session_debug) {
                        System.out.println("SNMP Type : 8\n");
                    }
                    Vector vector = (Vector)arrayList.get(0);
                    for (int i = 0; i < vector.size(); ++i) {
                        if (!this.session_debug) continue;
                        System.out.print(((Byte)vector.elementAt(i)).toString());
                    }
                    break;
                }
                case 2: {
                    if (this.session_debug) {
                        System.out.println("SNMP Type : 2");
                        System.out.println("Value: " + (String)arrayList.get(0));
                    }
                    this.writeSnmpRecord((String)arrayList.get(0) + "\n");
                    break;
                }
                case 1: {
                    if (this.session_debug) {
                        System.out.println("SNMP Type : 1");
                        if (arrayList.get(0) instanceof Long) {
                            System.out.println("Value: " + (Long)arrayList.get(0));
                            break;
                        }
                        System.out.println("Value: " + (Integer)arrayList.get(0));
                    }
                    break;
                }
                case 6: {
                    if (this.session_debug) {
                        System.out.println("SNMP Type : 6");
                        System.out.println("Value: " + (Long)arrayList.get(0));
                    }
                    break;
                }
                case 3: {
                    if (this.session_debug) {
                        System.out.println("SNMP Type : 3");
                        System.out.println("Value: " + (String)arrayList.get(0));
                    }
                    break;
                }
                case 4: {
                    if (this.session_debug) {
                        System.out.println("SNMP Type : 4");
                        System.out.println("Value: " + (String)arrayList.get(0));
                    }
                    break;
                }
                case 7: {
                    if (this.session_debug) {
                        System.out.println("SNMP Type : 7");
                        System.out.println("Value: " + (Long)arrayList.get(0));
                    }
                    break;
                }
                default: {
                    if (this.session_debug) {
                        System.out.println("Unexpected SNMP trap type \"" + (Integer)arrayList.get(1) + "\" detected.");
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new InteractiveSessionException(exception.getMessage());
        }
    }

    protected void writeSnmpRecord(String string) throws IOException {
        this.log.println(this, 6, "SNMP Trap from DSP:" + string);
        this.currentBaos.write(string.getBytes(), 0, string.length());
        this.sessionBaos.write(string.getBytes(), 0, string.length());
    }

    protected Vector expectedUpgradeStartTraps() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("LOG_INFO     (HOT_SWAP: 0-0)  Upgrade start completed successfully");
        return vector;
    }

    protected Vector errorUpgradeStartTraps() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("LOG_ERR      (HOT_SWAP: 0-0)  Upgrade start failed: Trouble disabling auto-failback");
        vector.addElement("LOG_ERR      (HOT_SWAP: 0-0)  Upgrade start failed: Trouble disabling auto-save");
        return vector;
    }

    protected Vector expectedUpgradeStopTraps() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("LOG_INFO     (HOT_SWAP: 0-0)  Upgrade stop completed successfully");
        return vector;
    }

    protected Vector errorUpgradeStopTraps() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("LOG_ERR      (HOT_SWAP: 0-0)  Upgrade stop failed: Trouble re-enabling auto-failback");
        vector.addElement("LOG_ERR      (HOT_SWAP: 0-0)  Upgrade stop failed: Trouble re-enabling auto-save");
        vector.addElement("LOG_ERR      (HOT_SWAP: 0-0)  Upgrade stop failed: Trouble forcing redistribution of luns");
        return vector;
    }

    protected Vector expectedUpgradeTraps() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("LOG_INFO     (UPGRADE: 0-0)  Upgrade phase 1 + 2 completed");
        return vector;
    }

    protected Vector errorUpgradeTraps() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("Upgrade phase 1 failed");
        vector.addElement("Upgrade phase 2 failed");
        return vector;
    }

    protected Vector expectedRebootTraps() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("LOG_INFO     (MIC_Failover: 0-0)  MIC redund - file sync: MIC master/slave FILES ARE IN SYNC!");
        return vector;
    }

    protected Vector errorRebootTraps() {
        Vector vector = new Vector();
        return vector;
    }

    protected Vector expectedShutdownCardTraps(String string) {
        Vector<String> vector = new Vector<String>();
        vector.addElement("LOG_INFO     (HOT_SWAP: 0-0)  Shutdown complete for card (" + string + ")");
        vector.addElement("Volume distribution complete");
        return vector;
    }

    protected Vector errorShutdownCardTraps(String string) {
        Vector vector = new Vector();
        return vector;
    }

    protected Vector expectdReloadSRCCardTraps(String string) {
        Vector<String> vector = new Vector<String>();
        vector.addElement("LOG_INFO     (HOT_SWAP: 0-0)  Restart complete for card (" + string + ").");
        vector.addElement("Volume distribution complete");
        return vector;
    }

    protected Vector errorReloadSRCCardTraps(String string) {
        Vector vector = new Vector();
        return vector;
    }

    protected Vector expectdReloadSFCCardTraps(String string) {
        Vector<String> vector = new Vector<String>();
        vector.addElement("LOG_INFO     (HOT_SWAP: 0-0)  Restart complete for card (" + string + ").");
        vector.addElement("Volume distribution complete");
        return vector;
    }

    protected Vector errorReloadSFCCardTraps(String string) {
        Vector vector = new Vector();
        return vector;
    }

    protected void resetBuffer() {
        this.currentBaos.reset();
    }

    protected String getSessionMessages() {
        return this.currentBaos.toString();
    }

    protected String getAllSessionMessages() {
        return this.sessionBaos.toString();
    }

    protected void retryDspCommand(String string, String string2, Vector vector, Vector vector2, Vector vector3, Vector vector4, int n) throws InteractiveSessionException {
        int n2 = this.convertStringToInteger(this.properties.getProperty("patchpro.DSP.command.retryattempts", "3"));
        this.retryDspCommand(string, string2, vector, vector2, vector3, vector4, n, n2);
    }

    protected void retryDspCommand(String string, String string2, Vector vector, Vector vector2, Vector vector3, Vector vector4, int n, int n2) throws InteractiveSessionException {
        for (int i = 0; i < n2; ++i) {
            try {
                this.issueDspCommand(string, string2, vector, vector2, vector3, vector4, n, false);
                break;
            }
            catch (InteractiveSessionException interactiveSessionException) {
                if (i != n2 - 1) continue;
                Object[] objectArray = new String[]{string2.trim()};
                throw new InteractiveSessionException(interactiveSessionException.getMessage() + "\n\n" + this.msgcat.getMessage("dsp_command_failure", objectArray, "\"" + string2.trim() + "\" " + "failed while installing firmware " + "to the DSP. Please request a " + "service call to resolve this " + "problem."));
            }
        }
    }

    protected void issueDspCommand(String string, String string2, Vector vector, Vector vector2, Vector vector3, Vector vector4, int n, boolean bl) throws InteractiveSessionException {
        String string3;
        int n2;
        int n3;
        long l = n / 1000;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        GregorianCalendar gregorianCalendar = null;
        GregorianCalendar gregorianCalendar2 = null;
        TelnetSession telnetSession = null;
        this.reportIssueDspCommandArgs(string, string2, vector, vector2, vector3, vector4, n, bl);
        if (vector.size() == 0) {
            this.issueDspCommand(string, string2, vector3, vector4, n, bl);
            return;
        }
        string4 = this.properties.getProperty("patchpro.psx1000.userid", "root");
        try {
            string5 = this.getPassword(string);
        }
        catch (IOException iOException) {
            throw new InteractiveSessionException("DSP password is not available", iOException);
        }
        boolean bl2 = false;
        Object e = vector.elementAt(vector.size() - 1);
        AbstractList abstractList = vector;
        if (e instanceof Boolean) {
            bl2 = (Boolean)e;
            abstractList = new ArrayList(vector);
            abstractList.remove(abstractList.size() - 1);
        }
        if (bl2) {
            string6 = (String)abstractList.get(abstractList.size() - 1);
            this.debugging("\n\nThe last trap to wait for is \"" + string6 + "\"");
        }
        this.resetBuffer();
        telnetSession = this.getInstanceOfTelnetSession(string, string4, string5);
        if (telnetSession == null) {
            throw new InteractiveSessionException("Unable to establish a telnet session with host " + string);
        }
        String string9 = "# ";
        if (!telnetSession.expectedResponse("no page-mode\r", string9, 30000)) {
            this.warning(this, "Unable to disable the page mode on DSP.");
        }
        for (n3 = 0; n3 < vector3.size(); ++n3) {
            telnetSession.expect((String)vector3.elementAt(n3), (String)vector4.elementAt(n3) + "\r");
        }
        if (bl) {
            string9 = "(config)#";
            string9.trim();
            if (!telnetSession.expectedResponse("configure\r", string9, 5000)) {
                string8 = "DSP \"configure\" command completed unsuccessfully";
                this.debugging(string8);
                throw new InteractiveSessionException(string8);
            }
        }
        telnetSession.send(string2);
        gregorianCalendar = new GregorianCalendar();
        gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.add(14, n);
        n3 = 1;
        while (gregorianCalendar.before(gregorianCalendar2) && l > 0L) {
            String string10 = this.getSessionMessages();
            this.debugging("SESSMSG: " + string10);
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                string3 = (String)vector2.elementAt(n2);
                if (string10.indexOf(string3) == -1) continue;
                this.debugging("An error SNMP trap was detected...terminating");
                string7 = "Error detected processing the \"" + string2.trim() + "\" command. " + "\nSNMP error trap detected: " + string3 + "\nSNMP traps caught in this session:\n" + string10;
                throw new InteractiveSessionException(string7);
            }
            if (bl2) {
                if (string10.indexOf(string6) != -1) {
                    this.debugging("The last expected SNMP trap was detected ...");
                    n3 = 0;
                    break;
                }
            } else {
                n2 = 1;
                for (int i = 0; i < abstractList.size(); ++i) {
                    String string11 = (String)abstractList.get(i);
                    if (string10.indexOf(string11) >= 0) continue;
                    n2 = 0;
                    break;
                }
                if (n2 != 0) {
                    return;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                throw new InteractiveSessionException("DSP firmware update was interrupted by another patch operation.", interruptedException);
            }
            gregorianCalendar = null;
            gregorianCalendar = new GregorianCalendar();
            if (!this.session_debug || --l % 100L != 0L) continue;
            System.out.println("Seconds remaining is " + l);
        }
        if (n3 != 0) {
            string7 = "Error detected processing the \"" + string2.trim() + "\" command. Expected SNMP traps were not " + "detected within the specified time limit." + "\n\nSNMP traps related to this session:\n" + this.getSessionMessages();
            throw new InteractiveSessionException(string7);
        }
        int n4 = 0;
        n2 = 0;
        string3 = this.getSessionMessages();
        if (this.session_debug) {
            System.out.println("Verify that the retrieved SNMP traps are in the expected order in which they were sent\n");
            System.out.println("The SNMP Traps receives are: ");
            System.out.println(string3);
            System.out.println("\n\n");
        }
        for (int i = 0; i < abstractList.size(); ++i) {
            String string12 = (String)abstractList.get(i);
            n4 = string3.indexOf(string12, n2);
            if (n4 != -1) {
                this.debugging("Expected Message : " + string12 + " detected at offset " + n2);
                n2 = n4 + string12.length();
                continue;
            }
            string7 = "Error detected processing the \"" + string2.trim() + "\" command. " + "Expected SNMP trap \"" + string12 + "\" was not detected" + "\n\nSNMP traps related to this session:\n" + this.getSessionMessages();
            if (!this.session_debug) {
                throw new InteractiveSessionException(string7);
            }
            System.out.println(string7);
        }
        try {
            if (telnetSession != null) {
                telnetSession.disconnect();
            }
        }
        catch (InteractiveSessionException interactiveSessionException) {
            // empty catch block
        }
    }

    protected void issueDspCommand(String string, String string2, Vector vector, Vector vector2, int n, boolean bl) throws InteractiveSessionException {
        String string3 = this.properties.getProperty("patchpro.psx1000.userid", "root");
        String string4 = null;
        try {
            string4 = this.getPassword(string);
        }
        catch (IOException iOException) {
            throw new InteractiveSessionException("DSP password is not available", iOException);
        }
        TelnetSession telnetSession = null;
        telnetSession = this.getInstanceOfTelnetSession(string, string3, string4);
        if (telnetSession == null) {
            throw new InteractiveSessionException("Unable to establish a telnet session with host " + string);
        }
        String string5 = "# ";
        if (!telnetSession.expectedResponse("no page-mode\r", string5, 30000)) {
            this.warning(this, "Unable to disable the page mode on DSP.");
        }
        if (bl) {
            string5 = "(config)#";
            if (!telnetSession.expectedResponse("configure\r", string5, 5000)) {
                String string6 = "DSP \"configure\" command completed unsuccessfully";
                this.debugging(string6);
                throw new InteractiveSessionException(string6);
            }
            if (!telnetSession.expectedResponse(string2 + "\r", string5, n)) {
                String string7 = "DSP \"" + string2 + "\" command completed unsuccessfully";
                this.debugging(string7);
                throw new InteractiveSessionException(string7);
            }
        } else if (!telnetSession.expectedResponse(string2 + "\r", string5, n)) {
            String string8 = "The \"" + string2 + "\" command did not complete " + "within the expected amount of time.";
            this.debugging(string8);
            throw new InteractiveSessionException(string8);
        }
        try {
            if (telnetSession != null) {
                telnetSession.disconnect();
            }
        }
        catch (InteractiveSessionException interactiveSessionException) {
            // empty catch block
        }
    }

    protected String execute(String string, int n) throws InteractiveSessionException {
        return this.execute(string, null, n, false);
    }

    protected String execute(String string, CmdInput[] cmdInputArray, int n) throws InteractiveSessionException {
        return this.execute(string, cmdInputArray, n, false);
    }

    protected String executeInConfig(String string, int n) throws InteractiveSessionException {
        return this.execute(string, null, n, true);
    }

    protected String executeInConfig(String string, CmdInput[] cmdInputArray, int n) throws InteractiveSessionException {
        return this.execute(string, cmdInputArray, n, true);
    }

    protected String execute(String string, CmdInput[] cmdInputArray, int n, boolean bl) throws InteractiveSessionException {
        return this.execute(string, cmdInputArray, n, bl, true);
    }

    protected String execute(String string, CmdInput[] cmdInputArray, int n, boolean bl, boolean bl2) throws InteractiveSessionException {
        String string2 = "";
        String string3 = "";
        boolean bl3 = true;
        String string4 = this.getDSPIPAddr();
        String string5 = this.getDSPUserName();
        String string6 = "";
        this.entry("execute( " + string + " )");
        try {
            string6 = this.getDSPPassword();
        }
        catch (IOException iOException) {
            throw new InteractiveSessionException("DSP password is not available", iOException);
        }
        TelnetSession telnetSession = TelnetSession.getInstance(string4, string5, string6);
        if (telnetSession == null) {
            throw new InteractiveSessionException("Unable to establish a telnet session with DSP " + string4);
        }
        string3 = "#";
        bl3 = telnetSession.expectedResponse("no page-mode\r", string3, 30000);
        if (!bl3) {
            this.warning(this, "Unable to disable the page mode on DSP");
        }
        for (int i = 0; cmdInputArray != null && i < cmdInputArray.length; ++i) {
            telnetSession.expect(cmdInputArray[i].getPrompt(), cmdInputArray[i].getReply() + "\r");
        }
        if (bl) {
            string3 = "(config)#";
            bl3 = telnetSession.expectedResponse("configure\r", string3, 5000);
        }
        if (bl2) {
            bl3 = telnetSession.expectedResponse(string + "\r", string3, n);
        } else {
            telnetSession.send(string);
            bl3 = true;
        }
        this.reportCmdResult(string, bl3);
        try {
            string2 = telnetSession.getSessionMessages().trim();
            this.debugging("\nReturn message of the command " + string + "::\n" + string2);
            if (telnetSession != null) {
                telnetSession.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.exit("execute( " + string + " )");
        return string2;
    }

    protected void reportCmdResult(String string, boolean bl) throws InteractiveSessionException {
        if (!bl) {
            String string2 = "DSP \"" + string + "\" command did NOT completed.";
            this.error(this, string2);
            this.debugging(string2);
            throw new InteractiveSessionException(string2);
        }
        String string3 = "DSP \"" + string + "\" command completed.";
        this.debug(this, string3);
        this.debugging(string3);
    }

    protected DSP getDSP() {
        return this.dsp;
    }

    protected String getDSPIPAddr() {
        return this.dsp.getAddress();
    }

    protected String getDSPUserName() {
        return this.getPatchProProperties().getProperty("patchpro.psx1000.userid", "root");
    }

    protected String getDSPPassword() throws IOException {
        return this.getPassword(this.getDSPIPAddr());
    }

    protected String getFirmwareVersion() {
        String string = null;
        if (this.dsp != null) {
            string = this.dsp.getSysLevelFirmware();
        }
        return string;
    }

    protected int getFWUploadTime() {
        String string = this.getPatchProProperties().getProperty("patchpro.DSP.uploaddata.limit", "1800");
        return StrUtil.toMillisec(string);
    }

    protected int getSnmpTrapPort() {
        int n = this.convertStringToInteger(this.properties.getProperty("patchpro.DSP.snmp.port", "162"));
        return n;
    }

    void reportIssueDspCommandArgs(String string, String string2, List list, List list2, List list3, List list4, int n, boolean bl) {
        int n2;
        if (!this.isDebug()) {
            return;
        }
        System.out.println("DSP Manipulator.issueDspCommand() ... ");
        System.out.println("   Hostname: " + string);
        System.out.println("   Command : " + string2);
        if (list.size() == 0) {
            System.out.println("\n\n   No traps expected");
        } else {
            System.out.println("\n\n   Expected Traps :");
            for (n2 = 0; n2 < list.size(); ++n2) {
                Object e = list.get(n2);
                if (!(e instanceof String)) continue;
                System.out.println("\t    \"" + e + "\"");
            }
        }
        if (list2.size() == 0) {
            System.out.println("\n\n   No error traps expected");
        } else {
            System.out.println("\n\n   Expected Error Traps :");
            for (n2 = 0; n2 < list2.size(); ++n2) {
                System.out.println("\t\t\"" + (String)list2.get(n2) + "\"");
            }
        }
        if (list3.size() == 0) {
            System.out.println("\n\n   No prompts expected");
        } else {
            System.out.println("\n\n   Expected Prompts :");
            for (n2 = 0; n2 < list3.size(); ++n2) {
                System.out.println("\t\t\"" + (String)list3.get(n2) + "\"");
            }
        }
        if (list4.size() == 0) {
            System.out.println("\n\n   No replies to prompts expected ");
        } else {
            System.out.println("\n\n   Expected Replies :");
            for (n2 = 0; n2 < list4.size(); ++n2) {
                System.out.println("\t\t\"" + (String)list4.get(n2) + "\"");
            }
        }
        System.out.println("\n\nThe amount of time (milliseconds) to wait for command to complete is " + n);
    }
}

