/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.database.AuditRecord;
import com.sun.patchpro.database.DspFirmwareImageAuditRecord;
import com.sun.patchpro.database.FirmwareImageAuditRecord;
import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Installable;
import com.sun.patchpro.manipulators.InstallerEvent;
import com.sun.patchpro.manipulators.Manipulable;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.ManipulatorEvent;
import com.sun.patchpro.manipulators.ManipulatorListener;
import com.sun.patchpro.manipulators.Removable;
import com.sun.patchpro.manipulators.RemoveFailedException;
import com.sun.patchpro.manipulators.Remover;
import com.sun.patchpro.manipulators.RemoverEvent;
import com.sun.patchpro.manipulators.VerifierEvent;
import com.sun.patchpro.model.InstallPatchEvent;
import com.sun.patchpro.model.InstallPatchListener;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchInfo;
import com.sun.patchpro.patch.PatchInfoImpl;
import com.sun.patchpro.util.AuditManager;
import java.io.File;
import java.util.Vector;

public abstract class SunOSRemover
extends Remover
implements ManipulatorListener {
    private boolean thisPatchInstallDone = false;
    private boolean thisPatchInstallFailed = false;
    private Manipulator manipulator;
    private AuditManager auditManager;
    Vector listeners = new Vector();

    public SunOSRemover(Manipulator manipulator, PatchProProperties patchProProperties) throws RemoveFailedException {
        super(manipulator, patchProProperties);
        this.manipulator = manipulator;
        this.auditManager = AuditManager.getInstance();
    }

    protected void postRemove() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(InstallPatchListener installPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(installPatchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(InstallPatchListener installPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(installPatchListener);
        }
    }

    public void manipulatorProgress(ManipulatorEvent manipulatorEvent) {
        this.dispatchProgressEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchProgressEvent() {
        InstallPatchListener installPatchListener = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                installPatchListener = (InstallPatchListener)this.listeners.elementAt(i);
                installPatchListener.installPatchProgress(new InstallPatchEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchFailedEvent(String string) {
        InstallPatchListener installPatchListener = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                installPatchListener = (InstallPatchListener)this.listeners.elementAt(i);
                installPatchListener.installPatchFailed(new InstallPatchEvent(this, string));
            }
        }
    }

    public void manipulatorDone(ManipulatorEvent manipulatorEvent) {
        this.thisPatchInstallDone = true;
    }

    public void manipulatorFailed(InstallerEvent installerEvent) {
        Exception exception = ((Installable)installerEvent.getSource()).getFailure();
        this.thisPatchInstallDone = true;
        this.thisPatchInstallFailed = true;
        this.dispatchFailedEvent(exception.getMessage());
    }

    public void manipulatorFailed(RemoverEvent removerEvent) {
        Exception exception = ((Removable)removerEvent.getSource()).getFailure();
        this.thisPatchInstallDone = true;
        this.thisPatchInstallFailed = true;
        this.dispatchFailedEvent(exception.getMessage());
    }

    public void manipulatorFailed(VerifierEvent verifierEvent) {
        this.thisPatchInstallDone = true;
        this.thisPatchInstallFailed = true;
        this.dispatchFailedEvent("Received a Verifier event.");
    }

    public void manipulatorFailed(ManipulatorEvent manipulatorEvent) {
        this.thisPatchInstallDone = true;
        this.thisPatchInstallFailed = true;
        this.dispatchFailedEvent("Received a Manipulable event.");
    }

    public void installPatch(Manipulable manipulable) throws InstallFailedException {
        Installable installable = null;
        Patch patch = manipulable.getPatch();
        this.thisPatchInstallDone = false;
        this.thisPatchInstallFailed = false;
        try {
            try {
                installable = manipulable.getInstaller();
                Thread thread = new Thread(installable);
                installable.addListener(this);
                thread.start();
                while (!this.thisPatchInstallDone) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                installable.removeListener(this);
                if (thread != null) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.thisPatchInstallFailed) {
                    throw new InstallFailedException(installable.getFailure().getMessage());
                }
                Object var7_8 = null;
                if (installable != null) {
                    installable.removeListener(this);
                }
            }
            catch (InstallFailedException installFailedException) {
                throw new InstallFailedException(installFailedException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (installable != null) {
                installable.removeListener(this);
            }
            throw throwable;
        }
    }

    public PatchImpl constructPatch(PatchID patchID, Patch patch) throws MalformedPatchException {
        PatchInfoImpl patchInfoImpl = new PatchInfoImpl();
        PatchInfo patchInfo = patch.getPatchInfo();
        patchInfoImpl.setObsolesces(patchInfo.getObsolesces());
        patchInfoImpl.setArchitecture(patchInfo.getArchitecture());
        patchInfoImpl.setOS(patchInfo.getOS());
        patchInfoImpl.setRelease(patchInfo.getRelease());
        patchInfoImpl.setType(patchInfo.getType());
        patchInfoImpl.setObsolesces(patchInfo.getObsolesces());
        patchInfoImpl.setRequires(patchInfo.getRequires());
        patchInfoImpl.setConstraint(patchInfo.getConstraint());
        patchInfoImpl.setIncompat(patchInfo.getIncompat());
        patchInfoImpl.setPrefers(patchInfo.getPrefers());
        patchInfoImpl.setProperties(patchInfo.getProperties());
        patchInfoImpl.setObsolescedBy(new PatchID(patch.getPatchID().getPatchID()));
        return new PatchImpl(patchInfoImpl, patchID);
    }

    public void setPatchToUndo() throws Exception {
        block7: {
            try {
                File file = null;
                HardwareComponent[] hardwareComponentArray = null;
                Vector<HardwareComponent> vector = new Vector<HardwareComponent>();
                String string = this.manipulator.getPatch().getPatchID().getPatchID();
                AuditRecord auditRecord = this.auditManager.getInstalledPatchAuditRecord(new PatchID(string));
                if (auditRecord instanceof FirmwareImageAuditRecord || auditRecord instanceof DspFirmwareImageAuditRecord) {
                    hardwareComponentArray = ((FirmwareImageAuditRecord)auditRecord).getHardwareComponents();
                    for (int i = 0; i < hardwareComponentArray.length; ++i) {
                        vector.addElement(hardwareComponentArray[i]);
                    }
                    this.manipulator.setPatch(this.constructPatch(((FirmwareImageAuditRecord)auditRecord).getOldPatchID(), this.manipulator.getPatch()));
                    this.manipulator.setTargetHardware(vector.elements());
                    file = new File(this.properties.getProperty("patchpro.patch.install.directory"));
                    this.manipulator.constructCurrent(file);
                    if (this.debug) {
                        System.out.println("Firmware patch \"" + string + "\" is to be removed by installing patch \"" + this.manipulator.getPatch().getPatchID().getPatchID() + "\"");
                        if (vector.size() > 0) {
                            System.out.println("\n ... Hardware components associated with firmware patch");
                            for (int i = 0; i < vector.size(); ++i) {
                                HardwareComponent hardwareComponent = (HardwareComponent)vector.elementAt(i);
                                System.out.println(" ... ... " + hardwareComponent.getLocator());
                            }
                        }
                    }
                    break block7;
                }
                throw new Exception("Cannot undo patch \"" + string + "\" because its firmware audit record is missing.");
            }
            catch (Exception exception) {
                this.log.printStackTrace(this, 2, exception);
                throw new Exception(exception.getMessage());
            }
        }
    }
}

