/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.PatchInstallFailedException;
import com.sun.patchpro.manipulators.SunOSRmtInstallerPrtl;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.util.CommandSession;
import com.sun.patchpro.util.InteractiveSessionException;
import com.sun.patchpro.util.LineParser;
import com.sun.patchpro.util.LocalizedMessages;
import java.io.File;
import java.util.GregorianCalendar;

public class SunOSLantronixSCS400FirmwareInstaller
extends SunOSRmtInstallerPrtl {
    private static final String NTC_PERSONALITY_FILE = "/opt/SUNWsespnc/conf/ntc.pty";
    private LocalizedMessages msgcat;
    private LineParser lineParser = new LineParser();
    private Manipulator manipulator = null;
    private GregorianCalendar currentTime = null;
    private GregorianCalendar expiredTime = null;
    private PatchID patchID = null;

    public SunOSLantronixSCS400FirmwareInstaller(Manipulator manipulator, PatchProProperties patchProProperties) throws InstallFailedException {
        super(manipulator, patchProProperties);
        this.manipulator = manipulator;
        this.msgcat = new LocalizedMessages(patchProProperties.getLocale());
    }

    public void install() {
        block11: {
            this.initializeProgress(0.0, 4.0);
            try {
                this.patchDirectoryFile = this.extractPatch();
            }
            catch (Exception exception) {
                this.log.printStackTrace(this, 2, exception);
                this.issueFail(new PatchInstallFailedException(57));
                return;
            }
            this.incrementProgress(1.0);
            try {
                if (this.debug) {
                    System.out.println("Install command procedure for the Lantronix SCS400 Network Terminal Concentrator (NTC) ");
                    try {
                        this.patchID = this.getPatchIDByFWVersion(this.properties.getProperty("patchpro.lantronix.scs400.package", "SUNWlntnx"), this.getFirmwareVersion("scs400"));
                    }
                    catch (InteractiveSessionException interactiveSessionException) {
                        // empty catch block
                    }
                    this.incrementProgress(2.0);
                    break block11;
                }
                try {
                    this.patchID = this.getPatchIDByFWVersion(this.properties.getProperty("patchpro.lantronix.scs400.package", "SUNWlntnx"), this.getFirmwareVersion("scs400"));
                    this.installNTCPatchOnSP();
                }
                catch (InteractiveSessionException interactiveSessionException) {
                    this.incrementProgress(2.0);
                    throw new InteractiveSessionException(interactiveSessionException.getMessage());
                }
                this.incrementProgress(1.0);
                try {
                    this.upgradeNTC();
                }
                catch (InteractiveSessionException interactiveSessionException) {
                    this.incrementProgress(1.0);
                    throw new InteractiveSessionException(interactiveSessionException.getMessage());
                }
                this.setAuditRecordData(this.patchID, this.getHardwareComponentsToUpdate());
                this.incrementProgress(1.0);
            }
            catch (InteractiveSessionException interactiveSessionException) {
                this.log.printStackTrace(this, 2, interactiveSessionException);
                this.issueFail(new PatchInstallFailedException(interactiveSessionException.getMessage()));
                System.out.println("Diagnostic Messages:\n" + interactiveSessionException.getMessage());
            }
        }
        this.incrementProgress(1.0);
    }

    protected void installNTCPatchOnSP() throws InteractiveSessionException {
        int n = -1;
        String string = "";
        String string2 = this.properties.getProperty("SunOS.command.install.patch", "/usr/sbin/patchadd");
        String string3 = "";
        if (this.backoutDirectory != null) {
            string3 = "-B " + this.backoutDirectory.getPath();
        }
        if (this.sourceDirectory == null) {
            this.sourceDirectory = new File(".");
        }
        String string4 = "-M " + this.sourceDirectory;
        String string5 = this.activePatch.getPatchID().getPatchID();
        String string6 = string2 + " " + string3 + " " + string4 + " " + string5;
        this.currentTime = new GregorianCalendar();
        this.expiredTime = new GregorianCalendar();
        this.expiredTime.add(14, 120000);
        CommandSession commandSession = new CommandSession();
        commandSession.start(string6);
        while (this.currentTime.before(this.expiredTime)) {
            try {
                n = commandSession.getProcessExitValue();
                break;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.currentTime = null;
                this.currentTime = new GregorianCalendar();
            }
        }
        string = commandSession.getAllSessionMessages();
        commandSession.stop();
        commandSession.cleanup();
        if (n != 0) {
            throw new InteractiveSessionException(string);
        }
    }

    private void upgradeNTC() throws InteractiveSessionException {
        try {
            int n = -1;
            int n2 = 0;
            LineParser lineParser = new LineParser();
            String string = "";
            String string2 = "";
            string2 = "/usr/bin/grep upgrade /opt/SUNWsespnc/conf/ntc.pty\n";
            CommandSession commandSession = new CommandSession();
            commandSession.start(string2);
            commandSession.wait(5000L);
            string = commandSession.getSessionMessages();
            commandSession.stop();
            commandSession.cleanup();
            string2 = lineParser.getTokenSuffix(string, "=");
            n2 = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.upgrade.ntc.limit", "1800")));
            this.currentTime = new GregorianCalendar();
            this.expiredTime = new GregorianCalendar();
            this.expiredTime.add(14, n2);
            commandSession = new CommandSession();
            commandSession.start(string2);
            while (this.currentTime.before(this.expiredTime)) {
                try {
                    n = commandSession.getProcessExitValue();
                    break;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    Thread.sleep(1000L);
                    this.currentTime = null;
                    this.currentTime = new GregorianCalendar();
                }
            }
            commandSession.stop();
            commandSession.cleanup();
            Object[] objectArray = new String[]{"NTC"};
            switch (n) {
                case 0: {
                    break;
                }
                case 11: {
                    throw new Exception(this.msgcat.getMessage("firewall_ntc_ConnectionProblem", objectArray, "Could not connect to NTC."));
                }
                case 12: {
                    throw new Exception(this.msgcat.getMessage("firewall_ntc_FirmwareUnavailable", objectArray, "NTC firmware is not accessible."));
                }
                case 14: {
                    throw new Exception(this.msgcat.getMessage("firewall_ntc_UpgradeProcessFailed", objectArray, "Unable to upgrade NTC since reboot operation failed."));
                }
                default: {
                    throw new Exception(this.msgcat.getMessage("firewall_ntc_unexpectedExitCode", objectArray, "Unexpected completion code returned by the firmware upgrade script :" + n));
                }
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            try {
                this.removeNTCPatchOnSP();
            }
            catch (Exception exception2) {
                string = string + "\n\n" + exception2.getMessage();
            }
            throw new InteractiveSessionException(string);
        }
    }

    protected void removeNTCPatchOnSP() throws Exception {
        int n = -1;
        String string = "";
        String string2 = "/usr/sbin/patchrm";
        String string3 = this.activePatch.getPatchID().getPatchID();
        String string4 = string2 + " " + string3;
        this.currentTime = new GregorianCalendar();
        this.expiredTime = new GregorianCalendar();
        this.expiredTime.add(14, 120000);
        CommandSession commandSession = new CommandSession();
        commandSession.start(string4);
        while (this.currentTime.before(this.expiredTime)) {
            try {
                n = commandSession.getProcessExitValue();
                break;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.currentTime = null;
                this.currentTime = new GregorianCalendar();
            }
        }
        string = commandSession.getAllSessionMessages();
        commandSession.stop();
        commandSession.cleanup();
        if (n != 0) {
            throw new Exception(string);
        }
    }
}

