/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.manipulators.ManipulableEventManager;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.Removable;
import com.sun.patchpro.manipulators.RemoveFailedException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.Patch;
import java.io.File;
import java.util.Enumeration;

public abstract class Remover
extends ManipulableEventManager
implements Removable {
    protected File sourceImage = null;
    protected File sourceDirectory = null;
    protected Patch activePatch = null;
    protected ReadOnlyHost targetHost = null;
    protected Enumeration targetHardware = null;
    protected Manipulator manipulator = null;
    protected PatchProProperties properties;
    protected PatchProLog log;
    protected boolean debug;
    protected int imageType;

    public Remover(Patch patch, ReadOnlyHost readOnlyHost, Enumeration enumeration) throws RemoveFailedException {
        this.setPatch(patch);
        this.setHost(readOnlyHost);
        this.setTargetHardware(enumeration);
    }

    public Remover(Manipulator manipulator, PatchProProperties patchProProperties) throws RemoveFailedException {
        this.manipulator = manipulator;
        this.properties = patchProProperties;
        this.setPatch(manipulator.getPatch());
        this.setHost(manipulator.getHost());
        this.setTargetHardware(manipulator.getTargetHardware());
        this.debug = patchProProperties.getProperty("patchpro.patch.install.debug", "false").equals("true");
        this.log = PatchProLog.getInstance();
    }

    public void setPatch(Patch patch) {
        this.activePatch = patch;
    }

    public void setHost(ReadOnlyHost readOnlyHost) {
        this.targetHost = readOnlyHost;
    }

    public void setTargetHardware(Enumeration enumeration) {
        this.targetHardware = enumeration;
    }

    public void run() {
        this.initializeProgress(0.0, 4.0);
        this.remove();
        this.postRemove();
        this.issueDone();
    }

    public void setImage(File file) throws RemoveFailedException {
        if (!file.exists()) {
            throw new RemoveFailedException(54, file.getPath() + " does not exist");
        }
        this.sourceImage = file;
    }

    public void setImageType(int n) {
        this.imageType = n;
    }

    protected abstract void postRemove();
}

