/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.host.Host;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.manipulators.CannotDeferException;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Installable;
import com.sun.patchpro.manipulators.Manipulable;
import com.sun.patchpro.manipulators.NoSuchImageException;
import com.sun.patchpro.manipulators.Removable;
import com.sun.patchpro.manipulators.RemoveFailedException;
import com.sun.patchpro.manipulators.SunOSManipulator;
import com.sun.patchpro.manipulators.Verifiable;
import com.sun.patchpro.manipulators.VerifyFailedException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.security.SignatureValidationUtil;
import com.sun.patchpro.util.CommandSession;
import com.sun.patchpro.util.LocalizedMessages;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class Manipulator
implements Manipulable {
    private static final String NO_PATCH_FOUND = "Could not find patch in source directory.";
    static final String NO_ACTION_REQUIRED = "No action required.";
    protected PatchProProperties properties;
    protected PatchProLog log;
    protected String problemMessage = "";
    protected String remedyMessage = "";
    private String sessionMessages = "";
    protected File backoutDirectory = null;
    protected Patch activePatch = null;
    protected Host targetHost = null;
    protected Enumeration targetHardware = null;
    protected boolean smpatch = false;
    protected int imageType = 19;
    private CommandSession commandSession = null;
    private static int COPYSIZE = 1024;
    protected File currentImage = null;
    private Vector imageCopies = new Vector();
    protected String manipulatorPrefix = new String("");
    protected LocalizedMessages msgcat;
    protected SignatureValidationUtil validationUtility = null;
    protected boolean debug;
    protected boolean testDebug;

    public Manipulator() {
        this.log = PatchProLog.getInstance();
        this.properties = PatchProProperties.getInstance();
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
        this.debug = this.properties.getProperty("patchpro.debug", "false").compareTo("true") == 0;
        this.testDebug = this.properties.getProperty("patchpro.script.debug", "false").compareTo("true") == 0;
        this.smpatch = this.properties.getProperty("smpatch.request", "false").equals("true");
        this.remedyMessage = this.msgcat.getMessage(NO_ACTION_REQUIRED, NO_ACTION_REQUIRED);
    }

    public Manipulator(Patch patch, Host host, Enumeration enumeration, SignatureValidationUtil signatureValidationUtil) throws NoSuchImageException {
        this();
        this.setPatch(patch);
        this.constructCurrent();
        this.setHost(host);
        this.setTargetHardware(enumeration);
        this.validationUtility = signatureValidationUtil;
    }

    private void setImageType(int n) {
        this.imageType = n;
    }

    public void setPatch(Patch patch) {
        this.activePatch = patch;
    }

    public void setHost(Host host) {
        this.properties = this.properties.getHostSpecificProperties(host);
        this.targetHost = host;
    }

    public void setTargetHardware(Enumeration enumeration) {
        this.targetHardware = enumeration;
    }

    public void setValidationUtility(SignatureValidationUtil signatureValidationUtil) {
        this.validationUtility = signatureValidationUtil;
    }

    public void setCurrent(String string) throws NoSuchImageException {
        this.setCurrent(new File(string));
    }

    public void setCurrent(File file) throws NoSuchImageException {
        if (!file.exists()) {
            throw new NoSuchImageException("Image does not exist.");
        }
        if (this.currentImage != null) {
            this.imageCopies.add(this.currentImage);
        }
        this.currentImage = file;
        this.imageCopies.remove(file);
    }

    public int getImageType() {
        return this.imageType;
    }

    public File getImage() {
        return this.currentImage;
    }

    public String getCurrent() throws NoSuchImageException {
        if (this.currentImage == null) {
            throw new NoSuchImageException("No current image.");
        }
        return this.currentImage.getPath();
    }

    public Patch getPatch() {
        return this.activePatch;
    }

    public Host getHost() {
        return this.targetHost;
    }

    public Enumeration getTargetHardware() {
        return this.targetHardware;
    }

    public SignatureValidationUtil getValidationUtility() {
        return this.validationUtility;
    }

    public int getStrategy(boolean bl) {
        return this.getInstallStrategy(bl);
    }

    public int getInstallStrategy(boolean bl) {
        return 3;
    }

    public int getRemoveStrategy(boolean bl) {
        return 8;
    }

    public Installable getInstaller() throws InstallFailedException {
        throw new InstallFailedException("Basic Manipulator can't install.");
    }

    public Verifiable getVerifier() throws VerifyFailedException {
        throw new VerifyFailedException("Basic Manipulator can't verify.");
    }

    public Removable getRemover() throws RemoveFailedException {
        throw new RemoveFailedException("Basic Manipulator can't remove.");
    }

    public String getProblem() {
        return this.problemMessage;
    }

    public String getRemedy() {
        return this.remedyMessage;
    }

    public void constructCurrent() throws NoSuchImageException {
        String string = this.properties.getProperty("patchpro.patch.install.directory", ".");
        if (string.length() == 0) {
            throw new NoSuchImageException("Installer.NO_PATCH_IMAGE");
        }
        this.constructCurrent(new File(string));
    }

    public void constructCurrent(File file) throws NoSuchImageException {
        int n = 10;
        if (this.activePatch == null) {
            throw new NoSuchImageException("Installer.NO_PATCH_IMAGE");
        }
        File file2 = new File("");
        for (int i = 0; i < Manipulable.suffixArray.length && !(file2 = new File(file, this.activePatch.getPatchID().getPatchID() + Manipulable.suffixArray[i])).exists(); ++i) {
            ++n;
        }
        if (!file2.exists()) {
            file2 = new File(file, this.activePatch.getPatchID().getPatchID());
            if (!file2.exists() || !file2.isDirectory()) {
                this.log.println(this, 4, "Could not find patch in source directory. " + this.activePatch.getPatchID().getPatchID());
                throw new NoSuchImageException("Installer.NO_PATCH_IMAGE");
            }
            n = 19;
        }
        this.setCurrent(file2);
        this.setImageType(n);
    }

    public void sequester() throws IOException {
        String string = null;
        File file = null;
        if (string == null) {
            string = this.properties.getProperty("patchpro.patch.sequester.directory", "/var/spool/pkg/patchproSequester");
        }
        file = new File(string);
        if (!this.smpatch) {
            System.out.println(this.msgcat.getMessage("PatchBundleInstaller.sequestering", "Sequestering") + " " + this.currentImage.getPath());
        }
        this.move(new File(file, this.currentImage.getName()));
    }

    public void defer() throws CannotDeferException {
        throw new CannotDeferException("Basic Manipulator can't defer.");
    }

    public void move(File file) throws IOException {
        if (this.currentImage != null) {
            if (!this.currentImage.isFile()) {
                throw new IOException("Manipulator.move(): Cannot move non-file.");
            }
        } else {
            throw new IOException("Manipulator.move(): No current image.");
        }
        File file2 = this.currentImage;
        this.copy(file);
        this.setCurrent(file);
        new File(file2.getPath()).delete();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copy(File file) throws IOException {
        if (this.currentImage == null) throw new IOException("Manipulator.copy(): No current image.");
        if (!file.exists()) {
            if (!this.currentImage.isFile()) throw new IOException("Manipulator.copy(): Cannot copy non-file.");
            byte[] byArray = new byte[COPYSIZE];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.currentImage));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            while (bufferedInputStream.available() > 0) {
                int n = bufferedInputStream.read(byArray, 0, COPYSIZE);
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            bufferedOutputStream.close();
            return;
        }
        if (this.areIdentical(file, this.currentImage)) return;
        throw new IOException("Manipulator.copy(): Cannot overwrite file.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete() throws IOException {
        if (this.currentImage == null) throw new IOException("Manipulator.delete(): No current image.");
        if (!this.currentImage.isFile()) throw new IOException("Manipulator.delete(): Cannot delete non-file.");
        File file = null;
        if (!this.imageCopies.isEmpty()) {
            file = (File)this.imageCopies.firstElement();
            this.imageCopies.remove(file);
        }
        this.currentImage.delete();
        this.currentImage = file;
    }

    public void deleteAll() throws IOException {
        if (this.currentImage != null) {
            while (!this.imageCopies.isEmpty()) {
                this.delete();
            }
            this.delete();
        }
    }

    private boolean areIdentical(File file, File file2) {
        boolean bl = false;
        if (file.isFile() && file2.isFile()) {
            if (file.length() == file2.length()) {
                bl = true;
            }
        } else if (file.isDirectory() && file2.isDirectory() && file.list().length == file2.list().length) {
            bl = true;
        }
        return bl;
    }

    protected boolean patchIsBlocked() {
        boolean bl = false;
        String string = this.properties.getProperty("SunOS.directory.patch.data", "/var/sadm/patch");
        Object var3_3 = null;
        int n = -1;
        String string2 = null;
        String string3 = null;
        string3 = this.activePatch.getPatchID().getPatchID();
        string2 = string + "/" + string3;
        String string4 = string2 + "/remove_test";
        File file = new File(string4);
        if (file.exists() && (n = this.executeScript(string4)) != 0) {
            File file2;
            bl = true;
            this.log.println(this, 7, "The remove_test script for the patch returns with an exit code of " + n + ".\n" + "The patch indicates that it may not be removed at " + "this time.");
            this.problemMessage = this.msgcat.getMessage("remove_test_exit_non_zero", "The patch indicates that it may not be removed at this time.");
            if (this.testDebug) {
                System.out.println("The remove_test script for the patch returns with an exit code of " + n + ".\n" + "The patch indicates that it may not be " + "removed at this time.\n");
            }
            if ((file2 = new File(string4 = string2 + "/remove_inst")).exists()) {
                n = this.executeScript(string4);
                if (n != 0) {
                    this.log.println(this, 7, "The remove_inst script for the patch returns with an exit code of " + n + ".\n" + "The instructions for back out " + "preparation cannot be acquired " + "from\nthe patch. It is likely " + "that this patch cannot be " + "backed out.");
                    this.problemMessage = this.msgcat.getMessage("remove_inst_exit_non_zero", "The instructions for back out preparation cannot be acquired from\nthe patch. It is likely that this patch cannot be backed out.");
                    if (this.testDebug) {
                        System.out.println("The remove_inst script for the patch returns with an exit code of " + n + ".\n" + "The instructions for back out " + "preparation cannot be acquired " + "from\nthe patch. It is likely " + "that this patch cannot be " + "backed out.");
                    }
                } else {
                    this.problemMessage = this.sessionMessages;
                    if (this.testDebug) {
                        System.out.println(this.sessionMessages);
                        System.out.println("The remove_inst script is successfully executed.\n");
                    }
                }
            }
        }
        return bl;
    }

    private int executeScript(String string) {
        String string2 = this.getOSName();
        int n = -1;
        if (string2.equals("SunOS")) {
            SunOSManipulator sunOSManipulator = new SunOSManipulator();
            n = sunOSManipulator.executeScript(string);
            this.sessionMessages = sunOSManipulator.getSessionMessage();
        } else {
            this.log.println(this, 3, "The OS type " + string2 + " is not supported.");
        }
        return n;
    }

    private String getOSName() {
        String string = System.getProperty("os.name");
        if (string.compareTo("Solaris") == 0) {
            string = "SunOS";
        }
        return string;
    }
}

