/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.database.AuditRecord;
import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.log.ApplicationLog;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.manipulators.CannotWriteException;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Installable;
import com.sun.patchpro.manipulators.InvalidTypeException;
import com.sun.patchpro.manipulators.ManipulableEventManager;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.PatchInstallFailedException;
import com.sun.patchpro.manipulators.Rebooter;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.security.ManifestFileNotFoundException;
import com.sun.patchpro.security.NotSignedByKnownCertificateException;
import com.sun.patchpro.security.SignatureCheckFailedException;
import com.sun.patchpro.security.SignatureValidationException;
import com.sun.patchpro.security.SignatureValidationUtil;
import com.sun.patchpro.util.JarFileHandlerFailedException;
import com.sun.patchpro.util.SunOSJarFileHandler;
import com.sun.patchpro.util.SunOSTarFileHandler;
import com.sun.patchpro.util.SunOSZipFileHandler;
import com.sun.patchpro.util.TarFileHandlerFailedException;
import com.sun.patchpro.util.ZipFileHandlerFailedException;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;

public abstract class Installer
extends ManipulableEventManager
implements Installable {
    public static final String NO_PATCH_IMAGE = "The installer cannot find the patch.";
    public static final String INSTALL_PROCESS_EXIT_WITH_ERROR = "The installation process terminated with an error.";
    protected static final int LINELENGTH = 256;
    protected PatchProProperties properties;
    protected PatchProLog log;
    protected Manipulator manipulator = null;
    protected Rebooter rebooter = null;
    protected File sourceImage = null;
    protected File backoutDirectory = null;
    protected Patch activePatch = null;
    protected ReadOnlyHost targetHost = null;
    protected Enumeration targetHardware = null;
    protected File sourceDirectory;
    protected boolean debug = false;
    protected boolean session_debug = false;
    protected SignatureValidationUtil validationUtility = null;
    protected int imageType;

    public Installer(Manipulator manipulator, PatchProProperties patchProProperties) throws InstallFailedException {
        this.manipulator = manipulator;
        this.setImage(manipulator.getImage());
        this.setImageType(manipulator.getImageType());
        this.properties = patchProProperties;
        try {
            this.setBackoutDirectory();
        }
        catch (CannotWriteException cannotWriteException) {
            throw new InstallFailedException("Installer.CANNOT_WRITE_BACKOUT_DIRECTORY");
        }
        this.setPatch(manipulator.getPatch());
        this.targetHardware = manipulator.getTargetHardware();
        this.validationUtility = manipulator.getValidationUtility();
        if (patchProProperties.installAuthenticationRequired()) {
            try {
                this.validationUtility = SignatureValidationUtil.getValidationUtility(patchProProperties, this.validationUtility);
            }
            catch (Exception exception) {
                throw new InstallFailedException(exception.getMessage());
            }
        }
        this.sourceDirectory = this.sourceImage.getParentFile();
        if (this.sourceDirectory == null) {
            throw new InstallFailedException("Installer.NO_PATCH_IMAGE");
        }
        this.debug = "true".equals(patchProProperties.getProperty("patchpro.patch.install.debug"));
        this.session_debug = "true".equals(patchProProperties.getProperty("patchpro.debug"));
        this.log = this.getPatchProLog();
    }

    public void run() {
        this.initializeProgress(0.0, this.sourceImage.length());
        this.install();
        this.postInstall();
        this.issueDone();
    }

    public void setImage(File file) throws PatchInstallFailedException {
        if (!file.exists()) {
            throw new PatchInstallFailedException(54, file.getPath() + " does not exist");
        }
        this.sourceImage = file;
    }

    public void setImageType(int n) {
        this.imageType = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBackoutDirectory() throws CannotWriteException {
        String string;
        if (this.backoutDirectory != null || (string = this.properties.getProperty("patchpro.patch.backout.directory", "")).length() <= 0) return;
        this.backoutDirectory = new File(string);
        if (this.backoutDirectory.exists()) {
            if (!this.backoutDirectory.isDirectory()) throw new CannotWriteException("Backout directory is not a directory.");
            if (this.backoutDirectory.canWrite()) return;
            throw new CannotWriteException("Cannot write backout directory.");
        }
        try {
            this.backoutDirectory.mkdirs();
            return;
        }
        catch (Exception exception) {
            throw new CannotWriteException("Cannot create backout directory.");
        }
    }

    public void setPatch(Patch patch) {
        this.activePatch = patch;
    }

    public Patch getPatch() {
        return this.activePatch;
    }

    public void setHost(ReadOnlyHost readOnlyHost) {
        this.targetHost = readOnlyHost;
    }

    public ReadOnlyHost getHost() {
        return this.targetHost;
    }

    public void setTargetHardware(Enumeration enumeration) {
        this.targetHardware = enumeration;
    }

    public void setRebooter(Rebooter rebooter) {
        this.rebooter = rebooter;
    }

    protected boolean purgeFile(File file) {
        boolean bl = true;
        if (file == null) {
            return false;
        }
        if (System.getProperty("os.name").compareTo("SunOS") == 0) {
            String[] stringArray = new String[]{"/usr/bin/rm", "-rf", file.getPath()};
            Process process = null;
            Runtime runtime = Runtime.getRuntime();
            try {
                process = runtime.exec(stringArray);
            }
            catch (IOException iOException) {
                this.log.printStackTrace(this, 4, iOException);
                return false;
            }
            try {
                int n = process.waitFor();
                if (n != 0) {
                    if (this.debug) {
                        System.out.println("DEBUG: Remove failed - cc: " + n);
                    }
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {
                this.log.printStackTrace(this, 4, interruptedException);
                return false;
            }
            return true;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (this.purgeFile(fileArray[i])) continue;
                bl = false;
            }
        }
        if (!file.delete()) {
            bl = false;
        }
        return bl;
    }

    protected File extractPatch() throws InvalidTypeException, SignatureValidationException, JarFileHandlerFailedException, ZipFileHandlerFailedException, TarFileHandlerFailedException {
        String string = this.activePatch.getPatchID().getPatchID();
        switch (this.imageType) {
            case 10: {
                SunOSJarFileHandler sunOSJarFileHandler = new SunOSJarFileHandler();
                if (this.properties.installAuthenticationRequired() && !this.validatePatch(this.sourceImage.getPath())) {
                    this.log.println(this, 1, string + " validation failed.");
                    SignatureValidationException signatureValidationException = new SignatureValidationException(PatchProLog.createMessage(3, "Failed to validate the digital signature(s) for:"));
                    throw signatureValidationException;
                }
                try {
                    sunOSJarFileHandler.extract(this.sourceDirectory.getPath(), this.sourceDirectory.getPath(), this.sourceImage.getName());
                    this.purgeFile(new File(this.sourceDirectory, "META-INF"));
                    break;
                }
                catch (JarFileHandlerFailedException jarFileHandlerFailedException) {
                    this.log.println(this, 3, "extractPatchBundle caught JarFileHandlerFailedException: " + jarFileHandlerFailedException.toString());
                    jarFileHandlerFailedException.printStackTrace();
                    throw jarFileHandlerFailedException;
                }
            }
            case 12: {
                SunOSZipFileHandler sunOSZipFileHandler = new SunOSZipFileHandler();
                try {
                    sunOSZipFileHandler.extract(this.sourceImage.getPath(), this.sourceDirectory.getPath(), this.sourceImage.getName());
                    break;
                }
                catch (ZipFileHandlerFailedException zipFileHandlerFailedException) {
                    this.log.println(this, 3, "extractPatch caught ZipFileHandlerFailedException: " + zipFileHandlerFailedException.toString());
                    throw zipFileHandlerFailedException;
                }
            }
            case 11: {
                SunOSTarFileHandler sunOSTarFileHandler = new SunOSTarFileHandler();
                try {
                    sunOSTarFileHandler.extract(this.sourceDirectory.getPath(), this.sourceDirectory.getPath(), this.sourceImage.getName(), true);
                    break;
                }
                catch (TarFileHandlerFailedException tarFileHandlerFailedException) {
                    this.log.println(this, 3, "extractPatch caught TarFileHandlerFailedException: " + tarFileHandlerFailedException.toString());
                    throw tarFileHandlerFailedException;
                }
            }
            case 13: {
                SunOSTarFileHandler sunOSTarFileHandler = new SunOSTarFileHandler();
                try {
                    sunOSTarFileHandler.extract(this.sourceDirectory.getPath(), this.sourceDirectory.getPath(), this.sourceImage.getName(), false);
                    break;
                }
                catch (TarFileHandlerFailedException tarFileHandlerFailedException) {
                    this.log.println(this, 3, "extractPatch caught TarFileHandlerFailedException: " + tarFileHandlerFailedException.toString());
                    throw tarFileHandlerFailedException;
                }
            }
            case 19: {
                break;
            }
            default: {
                throw new InvalidTypeException("Image type is " + this.imageType);
            }
        }
        this.log.println(this, 7, string + " has been extracted.");
        return new File(this.sourceDirectory.getPath() + File.separatorChar + string);
    }

    public AuditRecord getAuditRecord() {
        return new AuditRecord(this.manipulator.getHost(), this.manipulator.getPatch());
    }

    private boolean validatePatch(String string) {
        boolean bl = true;
        if (this.validationUtility == null) {
            this.log.println(this, 3, "PatchBundleInstaller.FAILED_TO_CREATE_VALIDATION_UTIL");
            Exception exception = new Exception("PatchBundleInstaller.FAILED_TO_CREATE_VALIDATION_UTIL");
            this.issueFail(exception);
            bl = false;
        } else {
            try {
                this.validationUtility.validateJarFile(string);
            }
            catch (ManifestFileNotFoundException manifestFileNotFoundException) {
                bl = false;
                this.log.println(this, 3, "Failed to validate the digital signature(s) for:" + string + ": " + manifestFileNotFoundException.getMessage());
                ManifestFileNotFoundException manifestFileNotFoundException2 = new ManifestFileNotFoundException("PatchBundleInstaller.FAILED_TO_VALIDATE_SIGNATURE");
                this.issueFail(manifestFileNotFoundException2);
            }
            catch (SignatureCheckFailedException signatureCheckFailedException) {
                bl = false;
                this.log.println(this, 3, "Failed to validate the digital signature(s) for:" + string + ": " + signatureCheckFailedException.getMessage());
                SignatureCheckFailedException signatureCheckFailedException2 = new SignatureCheckFailedException("PatchBundleInstaller.FAILED_TO_VALIDATE_SIGNATURE");
                this.issueFail(signatureCheckFailedException2);
            }
            catch (NotSignedByKnownCertificateException notSignedByKnownCertificateException) {
                bl = false;
                String string2 = "Failed to validate the digital signature(s) for:" + string + ": " + notSignedByKnownCertificateException.getMessage();
                this.log.println(this, 3, "Failed to validate the digital signature(s) for:" + string + ": " + notSignedByKnownCertificateException.getMessage());
                NotSignedByKnownCertificateException notSignedByKnownCertificateException2 = new NotSignedByKnownCertificateException("PatchBundleInstaller.FAILED_TO_VALIDATE_SIGNATURE");
                this.issueFail(notSignedByKnownCertificateException2);
            }
            catch (SignatureValidationException signatureValidationException) {
                bl = false;
                signatureValidationException.printStackTrace();
                String string3 = "Failed to validate the digital signature(s) for:" + string + ": " + signatureValidationException.getMessage();
                this.log.println(this, 3, "Failed to validate the digital signature(s) for:" + string + ": " + signatureValidationException.getMessage());
                SignatureValidationException signatureValidationException2 = new SignatureValidationException("PatchBundleInstaller.FAILED_TO_VALIDATE_SIGNATURE");
                this.issueFail(signatureValidationException2);
            }
            if (this.debug) {
                System.out.println("");
                if (bl) {
                    System.out.println(string + " has been validated.");
                } else {
                    System.out.println(string + " cannot be validated.");
                    System.out.print("\n\n");
                }
            }
        }
        return bl;
    }

    protected abstract void postInstall();

    protected Manipulator getManipulator() {
        return this.manipulator;
    }

    protected PatchProProperties getPatchProProperties() {
        return this.properties;
    }

    protected boolean isDebug() {
        return this.session_debug;
    }

    protected boolean isInstallDebug() {
        return this.debug;
    }

    protected PatchProLog getPatchProLog() {
        if (this.log != null) {
            return this.log;
        }
        this.log = PatchProLog.getInstance();
        try {
            String string = this.getPatchProProperties().getProperty("patchpro.log.file", "system");
            this.log.setLogger(new ApplicationLog(string));
        }
        catch (Exception exception) {
            this.log.error(this, exception.getMessage());
        }
        return this.log;
    }

    protected void emergency(Object object, String string) {
        this.getPatchProLog().println(object, 0, string);
    }

    protected void alert(Object object, String string) {
        this.getPatchProLog().println(object, 1, string);
    }

    protected void critical(Object object, String string) {
        this.getPatchProLog().println(object, 2, string);
    }

    protected void error(Object object, String string) {
        this.getPatchProLog().println(object, 3, string);
    }

    protected void warning(Object object, String string) {
        this.getPatchProLog().println(object, 4, string);
    }

    protected void notice(Object object, String string) {
        this.getPatchProLog().println(object, 5, string);
    }

    protected void info(Object object, String string) {
        this.getPatchProLog().println(object, 6, string);
    }

    protected void debug(Object object, String string) {
        this.getPatchProLog().println(object, 7, string);
    }

    protected void printStackTrace(Object object, int n, Throwable throwable) {
        this.getPatchProLog().printStackTrace(object, 7, throwable);
    }

    protected void message(String string) {
        System.out.println(string);
    }

    protected void message(Object object, String string) {
        System.out.println("\n" + string);
        this.info(object, string);
    }

    protected void message(Object object, String string, int n) {
        System.out.println("\n" + string);
        this.getPatchProLog().println(object, n, string);
    }

    protected void debugging(String string) {
        if (this.debug || this.session_debug) {
            System.out.println("\n" + string);
        }
    }

    protected void entry(String string) {
        if (this.debug || this.session_debug) {
            System.out.println("\nEnter: " + string);
        }
    }

    protected void exit(String string) {
        if (this.debug || this.session_debug) {
            System.out.println("\nExit: " + string);
        }
    }

    protected void asserts(boolean bl, String string) {
        if ((this.debug || this.session_debug) && bl) {
            System.out.println("\n" + string);
        }
    }

    protected void asserts(boolean bl, String string, String string2) {
        if (this.debug || this.session_debug) {
            if (bl) {
                System.out.println("\n" + string);
            } else {
                System.out.println("\n" + string2);
            }
        }
    }

    protected void stackTrace() {
        if (!this.debug && !this.session_debug) {
            return;
        }
        Exception exception = new Exception("fake");
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length - i; ++i) {
            System.out.println(stackTraceElementArray[i].toString());
        }
    }
}

