/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.log;

import com.sun.patchpro.host.Host;
import com.sun.patchpro.log.Log;
import com.sun.patchpro.log.LogEverything;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ApplicationLog
implements Log {
    private Log OSSystemLogger = null;
    private PatchProProperties properties;
    private int logSize;
    private int logLevel;
    private boolean wrap;
    private boolean writeToStdOut;
    private File file;
    private RandomAccessFile raFile;
    private static final String DEFAULTLOGSIZE = "50000";
    private static final String TRACEOFF = "0";
    private static final String TRACEON = "1";

    public ApplicationLog(String string) {
        this.file = string != null ? new File(string) : null;
        try {
            if (this.file == null || this.file.getPath().equals("system") || this.file.getPath().equals("")) {
                String string2 = Host.getOSName() + "SystemLogger";
                String string3 = "com.sun.patchpro.log." + string2;
                Class<?> clazz = Class.forName(string3);
                this.OSSystemLogger = (Log)clazz.newInstance();
            } else {
                Object object;
                this.properties = PatchProProperties.getInstance();
                if (this.file.isAbsolute()) {
                    this.file = this.file;
                } else {
                    object = this.properties.getProperty("patchpro.installdir.ppro") + System.getProperty("file.separator") + this.file.getPath();
                    this.file = new File((String)object);
                }
                object = this.file.getParentFile();
                if (!((File)object).exists()) {
                    ((File)object).mkdirs();
                }
                this.file.createNewFile();
                if (this.file.canWrite()) {
                    this.raFile = new RandomAccessFile(this.file, "rw");
                    this.logSize = new Integer(this.properties.getProperty("patchpro.log.size", DEFAULTLOGSIZE));
                    this.wrap = false;
                    this.writeToStdOut = false;
                } else {
                    System.out.println("WARNING: Cannot access patchpro log facilities. Messages shall be redirected to stdout.");
                    this.writeToStdOut = true;
                }
                this.logLevel = new Integer(this.properties.getProperty("patchpro.log.level", TRACEOFF));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                PatchProLog patchProLog = PatchProLog.getInstance();
                patchProLog.setLogger(new LogEverything(System.out));
                patchProLog.printStackTrace(this, 3, fileNotFoundException);
            }
            catch (Exception exception) {
                System.err.println("ERROR: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        catch (IOException iOException) {
            try {
                PatchProLog patchProLog = PatchProLog.getInstance();
                patchProLog.setLogger(new LogEverything(System.out));
                patchProLog.printStackTrace(this, 3, iOException);
            }
            catch (Exception exception) {
                System.err.println("ERROR: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            try {
                PatchProLog patchProLog = PatchProLog.getInstance();
                patchProLog.setLogger(new LogEverything(System.out));
                patchProLog.printStackTrace(this, 3, exception);
            }
            catch (Exception exception2) {
                System.err.println("ERROR: " + exception2.getMessage());
                exception2.printStackTrace();
            }
        }
    }

    public synchronized void print(Object object, int n, String string) {
        block26: {
            if (this.OSSystemLogger == null) {
                String string2 = "<unknown>";
                switch (n) {
                    case 0: {
                        string2 = "EMERGENCY";
                        break;
                    }
                    case 1: {
                        string2 = "ALERT";
                        break;
                    }
                    case 2: {
                        string2 = "CRITICAL";
                        break;
                    }
                    case 3: {
                        string2 = "ERROR";
                        break;
                    }
                    case 4: {
                        string2 = "WARNING";
                        break;
                    }
                    case 5: {
                        string2 = "NOTICE";
                        break;
                    }
                    case 6: {
                        string2 = "INFO";
                        break;
                    }
                    case 7: {
                        string2 = "DEBUG";
                    }
                }
                if (n <= this.logLevel) {
                    String string3 = new Date().toString() + "(" + string2 + ")=> " + object.toString() + " <=" + string;
                    if (this.writeToStdOut) {
                        System.out.println(string3);
                    } else {
                        try {
                            long l = this.raFile.length();
                            if (!this.wrap && l + (long)string3.length() > (long)this.logSize) {
                                this.wrap = true;
                            }
                            if (this.wrap) {
                                File file = null;
                                RandomAccessFile randomAccessFile = null;
                                String string4 = null;
                                String string5 = this.file.getAbsolutePath();
                                StringTokenizer stringTokenizer = new StringTokenizer(string3, "\n");
                                int n2 = 0;
                                int n3 = 0;
                                try {
                                    while (stringTokenizer.hasMoreElements()) {
                                        stringTokenizer.nextElement();
                                        ++n2;
                                    }
                                }
                                catch (NoSuchElementException noSuchElementException) {
                                    System.err.println("ERROR: " + noSuchElementException.getMessage());
                                    noSuchElementException.printStackTrace();
                                }
                                this.raFile.seek(0L);
                                for (int i = 0; i < n2; ++i) {
                                    string4 = this.raFile.readLine();
                                    if (string4 == null) continue;
                                    n3 += string4.length() + 1;
                                }
                                this.raFile.seek(n3);
                                byte[] byArray = new byte[(int)l - n3];
                                file = new File(string5 + ".tmp");
                                file.createNewFile();
                                randomAccessFile = new RandomAccessFile(file, "rw");
                                this.raFile.readFully(byArray);
                                randomAccessFile.write(byArray, 0, byArray.length);
                                randomAccessFile.writeBytes(string3);
                                randomAccessFile.close();
                                this.raFile.close();
                                file.renameTo(new File(string5));
                                this.file = new File(string5);
                                if (!this.file.exists()) {
                                    this.file.createNewFile();
                                }
                                this.raFile = new RandomAccessFile(this.file, "rw");
                                string5 = null;
                                string4 = null;
                                string3 = null;
                                file = null;
                                randomAccessFile = null;
                                break block26;
                            }
                            this.raFile.seek(this.raFile.length());
                            this.raFile.writeBytes(string3);
                        }
                        catch (IOException iOException) {
                            try {
                                PatchProLog patchProLog = PatchProLog.getInstance();
                                patchProLog.setLogger(new LogEverything(System.out));
                                patchProLog.printStackTrace(this, 3, iOException);
                            }
                            catch (Exception exception) {
                                System.err.println("ERROR: " + exception.getMessage());
                                exception.printStackTrace();
                            }
                        }
                    }
                }
            } else {
                this.OSSystemLogger.print(object, n, string);
            }
        }
    }
}

