/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.host;

import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.LineParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;

public class SoftwarePackage
implements Serializable {
    PatchProProperties properties = null;
    static final String REVLEVELPREAMBLE = ",PATCH=";
    private int patchLevel = 0;
    private int instance = 0;
    private Properties pkginfo;
    private String description;
    private String processor;
    private String name;
    private String instanceName;
    private String version;

    public SoftwarePackage() {
    }

    public SoftwarePackage(String string, String string2) {
        this.setInstanceName(string);
        this.setName(string);
        this.setVersion(string2);
        this.pkginfo = new Properties();
        this.properties = PatchProProperties.getInstance();
    }

    public SoftwarePackage(String string, String string2, File file) throws Exception {
        this(string, string2);
        try {
            this.populateFileBasedPkginfo(file);
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
    }

    public void populateInstalledPkginfo() throws Exception {
        String string = "pkgparam";
        String string2 = "";
        File file = new File("/tmp");
        File file2 = null;
        String string3 = null;
        try {
            file2 = File.createTempFile(string, string2, file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        string3 = this.properties.getProperty("SunOS.command.get.pkg.info", "/usr/bin/pkgparam -v");
        String string4 = string3 + " " + this.getInstanceName() + " >> " + file2.getPath();
        String[] stringArray = new String[]{"ksh", string4};
        Runtime runtime = Runtime.getRuntime();
        try {
            int n = -1;
            Process process = runtime.exec(stringArray);
            n = process.waitFor();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException.getMessage());
        }
        try {
            this.populateFileBasedPkginfo(file2);
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
        file2.deleteOnExit();
    }

    public void populateFileBasedPkginfo(File file) throws Exception {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            LineParser lineParser = new LineParser();
            String string2 = "";
            while ((string = bufferedReader.readLine()) != null) {
                String string3;
                try {
                    string3 = lineParser.getTokenPrefix(string, "=");
                    try {
                        string2 = lineParser.getTokenSuffix(string, "=");
                        string2 = string2.replace('\"', ' ');
                        string2 = string2.replace('\'', ' ');
                        string2 = string2.trim();
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        string2 = "";
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    string3 = new String(string);
                    string2 = "";
                }
                this.pkginfo.setProperty(string3, string2);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            throw new Exception(iOException.getMessage());
        }
    }

    public void setName(String string) {
        int n = string.indexOf(46);
        if (n > -1) {
            this.name = string.substring(0, n);
            try {
                Integer n2 = new Integer(string.substring(n + 1));
                this.instance = n2;
            }
            catch (Exception exception) {
                this.instance = 0;
            }
        } else {
            this.name = string;
            this.instance = 0;
        }
    }

    public void setInstanceName(String string) {
        this.instanceName = string;
    }

    public void setVersion(String string) {
        String string2 = string;
        int n = string2.indexOf(REVLEVELPREAMBLE);
        if (n > 0) {
            String string3 = string2.substring(n + REVLEVELPREAMBLE.length());
            try {
                this.patchLevel = new Integer(string3);
            }
            catch (Exception exception) {
                this.patchLevel = 0;
            }
            this.version = string2.substring(0, n);
        } else {
            this.version = string;
        }
    }

    public void setProcessorArch(String string) {
        this.processor = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getBasecode() {
        return this.name;
    }

    public Properties getPkginfo() {
        return this.pkginfo;
    }

    public boolean matches(SoftwarePackage softwarePackage) {
        if (softwarePackage.getName().compareTo(this.getName()) != 0) {
            return false;
        }
        return softwarePackage.getVersion().compareTo(this.getVersion()) == 0;
    }

    public String getFullName() {
        if (this.instance > 0) {
            return this.name + "." + this.instance + "-" + this.version;
        }
        return this.name + "-" + this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getVersion() {
        return this.version;
    }

    public int getPatchLevel() {
        return this.patchLevel;
    }

    public int getInstance() {
        return this.instance;
    }
}

