/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.host;

import com.sun.patchpro.database.PatchDB;
import com.sun.patchpro.database.PatchDBBuilder;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.interpreter.HostSpecificInterpreter;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.Messagable;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchInfoImpl;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.util.NoResultException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;

public class SessionData
implements Serializable,
Messagable {
    public static final int PATCHES_NONE = 0;
    public static final int PATCHES_REQUIRED = 1;
    public static final int PATCHES_TO_REMOVE = 1;
    public static final int PATCHES_CORRUPT_ON_DOWNLOAD = 2;
    public static final int PATCHES_UNAVAILABLE = 3;
    public static final int PATCHES_ALREADY_PRESENT = 4;
    public static final int PATCHES_DOWNLOADED = 5;
    public static final int PATCHES_CORRUPT_ON_INSTALL = 6;
    public static final int PATCHES_WITH_BAD_PROPERTIES = 7;
    public static final int PATCHES_FAILING_INSTALL = 8;
    public static final int PATCHES_FAILING_REMOVE = 8;
    public static final int PATCHES_INSTALLED = 9;
    public static final int PATCHES_REMOVED = 9;
    public static final int PATCHES_SEQUESTERED = 10;
    public static final int PATCHES_DEFERRED = 11;
    public static final int PATCHES_NOT_DOWNLOADED = 12;
    public static final int PATCHES_ACQUIRED = 13;
    public static final int PATCHES_NOT_INSTALLED = 14;
    public static final int PATCHES_ADDRESSED_IN_DOWNLOAD = 15;
    public static final int PATCHES_ADDRESSED_IN_INSTALL = 16;
    Host host = null;
    boolean isAssociate = false;
    boolean patchListSetExternally = false;
    protected transient PatchDBBuilder dbBuilder = null;
    protected PatchDB db = null;
    protected transient PatchProProperties properties;
    protected transient HostSpecificInterpreter interpreter = null;
    protected File latestDownloadDestination;
    private boolean propertiesAreDefault = true;
    private PatchListImpl patchesToProcessImpl = null;
    PatchInfoImpl genPatchInfo = null;
    private PatchList patchesToProcess = null;
    private PatchListImpl patchesCorruptOnDownload = null;
    private PatchListImpl patchesUnavailable = null;
    private PatchListImpl patchesAlreadyPresent = null;
    private PatchListImpl patchesDownloaded = null;
    private PatchListImpl patchesCorruptOnInstall = null;
    private PatchListImpl patchesWithBadProperties = null;
    private PatchListImpl patchesFailing = null;
    private PatchListImpl patchesProcessed = null;
    private PatchListImpl patchesSequestered = null;
    private PatchListImpl patchesDeferred = null;
    private transient PatchProLog log = PatchProLog.getInstance();
    private Collection exceptionRepository;
    private boolean errorDetected;
    boolean ignoreStatus = false;

    public SessionData() {
        this.properties = PatchProProperties.getInstance();
        this.exceptionRepository = new Vector();
        this.patchesToProcessImpl = new PatchListImpl();
        this.patchesToProcess = this.patchesToProcessImpl;
        this.genPatchInfo = new PatchInfoImpl();
        this.genPatchInfo.setProperties(new PatchProperties(""));
    }

    public SessionData(Host host) {
        this();
        this.host = host;
    }

    public void clearDownloadSession() {
        this.patchesToProcessImpl = new PatchListImpl();
        this.patchesToProcess = this.patchesToProcessImpl;
        this.patchesCorruptOnDownload = null;
        this.patchesUnavailable = null;
        this.patchesAlreadyPresent = null;
        this.patchesDownloaded = null;
    }

    public void clearInstallSession() {
        this.patchesCorruptOnInstall = null;
        this.patchesWithBadProperties = null;
        this.patchesFailing = null;
        this.patchesProcessed = null;
        this.patchesSequestered = null;
        this.patchesDeferred = null;
    }

    public void clearRemoveSession() {
        this.clearInstallSession();
    }

    public void clearSessionErrors() {
        this.errorDetected = false;
        this.exceptionRepository = new Vector();
    }

    public void clearSession() {
        this.clearDownloadSession();
        this.clearInstallSession();
        this.clearSessionErrors();
    }

    public void createProperties() {
        if (this.properties == null) {
            this.properties = PatchProProperties.getInstance();
        }
        if (this.propertiesAreDefault) {
            if (this.host.isAssociate()) {
                this.properties = this.properties.getHostSpecificProperties(this.host);
            }
            this.propertiesAreDefault = false;
        }
        String string = this.properties.getProperty("patchpro.patch.download.directory", "/var/spool/pkg/patchpro");
        this.latestDownloadDestination = new File(string);
    }

    public void createInterpreter() {
        this.interpreter = new HostSpecificInterpreter(this.host);
    }

    public void createPatchDBBuilder() {
        String string = this.properties.getProperty("patchpro.database.builder");
        try {
            this.dbBuilder = (PatchDBBuilder)Class.forName(string).newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.log.printStackTrace(this, 2, instantiationException);
            this.addPatchProException(new PatchProException("Critical failure.  Unable to load DB Builder! " + instantiationException.getMessage()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.printStackTrace(this, 2, classNotFoundException);
            this.addPatchProException(new PatchProException("Critical failure.  Unable to load DB Builder! " + classNotFoundException.getMessage()));
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log.printStackTrace(this, 2, illegalAccessException);
            this.addPatchProException(new PatchProException("Critical failure.  Unable to load DB Builder! " + illegalAccessException.getMessage()));
        }
        catch (NullPointerException nullPointerException) {
            this.log.printStackTrace(this, 2, nullPointerException);
            this.addPatchProException(new PatchProException("Critical failure.  DB Builder property not set! " + nullPointerException.getMessage()));
        }
    }

    public void setPatchProExceptions(Vector vector) {
        this.exceptionRepository.addAll(vector);
        if (vector.size() > 0) {
            this.errorDetected = true;
        }
    }

    public void setPatchProExceptions(Collection collection) {
        this.exceptionRepository.addAll(collection);
        if (collection.size() > 0) {
            this.errorDetected = true;
        }
    }

    public void addPatchProException(PatchProException patchProException) {
        if (!this.exceptionRepository.contains(patchProException)) {
            this.exceptionRepository.add(patchProException);
        }
        this.errorDetected = true;
    }

    public void setLatestDownloadDestination(File file) {
        this.latestDownloadDestination = file;
    }

    public void setPatchesRequired(PatchList patchList) {
        this.patchesToProcess = patchList;
        this.patchListSetExternally = true;
    }

    public void setPatchesToRemove(PatchList patchList) {
        this.setPatchesRequired(patchList);
    }

    public void addToPatchList(int n, Patch patch, String string) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                if (string.length() == 0) {
                    this.addPatchRequired(patch);
                    break;
                }
                this.addPatchRequired(patch, string);
                break;
            }
            case 2: {
                this.addPatchCorruptOnDownload(patch, string);
                break;
            }
            case 3: {
                this.addPatchUnavailable(patch, string);
                break;
            }
            case 4: {
                this.addPatchAlreadyPresent(patch);
                break;
            }
            case 5: {
                this.addPatchDownloaded(patch);
                break;
            }
            case 6: {
                this.addPatchCorruptOnInstall(patch, string);
                break;
            }
            case 7: {
                this.addPatchWithBadProperties(patch, string);
                break;
            }
            case 8: {
                this.addPatchFailingInstall(patch, string);
                break;
            }
            case 9: {
                this.addPatchInstalled(patch);
                break;
            }
            case 10: {
                this.addPatchSequestered(patch);
                break;
            }
            case 11: {
                this.addPatchDeferred(patch);
                break;
            }
        }
    }

    public PatchList getPatchList(int n) throws NoResultException, IndexOutOfBoundsException {
        PatchList patchList;
        switch (n) {
            case 1: {
                patchList = this.getPatchesRequired();
                break;
            }
            case 2: {
                patchList = this.getPatchesCorruptOnDownload();
                break;
            }
            case 3: {
                patchList = this.getPatchesUnavailable();
                break;
            }
            case 4: {
                patchList = this.getPatchesAlreadyPresent();
                break;
            }
            case 5: {
                patchList = this.getPatchesDownloaded();
                break;
            }
            case 6: {
                patchList = this.getPatchesCorruptOnInstall();
                break;
            }
            case 7: {
                patchList = this.getPatchesWithBadProperties();
                break;
            }
            case 8: {
                patchList = this.getPatchesFailingInstall();
                break;
            }
            case 9: {
                patchList = this.getPatchesInstalled();
                break;
            }
            case 10: {
                patchList = this.getPatchesSequestered();
                break;
            }
            case 11: {
                patchList = this.getPatchesDeferred();
                break;
            }
            case 12: {
                patchList = this.getPatchesNotDownloaded();
                break;
            }
            case 13: {
                patchList = this.getPatchesAcquired();
                break;
            }
            case 14: {
                patchList = this.getPatchesNotInstalled();
                break;
            }
            case 15: {
                patchList = this.getPatchesAddressedInDownload();
                break;
            }
            case 16: {
                patchList = this.getPatchesAddressedInInstall();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Recieved " + n);
            }
        }
        return patchList;
    }

    public void addPatchRequired(Patch patch) {
        IPatch iPatch = new IPatch(patch);
        this.patchesToProcessImpl.addAndSelectIPatch(iPatch);
        this.log.println(this, 7, "Added patch " + patch.getPatchID().getPatchID() + " to the required list.");
    }

    public void addPatchRequired(Patch patch, String string) {
        IPatch iPatch = new IPatch(patch);
        iPatch.setError(string);
        this.patchesToProcessImpl.addIPatch(iPatch);
        this.log.println(this, 7, "Added patch " + patch.getPatchID().getPatchID() + " to the required list. ErrString: " + string);
    }

    public void addPatchToRemove(Patch patch) {
        this.addPatchRequired(patch);
    }

    public void addPatchToRemove(Patch patch, String string) {
        this.addPatchRequired(patch, string);
    }

    public void addPatchCorruptOnDownload(Patch patch, String string) {
        IPatch iPatch = new IPatch(patch);
        iPatch.setError(string);
        this.addPatchCorruptOnDownload(iPatch);
    }

    public void addPatchCorruptOnDownload(IPatch iPatch) {
        if (this.patchesCorruptOnDownload == null) {
            this.patchesCorruptOnDownload = new PatchListImpl();
        }
        this.patchesCorruptOnDownload.addIPatch(iPatch);
        this.log.println(this, 7, "Added patch " + iPatch.getPatchID().getPatchID() + " to the corrupt-on-download list. ErrString: " + (iPatch.hasError() ? iPatch.getError() : ""));
    }

    public void setPatchesUnavailable(PatchList patchList, String string) {
        this.patchesUnavailable = new PatchListImpl();
        this.addPatchesUnavailable(patchList, string);
    }

    public void addPatchesUnavailable(PatchList patchList, String string) {
        int n = patchList.size();
        for (int i = 0; i < n; ++i) {
            try {
                this.addPatchUnavailable(patchList.getPatchAt(i), string);
                continue;
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.println(this, 5, "Skipping a patch with " + noSuchPatchException.getMessage());
            }
        }
    }

    public void addPatchUnavailable(Patch patch, String string) {
        IPatch iPatch = new IPatch(patch);
        iPatch.setError(string);
        this.addPatchUnavailable(iPatch);
    }

    public void addPatchUnavailable(IPatch iPatch) {
        if (this.patchesUnavailable == null) {
            this.patchesUnavailable = new PatchListImpl();
        }
        this.patchesUnavailable.addIPatch(iPatch);
        this.log.println(this, 7, "Added patch " + iPatch.getPatchID().getPatchID() + " to the unavailable list.");
    }

    public void addPatchAlreadyPresent(IPatch iPatch) {
        if (this.patchesAlreadyPresent == null) {
            this.patchesAlreadyPresent = new PatchListImpl();
        }
        this.patchesAlreadyPresent.addIPatch(iPatch);
        this.log.println(this, 7, "Added patch " + iPatch.getPatchID().getPatchID() + " to the already present list. ErrString: " + (iPatch.hasError() ? iPatch.getError() : ""));
    }

    public void addPatchAlreadyPresent(Patch patch) {
        IPatch iPatch = new IPatch(patch);
        this.addPatchAlreadyPresent(iPatch);
    }

    public void addPatchDownloaded(String string) throws MalformedPatchException {
        PatchImpl patchImpl = new PatchImpl(this.genPatchInfo, new PatchID(string));
        this.addPatchDownloaded(patchImpl);
    }

    public void addPatchDownloaded(Patch patch) {
        if (this.patchesDownloaded == null) {
            this.patchesDownloaded = new PatchListImpl();
        }
        IPatch iPatch = new IPatch(patch);
        this.patchesDownloaded.addIPatch(iPatch);
        this.log.println(this, 7, "Added patch " + patch.getPatchID().getPatchID() + " to the downloaded list.");
    }

    public void addPatchCorruptOnInstall(Patch patch, String string) {
        if (this.patchesCorruptOnInstall == null) {
            this.patchesCorruptOnInstall = new PatchListImpl();
        }
        IPatch iPatch = new IPatch(patch);
        iPatch.setError(string);
        this.patchesCorruptOnInstall.addIPatch(iPatch);
        this.patchesDownloaded.removeIPatch(iPatch);
        this.log.println(this, 7, "Added patch " + patch.getPatchID().getPatchID() + " to the corrupt-on-install list. ErrString: " + string);
    }

    public void addPatchWithBadProperties(Patch patch, String string) {
        IPatch iPatch = new IPatch(patch);
        iPatch.setError(string);
        this.addPatchWithBadProperties(iPatch);
    }

    public void addPatchWithBadProperties(IPatch iPatch) {
        if (this.patchesWithBadProperties == null) {
            this.patchesWithBadProperties = new PatchListImpl();
        }
        this.patchesWithBadProperties.addIPatch(iPatch);
        this.log.println(this, 7, "Added patch " + iPatch.getPatchID().getPatchID() + " to the bad properties list. ErrString: " + (iPatch.hasError() ? iPatch.getError() : ""));
    }

    public void addPatchFailingInstall(Patch patch, String string) {
        IPatch iPatch = new IPatch(patch);
        iPatch.setError(string);
        this.addPatchFailingInstall(iPatch);
    }

    public void addPatchFailingInstall(IPatch iPatch) {
        if (this.patchesFailing == null) {
            this.patchesFailing = new PatchListImpl();
        }
        this.patchesFailing.addIPatch(iPatch);
        this.log.println(this, 7, "Added patch " + iPatch.getPatchID().getPatchID() + " to the failed install list. ErrString: " + (iPatch.hasError() ? iPatch.getError() : ""));
    }

    public void addPatchFailingRemove(Patch patch, String string) {
        IPatch iPatch = new IPatch(patch);
        iPatch.setError(string);
        this.addPatchFailingRemove(iPatch);
    }

    public void addPatchFailingRemove(IPatch iPatch) {
        if (this.patchesFailing == null) {
            this.patchesFailing = new PatchListImpl();
        }
        this.patchesFailing.addIPatch(iPatch);
        this.log.println(this, 7, "Added patch " + iPatch.getPatchID().getPatchID() + " to the failed remove list. ErrString: " + (iPatch.hasError() ? iPatch.getError() : ""));
    }

    public void addPatchInstalled(Patch patch) {
        if (this.patchesProcessed == null) {
            this.patchesProcessed = new PatchListImpl();
        }
        IPatch iPatch = new IPatch(patch);
        this.patchesProcessed.addIPatch(iPatch);
        this.log.println(this, 7, "Added installed patch " + patch.getPatchID().getPatchID() + " to the installed list.");
    }

    public void addPatchRemoved(Patch patch) {
        if (this.patchesProcessed == null) {
            this.patchesProcessed = new PatchListImpl();
        }
        IPatch iPatch = new IPatch(patch);
        this.patchesProcessed.addIPatch(iPatch);
        this.log.println(this, 7, "Added removed patch " + patch.getPatchID().getPatchID() + " to the removed list.");
    }

    public void addPatchSequestered(Patch patch) {
        if (this.patchesSequestered == null) {
            this.patchesSequestered = new PatchListImpl();
        }
        IPatch iPatch = new IPatch(patch);
        this.patchesSequestered.addIPatch(iPatch);
        this.log.println(this, 7, "Added sequestered patch " + patch.getPatchID().getPatchID() + " to the sequestered list.");
    }

    public void addPatchDeferred(Patch patch) {
        if (this.patchesDeferred == null) {
            this.patchesDeferred = new PatchListImpl();
        }
        IPatch iPatch = new IPatch(patch);
        this.patchesDeferred.addIPatch(iPatch);
        this.log.println(this, 7, "Added deferred patch " + patch.getPatchID().getPatchID() + " to the deferred list.");
    }

    public void setPatchDB(PatchDB patchDB) {
        this.db = patchDB;
    }

    public void setIgnoreStatus(boolean bl) {
        this.ignoreStatus = bl;
    }

    public File getLatestDownloadDestination() {
        return this.latestDownloadDestination;
    }

    public HostSpecificInterpreter getInterpreter() {
        return this.interpreter;
    }

    public PatchList getPatchesRequired() throws NoResultException {
        if (this.patchesToProcess == null) {
            throw new NoResultException("No patch list provided.");
        }
        return this.patchesToProcess;
    }

    public PatchList getPatchesToRemove() throws NoResultException {
        return this.getPatchesRequired();
    }

    public PatchList getPatchesCorruptOnDownload() throws NoResultException {
        if (this.patchesCorruptOnDownload == null) {
            throw new NoResultException("No patch list provided.");
        }
        return this.patchesCorruptOnDownload;
    }

    public PatchList getPatchesUnavailable() throws NoResultException {
        if (this.patchesUnavailable == null) {
            throw new NoResultException("No patch list provided.");
        }
        return this.patchesUnavailable;
    }

    public PatchList getPatchesAlreadyPresent() throws NoResultException {
        if (this.patchesAlreadyPresent == null) {
            throw new NoResultException("No patch list provided.");
        }
        return this.patchesAlreadyPresent;
    }

    public PatchList getPatchesDownloaded() throws NoResultException {
        if (this.patchesDownloaded == null) {
            throw new NoResultException("No patch list provided.");
        }
        return this.patchesDownloaded;
    }

    public PatchList getPatchesCorruptOnInstall() throws NoResultException {
        if (this.patchesCorruptOnInstall == null) {
            throw new NoResultException("No patch list provided.");
        }
        return this.patchesCorruptOnInstall;
    }

    public PatchList getPatchesWithBadProperties() throws NoResultException {
        if (this.patchesWithBadProperties == null) {
            throw new NoResultException("No patch list provided.");
        }
        return this.patchesWithBadProperties;
    }

    public PatchList getPatchesFailingInstall() throws NoResultException {
        if (this.patchesFailing == null) {
            throw new NoResultException("No patch list provided.");
        }
        return this.patchesFailing;
    }

    public PatchList getPatchesFailingRemove() throws NoResultException {
        return this.getPatchesFailingInstall();
    }

    public PatchList getPatchesInstalled() throws NoResultException {
        if (this.patchesProcessed == null) {
            throw new NoResultException("No patch list provided.");
        }
        return this.patchesProcessed;
    }

    public PatchList getPatchesRemoved() throws NoResultException {
        return this.getPatchesInstalled();
    }

    public PatchList getPatchesSequestered() throws NoResultException {
        if (this.patchesSequestered == null) {
            throw new NoResultException("No patch list provided.");
        }
        return this.patchesSequestered;
    }

    public PatchList getPatchesDeferred() throws NoResultException {
        if (this.patchesDeferred == null) {
            throw new NoResultException("No patch list provided.");
        }
        return this.patchesDeferred;
    }

    public PatchList getPatchesNotDownloaded() throws NoResultException {
        PatchListImpl patchListImpl = new PatchListImpl();
        int n = 2;
        int n2 = 0;
        if (this.patchesCorruptOnDownload != null) {
            patchListImpl.merge(this.patchesCorruptOnDownload);
        } else {
            ++n2;
        }
        if (this.patchesUnavailable != null) {
            patchListImpl.merge(this.patchesUnavailable);
        } else {
            ++n2;
        }
        if (n2 == n) {
            throw new NoResultException("No patch list provided.");
        }
        return patchListImpl;
    }

    public PatchList getPatchesAcquired() throws NoResultException {
        PatchListImpl patchListImpl = new PatchListImpl();
        int n = 2;
        int n2 = 0;
        if (this.patchesAlreadyPresent != null) {
            patchListImpl.merge(this.patchesAlreadyPresent);
        } else {
            ++n2;
        }
        if (this.patchesDownloaded != null) {
            patchListImpl.merge(this.patchesDownloaded);
        } else {
            ++n2;
        }
        if (n2 == n) {
            throw new NoResultException("No patch list provided.");
        }
        return patchListImpl;
    }

    public PatchList getPatchesNotInstalled() throws NoResultException {
        PatchListImpl patchListImpl = new PatchListImpl();
        int n = 3;
        int n2 = 0;
        if (this.patchesCorruptOnInstall != null) {
            patchListImpl.merge(this.patchesCorruptOnInstall);
        } else {
            ++n2;
        }
        if (this.patchesWithBadProperties != null) {
            patchListImpl.merge(this.patchesWithBadProperties);
        } else {
            ++n2;
        }
        if (this.patchesFailing != null) {
            patchListImpl.merge(this.patchesFailing);
        } else {
            ++n2;
        }
        if (n2 == n) {
            throw new NoResultException("No patch list provided.");
        }
        return patchListImpl;
    }

    public PatchList getPatchesAddressedInDownload() throws NoResultException {
        PatchListImpl patchListImpl = new PatchListImpl();
        int n = 4;
        int n2 = 0;
        if (this.patchesCorruptOnDownload != null) {
            patchListImpl.merge(this.patchesCorruptOnDownload);
        } else {
            ++n2;
        }
        if (this.patchesUnavailable != null) {
            patchListImpl.merge(this.patchesUnavailable);
        } else {
            ++n2;
        }
        if (this.patchesAlreadyPresent != null) {
            patchListImpl.merge(this.patchesAlreadyPresent);
        } else {
            ++n2;
        }
        if (this.patchesDownloaded != null) {
            patchListImpl.merge(this.patchesDownloaded);
        } else {
            ++n2;
        }
        if (n2 == n) {
            throw new NoResultException("No patch list provided.");
        }
        return patchListImpl;
    }

    public PatchList getPatchesAddressedInInstall() throws NoResultException {
        PatchListImpl patchListImpl = new PatchListImpl();
        int n = 6;
        int n2 = 0;
        if (this.patchesCorruptOnInstall != null) {
            patchListImpl.merge(this.patchesCorruptOnInstall);
        } else {
            ++n2;
        }
        if (this.patchesWithBadProperties != null) {
            patchListImpl.merge(this.patchesWithBadProperties);
        } else {
            ++n2;
        }
        if (this.patchesFailing != null) {
            patchListImpl.merge(this.patchesFailing);
        } else {
            ++n2;
        }
        if (this.patchesProcessed != null) {
            patchListImpl.merge(this.patchesProcessed);
        } else {
            ++n2;
        }
        if (this.patchesSequestered != null) {
            patchListImpl.merge(this.patchesSequestered);
        } else {
            ++n2;
        }
        if (this.patchesDeferred != null) {
            patchListImpl.merge(this.patchesDeferred);
        } else {
            ++n2;
        }
        if (n2 == n) {
            throw new NoResultException("No patch list provided.");
        }
        return patchListImpl;
    }

    public PatchProProperties getProperties() {
        return this.properties;
    }

    public PatchDBBuilder getPatchDBBuilder() {
        return this.dbBuilder;
    }

    public PatchDB getPatchDB() {
        return this.db;
    }

    public boolean getIgnoreStatus() {
        return this.ignoreStatus;
    }

    public Collection getPatchProExceptions() {
        return this.exceptionRepository;
    }

    public boolean hasErrors() {
        return this.errorDetected;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            this.log = PatchProLog.getInstance();
            this.propertiesAreDefault = true;
            this.createProperties();
            this.createPatchDBBuilder();
            if (this.host != null) {
                this.createInterpreter();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

