/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.host;

import com.sun.database.simpleadapter.memory.MemoryAdapter;
import com.sun.database.simpledatabase.DuplicateEntryException;
import com.sun.database.simpledatabase.NoSuchObjectException;
import com.sun.database.simpledatabase.SimpleDatabase;
import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.RealizationEnumerator;
import com.sun.patchpro.host.RealizationStatus;
import com.sun.patchpro.host.RestrictedHost;
import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.host.SoftwarePackage;
import com.sun.patchpro.host.UnknownRealizationException;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.util.InvalidVersionException;
import com.sun.patchpro.util.NoResultException;
import com.sun.patchpro.util.Version;
import com.sun.patchpro.util.XMLFormatUtilities;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class Host
implements RestrictedHost,
ReadOnlyHost {
    static final long serialVersionUID = 7266014287079093105L;
    private String platform = null;
    private String architecture;
    private String operatingSystem = null;
    private String osRelease = null;
    private String hostType;
    private String hostName = null;
    private String hostAddress = null;
    private SimpleDatabase associateDatabase;
    private SimpleDatabase realizationsDatabase;
    private SimpleDatabase softwareDatabase;
    private SimpleDatabase patchIDDatabase;
    private SimpleDatabase hardwareDatabase;
    private Vector driverDatabase;
    private transient PatchProLog log;
    private String memorySizeString = "0";
    private int memorySize = 0;
    private Version bootFirmware = null;
    private boolean isAssociate = false;
    private int totalAssociates = 0;
    private SessionData sessionData;
    private Host primaryHost = null;

    public Host() {
        this.initRealizations();
        this.initSoftwarePackages();
        this.initPatches();
        this.initDrivers();
        this.initHardwareComponents();
        this.initAssociates();
        this.hostType = this.operatingSystem = Host.getOSName();
        try {
            this.hostAddress = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.hostAddress = null;
        }
        this.log = PatchProLog.getInstance();
        this.sessionData = new SessionData(this);
    }

    public Host(String string, String string2, String string3, Enumeration enumeration, Enumeration enumeration2, Enumeration enumeration3) {
        this();
        this.platform = string3;
        this.operatingSystem = string;
        this.osRelease = string2;
        this.addRealizations(enumeration);
        this.addSoftwarePackages(enumeration2);
        this.addPatches(enumeration3);
    }

    public Host(String string, String string2, String string3, String string4, String string5, String string6, Enumeration enumeration, Enumeration enumeration2, Enumeration enumeration3) {
        this(string, string2, string3, enumeration, enumeration2, enumeration3);
        this.hostType = string4;
        this.hostName = string5;
        this.hostAddress = string6;
    }

    public void markAsAssociate(boolean bl) {
        this.isAssociate = bl;
        if (bl) {
            this.getSessionData().createProperties();
        }
    }

    public boolean isAssociate() {
        return this.isAssociate;
    }

    public String getType() {
        return this.hostType;
    }

    public boolean isType(String string) {
        return this.hostType.compareTo(string) == 0;
    }

    public void setType(String string) {
        this.hostType = string;
    }

    public static String getOSName() {
        String string = System.getProperty("os.name");
        if (string.compareTo("Solaris") == 0) {
            string = "SunOS";
        }
        return string;
    }

    public static String getOSArchitectureName() {
        String string = System.getProperty("os.arch");
        if (string.compareTo("x86") == 0) {
            string = "i386";
        }
        return string;
    }

    public String getName() {
        return this.hostName;
    }

    public boolean isName(String string) {
        return this.hostName.compareTo(string) == 0;
    }

    public void setName(String string) {
        this.hostName = string;
    }

    public String getAddress() {
        return this.hostAddress;
    }

    public boolean isAddress(String string) {
        return this.hostAddress.compareTo(string) == 0;
    }

    public void setAddress(String string) {
        this.hostAddress = string;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public boolean isOperatingSystem(String string) {
        boolean bl = this.operatingSystem == null ? string == null : this.operatingSystem.compareTo(string) == 0;
        return bl;
    }

    public void setOperatingSystem(String string) {
        this.operatingSystem = string;
    }

    public String getOSRelease() {
        return this.osRelease;
    }

    public boolean isOSRelease(String string) {
        boolean bl = this.osRelease == null ? string == null : this.osRelease.compareTo(string) == 0;
        return bl;
    }

    public void setOSRelease(String string) {
        this.osRelease = string;
    }

    public String getPlatform() {
        return this.platform;
    }

    public boolean isPlatform(String string) {
        boolean bl = this.platform == null ? string == null : this.platform.compareTo(string) == 0;
        return bl;
    }

    public String getHostName() {
        return this.hostName;
    }

    public boolean isHostName(String string) {
        boolean bl = this.hostName == null ? string == null : this.hostName.compareTo(string) == 0;
        return bl;
    }

    public void setHostName(String string) {
        this.hostName = string;
    }

    public void setBootFirmware(String string) throws InvalidVersionException {
        this.bootFirmware = new Version(string);
    }

    public void setMemorySize(String string) {
        this.memorySizeString = new String(string);
        this.memorySize = Integer.parseInt(string);
    }

    public void setPlatform(String string) {
        this.platform = string;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public boolean isArchitecture(String string) {
        boolean bl = this.architecture == null ? string == null : this.architecture.compareTo(string) == 0;
        return bl;
    }

    public void setArchitecture(String string) {
        this.architecture = string;
    }

    public Version getBootFirmware() {
        return this.bootFirmware;
    }

    public int getMemorySizeMegabytes() {
        return this.memorySize;
    }

    public Enumeration getDrivers() {
        return this.driverDatabase.elements();
    }

    public void addDrivers(Enumeration enumeration) {
        if (enumeration != null) {
            try {
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (string == null) continue;
                    this.addDriver(string);
                }
            }
            catch (Exception exception) {
                this.log.println(this, 4, "Host.addDrivers(Enumeration list): " + exception.getMessage());
            }
        }
    }

    public synchronized void addDriver(String string) {
        if (!this.driverDatabase.contains(string)) {
            this.driverDatabase.addElement(string);
        }
    }

    public void initDrivers() {
        this.driverDatabase = new Vector();
    }

    public boolean hasDriver(String string) {
        return this.driverDatabase.contains(string);
    }

    public boolean hasAssociates() {
        return this.getAssociateCount() != 0;
    }

    public int getAssociateCount() {
        return this.totalAssociates;
    }

    public Enumeration getAssociates() {
        return this.associateDatabase.elements();
    }

    public void addAssociates(Enumeration enumeration) {
        if (enumeration != null) {
            try {
                while (enumeration.hasMoreElements()) {
                    Host host = (Host)enumeration.nextElement();
                    if (host == null) continue;
                    this.addAssociate(host);
                }
            }
            catch (Exception exception) {
                this.log.println(this, 4, "Host.addAssociates(Enumeration list): " + exception.getMessage());
            }
        }
    }

    public synchronized void addAssociate(Host host) throws IllegalAccessException {
        if (this.associateDatabase != null && host != null) {
            if (host.getAddress() == null || host.getType() == null) {
                throw new IllegalAccessException("Associate has a null key and may not be inserted.");
            }
            try {
                host.markAsAssociate(true);
                this.associateDatabase.addObject((Object)host);
                ++this.totalAssociates;
            }
            catch (DuplicateEntryException duplicateEntryException) {
                // empty catch block
            }
        }
    }

    public void initAssociates() {
        String[] stringArray = new String[]{"getAddress()", "getType()"};
        try {
            this.associateDatabase = new MemoryAdapter(Class.forName("com.sun.patchpro.host.Host"), stringArray);
            this.associateDatabase.allowDuplicates("getType()", true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Couldn't create associates database.");
        }
    }

    public boolean hasAssociateByAddress(String string) {
        if (this.associateDatabase != null && string != null) {
            try {
                this.associateDatabase.findObject("getAddress()", (Object)string);
                return true;
            }
            catch (NoSuchObjectException noSuchObjectException) {
                return false;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return false;
            }
        }
        return false;
    }

    public boolean hasAssociateByType(String string) {
        boolean bl = false;
        if (this.isType(string)) {
            bl = true;
        } else if (this.associateDatabase != null && string != null) {
            try {
                this.associateDatabase.findObject("getType()", (Object)string);
                bl = true;
            }
            catch (NoSuchObjectException noSuchObjectException) {
                bl = false;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                bl = false;
            }
        }
        return bl;
    }

    public Host getAssociateByAddress(String string) throws NoSuchFieldException, NoSuchObjectException {
        Host host;
        if (this.isAddress(string)) {
            host = this;
        } else if (this.associateDatabase != null && string != null) {
            host = (Host)this.associateDatabase.findObject("getAddress()", (Object)string.toString());
        } else {
            throw new NoSuchObjectException("getAssociate: bad arguments.");
        }
        return host;
    }

    public Enumeration getAssociatesByType(String string) throws NoSuchObjectException, NoSuchFieldException {
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.associateDatabase.findList("getType()", (Object)string);
        if (this.isType(string)) {
            vector.add(this);
        }
        while (enumeration.hasMoreElements()) {
            vector.add(this.associateDatabase.getObject(((Integer)enumeration.nextElement()).intValue()));
        }
        return vector.elements();
    }

    public Enumeration getHardwareComponents() {
        return this.hardwareDatabase.elements();
    }

    public void addHardwareComponents(Enumeration enumeration) {
        if (enumeration != null) {
            try {
                while (enumeration.hasMoreElements()) {
                    HardwareComponent hardwareComponent = (HardwareComponent)enumeration.nextElement();
                    if (hardwareComponent == null) continue;
                    this.addHardwareComponent(hardwareComponent);
                }
            }
            catch (Exception exception) {
                this.log.println(this, 4, "Host.addHardwareComponents(Enumeration list): " + exception.getMessage());
            }
        }
    }

    public synchronized void addHardwareComponent(HardwareComponent hardwareComponent) {
        try {
            this.hardwareDatabase.addObject((Object)hardwareComponent);
        }
        catch (DuplicateEntryException duplicateEntryException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public void initHardwareComponents() {
        String[] stringArray = new String[]{"getProduct()", "getFullName()"};
        try {
            this.hardwareDatabase = new MemoryAdapter(Class.forName("com.sun.patchpro.host.HardwareComponent"), stringArray);
            this.hardwareDatabase.allowDuplicates("getProduct()", true);
            this.hardwareDatabase.allowDuplicates("getFullName()", true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Couldn't create hardware component database.");
        }
    }

    public boolean hasExactHardwareComponent(String string, String string2) {
        if (this.hardwareDatabase != null && string != null && string2 != null) {
            try {
                this.hardwareDatabase.findObject("getFullName()", (Object)(string + "~" + string2));
                return true;
            }
            catch (NoSuchObjectException noSuchObjectException) {
                return false;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return false;
            }
        }
        return false;
    }

    public String getHardwareComponentRev(String string) throws NoSuchObjectException, NoSuchFieldException {
        if (this.hardwareDatabase == null || string == null) {
            throw new NoSuchObjectException("getHardwareComponent: bad argument");
        }
        HardwareComponent hardwareComponent = (HardwareComponent)this.hardwareDatabase.findObject("getProduct()", (Object)string);
        return hardwareComponent.getRevision();
    }

    public boolean hasHardwareComponent(String string) {
        try {
            this.hardwareDatabase.findObject("getProduct()", (Object)string);
            return true;
        }
        catch (NoSuchObjectException noSuchObjectException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public Enumeration getAllRealizations() {
        return new RealizationEnumerator(this.realizationsDatabase.elements());
    }

    public Enumeration getRealizations() {
        Vector<RealizationStatus> vector = new Vector<RealizationStatus>();
        Enumeration enumeration = this.realizationsDatabase.elements();
        while (enumeration.hasMoreElements()) {
            RealizationStatus realizationStatus = (RealizationStatus)enumeration.nextElement();
            if (!realizationStatus.isInstalled) continue;
            vector.addElement(realizationStatus);
        }
        RealizationEnumerator realizationEnumerator = new RealizationEnumerator(vector.elements());
        return realizationEnumerator;
    }

    public void addRealizations(Enumeration enumeration) {
        if (enumeration != null) {
            try {
                while (enumeration.hasMoreElements()) {
                    Realization realization = (Realization)enumeration.nextElement();
                    if (realization == null) continue;
                    this.addRealization(realization);
                }
            }
            catch (Exception exception) {
                this.log.println(this, 4, "Host.addRealizations(Enumeration list): " + exception.getMessage());
            }
        }
    }

    public void addRealization(Realization realization) {
        this.addRealization(realization, true);
    }

    public synchronized void addRealization(Realization realization, boolean bl) {
        RealizationStatus realizationStatus = new RealizationStatus(realization, bl);
        try {
            this.modifyRealization(realization, bl);
        }
        catch (NoSuchRealizationException noSuchRealizationException) {
            try {
                this.realizationsDatabase.addObject((Object)realizationStatus);
            }
            catch (DuplicateEntryException duplicateEntryException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (Exception exception) {
                this.log.println(this, 3, "Host.addRealization()Unexpected Exception - " + exception.getMessage() + ".");
            }
        }
    }

    public void verifyRealization(Realization realization) throws NoSuchRealizationException {
        this.modifyRealization(realization, true);
    }

    public void verifyRealization(Realization realization, boolean bl) throws NoSuchRealizationException {
        this.modifyRealization(realization, bl);
    }

    public void initRealizations() {
        String[] stringArray = new String[]{"realization.getBasename()", "realization.getRealizationString()"};
        try {
            this.realizationsDatabase = new MemoryAdapter(Class.forName("com.sun.patchpro.host.RealizationStatus"), stringArray);
            this.realizationsDatabase.allowDuplicates("realization.getBasename()", true);
        }
        catch (Exception exception) {
            System.out.println("Couldn't create Realization database.");
        }
    }

    public boolean hasExactRealization(Realization realization) throws UnknownRealizationException {
        if (realization == null) {
            throw new UnknownRealizationException("Host.hasExactRealization(): The null realization is meaningless.");
        }
        if (this.realizationsDatabase == null) {
            throw new UnknownRealizationException("Host.hasExactRealization(): No realizations are present.");
        }
        String string = realization.getRealizationString();
        try {
            RealizationStatus realizationStatus = (RealizationStatus)this.realizationsDatabase.findObject("realization.getRealizationString()", (Object)string);
            return realizationStatus.isInstalled;
        }
        catch (Exception exception) {
            throw new UnknownRealizationException("Host.hasExactRealization(): The realization provided hasnot been tested.");
        }
    }

    public boolean hasRealization(Realization realization) throws UnknownRealizationException {
        boolean bl;
        block11: {
            bl = false;
            if (realization == null) {
                throw new UnknownRealizationException("Host.hasExactRealization(): The null realization is meaningless.");
            }
            if (this.realizationsDatabase == null) {
                throw new UnknownRealizationException("Host.hasExactRealization(): No realizations are present.");
            }
            try {
                bl = this.hasExactRealization(realization);
                if (bl) break block11;
                try {
                    Enumeration enumeration = this.getRealizationStatusByName(realization.getBasename());
                    boolean bl2 = false;
                    while (enumeration.hasMoreElements() && !bl2) {
                        RealizationStatus realizationStatus = (RealizationStatus)enumeration.nextElement();
                        if (!realizationStatus.isInstalled || realizationStatus.realization.getVersion().compareTo(realization.getVersion()) < 0) continue;
                        bl2 = true;
                    }
                    bl = bl2;
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    throw new UnknownRealizationException("Host.hasExactRealization(): No such Realization.");
                }
            }
            catch (UnknownRealizationException unknownRealizationException) {
                Serializable serializable;
                Enumeration enumeration;
                try {
                    enumeration = this.getRealizationStatusByName(realization.getBasename());
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    throw new UnknownRealizationException("Host.hasExactRealization(): No such Realization.");
                }
                if (!enumeration.hasMoreElements()) {
                    throw new UnknownRealizationException("Host.hasRealization(): Realization " + realization.getBasename() + " is not present.");
                }
                if (!enumeration.hasMoreElements()) break block11;
                Serializable serializable2 = (RealizationStatus)enumeration.nextElement();
                while (enumeration.hasMoreElements()) {
                    serializable = (RealizationStatus)enumeration.nextElement();
                    if (serializable2.realization.getVersion().compareTo(((RealizationStatus)serializable).realization.getVersion()) >= 0 || !((RealizationStatus)serializable).isInstalled) continue;
                    serializable2 = serializable;
                }
                serializable = serializable2.realization;
                if (((Realization)serializable).getVersion().compareTo(realization.getVersion()) < 0) break block11;
                bl = serializable2.isInstalled;
            }
        }
        return bl;
    }

    public Realization getRealizationByName(String string) {
        if (this.realizationsDatabase == null || string == null) {
            return null;
        }
        try {
            Enumeration enumeration = this.getRealizationStatusByName(string);
            if (enumeration.hasMoreElements()) {
                RealizationStatus realizationStatus = (RealizationStatus)enumeration.nextElement();
                while (enumeration.hasMoreElements()) {
                    RealizationStatus realizationStatus2 = (RealizationStatus)enumeration.nextElement();
                    if (realizationStatus.realization.getVersion().compareTo(realizationStatus2.realization.getVersion()) >= 0 || !realizationStatus2.isInstalled) continue;
                    realizationStatus = realizationStatus2;
                }
                if (realizationStatus.isInstalled) {
                    return realizationStatus.realization;
                }
                return null;
            }
            return null;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            return null;
        }
        catch (Exception exception) {
            throw new Error("Critical internal error in Host:\n " + exception.getMessage());
        }
    }

    public Enumeration getSoftwarePackages() {
        return this.softwareDatabase.elements();
    }

    public void addSoftwarePackages(Enumeration enumeration) {
        if (enumeration != null) {
            try {
                while (enumeration.hasMoreElements()) {
                    SoftwarePackage softwarePackage = (SoftwarePackage)enumeration.nextElement();
                    if (softwarePackage == null) continue;
                    this.addSoftwarePackage(softwarePackage);
                }
            }
            catch (Exception exception) {
                this.log.println(this, 4, "Host.addSoftwarePackages(Enumeration list): " + exception.getMessage());
            }
        }
    }

    public void addSoftwarePackage(SoftwarePackage softwarePackage) {
        try {
            this.softwareDatabase.addObject((Object)softwarePackage);
        }
        catch (DuplicateEntryException duplicateEntryException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public void initSoftwarePackages() {
        String[] stringArray = new String[]{"getName()", "getFullName()"};
        try {
            this.softwareDatabase = new MemoryAdapter(Class.forName("com.sun.patchpro.host.SoftwarePackage"), stringArray);
            this.softwareDatabase.allowDuplicates("getName()", true);
            this.softwareDatabase.allowDuplicates("getFullName()", true);
        }
        catch (Exception exception) {
            System.out.println("Couldn't create software database.");
        }
    }

    public boolean hasExactSoftwarePackage(SoftwarePackage softwarePackage) {
        if (this.softwareDatabase != null && softwarePackage != null) {
            try {
                this.softwareDatabase.findObject("getFullName()", (Object)softwarePackage.getFullName());
                return true;
            }
            catch (NoSuchObjectException noSuchObjectException) {
                return false;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return false;
            }
        }
        return false;
    }

    public String getSoftwarePackageRev(String string) {
        if (this.softwareDatabase != null && string != null) {
            try {
                SoftwarePackage softwarePackage = (SoftwarePackage)this.softwareDatabase.findObject("getName()", (Object)string);
                return softwarePackage.getVersion();
            }
            catch (NoSuchObjectException noSuchObjectException) {
                return null;
            }
            catch (Exception exception) {
                this.log.println(this, 4, "Host.getSoftwarePackageRev(String name): " + exception.getMessage());
            }
        }
        return null;
    }

    public boolean hasSoftwarePackage(String string) {
        try {
            this.softwareDatabase.findObject("getName()", (Object)string);
            return true;
        }
        catch (NoSuchObjectException noSuchObjectException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public SoftwarePackage getSoftwarePackage(String string) {
        SoftwarePackage softwarePackage = null;
        try {
            softwarePackage = (SoftwarePackage)this.softwareDatabase.findObject("getName()", (Object)string);
        }
        catch (NoSuchObjectException noSuchObjectException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return softwarePackage;
    }

    public SoftwarePackage getExactSoftwarePackage(String string) {
        SoftwarePackage softwarePackage = null;
        try {
            softwarePackage = (SoftwarePackage)this.softwareDatabase.findObject("getFullName()", (Object)string);
        }
        catch (NoSuchObjectException noSuchObjectException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return softwarePackage;
    }

    public PatchListImpl getPatchesDtl() {
        PatchListImpl patchListImpl = new PatchListImpl();
        Enumeration enumeration = this.patchIDDatabase.elements();
        while (enumeration.hasMoreElements()) {
            patchListImpl.addIPatch(new IPatch(new PatchImpl((PatchID)enumeration.nextElement())));
        }
        return patchListImpl;
    }

    public Enumeration getAppliedPatches() {
        return this.patchIDDatabase.elements();
    }

    public PatchList getPatches() {
        return this.getPatchesDtl();
    }

    public void addPatches(Enumeration enumeration) {
        if (enumeration != null) {
            try {
                while (enumeration.hasMoreElements()) {
                    PatchID patchID = (PatchID)enumeration.nextElement();
                    if (patchID == null) continue;
                    this.addPatchID(patchID);
                }
            }
            catch (Exception exception) {
                this.log.println(this, 4, "Host.addPatches(String name): " + exception.getMessage());
            }
        }
    }

    public void addPatchID(PatchID patchID) {
        try {
            this.patchIDDatabase.addObject((Object)patchID);
        }
        catch (DuplicateEntryException duplicateEntryException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public void initPatches() {
        String[] stringArray = new String[]{"getBasecode()", "getPatchID()"};
        try {
            this.patchIDDatabase = new MemoryAdapter(Class.forName("com.sun.patchpro.patch.PatchID"), stringArray);
            this.patchIDDatabase.allowDuplicates("getBasecode()", true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Couldn't create patch ID database.");
        }
    }

    public boolean hasExactPatchID(PatchID patchID) {
        if (this.patchIDDatabase == null || patchID == null) {
            return false;
        }
        String string = patchID.getPatchID();
        try {
            this.patchIDDatabase.findObject("getPatchID()", (Object)patchID.getPatchID());
            return true;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getPatchRev(String string) {
        if (this.patchIDDatabase != null && string != null) {
            try {
                PatchID patchID = (PatchID)this.patchIDDatabase.findObject("getBasecode()", (Object)string);
                return patchID.getRevision();
            }
            catch (NoSuchObjectException noSuchObjectException) {
                return null;
            }
            catch (Exception exception) {
                this.log.println(this, 4, "Host.getPatchRev(String name): " + exception.getMessage());
            }
        }
        return null;
    }

    public String getLatestPatchRev(String string) {
        if (this.patchIDDatabase != null && string != null) {
            try {
                PatchID patchID = null;
                Enumeration enumeration = this.patchIDDatabase.findList("getBasecode()", (Object)string);
                String string2 = null;
                while (enumeration.hasMoreElements()) {
                    int n = (Integer)enumeration.nextElement();
                    patchID = (PatchID)this.patchIDDatabase.getObject(n);
                    if (string2 != null && string2.compareTo(patchID.getRevision()) >= 0) continue;
                    string2 = patchID.getRevision();
                }
                return string2;
            }
            catch (NoSuchObjectException noSuchObjectException) {
                return null;
            }
            catch (Exception exception) {
                this.log.println(this, 4, "Host.getPatchLatestRev(String name): " + exception.getMessage());
            }
        }
        return null;
    }

    public boolean hasPatchID(String string) {
        try {
            this.patchIDDatabase.findObject("getBasecode()", (Object)string);
            return true;
        }
        catch (NoSuchObjectException noSuchObjectException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean hasPatch(PatchID patchID) throws NoSuchPatchException {
        int n;
        boolean bl = false;
        String string = patchID.getBasecode();
        String string2 = patchID.getRevision();
        try {
            n = new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.log.println(this, 4, "Host.hasPatch(" + string + "-" + string2 + "): could not convert the provided patch " + "version to an int.");
            throw new NoSuchPatchException("Host.hasPatch(" + string + "-" + string2 + "): could not convert " + "the provided patch version to an int.");
        }
        String string3 = this.getLatestPatchRev(string);
        if (string3 != null) {
            int n2;
            try {
                n2 = new Integer(string3);
            }
            catch (NumberFormatException numberFormatException) {
                this.log.println(this, 4, "Host.hasPatch(" + string + "-" + string2 + "): could not convert the installed patch " + "version, " + string3 + ", to an int.");
                throw new NoSuchPatchException("Host.hasPatch(" + string + "-" + string2 + "): could not convert " + "the installed patch version, " + string3 + ", to an int.");
            }
            if (n2 >= n) {
                bl = true;
            }
        }
        return bl;
    }

    private Enumeration getRealizationStatusByName(String string) throws NoSuchObjectException {
        Enumeration enumeration;
        if (string == null) {
            throw new NoSuchObjectException("Host.hasExactRealization(): The null realization is meaningless.");
        }
        try {
            enumeration = this.realizationsDatabase.findList("realization.getBasename()", (Object)string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.log.println(this, 3, "Host.getRealizationStatusByName(" + string + "): Nonexistent database field.");
            throw new NoSuchObjectException("Host.hasExactRealization(): The null realization is meaningless.");
        }
        Vector<RealizationStatus> vector = new Vector<RealizationStatus>();
        while (enumeration.hasMoreElements()) {
            try {
                RealizationStatus realizationStatus = (RealizationStatus)this.realizationsDatabase.getObject(((Integer)enumeration.nextElement()).intValue());
                if (!realizationStatus.isInstalled) continue;
                vector.addElement(realizationStatus);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                throw new NoSuchObjectException(noSuchObjectException.getMessage());
            }
        }
        return vector.elements();
    }

    private void modifyRealization(Realization realization, boolean bl) throws NoSuchRealizationException {
        try {
            RealizationStatus realizationStatus = (RealizationStatus)this.realizationsDatabase.findObject("realization.getRealizationString()", (Object)realization.getRealizationString());
            realizationStatus.isInstalled = bl;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            throw new NoSuchRealizationException("The realization " + realization.getRealizationString() + " is not known to this host.");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.log.println(this, 3, "Host.modifyRealization(" + realization.getRealizationString() + "): could not modify database.");
        }
    }

    public boolean isIdentical(Host host) {
        Object object;
        Object object2;
        Object object3;
        boolean bl = true;
        if (!(host.isOperatingSystem(this.operatingSystem) && host.isOSRelease(this.osRelease) && host.isArchitecture(this.architecture) && host.isPlatform(this.platform))) {
            bl = false;
        }
        Enumeration enumeration = host.getAllRealizations();
        while (enumeration.hasMoreElements()) {
            object3 = (Realization)enumeration.nextElement();
            try {
                if (this.hasExactRealization((Realization)object3)) continue;
                bl = false;
                break;
            }
            catch (UnknownRealizationException unknownRealizationException) {
                bl = false;
                break;
            }
        }
        object3 = host.getSoftwarePackages();
        while (object3.hasMoreElements()) {
            object2 = (SoftwarePackage)object3.nextElement();
            if (this.hasExactSoftwarePackage((SoftwarePackage)object2)) continue;
            bl = false;
            break;
        }
        object2 = host.getAppliedPatches();
        while (object2.hasMoreElements()) {
            object = (PatchID)object2.nextElement();
            if (this.hasExactPatchID((PatchID)object)) continue;
            bl = false;
            break;
        }
        object = host.getAssociates();
        Enumeration enumeration2 = this.getAssociates();
        int n = 0;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        while (object.hasMoreElements()) {
            ++n2;
            vector2.add(((Host)object.nextElement()).getType());
        }
        while (enumeration2.hasMoreElements()) {
            ++n;
            vector.add(((Host)enumeration2.nextElement()).getType());
        }
        if (n != n2) {
            bl = false;
        } else {
            for (int i = 0; i < n; ++i) {
                String string = (String)vector.elementAt(i);
                boolean bl2 = false;
                for (int j = 0; j < n2; ++j) {
                    if (string.compareTo((String)vector2.elementAt(j)) != 0) continue;
                    vector2.setElementAt("", j);
                    bl2 = true;
                }
                if (bl2) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public SessionData getSessionData() {
        return this.sessionData;
    }

    private PatchList getAppropriatePatchList(ReadOnlyHost readOnlyHost, int n) throws NoResultException, IndexOutOfBoundsException {
        SessionData sessionData = readOnlyHost.getSessionData();
        PatchList patchList = sessionData.getPatchList(n);
        return patchList;
    }

    public String getXMLPatchListSet(int n) {
        String string = "";
        try {
            string = this.getXMLPatchListSet(1, n, "");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return string;
    }

    public void printXMLPatchListSet(int n) {
        this.printXMLPatchListSet(1, n);
    }

    public void printXMLPatchListSet(int n, PrintWriter printWriter) {
        this.printXMLPatchListSet(1, n, printWriter);
    }

    public String getXMLPatchListSet(int n, int n2, String string) {
        String string2 = XMLFormatUtilities.indent(n2);
        PatchList patchList = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = this.getType();
        String string4 = this.getAddress();
        stringBuffer.append(string2 + "<?xml version=\"1.0\"?>");
        stringBuffer.append(string2 + "<!DOCTYPE patchlistset SYSTEM " + "\"../lib/patchlistset.dtd\">\n");
        stringBuffer.append(string2 + "<patchlistset>\n");
        String string5 = XMLFormatUtilities.indent(n2 + 1);
        String string6 = XMLFormatUtilities.indent(n2 + 2);
        stringBuffer.append(string5 + "<errorlist>\n");
        stringBuffer.append(string6 + "<error>" + string + "</error>\n");
        stringBuffer.append(string5 + "</errorlist>\n");
        try {
            patchList = this.getAppropriatePatchList(this, n);
            if (patchList != null) {
                stringBuffer.append(patchList.toSummaryXML(n2 + 1, string3, string4));
            }
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        Enumeration enumeration = this.getAssociates();
        while (enumeration.hasMoreElements()) {
            patchList = null;
            Host host = (Host)enumeration.nextElement();
            string3 = host.getType();
            string4 = host.getAddress();
            try {
                patchList = this.getAppropriatePatchList(host, n);
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
            if (patchList == null) continue;
            stringBuffer.append(patchList.toSummaryXML(n2 + 1, string3, string4));
        }
        stringBuffer.append(string2 + "</patchlistset>\n");
        return stringBuffer.toString();
    }

    public void printXMLPatchListSet(int n, int n2) {
        System.out.println(this.getXMLPatchListSet(n, n2, ""));
    }

    public void printXMLPatchListSet(int n, int n2, PrintWriter printWriter) {
        String string = this.getXMLPatchListSet(n, n2, "");
        printWriter.print(string);
    }

    public void printXMLPatchListSet(int n, int n2, PrintWriter printWriter, String string) {
        String string2 = this.getXMLPatchListSet(n, n2, string);
        printWriter.print(string2);
    }

    public void setPrimaryHost(Host host) {
        this.primaryHost = host;
    }

    public Host getPrimaryHost() {
        return this.primaryHost;
    }
}

