/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.database;

import com.sun.database.simpleadapter.ndbm.NDBMAdapter;
import com.sun.database.simpledatabase.DatabaseError;
import com.sun.database.simpledatabase.NoSuchDatabaseException;
import com.sun.database.simpledatabase.NoSuchObjectException;
import com.sun.database.simpledatabase.SimpleDatabase;
import com.sun.patchpro.database.PatchBaseRecord;
import com.sun.patchpro.database.PatchDB;
import com.sun.patchpro.database.RealizationRecord;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchInfoImpl;
import com.sun.patchpro.patch.PatchProperties;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class NDBMPatchDB
implements PatchDB {
    static final long serialVersionUID = 885356157898626732L;
    private String OSName = null;
    private String OSRelease = null;
    private String Architecture = null;
    private URL patchbaseUrl;
    private URL realizationUrl;
    private SimpleDatabase patchBaseDB;
    private SimpleDatabase realizationDB;

    public NDBMPatchDB() {
    }

    public NDBMPatchDB(URL uRL) throws MalformedURLException, NoSuchDatabaseException {
        this.setDatabase(uRL);
        this.openDatabases();
    }

    public NDBMPatchDB(String string, String string2, String string3, URL uRL) throws MalformedURLException, NoSuchDatabaseException {
        this.setDatabase(uRL);
        this.openDatabases();
        this.setTarget(string, string2, string3);
    }

    public void setTarget(String string, String string2, String string3) {
        this.OSName = string;
        this.OSRelease = string2;
        this.Architecture = string3;
    }

    public void setDatabase(URL uRL) throws MalformedURLException {
        this.patchbaseUrl = new URL("file:" + uRL.getFile() + "/patchbase");
        this.realizationUrl = new URL("file:" + uRL.getFile() + "/realization");
    }

    public void setDatabase(String string) {
        try {
            this.setDatabase(new URL(string));
        }
        catch (Exception exception) {
            throw new Error("Bad URL.  Unable to connect to DB.");
        }
    }

    public void openDatabases() throws NoSuchDatabaseException {
        this.patchBaseDB = null;
        this.realizationDB = null;
        try {
            this.patchBaseDB = new NDBMAdapter(this.patchbaseUrl);
            this.realizationDB = new NDBMAdapter(this.realizationUrl);
        }
        catch (NoSuchDatabaseException noSuchDatabaseException) {
            PatchProLog.getInstance().println(this, 2, noSuchDatabaseException.getMessage());
            this.closeDatabase();
            throw noSuchDatabaseException;
        }
        catch (Error error) {
            this.closeDatabase();
            PatchProLog.getInstance().println(this, 2, error.getMessage());
            throw error;
        }
    }

    public void openDatabase() throws NoSuchDatabaseException {
        this.openDatabases();
    }

    public void closeDatabase() {
        try {
            if (this.patchBaseDB != null) {
                this.patchBaseDB.closeDatabase();
                this.patchBaseDB = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.realizationDB != null) {
                this.realizationDB.closeDatabase();
                this.realizationDB = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Enumeration getPatches(Realization realization) throws NoSuchPatchException {
        RealizationRecord realizationRecord;
        Hashtable hashtable = new Hashtable();
        String string = new String(realization.getBasename() + "-" + realization.getVersion());
        try {
            realizationRecord = (RealizationRecord)this.realizationDB.findObject("realization", (Object)string);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            PatchProLog.getInstance().println(this, 3, noSuchObjectException.getMessage() + " Indicating no patches for " + string + ".");
            throw new NoSuchPatchException("No patches for " + string + ".");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            PatchProLog.getInstance().println(this, 3, noSuchFieldException.getMessage());
            throw new NoSuchPatchException("Could not find Field.");
        }
        catch (Error error) {
            PatchProLog.getInstance().println(this, 2, error.getMessage());
            throw error;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(realizationRecord.patchIDs);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                PatchBaseRecord patchBaseRecord = this.basicGetPatch(string2, true);
                this.qualifyPatch(patchBaseRecord, hashtable);
            }
            catch (MalformedPatchException malformedPatchException) {
                PatchProLog.getInstance().println(this, 2, malformedPatchException.getMessage());
            }
        }
        if (hashtable.isEmpty()) {
            throw new NoSuchPatchException("No patches meet the criteria.");
        }
        return hashtable.elements();
    }

    public PatchImpl getPatch(PatchID patchID) throws NoSuchPatchException {
        PatchImpl patchImpl = null;
        String string = new String(patchID.getBasecode() + "-" + patchID.getRevision());
        try {
            PatchBaseRecord patchBaseRecord = this.basicGetPatch(string, false);
            patchImpl = this.constructPatchObject(patchBaseRecord);
        }
        catch (Exception exception) {
            PatchProLog.getInstance().println(this, 2, "NDBMPatchDB.getPatch: Unable to  construct patch, " + string + ". Error is " + exception.getMessage() + ".");
            throw new NoSuchPatchException("Could not construct patch from patch ID.");
        }
        return patchImpl;
    }

    public PatchImpl getLatestPatch(PatchID patchID) throws NoSuchPatchException {
        PatchImpl patchImpl = null;
        String string = new String(patchID.getBasecode() + "-" + patchID.getRevision());
        try {
            PatchBaseRecord patchBaseRecord = this.basicGetPatch(string, true);
            patchImpl = this.constructPatchObject(patchBaseRecord);
        }
        catch (Exception exception) {
            PatchProLog.getInstance().println(this, 2, "NDBMPatchDB.getLatestPatch: Unable to  construct patch, " + string + ". Error is " + exception.getMessage() + ".");
            throw new NoSuchPatchException("Could not construct patch from patch ID.");
        }
        return patchImpl;
    }

    private void qualifyPatch(PatchBaseRecord patchBaseRecord, Hashtable hashtable) throws NoSuchPatchException {
        if (!hashtable.containsKey(patchBaseRecord.patchBaseCode)) {
            if (this.OSName != null && patchBaseRecord.targetOS.compareTo(this.OSName) != 0) {
                return;
            }
            if (this.OSRelease != null) {
                boolean bl = false;
                StringTokenizer stringTokenizer = new StringTokenizer(patchBaseRecord.targetRelease);
                while (stringTokenizer.hasMoreTokens()) {
                    if (stringTokenizer.nextToken().compareTo(this.OSRelease) != 0) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return;
                }
            }
            if (this.Architecture != null && patchBaseRecord.targetArchitecture.compareTo(this.Architecture) != 0) {
                return;
            }
            try {
                hashtable.put(patchBaseRecord.patchBaseCode, this.constructPatchObject(patchBaseRecord));
            }
            catch (Exception exception) {
                PatchProLog.getInstance().println(this, 2, "NDBMPatchDB.qualifyPatch: Unable to construct a patch object from, " + patchBaseRecord.patchBaseCode + "-" + patchBaseRecord.patchVersion + ".");
            }
        }
    }

    private PatchImpl constructPatchObject(PatchBaseRecord patchBaseRecord) throws MalformedPatchException {
        String string = new String("unknown");
        PatchID patchID = new PatchID(patchBaseRecord.patchBaseCode + "-" + patchBaseRecord.patchVersion);
        PatchInfoImpl patchInfoImpl = new PatchInfoImpl();
        patchInfoImpl.setSynopsis(patchBaseRecord.synopsis);
        patchInfoImpl.setArchitecture(patchBaseRecord.targetArchitecture);
        patchInfoImpl.setOS(patchBaseRecord.targetOS);
        patchInfoImpl.setRelease(patchBaseRecord.targetRelease);
        patchInfoImpl.setType(patchBaseRecord.type);
        StringTokenizer stringTokenizer = new StringTokenizer(patchBaseRecord.corrects);
        while (stringTokenizer.hasMoreElements()) {
            string = (String)stringTokenizer.nextElement();
            try {
                patchInfoImpl.addRealization(new Realization(string));
            }
            catch (NoSuchRealizationException noSuchRealizationException) {
                PatchProLog.getInstance().println(this, 2, "NDBMPatchDB.constructPatchObject: Ignoring invalid realization, " + string + ", in patch " + patchID.getPatchID() + ".");
            }
        }
        patchInfoImpl.setObsolesces(patchBaseRecord.obsolesces);
        patchInfoImpl.setRequires(patchBaseRecord.requires);
        patchInfoImpl.setIncompat(patchBaseRecord.incompatibleWith);
        patchInfoImpl.setPrefers(patchBaseRecord.prefers);
        patchInfoImpl.setProperties(new PatchProperties(patchBaseRecord.properties));
        if (patchBaseRecord.obsolescedBy != null && patchBaseRecord.obsolescedBy.compareTo("") != 0) {
            try {
                patchInfoImpl.setObsolescedBy(new PatchID(patchBaseRecord.obsolescedBy));
            }
            catch (MalformedPatchException malformedPatchException) {
                // empty catch block
            }
        }
        return new PatchImpl(patchInfoImpl, patchID);
    }

    private PatchBaseRecord basicGetPatch(String string, boolean bl) throws MalformedPatchException, NoSuchPatchException {
        Enumeration enumeration;
        String string2 = this.getPatchBaseCode(string);
        String string3 = this.getPatchVersion(string);
        int n = 0;
        PatchBaseRecord patchBaseRecord = null;
        int n2 = new Integer(string3);
        try {
            enumeration = this.patchBaseDB.findList("patchBaseCode", (Object)string2);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            throw new NoSuchPatchException("No patch matches the base code " + string2 + ".");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new DatabaseError((Exception)noSuchFieldException, "NDBMPatchDB.basicGetPatch: patchBaseCode is apparently not a valid field!!!");
        }
        while (enumeration.hasMoreElements()) {
            PatchBaseRecord patchBaseRecord2;
            try {
                patchBaseRecord2 = (PatchBaseRecord)this.patchBaseDB.getObject(((Integer)enumeration.nextElement()).intValue());
            }
            catch (NoSuchObjectException noSuchObjectException) {
                throw new NoSuchPatchException(noSuchObjectException.getMessage());
            }
            if (bl) {
                int n3 = new Integer(patchBaseRecord2.patchVersion);
                if (n3 >= n2 && n < n3) {
                    patchBaseRecord = patchBaseRecord2;
                }
                n = n3;
                continue;
            }
            if (patchBaseRecord2.patchVersion.compareTo(string3) != 0) continue;
            patchBaseRecord = patchBaseRecord2;
            break;
        }
        if (patchBaseRecord == null) {
            if (bl) {
                throw new NoSuchPatchException("No patch version equal to or later than " + string + ".");
            }
            throw new NoSuchPatchException("No patch matching " + string + ".");
        }
        return patchBaseRecord;
    }

    private String getPatchBaseCode(String string) {
        return string.substring(0, string.indexOf("-"));
    }

    private String getPatchVersion(String string) {
        return string.substring(string.indexOf("-") + 1);
    }
}

