/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.database;

import com.sun.patchpro.database.AuditRecordParsingException;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchInfoImpl;
import com.sun.patchpro.patch.PatchProperties;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class AuditRecord
implements Serializable {
    static final long serialVersionUID = 123L;
    static final String auditRecordFormat = "<type>|<address>|<host attributes>|<patchid>|<patch attributes>";
    protected int auditRecordTokenCount;
    protected Host targetHost;
    protected Patch patch;
    protected String targetHostAddress;
    protected String targetHostType;
    protected String targetHostArchitecture;
    protected String targetHostOS;
    protected String targetHostOSRelease;

    public AuditRecord(Host host, Patch patch) {
        this(host.getAddress(), host.getType(), host.getOSArchitectureName(), host.getOSName(), host.getOSRelease(), patch);
        this.targetHost = host;
    }

    public AuditRecord(String string) throws AuditRecordParsingException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer.countTokens() < 5) {
            this.targetHostAddress = "";
            this.targetHostType = "";
            this.targetHostArchitecture = "";
            this.targetHostOS = "";
            this.targetHostOSRelease = "";
            this.patch = null;
            throw new AuditRecordParsingException("This audit record is not parsable: " + string, 1);
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        String string6 = stringTokenizer.nextToken();
        String string7 = stringTokenizer.nextToken();
        if (string7.compareTo("null") == 0) {
            string7 = "SunOS";
        }
        stringTokenizer = new StringTokenizer(string4, ",");
        String string8 = stringTokenizer.nextToken();
        String string9 = stringTokenizer.nextToken();
        if (string9.compareTo("null") == 0) {
            string9 = "";
        }
        String string10 = stringTokenizer.nextToken();
        String string11 = stringTokenizer.nextToken();
        PatchProperties patchProperties = new PatchProperties(string6);
        PatchInfoImpl patchInfoImpl = new PatchInfoImpl();
        patchInfoImpl.setType(string7);
        patchInfoImpl.setProperties(patchProperties);
        PatchID patchID = null;
        try {
            patchID = new PatchID(string5);
        }
        catch (MalformedPatchException malformedPatchException) {
            // empty catch block
        }
        PatchImpl patchImpl = new PatchImpl(patchInfoImpl, patchID);
        this.targetHostAddress = string3;
        this.targetHostType = string8;
        this.targetHostArchitecture = string9;
        this.targetHostOS = string10;
        this.targetHostOSRelease = string11;
        this.patch = patchImpl;
    }

    public AuditRecord(String string, String string2, String string3, String string4, String string5, Patch patch) {
        this.targetHostAddress = string;
        this.targetHostType = string2;
        this.targetHostArchitecture = string3;
        this.targetHostOS = string4;
        this.targetHostOSRelease = string5;
        this.patch = patch;
    }

    public String getTargetHostAddress() {
        return this.targetHostAddress;
    }

    public String getTargetHostType() {
        return this.targetHostType;
    }

    public String getTargetHostArchitecture() {
        return this.targetHostArchitecture;
    }

    public String getTargetHostOS() {
        return this.targetHostOS;
    }

    public String getTargetHostOSRelease() {
        return this.targetHostOSRelease;
    }

    public Patch getPatch() {
        return this.patch;
    }

    public void recordInstall(File file, String string) {
        Vector vector = this.patch.getPatchInfo().getProperties().getAllTypes();
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < vector.size(); ++i) {
            string2 = string2 + (String)vector.elementAt(i) + " ";
        }
        string3 = this.patch.getPatchInfo().getType();
        String string4 = "";
        if (string != null) {
            string4 = "|" + string;
        }
        try {
            FileWriter fileWriter = new FileWriter(file.getPath(), true);
            System.out.println("AuditRecord.write: about to write to: " + file.getPath());
            String string5 = this.getTargetHostArchitecture();
            if (string5.compareTo("") == 0) {
                string5 = "null";
            }
            System.out.println("AuditRecord - hostArchitecture: " + string5);
            fileWriter.write("general|" + this.getTargetHostAddress() + "|" + this.getTargetHostType() + "," + string5 + "," + this.getTargetHostOS() + "," + this.getTargetHostOSRelease() + "|" + this.patch.getPatchID().getPatchID() + "|" + string2 + "|" + string3 + string4);
            fileWriter.write("\n");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void recordBackout(File file) {
        this.recordInstall(file, "done");
    }
}

