/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.cli;

import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.manipulators.Manipulable;
import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProAccessor;
import com.sun.patchpro.model.PatchProEvent;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProListener;
import com.sun.patchpro.model.PatchProModel;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchAccumulator;
import com.sun.patchpro.patch.PatchContents;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchInfoImpl;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.security.SignatureValidationUtil;
import com.sun.patchpro.util.GetOpt;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.NoResultException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;

public final class SMPatchServices
implements PatchProListener {
    private static final String add_validArgs = "d:hi:x:";
    private static final String analyze_validArgs = "h";
    private static final String download_validArgs = "d:hi:x:";
    private static final String remove_validArgs = "hi:";
    private static final String update_validArgs = "d:h";
    private static final int LINELENGTH = 200;
    private static boolean outData;
    private static Vector exceptionRepository;
    private static LocalizedMessages msgcat;
    private static String hostMachine;
    private static String sequesterDirectory;
    private static boolean debug;
    private PatchPro model;
    private PatchProProperties properties = PatchProProperties.getInstance();
    private PatchList unavailablePatches = null;
    boolean done = false;
    boolean failed = false;

    public SMPatchServices() {
        debug = this.properties.getProperty("patchpro.debug", "false").equals("true");
        msgcat = new LocalizedMessages(this.properties.getLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] stringArray) {
        int n;
        int n2 = 0;
        int n3 = -1;
        GetOpt getOpt = null;
        InetAddress inetAddress = null;
        PatchList patchList = null;
        Runtime runtime = null;
        SMPatchServices sMPatchServices = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String[] stringArray2 = null;
        String[] stringArray3 = new String[3];
        String string6 = "";
        String string7 = "";
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        try {
            sMPatchServices = new SMPatchServices();
            sMPatchServices.instantiateModel();
        }
        catch (PatchProException patchProException) {
            System.err.println(patchProException.getLocalizedMessage());
            System.exit(1);
        }
        if (stringArray.length < 1) {
            SMPatchServices.usageTool(msgcat);
            System.exit(1);
        }
        if (stringArray.length == 1 && stringArray[0].equals("-h")) {
            SMPatchServices.usageTool(msgcat);
            System.exit(0);
        }
        string5 = stringArray[0];
        stringArray2 = new String[stringArray.length - 1];
        for (n = 0; n < stringArray.length - 1; ++n) {
            if (stringArray[n + 1].substring(0, 1).equals("-") && stringArray[n + 1].length() > 2) {
                vector3.addElement(stringArray[n + 1].substring(0, 2));
                vector3.addElement(stringArray[n + 1].substring(2));
                continue;
            }
            vector3.addElement(stringArray[n + 1]);
        }
        stringArray2 = new String[vector3.size()];
        for (n = 0; n < vector3.size(); ++n) {
            stringArray2[n] = (String)vector3.elementAt(n);
            if (!debug) continue;
            System.out.println("Option " + n + " : " + stringArray2[n]);
        }
        try {
            inetAddress = InetAddress.getLocalHost();
            hostMachine = "\"" + inetAddress.getLocalHost() + "\"";
        }
        catch (UnknownHostException unknownHostException) {
            hostMachine = "\"local host\"";
        }
        catch (SecurityException securityException) {
            hostMachine = "\"local host\"";
        }
        string6 = sMPatchServices.properties.getProperty("patchpro.patch.download.directory", "/var/sadm/spool");
        string7 = sMPatchServices.properties.getProperty("patchpro.patch.sequester.directory", "/var/sadm/spool/patchproSequester");
        if (string5.equals("add")) {
            try {
                if (stringArray2.length == 0) {
                    System.out.println(msgcat.getMessage("missing_patch_id", "At least one patch must be specified for this request."));
                    System.exit(1);
                }
                getOpt = new GetOpt(stringArray2, "d:hi:x:");
                try {
                    int n4;
                    block67: while ((n4 = getOpt.getNextOption()) != -1) {
                        ++n2;
                        switch ((char)n4) {
                            case 'd': {
                                if (bl2) {
                                    bl = true;
                                    continue block67;
                                }
                                bl2 = true;
                                string = getOpt.getOptionArg();
                                ++n2;
                                continue block67;
                            }
                            case 'i': {
                                if (bl3) {
                                    String string8 = getOpt.getOptionArg();
                                    if (vector2.contains(string8)) {
                                        System.out.println(msgcat.getMessage("dup_patchids", "Ignoring duplicate patch ID") + " " + string8);
                                    } else {
                                        vector2.addElement(string8);
                                    }
                                    ++n2;
                                    continue block67;
                                }
                                bl3 = true;
                                vector2.addElement(getOpt.getOptionArg());
                                ++n2;
                                continue block67;
                            }
                            case 'x': {
                                if (bl4) {
                                    bl = true;
                                    continue block67;
                                }
                                bl4 = true;
                                string2 = getOpt.getOptionArg();
                                if (string2.length() < 8 || !string2.substring(0, 7).equals("idlist=")) {
                                    throw new IllegalArgumentException(string2);
                                }
                                string3 = string2.substring(7);
                                ++n2;
                                continue block67;
                            }
                            case 'h': {
                                if (bl5) {
                                    bl = true;
                                    continue block67;
                                }
                                bl5 = true;
                                continue block67;
                            }
                        }
                        System.err.println(msgcat.getMessage("uncovered_GetOpt_error", "Invalid option or invalid syntax specification detected."));
                        System.exit(1);
                    }
                    if (bl) {
                        System.err.println(msgcat.getMessage("errDuplicateDetected", "Error: One or more duplicate options were detected."));
                        SMPatchServices.usageAdd(msgcat);
                        System.exit(1);
                    }
                    if (bl5) {
                        SMPatchServices.usageAdd(msgcat);
                        System.exit(0);
                    }
                    if (n2 != stringArray2.length) {
                        System.err.println(msgcat.getMessage("invalid_option_detected", "Unexpected option or option value detected."));
                        SMPatchServices.usageAdd(msgcat);
                        System.exit(1);
                    }
                    if (bl3 && bl4) {
                        System.err.println(msgcat.getMessage("smpatch_mutex_optix", "Options i and x are mutually exclusive"));
                        SMPatchServices.usageAdd(msgcat);
                        System.exit(1);
                    }
                    if (debug && bl3) {
                        for (int i = 0; i < vector2.size(); ++i) {
                            System.out.println("Patch to add via the -i options is " + vector2.elementAt(i));
                        }
                    }
                    vector = bl4 ? sMPatchServices.createPatchList(string3) : sMPatchServices.createPatchList(vector2);
                    if (!bl2) {
                        string = string6;
                        sequesterDirectory = string7;
                    } else {
                        sequesterDirectory = string + System.getProperty("file.separator") + "patchproSequester";
                    }
                    if (debug) {
                        System.out.println("Effective patch directory is " + string);
                    }
                    sMPatchServices.addPatches(vector, new File(string));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(msgcat.getMessage("illegal_argument_detected", "Illegal Argument detected") + ": " + illegalArgumentException.getMessage());
                    SMPatchServices.usageAdd(msgcat);
                    System.exit(1);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(msgcat.getMessage("patchlist_file_not_found", "Specified patch list file was not found."));
                    System.exit(2);
                }
                catch (IOException iOException) {
                    System.err.println(msgcat.getMessage("err_processing_patch_file", "Error detected while processing patch list file") + ": " + iOException.getMessage());
                    System.exit(2);
                }
                catch (MalformedPatchException malformedPatchException) {
                    System.exit(2);
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            }
            catch (Exception exception) {
                System.exit(2);
            }
        } else if (string5.equals("download")) {
            try {
                getOpt = new GetOpt(stringArray2, "d:hi:x:");
                try {
                    int n5;
                    block69: while ((n5 = getOpt.getNextOption()) != -1) {
                        ++n2;
                        switch ((char)n5) {
                            case 'd': {
                                if (bl2) {
                                    bl = true;
                                    continue block69;
                                }
                                bl2 = true;
                                string = getOpt.getOptionArg();
                                ++n2;
                                continue block69;
                            }
                            case 'i': {
                                if (bl3) {
                                    String string9 = getOpt.getOptionArg();
                                    if (vector2.contains(string9)) {
                                        System.out.println(msgcat.getMessage("dup_patchids", "Ignoring duplicate patchID") + " " + string9);
                                    } else {
                                        vector2.addElement(string9);
                                    }
                                    ++n2;
                                    continue block69;
                                }
                                bl3 = true;
                                vector2.addElement(getOpt.getOptionArg());
                                ++n2;
                                continue block69;
                            }
                            case 'x': {
                                if (bl4) {
                                    bl = true;
                                    continue block69;
                                }
                                bl4 = true;
                                string2 = getOpt.getOptionArg();
                                if (string2.length() < 8 || !string2.substring(0, 7).equals("idlist=")) {
                                    throw new IllegalArgumentException(string2);
                                }
                                string3 = string2.substring(7);
                                ++n2;
                                continue block69;
                            }
                            case 'h': {
                                if (bl5) {
                                    bl = true;
                                    continue block69;
                                }
                                bl5 = true;
                                continue block69;
                            }
                        }
                        System.err.println(msgcat.getMessage("uncovered_GetOpt_error", "Invalid option or invalid syntax specification detected."));
                        System.exit(1);
                    }
                    if (bl) {
                        System.err.println(msgcat.getMessage("errDuplicateDetected", "Error: One or more duplicate options were detected."));
                        SMPatchServices.usageDownload(msgcat);
                        System.exit(1);
                    }
                    if (bl5) {
                        SMPatchServices.usageDownload(msgcat);
                        System.exit(0);
                    }
                    if (n2 != stringArray2.length) {
                        System.err.println(msgcat.getMessage("invalid_option_detected", "Unexpected option or option value detected."));
                        SMPatchServices.usageDownload(msgcat);
                        System.exit(1);
                    }
                    if (bl3 && bl4) {
                        System.err.println(msgcat.getMessage("smpatch_mutex_optix", "Options i and x are mutually exclusive"));
                        SMPatchServices.usageDownload(msgcat);
                        System.exit(1);
                    }
                    if (debug && bl3) {
                        for (int i = 0; i < vector2.size(); ++i) {
                            System.out.println("Patch to download via the -i options is " + vector2.elementAt(i));
                        }
                    }
                    vector = bl4 ? sMPatchServices.createPatchList(string3) : sMPatchServices.createPatchList(vector2);
                    if (!bl2) {
                        string = string6;
                    }
                    if (!bl4 && !bl3) {
                        sMPatchServices.downloadAllPatches(new File(string));
                        System.exit(0);
                    }
                    System.out.println(msgcat.getMessage("requested_patches", "Requested patches:"));
                    System.out.println("");
                    for (int i = 0; i < vector.size(); ++i) {
                        System.out.println("    " + vector.elementAt(i));
                    }
                    System.out.println("");
                    sMPatchServices.downloadPatches(vector, new File(string));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(msgcat.getMessage("illegal_argument_detected", "Illegal Argument detected") + ": " + illegalArgumentException.getMessage());
                    SMPatchServices.usageDownload(msgcat);
                    System.exit(1);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(msgcat.getMessage("patchlist_file_not_found", "Specified patch list file was not found."));
                    System.exit(2);
                }
                catch (IOException iOException) {
                    System.err.println(msgcat.getMessage("err_processing_patch_file", "Error detected while processing patch list file") + ": " + iOException.getMessage());
                    System.exit(2);
                }
                catch (MalformedPatchException malformedPatchException) {
                    System.exit(2);
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                    System.exit(2);
                }
            }
            catch (Exception exception) {
                System.exit(1);
            }
        } else if (string5.equals("analyze")) {
            try {
                if (stringArray2.length == 0) {
                    patchList = sMPatchServices.displayPatchList();
                    System.exit(0);
                }
                getOpt = new GetOpt(stringArray2, "d:hi:x:");
                try {
                    int n6;
                    block72: while ((n6 = getOpt.getNextOption()) != -1) {
                        ++n2;
                        switch ((char)n6) {
                            case 'h': {
                                ++n2;
                                if (bl5) {
                                    bl = true;
                                    continue block72;
                                }
                                bl5 = true;
                                continue block72;
                            }
                        }
                        System.err.println(msgcat.getMessage("uncovered_GetOpt_error", "Invalid option or invalid syntax specification detected."));
                        System.exit(1);
                    }
                    if (bl) {
                        System.err.println(msgcat.getMessage("errDuplicateDetected", "Error: One or more duplicate options were detected."));
                        SMPatchServices.usageAnalyze(msgcat);
                        System.exit(1);
                    }
                    if (bl5) {
                        SMPatchServices.usageAnalyze(msgcat);
                        System.exit(0);
                    }
                    if (n2 != stringArray2.length) {
                        System.err.println(msgcat.getMessage("invalid_option_detected", "Unexpected option or option value detected."));
                        SMPatchServices.usageAnalyze(msgcat);
                        System.exit(1);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(msgcat.getMessage("illegal_argument_detected", "Illegal Argument detected") + ": " + illegalArgumentException.getMessage());
                    SMPatchServices.usageAnalyze(msgcat);
                    System.exit(1);
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                    System.exit(2);
                }
            }
            catch (Exception exception) {
                System.exit(2);
            }
        } else if (string5.equals("remove")) {
            try {
                char[] cArray = new char[200];
                if (stringArray2.length == 0) {
                    System.out.println(msgcat.getMessage("missing_patch_id", "At least one patch must be specified for this request."));
                    System.exit(1);
                }
                getOpt = new GetOpt(stringArray2, remove_validArgs);
                try {
                    block146: {
                        int n7;
                        block73: while ((n7 = getOpt.getNextOption()) != -1) {
                            ++n2;
                            switch ((char)n7) {
                                case 'h': {
                                    ++n2;
                                    if (bl5) {
                                        bl = true;
                                        continue block73;
                                    }
                                    bl5 = true;
                                    continue block73;
                                }
                                case 'i': {
                                    if (bl3) {
                                        bl = true;
                                        continue block73;
                                    }
                                    bl3 = true;
                                    string4 = getOpt.getOptionArg();
                                    ++n2;
                                    continue block73;
                                }
                            }
                            System.err.println(msgcat.getMessage("uncovered_GetOpt_error", "Invalid option or invalid syntax specification detected."));
                            System.exit(1);
                        }
                        if (bl) {
                            System.err.println(msgcat.getMessage("errDuplicateDetected", "Error: One or more duplicate options were detected."));
                            SMPatchServices.usageRemove(msgcat);
                            System.exit(1);
                        }
                        if (bl5) {
                            SMPatchServices.usageRemove(msgcat);
                            System.exit(0);
                        }
                        if (n2 != stringArray2.length) {
                            System.err.println(msgcat.getMessage("invalid_option_detected", "Unexpected option or option value detected."));
                            SMPatchServices.usageRemove(msgcat);
                            System.exit(1);
                        }
                        if (!sMPatchServices.isValidPatch(string4)) {
                            System.err.println(string4 + " " + msgcat.getMessage("err_patchid", "is an invalid patch. Please specify patch in XXXXXX-YY format where X and Y are numbers."));
                            System.exit(1);
                        }
                        System.out.println(msgcat.getMessage("machine_name", "On machine") + " " + hostMachine + " ...\n");
                        System.out.println(msgcat.getMessage("remove_patch", "Removing patch") + " " + string4);
                        runtime = Runtime.getRuntime();
                        stringArray3[0] = "/bin/sh";
                        stringArray3[1] = "-c";
                        stringArray3[2] = "/usr/sbin/patchrm " + string4;
                        Process process = runtime.exec(stringArray3);
                        n3 = process.waitFor();
                        InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                        InputStreamReader inputStreamReader2 = new InputStreamReader(process.getErrorStream());
                        try {
                            outData = false;
                            do {
                                try {
                                    int n8;
                                    int n9;
                                    sMPatchServices.clearArray(cArray, 200);
                                    if (inputStreamReader.ready()) {
                                        n9 = 0;
                                        while ((n9 = inputStreamReader.read(cArray, 0, 200)) != -1) {
                                            outData = true;
                                            for (n8 = 0; n8 < n9; ++n8) {
                                                System.out.print(cArray[n8]);
                                            }
                                            sMPatchServices.clearArray(cArray, 200);
                                        }
                                    }
                                    if (!inputStreamReader2.ready()) continue;
                                    n9 = 0;
                                    while ((n9 = inputStreamReader2.read(cArray, 0, 200)) != -1) {
                                        outData = true;
                                        for (n8 = 0; n8 < n9; ++n8) {
                                            System.err.print(cArray[n8]);
                                        }
                                        sMPatchServices.clearArray(cArray, 200);
                                    }
                                }
                                catch (IOException iOException) {
                                    outData = true;
                                    System.out.println("smpatch: IOException " + iOException + " thrown by out/err read.");
                                }
                            } while (!outData);
                            Object var33_68 = null;
                        }
                        catch (Throwable throwable) {
                            Object var33_70 = null;
                            inputStreamReader.close();
                            inputStreamReader2.close();
                            inputStreamReader = null;
                            inputStreamReader2 = null;
                            throw throwable;
                        }
                        inputStreamReader.close();
                        inputStreamReader2.close();
                        inputStreamReader = null;
                        inputStreamReader2 = null;
                        {
                            break block146;
                            catch (Exception exception) {
                                System.err.println("smpatch: Failed to read output in reader thread.");
                                exception.printStackTrace();
                                Object var33_69 = null;
                                inputStreamReader.close();
                                inputStreamReader2.close();
                                inputStreamReader = null;
                                inputStreamReader2 = null;
                            }
                        }
                    }
                    if (n3 > 0) {
                        if (debug) {
                            System.out.println(stringArray3[0] + stringArray3[1] + stringArray3[2] + " completed with cc=" + n3);
                        }
                        System.exit(2);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(msgcat.getMessage("illegal_argument_detected", "Illegal Argument detected") + ": " + illegalArgumentException.getMessage());
                    SMPatchServices.usageRemove(msgcat);
                    System.exit(1);
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                    System.exit(2);
                }
            }
            catch (Exception exception) {
                System.exit(2);
            }
        } else if (string5.equals("update")) {
            try {
                getOpt = new GetOpt(stringArray2, update_validArgs);
                try {
                    int n10;
                    block79: while ((n10 = getOpt.getNextOption()) != -1) {
                        ++n2;
                        switch ((char)n10) {
                            case 'd': {
                                if (bl2) {
                                    bl = true;
                                    continue block79;
                                }
                                bl2 = true;
                                string = getOpt.getOptionArg();
                                ++n2;
                                continue block79;
                            }
                            case 'h': {
                                ++n2;
                                if (bl5) {
                                    bl = true;
                                    continue block79;
                                }
                                bl5 = true;
                                continue block79;
                            }
                        }
                        System.err.println(msgcat.getMessage("uncovered_GetOpt_error", "Invalid option or invalid syntax specification detected."));
                        System.exit(1);
                    }
                    if (bl) {
                        System.err.println(msgcat.getMessage("errDuplicateDetected", "Error: One or more duplicate options were detected."));
                        SMPatchServices.usageUpdate(msgcat);
                        System.exit(1);
                    }
                    if (bl5) {
                        SMPatchServices.usageUpdate(msgcat);
                        System.exit(0);
                    }
                    if (!bl2) {
                        string = string6;
                        sequesterDirectory = string7;
                    } else {
                        sequesterDirectory = string + System.getProperty("file.separator") + "patchproSequester";
                    }
                    if (n2 != stringArray2.length) {
                        System.err.println(msgcat.getMessage("invalid_option_detected", "Unexpected option or option value detected."));
                        SMPatchServices.usageUpdate(msgcat);
                        System.exit(1);
                    }
                    System.out.println(msgcat.getMessage("machine_name", "On machine") + " " + hostMachine + " ...\n");
                    sMPatchServices.installAllPatches(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(msgcat.getMessage("illegal_argument_detected", "Illegal Argument detected") + ": " + illegalArgumentException.getMessage());
                    SMPatchServices.usageUpdate(msgcat);
                    System.exit(1);
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                    System.exit(2);
                }
            }
            catch (Exception exception) {
                System.exit(2);
            }
        } else {
            System.err.println(msgcat.getMessage("unknown_subcommand", "Unknown subcommand was specified."));
            SMPatchServices.usageTool(msgcat);
            System.exit(1);
        }
        System.exit(0);
    }

    private static void usageTool(LocalizedMessages localizedMessages) {
        SMPatchServices.usageAdd(localizedMessages);
        SMPatchServices.usageAnalyze(localizedMessages);
        SMPatchServices.usageDownload(localizedMessages);
        SMPatchServices.usageRemove(localizedMessages);
        SMPatchServices.usageUpdate(localizedMessages);
    }

    private static void usageAdd(LocalizedMessages localizedMessages) {
        System.err.println(localizedMessages.getMessage("usage_header", "Usage:"));
        System.err.println(localizedMessages.getMessage("smpatch_add_usage_1", "\tsmpatch add [-h] -i <patchid> [-i <patchid> ...] |<patchlist_file>  [-d <patchdir>] where:\n"));
        System.err.println(localizedMessages.getMessage("smpatch_add_usage_2", "\tadd\tSubcommand used to install the patches."));
        System.err.println(localizedMessages.getMessage("smpatch_add_usage_3", "\t-d <patchdir>\n\t\tUsed to specify the directory where patches are\n\t\texpected to be installed from.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_add_usage_4", "\t-h\tUsed to display help info for the add subcommand.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_add_usage_5", "\t-i <patchid>\n\t\tUsed to specify the id of the patch to install.\n\t\tOne or more patches can be specified using this\n\t\toption.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_add_usage_6", "\t-x idlist=<patchlist_file>\n\t\tUsed to specify the path of the file that contains\n\t\ta list of patches to install."));
        System.err.println();
    }

    private static void usageAnalyze(LocalizedMessages localizedMessages) {
        System.err.println(localizedMessages.getMessage("usage_header", "Usage:"));
        System.err.println(localizedMessages.getMessage("smpatch_analyze_usage_1", "\tsmpatch analyze [-h] where:"));
        System.err.println(localizedMessages.getMessage("smpatch_analyze_usage_2", "\tanalyze\tSubcommand used to analyze a host and list\n\t\tneeded patches.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_analyze_usage_3", "\t-h\tUsed to display help info for the analyze subcommand.\n"));
        System.err.println();
    }

    private static void usageDownload(LocalizedMessages localizedMessages) {
        System.err.println(localizedMessages.getMessage("usage_header", "Usage:"));
        System.err.println(localizedMessages.getMessage("smpatch_download_usage_1", "\tsmpatch download [-h] -i <patchid> [-i <patchid> ...] |\n\t\t-x idlist=<patchlist_file>  [-d <patchdir>] where:\n"));
        System.err.println(localizedMessages.getMessage("smpatch_download_usage_2", "\tdownload\tSubcommand used to download patches from SunSolve.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_download_usage_3", "\t-d <patchdir>\n\t\tUsed to specify the directory where the patches\n\t\tfrom SunSolve are to be downloaded.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_download_usage_4", "\t-h\tUsed to display help info for the download subcommand.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_download_usage_5", "\t-i <patchid>\n\t\tUsed to specify the id of the patch to download.\n\t\tOne or more patches can be specified using this\n\t\toption.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_download_usage_6", "\t-x idlist=<patchlist_file>\n\t\tUsed to specify the path of the file that contains\n\t\ta list of patches to download."));
        System.err.println();
    }

    private static void usageRemove(LocalizedMessages localizedMessages) {
        System.err.println(localizedMessages.getMessage("usage_header", "Usage:"));
        System.err.println(localizedMessages.getMessage("smpatch_remove_usage_1", "\tsmpatch remove -i patchid [-h] where:\n"));
        System.err.println(localizedMessages.getMessage("smpatch_remove_usage_2", "\tremove\tSubcommand used to remove a patch.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_remove_usage_3", "\t-h\tUsed to display help info for the remove subcommand.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_remove_usage_4", "\t-i <patchid>\n\t\tUsed to specify the id of the patch to remove."));
        System.err.println();
    }

    private static void usageUpdate(LocalizedMessages localizedMessages) {
        System.err.println(localizedMessages.getMessage("usage_header", "Usage:"));
        System.err.println(localizedMessages.getMessage("smpatch_update_usage_1", "\tsmpatch update [-d patchdir] [-h] where:\n"));
        System.err.println(localizedMessages.getMessage("smpatch_update_usage_2", "\tupdate\tSubcommand used to download and install required\n\t\tpatches for the local host.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_update_usage_3", "\t-d <patchdir>\n\t\tUsed to specify the directory  where the patches\n\t\tfrom SunSolve which are required by the local host\n\t\tare to be downloaded and installed from.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_update_usage_4", "\t-h\tUsed to display help info for the update subcommand.\n"));
        System.err.println();
    }

    private void instantiateModel() throws PatchProException {
        this.model = new PatchProAccessor().getPatchPro();
    }

    public boolean areAccessible(PatchList patchList, File file) {
        boolean bl = true;
        File file2 = null;
        String string = null;
        IPatch iPatch = null;
        try {
            for (int i = 0; i < patchList.size(); ++i) {
                iPatch = (IPatch)patchList.getPatchAt(i);
                string = file + System.getProperty("file.separator") + iPatch.getPatchID().getPatchID() + ".jar";
                file2 = new File(string);
                if (!file2.exists()) {
                    System.err.println("(" + (i + 1) + ") " + msgcat.getMessage("err_patch_missing", "Patch not found:") + " " + iPatch.getPatchID().getPatchID());
                    bl = false;
                }
                file2 = null;
                string = null;
                iPatch = null;
            }
        }
        catch (NoSuchPatchException noSuchPatchException) {
            System.err.println("Error: Invalid patch list detected");
            bl = false;
        }
        return bl;
    }

    public void addPatches(Vector vector, File file) {
        try {
            int n;
            int n2;
            Object object;
            System.out.println(msgcat.getMessage("machine_name", "On machine") + " " + hostMachine + " ...\n");
            this.model.addListener(this);
            this.done = false;
            this.model.analyzeHost();
            while (!this.done) {
                Thread.sleep(2000L);
            }
            ReadOnlyHost readOnlyHost = this.model.getHost();
            PatchAccumulator patchAccumulator = this.model.getPatchAccumulator();
            PatchList patchList = new PatchListImpl();
            for (int i = 0; i < vector.size(); ++i) {
                if (debug) {
                    System.out.println("Accumulating patches for " + vector.elementAt(i));
                }
                object = new PatchID((String)vector.elementAt(i));
                patchList = patchAccumulator.getPatchClosure((PatchID)object);
                if (!debug) continue;
                System.out.println("The Total number of patches that were acculmulated so far is " + patchList.size());
                for (int j = 0; j < patchList.size(); ++j) {
                    System.out.println(((IPatch)patchList.getPatchAt(j)).getPatchID().getPatchID());
                }
                System.out.println(" -- ");
            }
            System.out.println("");
            Vector<Object> vector2 = new Vector<Object>();
            object = null;
            String string = null;
            boolean bl = false;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                bl = false;
                object = (String)vector.elementAt(n2);
                for (n = 0; n < patchList.size(); ++n) {
                    string = patchList.getPatchAt(n).getPatchID().getPatchID();
                    if (!((String)object).equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                vector2.addElement(object);
            }
            if (vector2.size() > 0) {
                System.out.println("\n" + msgcat.getMessage("download_excluded", "The following patch(es) are already installed or replaced by another patch:"));
                for (n2 = 0; n2 < vector2.size(); ++n2) {
                    System.out.println("    " + vector2.elementAt(n2));
                }
                System.out.println("");
            }
            if (patchList.size() == 0) {
                System.exit(2);
            }
            Vector<String> vector3 = new Vector<String>();
            for (n = 0; n < patchList.size(); ++n) {
                string = patchList.getPatchAt(n).getPatchID().getPatchID();
                if (vector.contains(string)) continue;
                vector3.addElement(string);
            }
            if (vector3.size() > 0) {
                System.out.println("\n" + msgcat.getMessage("download_added", "The following patches were added due to patch dependencies:"));
                for (n = 0; n < vector3.size(); ++n) {
                    System.out.println("    " + vector3.elementAt(n));
                }
                System.out.println("");
            }
            this.defineValidPatchTypes(patchList);
            if (!this.areAccessible(patchList, file)) {
                System.err.println(msgcat.getMessage("patches_not_found", "One or more patches could not be found."));
                System.exit(2);
            }
            this.properties.setProperty("smpatch.request", "true");
            this.properties.setProperty("patchpro.patch.sequester.directory", sequesterDirectory);
            this.model.installPatches(patchList, file);
            this.done = false;
            while (!this.done) {
                Thread.sleep(2000L);
                if (!debug) continue;
                System.out.print(".");
            }
            this.problemSummary();
        }
        catch (NoSuchPatchException noSuchPatchException) {
            System.err.println(noSuchPatchException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void downloadPatches(Vector vector, File file) {
        try {
            int n;
            int n2;
            Object object;
            System.out.println(msgcat.getMessage("download_patches", "Downloading the requested patches"));
            this.model.addListener(this);
            this.done = false;
            this.model.analyzeHost();
            while (!this.done) {
                Thread.sleep(2000L);
            }
            if (this.failed) {
                System.exit(2);
            }
            ReadOnlyHost readOnlyHost = this.model.getHost();
            PatchAccumulator patchAccumulator = this.model.getPatchAccumulator();
            PatchList patchList = new PatchListImpl();
            for (int i = 0; i < vector.size(); ++i) {
                if (debug) {
                    System.out.println("Accumulating patches for " + vector.elementAt(i));
                }
                object = new PatchID((String)vector.elementAt(i));
                patchList = patchAccumulator.getPatchClosure((PatchID)object);
                if (!debug) continue;
                System.out.println("The Total number of patches that were acculmulated so far is " + patchList.size());
                for (int j = 0; j < patchList.size(); ++j) {
                    System.out.println(((IPatch)patchList.getPatchAt(j)).getPatchID().getPatchID());
                }
                System.out.println(" -- ");
            }
            System.out.println("");
            Vector<Object> vector2 = new Vector<Object>();
            object = null;
            String string = null;
            boolean bl = false;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                bl = false;
                object = (String)vector.elementAt(n2);
                for (n = 0; n < patchList.size(); ++n) {
                    string = patchList.getPatchAt(n).getPatchID().getPatchID();
                    if (!((String)object).equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                vector2.addElement(object);
            }
            if (vector2.size() > 0) {
                System.out.println("\n" + msgcat.getMessage("download_excluded", "The following patch(es) are already installed or replaced by another patch:"));
                for (n2 = 0; n2 < vector2.size(); ++n2) {
                    System.out.println("    " + vector2.elementAt(n2));
                }
            }
            Vector<String> vector3 = new Vector<String>();
            for (n = 0; n < patchList.size(); ++n) {
                string = patchList.getPatchAt(n).getPatchID().getPatchID();
                if (vector.contains(string)) continue;
                vector3.addElement(string);
            }
            if (vector3.size() > 0) {
                System.out.println("\n" + msgcat.getMessage("download_added", "The following patches were added due to patch dependencies:"));
                for (n = 0; n < vector3.size(); ++n) {
                    System.out.println("    " + vector3.elementAt(n));
                }
            }
            if (patchList.size() == 0) {
                System.exit(2);
            }
            for (n = 0; n < patchList.size(); ++n) {
                patchList.setSelectionStatus(n, true);
            }
            this.properties.setProperty("smpatch.request", "true");
            this.model.downloadPatches(patchList, file);
            if (debug) {
                System.out.println(msgcat.getMessage("downloadingPatches", "Downloading patches to") + " " + file.getPath() + "...");
            }
            this.done = false;
            while (!this.done) {
                Thread.sleep(2000L);
                if (!debug) continue;
                System.out.print(".");
            }
            if (this.checkForUnavailablePatches() != patchList.size()) {
                System.out.println("\n" + msgcat.getMessage("download_done", "For downloaded patch(es) see") + " " + file.getPath());
            }
            this.problemSummary();
        }
        catch (NoSuchPatchException noSuchPatchException) {
            System.err.println(noSuchPatchException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public PatchList displayPatchList() {
        PatchList patchList = null;
        try {
            System.out.println(msgcat.getMessage("host_needed_patches", "Assessing required patches for machine") + " " + hostMachine + " . " + msgcat.getMessage("please_wait", "Please wait ...") + "\n");
            this.model.addListener(this);
            this.done = false;
            this.model.assessNeededPatches();
            while (!this.done) {
                Thread.sleep(2000L);
                if (!debug) continue;
                System.out.print(".");
            }
            patchList = this.model.getNeededPatches();
            if (patchList.size() > 0) {
                this.printPatchList(patchList);
            } else {
                System.out.println(msgcat.getMessage("no_required_patches", "No patches needed."));
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException.getMessage());
        }
        catch (NoResultException noResultException) {
            System.err.println(noResultException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return patchList;
    }

    public void printPatchList(PatchList patchList) {
        if (patchList.hasAnyErrors()) {
            System.out.println(msgcat.getMessage("errorsFound", "Errors were found."));
        }
        for (int i = 0; i < patchList.size(); ++i) {
            try {
                Patch patch = patchList.getPatchAt(i);
                System.out.println(patch.getPatchID().getPatchID() + " " + patch.getPatchInfo().getSynopsis());
                boolean bl = patchList.hasErrorAt(i);
                if (!bl) continue;
                System.err.println("    Error: " + patchList.getErrorAt(i));
                continue;
            }
            catch (NoSuchPatchException noSuchPatchException) {
                System.err.println(msgcat.getMessage("patchlist_non_existing_patch", "Error: The patch list contains a non-existing patch."));
            }
        }
    }

    public void downloadAllPatches(File file) {
        try {
            System.out.println(msgcat.getMessage("host_needed_patches", "Assessing required patches for machine") + " " + hostMachine + " . " + msgcat.getMessage("please_wait", "Please wait ...") + "\n");
            String string = this.properties.getProperty("patchpro.patch.download.directory");
            this.model.addListener(this);
            this.done = false;
            this.model.assessNeededPatches();
            while (!this.done) {
                Thread.sleep(2000L);
                if (!debug) continue;
                System.out.print(".");
            }
            System.out.println("");
            PatchList patchList = this.model.getNeededPatches();
            if (patchList.size() <= 0) {
                System.out.println(msgcat.getMessage("no_required_patches", "No patches needed."));
                return;
            }
            this.printPatchList(patchList);
            System.out.println();
            System.out.println(msgcat.getMessage("download_host_patches", "Downloading the required patches for machine") + " " + hostMachine + ". " + msgcat.getMessage("please_wait", "Please wait ..."));
            if (patchList.size() > 0) {
                this.failed = false;
                this.done = false;
                this.properties.setProperty("smpatch.request", "true");
                this.model.downloadPatches(patchList, file);
                if (debug) {
                    System.out.println(msgcat.getMessage("downloadingPatches", "Downloading patches to") + " " + file.getPath() + "...");
                }
                while (!this.done) {
                    Thread.sleep(2000L);
                    if (!debug) continue;
                    System.out.print(".");
                }
                System.out.println("");
                if (this.checkForUnavailablePatches() != patchList.size()) {
                    System.out.println("\n" + msgcat.getMessage("download_done", "For downloaded patch(es) see") + " " + file.getPath());
                }
                this.problemSummary();
            } else {
                System.out.println(msgcat.getMessage("no_required_patches", "No patches needed."));
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException.getMessage());
        }
        catch (NoResultException noResultException) {
            System.err.println(noResultException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void installAllPatches(String string) {
        try {
            this.model.addListener(this);
            this.model.assessNeededPatches();
            System.out.println(msgcat.getMessage("host_needed_patches", "Assessing required patches for machine") + " " + hostMachine + " . " + msgcat.getMessage("please_wait", "Please wait ...") + "\n");
            this.failed = false;
            this.done = false;
            while (!this.done) {
                Thread.sleep(2000L);
                if (!debug) continue;
                System.out.print(".");
            }
            System.out.println("");
            PatchList patchList = this.model.getNeededPatches();
            if (patchList.size() > 0) {
                this.properties.setProperty("smpatch.request", "true");
                this.printPatchList(patchList);
                File file = new File(string);
                System.out.println("\n" + msgcat.getMessage("download_host_patches", "Downloading the required patches for machine") + " " + hostMachine + ". " + msgcat.getMessage("please_wait", "Please wait ..."));
                this.model.downloadPatches(patchList, file);
                if (debug) {
                    System.out.println("\n" + msgcat.getMessage("downloadingPatches", "Downloading patches to") + " " + string + "...");
                }
                this.done = false;
                while (!this.done) {
                    Thread.sleep(2000L);
                    if (!debug) continue;
                    System.out.print(".");
                }
                System.out.println("");
                if (this.checkForUnavailablePatches() > 0) {
                    System.out.println("\n" + msgcat.getMessage("update_retry", "Please try to update your host again after the Sun Microsystems support provider confirms that the patches are now available"));
                    System.exit(2);
                }
                this.defineValidPatchTypes(patchList);
                this.properties.setProperty("patchpro.patch.sequester.directory", sequesterDirectory);
                this.model.installPatches(patchList, file);
                if (debug) {
                    System.out.println(msgcat.getMessage("installingPatches", "Installing patches from") + " " + string + "...");
                }
                this.done = false;
                while (!this.done) {
                    Thread.sleep(2000L);
                    if (!debug) continue;
                    System.out.print(".");
                }
                this.problemSummary();
                System.out.println("");
            } else {
                System.out.println(msgcat.getMessage("no_required_patches", "No patches required."));
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException.getMessage());
        }
        catch (NoResultException noResultException) {
            System.err.println(noResultException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Vector createPatchList(String string) throws FileNotFoundException, IOException, MalformedPatchException {
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        File file = new File(string);
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String string2 = null;
        while (null != (string2 = bufferedReader.readLine())) {
            if (!this.isValidPatch(string2)) {
                System.err.println(string2 + " " + msgcat.getMessage("err_patchid", "is an invalid patch. Please specify patch in XXXXXX-YY format where X and Y are numbers."));
                bl = true;
                continue;
            }
            vector.addElement(string2);
        }
        if (bl) {
            throw new MalformedPatchException("");
        }
        return vector;
    }

    public Vector createPatchList(Vector vector) throws MalformedPatchException {
        boolean bl = false;
        Object var3_3 = null;
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            if (!this.isValidPatch((String)vector.elementAt(i))) {
                System.err.println((String)vector.elementAt(i) + " " + msgcat.getMessage("err_patchid", "is an invalid patch. Please specify patch in XXXXXX-YY format where X and Y are numbers."));
                bl = true;
                continue;
            }
            vector2.addElement(vector.elementAt(i));
        }
        if (bl) {
            throw new MalformedPatchException("");
        }
        return vector2;
    }

    public int checkForUnavailablePatches() {
        Patch patch = null;
        try {
            PatchList patchList = this.model.getUnavailablePatches();
            if (patchList != null) {
                if (debug) {
                    System.out.println("\nThe number of patches that are not available: " + patchList.size());
                }
                if (patchList.size() > 0) {
                    System.out.println("\n" + msgcat.getMessage("downloaded_not", "The following patches were not downloaded. Contact your Sun Microsystems support provider for more information."));
                    for (int i = 0; i < patchList.size(); ++i) {
                        patch = patchList.getPatchAt(i);
                        System.out.println(patch.getPatchID().getPatchID());
                        patch = null;
                    }
                }
            }
            return patchList.size();
        }
        catch (NoResultException noResultException) {
            return 0;
        }
        catch (NoSuchPatchException noSuchPatchException) {
            return 0;
        }
    }

    public void defineValidPatchTypes(PatchList patchList) throws NoSuchPatchException, Exception {
        int n;
        int n2 = -1;
        Vector<IPatch> vector = new Vector<IPatch>();
        Vector<IPatch> vector2 = new Vector<IPatch>();
        IPatch iPatch = null;
        PatchContents patchContents = null;
        Object var7_7 = null;
        SignatureValidationUtil signatureValidationUtil = null;
        Manipulable manipulable = null;
        try {
            signatureValidationUtil = SignatureValidationUtil.getValidationUtility(this.properties, null);
        }
        catch (Exception exception) {
            throw new Exception("Unable to get the validation utility");
        }
        block8: for (n = 0; n < patchList.size(); ++n) {
            iPatch = (IPatch)patchList.getPatchAt(n);
            patchContents = iPatch.getPatchContents();
            manipulable = patchContents.getManipulator(null, (Host)this.model.getHost(), null, null, signatureValidationUtil);
            n2 = manipulable.getStrategy(this.model.isInteractive());
            switch (n2) {
                case 1: {
                    vector.addElement(iPatch);
                    continue block8;
                }
                case 3: {
                    vector2.addElement(iPatch);
                    continue block8;
                }
                case 2: {
                    vector2.addElement(iPatch);
                    continue block8;
                }
                case 4: {
                    vector2.addElement(iPatch);
                    continue block8;
                }
                default: {
                    throw new Exception("Unknown patch strategy detected: " + n2);
                }
            }
        }
        if (vector2.size() > 0) {
            System.out.println(msgcat.getMessage("not_installable", "At least one patch cannot be installed due to patch attributes.") + "\n");
            for (n = 0; n < vector2.size(); ++n) {
                iPatch = (IPatch)vector2.elementAt(n);
                String string = "";
                StringTokenizer stringTokenizer = new StringTokenizer(this.getPatchProperties(iPatch));
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.equals("noncontract") || string2.equals("clientusr") || string2.equals("clientroot")) continue;
                    string = string + string2 + " ";
                }
                string = string.trim();
                System.out.println("    " + iPatch.getPatchID().getPatchID() + "    " + string);
            }
            System.out.println("");
        }
    }

    private String getPatchProperties(IPatch iPatch) {
        String string = "";
        PatchInfoImpl patchInfoImpl = (PatchInfoImpl)iPatch.getPatchInfo();
        PatchProperties patchProperties = patchInfoImpl.getProperties();
        Vector vector = new Vector();
        vector = patchProperties.getAllTypes();
        for (int i = 0; i < vector.size(); ++i) {
            string = string + vector.elementAt(i) + " ";
        }
        return string;
    }

    public boolean isValidPatch(String string) {
        int n;
        String string2 = "";
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                return false;
            }
        } else {
            return false;
        }
        string3 = stringTokenizer.nextToken();
        if (string2.length() != 6) {
            return false;
        }
        for (n = 0; n < string2.length(); ++n) {
            if (Character.isDigit(string2.charAt(n))) continue;
            return false;
        }
        if (string3.length() != 2) {
            return false;
        }
        for (n = 0; n < string3.length(); ++n) {
            if (Character.isDigit(string3.charAt(n))) continue;
            return false;
        }
        return true;
    }

    public void patchproProgress(PatchProEvent patchProEvent) {
    }

    public void patchproDone(PatchProEvent patchProEvent) {
        this.done = true;
    }

    public void patchproFailed(PatchProEvent patchProEvent) {
        Object object = patchProEvent.getSource();
        Throwable throwable = null;
        if (object instanceof PatchProModel) {
            throwable = ((PatchProModel)object).getPatchProFailure();
            System.err.println(msgcat.getMessage("patchProFailed", "Error: PatchPro failed:\n") + throwable.getMessage());
        } else {
            System.err.println(msgcat.getMessage("err_event_not_model", "Error: Event source not PatchProModel"));
        }
        this.failed = true;
    }

    private void clearArray(char[] cArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            cArray[n2++] = '\u0000';
        }
    }

    private void problemSummary() {
        if (this.model.getPatchProExceptions() != null) {
            exceptionRepository.addAll(this.model.getPatchProExceptions());
            if (exceptionRepository.size() > 0) {
                System.err.println(msgcat.getMessage("diagnostic_info", "Problem Summary:"));
                String string = "";
                for (int i = 0; i < exceptionRepository.size(); ++i) {
                    string = string + "\n(" + (i + 1) + ") " + ((PatchProException)exceptionRepository.elementAt(i)).getLocalizedMessage() + "\n" + ((PatchProException)exceptionRepository.elementAt(i)).getLocalizedRemedy();
                    System.err.println(string);
                }
                System.exit(2);
            }
        }
    }

    static {
        exceptionRepository = new Vector();
        hostMachine = null;
        sequesterDirectory = null;
        debug = false;
    }
}

