/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.cli;

import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.model.NoUndoElementsException;
import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProAccessor;
import com.sun.patchpro.model.PatchProEvent;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProListener;
import com.sun.patchpro.model.PatchProModel;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.UndoNotPermittedException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.util.GetOpt;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.NoResultException;
import com.sun.patchpro.util.Spinner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public final class PatchServices
implements PatchProListener {
    private static final String validArgs = "o:c:z:hR:s:p:t:r:FPlnuUd;i;";
    private LocalizedMessages msgcat;
    private PatchPro model;
    private ReadOnlyHost primaryHost;
    private PatchProProperties properties = PatchProProperties.getInstance();
    boolean done = false;
    boolean failed = false;
    boolean hostIsAnalyzed = false;
    String hostsToInstall = null;
    String gerrorMessage = "";
    private static final String LIST_UNDO_FILE = "undo_patches.xml";
    private static final String LIST_RESULT_FILE = "required_patches.xml";
    private static final String DOWNLOAD_RESULT_FILE = "results.xml";
    private static final String INSTALL_RESULT_FILE = "results.xml";
    private static boolean option_p_Specified = false;
    private static boolean option_o_Specified = false;
    private static boolean option_U_Specified = false;
    private static boolean option_u_Specified = false;
    private static String targetHostStr = null;
    private static String patchIDStr = null;
    public static final String SIGNING_CERT_REVOKED = "The signing certificate has been revoked. All patch download activities have been disabled. ";
    public static final String INSTANTIATION_PROBLEM = "Problem detected during PatchPro initialization process. Please check the log file. Exiting";

    public PatchServices() {
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = "";
        PatchProProperties patchProProperties = PatchProProperties.getInstance();
        GetOpt getOpt = new GetOpt(stringArray, validArgs);
        LocalizedMessages localizedMessages = new LocalizedMessages(patchProProperties.getLocale());
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        PatchServices patchServices = new PatchServices();
        Spinner spinner = Spinner.getInstance();
        System.out.println(localizedMessages.getLTime());
        System.out.println(localizedMessages.getMessage("dummyMessage", "\nStarting Revision Maintenance..."));
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        boolean bl16 = true;
        boolean bl17 = true;
        try {
            int n;
            block26: while ((n = getOpt.getNextOption()) != -1) {
                switch ((char)n) {
                    case 'd': {
                        if (bl4) {
                            bl2 = true;
                            continue block26;
                        }
                        bl4 = true;
                        continue block26;
                    }
                    case 'c': {
                        if (bl3) {
                            bl2 = true;
                            continue block26;
                        }
                        string3 = getOpt.getOptionArg();
                        bl3 = true;
                        continue block26;
                    }
                    case 'n': {
                        if (bl10) {
                            bl2 = true;
                            continue block26;
                        }
                        bl10 = true;
                        continue block26;
                    }
                    case 'h': {
                        if (bl7) {
                            bl2 = true;
                            continue block26;
                        }
                        bl7 = true;
                        continue block26;
                    }
                    case 'i': {
                        if (bl8) {
                            bl2 = true;
                            continue block26;
                        }
                        bl8 = true;
                        continue block26;
                    }
                    case 'U': {
                        if (option_U_Specified) {
                            bl2 = true;
                            continue block26;
                        }
                        option_U_Specified = true;
                        continue block26;
                    }
                    case 'l': {
                        if (bl9) {
                            bl2 = true;
                            continue block26;
                        }
                        bl9 = true;
                        continue block26;
                    }
                    case 'o': {
                        if (option_o_Specified) {
                            bl2 = true;
                            continue block26;
                        }
                        targetHostStr = getOpt.getOptionArg();
                        option_o_Specified = true;
                        continue block26;
                    }
                    case 'p': {
                        if (option_p_Specified) {
                            bl2 = true;
                            continue block26;
                        }
                        patchIDStr = getOpt.getOptionArg();
                        option_p_Specified = true;
                        continue block26;
                    }
                    case 'r': {
                        if (bl11) {
                            bl2 = true;
                            continue block26;
                        }
                        string = getOpt.getOptionArg();
                        bl11 = true;
                        continue block26;
                    }
                    case 's': {
                        if (bl12) {
                            bl2 = true;
                            continue block26;
                        }
                        string5 = getOpt.getOptionArg();
                        bl12 = true;
                        continue block26;
                    }
                    case 'F': {
                        if (bl5) {
                            bl2 = true;
                            continue block26;
                        }
                        bl5 = true;
                        continue block26;
                    }
                    case 'P': {
                        if (bl6) {
                            bl2 = true;
                            continue block26;
                        }
                        bl6 = true;
                        continue block26;
                    }
                    case 'u': {
                        if (option_u_Specified) {
                            bl2 = true;
                            continue block26;
                        }
                        option_u_Specified = true;
                        continue block26;
                    }
                    case 'R': {
                        if (bl15) {
                            bl2 = true;
                            continue block26;
                        }
                        string4 = getOpt.getOptionArg();
                        bl15 = true;
                        continue block26;
                    }
                    case 't': {
                        if (bl13) {
                            bl2 = true;
                            continue block26;
                        }
                        string6 = getOpt.getOptionArg();
                        bl13 = true;
                        continue block26;
                    }
                    case 'z': {
                        if (bl14) {
                            bl2 = true;
                            continue block26;
                        }
                        String string7 = getOpt.getOptionArg();
                        bl = string7.equals("true");
                        bl14 = true;
                        continue block26;
                    }
                }
                System.out.println(patchServices.msgcat.getMessage("invalidOption", "Ignoring invalid option."));
            }
            if (bl2) {
                System.err.println(localizedMessages.getMessage("errDuplicateDetected", "Error: One or more duplicate options were detected."));
                System.exit(1);
            }
            if (bl7 || stringArray.length < 1) {
                PatchServices.usage(localizedMessages);
                System.exit(0);
            }
            if (bl9 && (bl4 || bl8) || bl4 && (bl9 || bl8) || bl8 && (bl9 || bl4)) {
                System.err.println(localizedMessages.getMessage("pprosvcmutex", "Options l, d and i are mutually exclusive"));
                PatchServices.usage(localizedMessages);
                System.exit(1);
            }
            if ((option_U_Specified || option_u_Specified) && (bl9 || bl8 || bl4 || bl7 || option_p_Specified)) {
                System.err.println(localizedMessages.getMessage("pprosvcUmutex", "Option U may not appear with l, i, d or p"));
                PatchServices.usage(localizedMessages);
                System.exit(1);
            }
            if (bl15) {
                bl16 = patchServices.setRealizationsProvided(string4);
            }
            if (bl6) {
                patchServices.setProperty("patchpro.override.level", "permissive");
            }
            if (bl5) {
                patchServices.setProperty("patchpro.override.level", "force");
            }
            if (!bl16) {
                System.exit(1);
            } else {
                try {
                    patchServices.instantiateModel();
                }
                catch (PatchProException patchProException) {
                    System.err.println(patchProException.getLocalizedMessage());
                    System.exit(1);
                }
                if (string3 != null) {
                    patchServices.changeConfigFile(string3);
                }
                if (option_o_Specified) {
                    bl17 = patchServices.setInstallHost(targetHostStr);
                    if (!bl17) {
                        System.exit(1);
                    }
                    if (option_p_Specified) {
                        if (bl4 || bl8) {
                            patchProProperties.setProperty(targetHostStr, "patchpro.patches.provided", patchIDStr);
                        } else {
                            PatchServices.usage(localizedMessages);
                            System.exit(1);
                        }
                    }
                    patchProProperties.setProperty("patchpro.target.hosts", targetHostStr);
                } else if (option_p_Specified) {
                    if (bl4 || bl8) {
                        patchProProperties.setProperty("patchpro.patches.provided", patchIDStr);
                        bl17 = patchServices.setInstallHost(null);
                    } else {
                        PatchServices.usage(localizedMessages);
                        System.exit(1);
                    }
                }
                if (bl10) {
                    if (!bl8) {
                        PatchServices.usage(localizedMessages);
                        System.exit(1);
                    } else {
                        patchServices.setNoninteractive();
                    }
                }
                spinner.start();
                if (option_u_Specified) {
                    if (string == null) {
                        string = LIST_UNDO_FILE;
                    }
                    patchServices.showUndoLastSession();
                }
                if (option_U_Specified) {
                    if (string == null) {
                        string = LIST_UNDO_FILE;
                    }
                    patchServices.undoLastSession();
                }
                if (bl9) {
                    if (string == null) {
                        string = LIST_RESULT_FILE;
                    }
                    PatchList patchList = patchServices.displayPatchList();
                }
                if (bl4) {
                    if (string == null) {
                        string = "results.xml";
                    }
                    patchServices.downloadAllPatches();
                }
                if (bl8) {
                    if (string == null) {
                        string = "results.xml";
                    }
                    patchServices.installPatches();
                }
                if (bl12) {
                    int n2 = 1;
                    if (bl9 || bl4 || bl8 || option_u_Specified || option_U_Specified) {
                        try {
                            patchServices.initializeHost();
                            if (bl9) {
                                n2 = 1;
                            } else if (bl4) {
                                n2 = 3;
                            } else if (bl8) {
                                n2 = 16;
                            } else if (option_u_Specified) {
                                n2 = 1;
                            } else if (option_U_Specified) {
                                n2 = 9;
                            }
                            string2 = patchServices.getErrorMessage();
                            patchServices.setSessionID(string5, string, n2, string2);
                        }
                        catch (NoResultException noResultException) {
                            System.err.println(noResultException.getLocalizedMessage());
                        }
                    }
                }
            }
            System.out.println(localizedMessages.getMessage("dummyMessage", "\nRevision Maintenance Completed..."));
            System.out.println(localizedMessages.getLTime());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException.getMessage());
            PatchServices.usage(localizedMessages);
            if (bl) {
                System.out.println("System.exit(1)");
                return;
            }
            System.exit(1);
        }
        catch (IOException iOException) {
            if (bl) {
                System.out.println("System.exit(1)");
                return;
            }
            System.exit(1);
        }
        spinner.stop();
        if (bl) {
            System.out.println("System.exit(0)");
            return;
        }
        System.exit(0);
    }

    private static void usage(LocalizedMessages localizedMessages) {
        System.err.println(localizedMessages.getMessage("pprosvcUsage", "usage:\tpprosvc [-d [-p patch-id[,patch-id,...]]] [-h]\n\t[-i [-n] [-p patch-id[,patch-id,...]]] [-l]\n\n\tWhere:\n"));
        System.err.println("\t-d\t" + localizedMessages.getMessage("usageDownloadAll", "Downloads the patches that are required by this hos\n\t\tsystem"));
        System.err.println("\t-h\t" + localizedMessages.getMessage("usageHelp", "Displays command usage statement"));
        System.err.println("\t-i\t" + localizedMessages.getMessage("usageInstallAll", "Installs the patches from the designated download\n\t\tdirectory"));
        System.err.println("\t-l\t" + localizedMessages.getMessage("usageListPatches", "Analyzes the host system to generate a list of required\n\t\tpatches"));
        System.err.println("\t-U\t" + localizedMessages.getMessage("usageUndoPatches", "Backs out the patches installed in the last install session."));
        System.err.println("\t-n\t" + localizedMessages.getMessage("usageNonInteractive", "Runs Patch Manager in non-interactive mode"));
        System.err.println("\t-p\t" + localizedMessages.getMessage("usagePatchID", "Specifies the particular patches on which to operate"));
    }

    private void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    private String getErrorMessage() {
        return this.gerrorMessage;
    }

    private void instantiateModel() throws PatchProException {
        this.model = PatchProAccessor.getPatchProStatic();
    }

    private void initializeHost() throws NoResultException {
        this.primaryHost = this.model.getHost();
    }

    public PatchList displayPatchList() {
        PatchList patchList = null;
        try {
            this.model.addListener(this);
            this.done = false;
            this.model.assessNeededPatches();
            System.out.println(this.msgcat.getMessage("assessNeededPatches", "Assessing patches needed for your system..."));
            while (!this.done) {
                Thread.sleep(2000L);
                System.out.print(".");
            }
            System.out.println("");
            patchList = this.model.getNeededPatches();
            System.out.println(this.msgcat.getMessage("getNeededPatches", "Retrieved patch list..."));
            if (patchList.size() > 0) {
                this.printPatchList(patchList);
            } else {
                System.out.println(this.msgcat.getMessage("noPatches", "No patches required."));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (NoResultException noResultException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return patchList;
    }

    public void printPatchList(PatchList patchList) {
        if (option_U_Specified || option_u_Specified) {
            System.out.println(this.msgcat.getMessage("backoutPatches", "Patches to backout."));
        } else {
            System.out.println(this.msgcat.getMessage("reqPatches", "Required patches."));
        }
        if (patchList.hasAnyErrors()) {
            System.out.println(this.msgcat.getMessage("errorsFound", "Errors were found."));
        }
        for (int i = 0; i < patchList.size(); ++i) {
            try {
                Patch patch = patchList.getPatchAt(i);
                System.out.println(patch.getPatchID().getPatchID() + " " + patch.getPatchInfo().getSynopsis());
                boolean bl = patchList.hasErrorAt(i);
                if (!bl) continue;
                System.err.println("    Error: " + patchList.getErrorAt(i));
                continue;
            }
            catch (NoSuchPatchException noSuchPatchException) {
                System.err.println("Error: The patch list contains a non-existing patch.");
            }
        }
    }

    public void printPatchList(ReadOnlyHost readOnlyHost) {
        boolean bl = true;
        int n = 0;
        ReadOnlyHost readOnlyHost2 = readOnlyHost;
        Enumeration enumeration = readOnlyHost2.getAssociates();
        do {
            SessionData sessionData;
            if (!bl) {
                readOnlyHost2 = (ReadOnlyHost)enumeration.nextElement();
            }
            if (!(sessionData = readOnlyHost2.getSessionData()).getIgnoreStatus()) {
                String string = readOnlyHost2.getHostName();
                if (string != null) {
                    System.out.println(this.msgcat.getMessage("displayHostTitle", "\n\nFor system") + "  " + string + " (" + readOnlyHost2.getAddress() + ")\n\n");
                } else {
                    System.out.println(this.msgcat.getMessage("displayHostTitle", "\n\nFor system") + "  " + " (" + readOnlyHost2.getAddress() + ")\n\n");
                }
                try {
                    ++n;
                    PatchList patchList = sessionData.getPatchesRequired();
                    this.printPatchList(patchList);
                    ++n;
                }
                catch (NoResultException noResultException) {
                    System.out.println(this.msgcat.getMessage("email.description_none", "None."));
                }
            }
            bl = false;
        } while (enumeration.hasMoreElements());
        if (n == 0) {
            if (option_U_Specified) {
                System.out.println(this.msgcat.getMessage("noPatchesToBackout", "No patches to backout."));
            } else {
                System.out.println(this.msgcat.getMessage("noPatches", "No patches required."));
            }
        }
    }

    public void showUndoLastSession() {
        try {
            this.model.addListener(this);
            this.failed = false;
            this.done = false;
            System.out.println("");
            this.model.getUndoSessionInfo();
            while (!this.done) {
                Thread.sleep(2000L);
                System.out.print(".");
            }
            ReadOnlyHost readOnlyHost = this.model.getAbbreviatedHost();
            this.printPatchList(readOnlyHost);
            System.out.println("");
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void undoLastSession() {
        try {
            this.model.addListener(this);
            this.failed = false;
            this.done = false;
            System.out.println("");
            this.model.getUndoSessionInfo();
            while (!this.done) {
                Thread.sleep(2000L);
                System.out.print(".");
            }
            ReadOnlyHost readOnlyHost = this.model.getAbbreviatedHost();
            this.printPatchList(readOnlyHost);
            try {
                this.model.mayUndo();
                this.model.undoLastSession();
                this.failed = false;
                this.done = false;
                System.out.println(this.msgcat.getMessage("PatchServices.UNDOINGLASTSESSION", "Undoing last session..."));
                while (!this.done) {
                    Thread.sleep(2000L);
                    System.out.print(".");
                }
                System.out.println("");
            }
            catch (UndoNotPermittedException undoNotPermittedException) {
                System.out.println(this.msgcat.getMessage("PatchServices.UNDONOTPERMITTED", "Since some of the patches cannot be backed out safely, undo of the\nsession is not permitted."));
            }
            catch (NoUndoElementsException noUndoElementsException) {
                System.out.println(this.msgcat.getMessage("PatchServices.NOUNDOPATCHES", "No patch session to undo."));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void downloadAllPatches() {
        try {
            String string = this.properties.getProperty("patchpro.patch.download.directory");
            this.model.addListener(this);
            this.done = false;
            this.model.assessNeededPatches();
            System.out.println(this.msgcat.getMessage("assessNeededPatches", "Assessing patches needed for your system..."));
            while (!this.done) {
                Thread.sleep(2000L);
                System.out.print(".");
            }
            System.out.println("");
            PatchList patchList = this.model.getNeededPatches();
            System.out.println(this.msgcat.getMessage("getNeededPatches", "Retrieved patch list..."));
            if (patchList.size() > 0) {
                this.failed = false;
                this.done = false;
                this.model.downloadPatches();
                System.out.println(this.msgcat.getMessage("downloadingPatches", "Downloading patches to") + " " + string + "...");
                while (!this.done) {
                    Thread.sleep(2000L);
                    System.out.print(".");
                }
                System.out.println("");
            } else {
                System.out.println(this.msgcat.getMessage("noPatches", "No patches required."));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (NoResultException noResultException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean setInstallHost(String string) {
        boolean bl = true;
        try {
            ReadOnlyHost readOnlyHost;
            System.out.println(this.msgcat.getMessage("dummyMessage", "\nAnalyzing Install Host..."));
            this.model.addListener(this);
            this.done = false;
            if (!this.hostIsAnalyzed) {
                this.model.analyzeHost();
                while (!this.done) {
                    Thread.sleep(2000L);
                    System.out.print(".");
                }
                this.hostIsAnalyzed = true;
                System.out.println("");
            }
            this.primaryHost = this.model.getHost();
            if (string == null) {
                string = targetHostStr = this.primaryHost.getAddress();
            }
            Enumeration enumeration = this.primaryHost.getAssociates();
            int n = this.primaryHost.getAssociateCount() + 1;
            Vector<ReadOnlyHost> vector = new Vector<ReadOnlyHost>(n);
            vector.add(this.primaryHost);
            while (enumeration.hasMoreElements()) {
                readOnlyHost = (ReadOnlyHost)enumeration.nextElement();
                vector.add(readOnlyHost);
            }
            boolean bl2 = this.validateIP(string);
            if (!bl2) {
                vector.clear();
                bl = false;
            } else {
                if (this.primaryHost.isAddress(string)) {
                    vector.remove(this.primaryHost);
                }
                enumeration = this.primaryHost.getAssociates();
                while (enumeration.hasMoreElements()) {
                    readOnlyHost = (ReadOnlyHost)enumeration.nextElement();
                    if (!readOnlyHost.isAddress(string)) continue;
                    vector.remove(readOnlyHost);
                }
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    ReadOnlyHost readOnlyHost2 = (ReadOnlyHost)enumeration2.nextElement();
                    readOnlyHost2.getSessionData().setIgnoreStatus(true);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException.getMessage());
        }
        catch (NoResultException noResultException) {
            System.err.println(noResultException.getMessage());
        }
        return bl;
    }

    private boolean validateIP(String string) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        n2 = stringTokenizer.countTokens();
        if (n2 == 4) {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                Integer n3 = new Integer(string2);
                int n4 = 0;
                int n5 = 255;
                if (n3.compareTo(new Integer(n4)) >= 0 && n3.compareTo(new Integer(n5)) <= 255) {
                    ++n;
                    continue;
                }
                System.out.println(this.msgcat.getMessage("invalidIPAddress", "An invalid IP address is specified."));
                break;
            }
            if (n == 4) {
                bl = true;
            }
        } else {
            System.out.println(this.msgcat.getMessage("invalidIPAddress", "An invalid IP address is specified."));
        }
        return bl;
    }

    public void setSessionID(String string, String string2, int n, String string3) {
        String string4;
        File file;
        File file2;
        String string5 = "patchpro.sessionid.directory.prefix";
        this.properties.setProperty(string5, "/var/tmp/pprosvc_");
        if (string2 == null || string2.length() == 0) {
            string2 = "results.xml";
        }
        if ((file2 = (file = new File(string4 = "/var/tmp/pprosvc_" + string + "/" + string2)).getParentFile()) != null && !file2.exists()) {
            file2.mkdirs();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string4);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            this.primaryHost.printXMLPatchListSet(n, 0, printWriter, string3);
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    private boolean patchesAreRequired(ReadOnlyHost readOnlyHost) {
        boolean bl = false;
        SessionData sessionData = readOnlyHost.getSessionData();
        if (!sessionData.getIgnoreStatus()) {
            try {
                sessionData.getPatchesRequired();
                bl = true;
            }
            catch (NoResultException noResultException) {
                bl = false;
            }
        }
        Enumeration enumeration = readOnlyHost.getAssociates();
        while (!bl && enumeration.hasMoreElements()) {
            Host host = (Host)enumeration.nextElement();
            sessionData = host.getSessionData();
            if (sessionData.getIgnoreStatus()) continue;
            try {
                sessionData.getPatchesRequired();
                bl = true;
            }
            catch (NoResultException noResultException) {
                bl = false;
            }
        }
        return bl;
    }

    public void installPatches() {
        try {
            this.model.addListener(this);
            this.model.assessNeededPatches();
            System.out.println(this.msgcat.getMessage("assessNeededPatches", "Assessing patches needed for your system..."));
            this.failed = false;
            this.done = false;
            try {
                while (!this.done) {
                    Thread.sleep(2000L);
                    System.out.print(".");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.model.removeListener(this);
            System.out.println("");
            System.out.println(this.msgcat.getMessage("getNeededPatches", "Retrieved patch list..."));
            if (this.patchesAreRequired(this.model.getHost())) {
                String string = this.properties.getProperty("patchpro.patch.download.directory");
                this.model.addListener(this);
                this.done = false;
                this.model.downloadPatches();
                System.out.println(this.msgcat.getMessage("downloadingPatches", "Downloading patches to") + " " + string + "...");
                while (!this.done) {
                    Thread.sleep(2000L);
                    System.out.print(".");
                }
                System.out.println("");
                String string2 = this.properties.getProperty("patchpro.patch.install.directory");
                this.model.installPatches();
                System.out.println(this.msgcat.getMessage("installingPatches", "Applying patches from") + " " + string2 + "...");
                this.done = false;
                while (!this.done) {
                    Thread.sleep(2000L);
                    System.out.print(".");
                }
                System.out.println("");
            } else {
                System.out.println(this.msgcat.getMessage("noPatches", "No patches required."));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (NoResultException noResultException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean setRealizationsProvided(String string) {
        String string2 = "patchpro.realization.provided";
        boolean bl = true;
        try {
            if (string == null || string.equals("none")) {
                string = "";
            }
            if (string != "") {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    try {
                        Realization realization = new Realization(string3);
                    }
                    catch (NoSuchRealizationException noSuchRealizationException) {
                        System.out.println(this.msgcat.getMessage("noSuchRealization", "Poorly formed realization."));
                        bl = false;
                        return bl;
                    }
                }
            }
            this.properties.setProperty(string2, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public void patchproProgress(PatchProEvent patchProEvent) {
    }

    public void patchproDone(PatchProEvent patchProEvent) {
        this.done = true;
    }

    public void patchproFailed(PatchProEvent patchProEvent) {
        Object object = patchProEvent.getSource();
        Throwable throwable = null;
        if (object instanceof PatchProModel) {
            throwable = ((PatchProModel)object).getPatchProFailure();
            this.gerrorMessage = throwable.getMessage();
            System.err.println(throwable.getMessage());
        } else {
            System.err.println("Error: Event source not PatchProModel");
        }
        this.failed = true;
    }

    public void setNoninteractive() {
        this.model.setInteractive(false);
    }

    public void changeConfigFile(String string) throws IOException {
        File file = new File(string);
        try {
            if (!file.isAbsolute()) {
                file = new File(this.properties.getConfigDirectory(), string);
            }
            this.properties.load(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(this.msgcat.getMessage("config.file.not.found", "The specified configuration file could not be found."));
            throw new IOException("No Such Config File.");
        }
        catch (IOException iOException) {
            System.out.println(this.msgcat.getMessage("config.file.not.readable", "The specified configuration file cannot be read."));
            throw iOException;
        }
    }
}

