/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.cli;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.NoMoreDetectorsException;
import com.sun.patchpro.cli.RenderInteractionSetImpl;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProAccessor;
import com.sun.patchpro.model.PatchProEvent;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProListener;
import com.sun.patchpro.model.PatchProModel;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.GetOpt;
import com.sun.patchpro.util.InteractionSet;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.ScheduleService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public final class PatchProSetup
implements PatchProListener {
    private static final String validArgs = "o:DW:M:s:Cd:b:q:P:a;A:m:p;Hx;c:z:u;U;hy:i:L";
    private static final String[] validPatchTypes = new String[]{"", "none", "standard", "rebootafter", "reconfigafter", "singleuser"};
    private static final String[] validInteractivePatchTypes = new String[]{"none", "standard", "rebootafter", "reconfigafter", "singleuser", "rebootimmediate", "reconfigimmediate", "interactive"};
    private static final String[] propertyNamesForList = new String[]{"patchpro.log.file", "patchpro.log.size", "patchpro.patch.download.directory", "patchpro.patch.sequester.directory", "patchpro.proxyserver.host", "patchpro.proxyserver.port", "patchpro.patch.server.url", "patchpro.database.source.url", "patchpro.detectors.source.url"};
    private static File defaultConfFile;
    private PatchProProperties properties = PatchProProperties.getInstance();
    private LocalizedMessages msgcat;
    boolean done = false;
    PatchPro patchPro;
    String associateStr = null;
    boolean hasAssociate = false;
    private static boolean displayMsg;

    public PatchProSetup() throws PatchProException {
        PatchProAccessor patchProAccessor = new PatchProAccessor();
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
        this.patchPro = patchProAccessor.getPatchPro();
        String string = this.properties.getProperty("patchpro.default.conf.file", "etc/patchpro.conf");
        defaultConfFile = new File(string);
        if (!defaultConfFile.exists()) {
            System.err.println(this.msgcat.getMessage("noConfigurationFile", "Configuration file was not found -") + " " + string);
            System.exit(1);
        } else if (!defaultConfFile.canWrite()) {
            System.err.println(this.msgcat.getMessage("cantWriteConfigurationFile", "Configuration file is not writable -") + " " + string);
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        PatchProProperties patchProProperties = null;
        GetOpt getOpt = new GetOpt(stringArray, validArgs);
        LocalizedMessages localizedMessages = null;
        PatchProSetup patchProSetup = null;
        Vector<String> vector = new Vector<String>();
        String string = "00:00";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        boolean bl16 = false;
        boolean bl17 = false;
        boolean bl18 = false;
        boolean bl19 = false;
        boolean bl20 = false;
        boolean bl21 = false;
        boolean bl22 = false;
        boolean bl23 = false;
        boolean bl24 = false;
        boolean bl25 = false;
        boolean bl26 = false;
        boolean bl27 = false;
        try {
            int n;
            String string15;
            Object object;
            int n2;
            block31: while ((n2 = getOpt.getNextOption()) != -1) {
                object = new Character((char)n2);
                switch ((char)n2) {
                    case 'D': {
                        if (bl10) {
                            bl2 = true;
                            continue block31;
                        }
                        vector.addElement(((Character)object).toString());
                        bl = true;
                        bl10 = true;
                        continue block31;
                    }
                    case 'W': {
                        if (bl11) {
                            bl2 = true;
                            continue block31;
                        }
                        vector.addElement(((Character)object).toString());
                        vector.addElement(getOpt.getOptionArg());
                        bl = true;
                        bl11 = true;
                        continue block31;
                    }
                    case 'M': {
                        if (bl13) {
                            bl2 = true;
                            continue block31;
                        }
                        vector.addElement(((Character)object).toString());
                        vector.addElement(getOpt.getOptionArg());
                        bl = true;
                        bl13 = true;
                        continue block31;
                    }
                    case 's': {
                        if (bl22) {
                            bl2 = true;
                            continue block31;
                        }
                        if (string.compareTo("none") == 0) continue block31;
                        string = getOpt.getOptionArg();
                        bl = true;
                        bl22 = true;
                        continue block31;
                    }
                    case 'a': {
                        if (bl4) {
                            bl2 = true;
                            continue block31;
                        }
                        string2 = getOpt.getOptionArg();
                        if (string2 == null) {
                            string2 = "";
                        }
                        bl4 = true;
                        continue block31;
                    }
                    case 'C': {
                        if (bl9) {
                            bl2 = true;
                            continue block31;
                        }
                        string = "none";
                        bl = true;
                        bl9 = true;
                        continue block31;
                    }
                    case 'o': {
                        if (bl18) {
                            bl2 = true;
                            continue block31;
                        }
                        string4 = getOpt.getOptionArg();
                        bl18 = true;
                        continue block31;
                    }
                    case 'd': {
                        if (bl8) {
                            bl2 = true;
                            continue block31;
                        }
                        string3 = getOpt.getOptionArg();
                        bl8 = true;
                        continue block31;
                    }
                    case 'b': {
                        if (bl6) {
                            bl2 = true;
                            continue block31;
                        }
                        string5 = getOpt.getOptionArg();
                        bl6 = true;
                        continue block31;
                    }
                    case 'q': {
                        if (bl21) {
                            bl2 = true;
                            continue block31;
                        }
                        string6 = getOpt.getOptionArg();
                        bl21 = true;
                        continue block31;
                    }
                    case 'P': {
                        if (bl20) {
                            bl2 = true;
                            continue block31;
                        }
                        string7 = getOpt.getOptionArg();
                        bl20 = true;
                        continue block31;
                    }
                    case 'm': {
                        if (bl16 || bl12) {
                            bl2 = true;
                            continue block31;
                        }
                        string9 = getOpt.getOptionArg();
                        bl12 = true;
                        continue block31;
                    }
                    case 'A': {
                        if (bl19 || bl5) {
                            bl2 = true;
                            continue block31;
                        }
                        string8 = getOpt.getOptionArg();
                        bl5 = true;
                        continue block31;
                    }
                    case 'p': {
                        if (bl19 || bl5) {
                            bl2 = true;
                            continue block31;
                        }
                        string8 = getOpt.getOptionArg();
                        bl19 = true;
                        continue block31;
                    }
                    case 'i': {
                        if (bl16 || bl12) {
                            bl2 = true;
                            continue block31;
                        }
                        string9 = getOpt.getOptionArg();
                        bl16 = true;
                        continue block31;
                    }
                    case 'L': {
                        if (bl17) {
                            bl2 = true;
                            continue block31;
                        }
                        bl17 = true;
                        continue block31;
                    }
                    case 'H': {
                        if (bl14) {
                            bl2 = true;
                            continue block31;
                        }
                        bl14 = true;
                        continue block31;
                    }
                    case 'c': {
                        if (bl7) {
                            bl2 = true;
                            continue block31;
                        }
                        string10 = getOpt.getOptionArg();
                        bl7 = true;
                        continue block31;
                    }
                    case 'z': {
                        if (bl27) {
                            bl2 = true;
                            continue block31;
                        }
                        String string16 = getOpt.getOptionArg();
                        bl3 = string16.equals("true");
                        bl27 = true;
                        continue block31;
                    }
                    case 'x': {
                        if (bl25) {
                            bl2 = true;
                            continue block31;
                        }
                        string11 = getOpt.getOptionArg();
                        bl25 = true;
                        continue block31;
                    }
                    case 'u': {
                        if (bl23) {
                            bl2 = true;
                            continue block31;
                        }
                        string13 = getOpt.getOptionArg();
                        if (string13 == null) {
                            string13 = "";
                        }
                        bl23 = true;
                        continue block31;
                    }
                    case 'U': {
                        if (bl24) {
                            bl2 = true;
                            continue block31;
                        }
                        string12 = getOpt.getOptionArg();
                        if (string12 == null) {
                            string12 = "";
                        }
                        bl24 = true;
                        continue block31;
                    }
                    case 'y': {
                        if (bl26) {
                            bl2 = true;
                            continue block31;
                        }
                        string14 = getOpt.getOptionArg();
                        bl26 = true;
                        continue block31;
                    }
                    case 'h': {
                        if (bl15) {
                            bl2 = true;
                            continue block31;
                        }
                        bl15 = true;
                        continue block31;
                    }
                }
            }
            if (bl27) {
                PatchProProperties.freeInstance();
                string10 = "etc" + File.separator + "patchpro.conf";
                patchProProperties = PatchProProperties.getInstance(string10);
            } else {
                patchProProperties = PatchProProperties.getInstance();
                if (string10 != null) {
                    patchProProperties.useAlternate(string10);
                }
            }
            try {
                patchProSetup = new PatchProSetup();
                localizedMessages = new LocalizedMessages(patchProProperties.getLocale());
            }
            catch (PatchProException patchProException) {
                System.err.println(patchProException.getLocalizedMessage());
                if (bl3) {
                    System.err.println("System.exit(1)");
                    return;
                }
                System.exit(1);
            }
            if (bl2) {
                System.err.println(localizedMessages.getMessage("errDuplicateDetected", "Error: One or more duplicate options were detected."));
                if (bl3) {
                    System.err.println("System.exit(1)");
                    return;
                }
                System.exit(1);
            }
            if (bl15 || stringArray.length < 2 && bl26) {
                PatchProSetup.usage(localizedMessages);
                System.exit(0);
            }
            if (bl17 && (bl4 || bl6 || bl7 || bl8 || bl9 || bl10 || bl11 || bl13 || bl14 || bl15 || bl16 || bl12 || bl18 || bl19 || bl20 || bl21 || bl22 || bl23 || bl25 || bl5)) {
                System.err.println(localizedMessages.getMessage("pprosetupmutexanyotheroption", "Option L is mutually exclusive with any other option"));
                PatchProSetup.usage(localizedMessages);
                System.exit(1);
            }
            if (bl10 && (bl11 || bl13) || bl11 && (bl10 || bl13) || bl13 && (bl10 || bl11)) {
                System.err.println(localizedMessages.getMessage("pprosetupmutexDWM", "Options D, W and M are mutually exclusive"));
                PatchProSetup.usage(localizedMessages);
                System.exit(1);
            }
            patchProProperties.lock(string14);
            if (bl17) {
                patchProSetup.listProperties();
                System.exit(0);
            }
            if (bl18) {
                patchProSetup.associateStr = string4;
                patchProSetup.hasAssociate = true;
            }
            if (bl14) {
                patchProSetup.changeHardware();
            }
            if (bl19 || bl5) {
                patchProSetup.changePatchType(string8);
            }
            if (bl16 || bl12) {
                patchProSetup.changeInteractivePatchType(string9);
            }
            if (bl25) {
                patchProSetup.changeProxyServer(string11);
            }
            if (bl) {
                object = new String[vector.size()];
                for (int i = 0; i < ((String[])object).length; ++i) {
                    object[i] = (String)vector.elementAt(i);
                }
                patchProSetup.changeSchedule(string, (String[])object, string10);
            }
            if (string2 != null) {
                patchProSetup.changeAdminEmail(string2);
            }
            if (string3 != null) {
                patchProSetup.changeDirectoryLocation(string3);
            }
            if (string5 != null) {
                patchProSetup.changeBackoutLocation(string5);
            }
            if (string6 != null) {
                patchProSetup.changeSequesterLocation(string6);
            }
            if (string7 != null) {
                patchProSetup.changePatchServer(string7);
            }
            if (string13 != null) {
                patchProSetup.changeUserName(string13);
            }
            if (string12 != null) {
                patchProSetup.changeProxyUserName(string12);
            }
            if (displayMsg && (string15 = ((String)(object = System.getProperty("os.version"))).trim()).startsWith("5.") && (n = Integer.valueOf(string15.substring(2)).intValue()) > 8) {
                System.out.println(localizedMessages.getMessage("osVersionMessage", "For your configuration changes to take effect, you must restart the\nSolaris WBEM Services on your system. See the section \"How to Set Up\nYour Patch Management Environment After a Non-Interactive Installation\n or Upgrade\" in the Signed Patches Administration Guide for PatchPro\n2.2 for instructions."));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            if (localizedMessages != null) {
                PatchProSetup.usage(localizedMessages);
            }
            if (bl3) {
                System.err.println("System.exit(1)");
                return;
            }
            System.exit(1);
        }
        catch (Exception exception) {
            if (exception.getMessage().indexOf("in use") != -1) {
                System.err.println(localizedMessages.getMessage("inuse", "Error - PatchPro is in use by another process. Please try again later ..."));
            } else {
                System.err.println("Error: " + exception.getMessage());
            }
            System.exit(1);
        }
        if (bl3) {
            return;
        }
        System.exit(0);
    }

    private static void usage(LocalizedMessages localizedMessages) {
        System.err.println(localizedMessages.getMessage("pprosetupUsage", "usage:\tpprosetup [-a admin-email-addr] [-b backout-dir] [-C]\n\t[-d download-dir]] [[-D | -M day-of-month | -W day-of-week]\n\t[-s hh:mm]] [-h] [-H] [-i [none | patch-property-list]]\n\t[-L] [-p [none | standard]] [-P patch-server-url] \n\t[-q sequester-dir] [-u user-name] [-U proxy-user-name]\n\t[-x host:port]\n\n\tWhere:\n"));
        System.err.println("\t-a\t" + localizedMessages.getMessage("usageAdminEmail", "Specifies the email address to use for event notification"));
        System.err.println("\t-b\t" + localizedMessages.getMessage("usageBackoutDirectory", "Specifies the directory in which patch backout data is\n\t\tstored"));
        System.err.println("\t-C\t" + localizedMessages.getMessage("usageClearPatchService", "Clears the existing patch service schedule"));
        System.err.println("\t-d\t" + localizedMessages.getMessage("usageDownloadDirectory", "Specifies the directory in which patches are downloaded"));
        System.err.println("\t-D\t" + localizedMessages.getMessage("usageDailyPatchService", "Schedules the patch service to run on a daily basis"));
        System.err.println("\t-h\t" + localizedMessages.getMessage("usageHelp", "Displays command usage statement"));
        System.err.println("\t-H\t" + localizedMessages.getMessage("usageHardware", "Establishes an interactive dialog to determine the\n\t\thardware attached to the host system"));
        System.err.println("\t-i\t" + localizedMessages.getMessage("usageInteractivePatchType", "Defines the patch installation policy for the type of\n\t\tpatches that are permitted to be installed in interactive\n\t\tmode. patch-property-list is a colon-separated list that\n\t\tcan include the following:\n\t\t\tinteractive\n\t\t\trebootafter\n\t\t\trebootimmediate\n\t\t\treconfigafter\n\t\t\treconfigimmediate\n\t\t\tsingleuser\n\t\t\tstandard"));
        System.err.println("\t-L\t" + localizedMessages.getMessage("usageListProperties", "Displays the configuration properties that can be updated\n\t\tby users"));
        System.err.println("\t-M\t" + localizedMessages.getMessage("usageMonthlyPatchService", "Schedules the patch service to run on a monthly basison\n\t\tday-of-month"));
        System.err.println("\t-p\t" + localizedMessages.getMessage("usagePatchType", "Specifies the patch types that can be scheduled for automatic\n\t\tinstallation: standard automatically installs only standard\n\t\tpatches and none automatically installs no patches"));
        System.err.println("\t-P\t" + localizedMessages.getMessage("usagePatchServer", "Specifies the URL of the server that provides the patches"));
        System.err.println("\t-q\t" + localizedMessages.getMessage("usageSequesterDirectory", "Specifies the directory in which uninstallable patches are\n\t\tstored"));
        System.err.println("\t-s\t" + localizedMessages.getMessage("usageSchedulePatchService", "Schedules the patch service to run at the specified time,\n\t\twhich is midnight, by default"));
        System.err.println("\t-u\t" + localizedMessages.getMessage("usageUserName", "Specifies the name of the Sunsolve user who can access\n\t\tcontract patches."));
        System.err.println("\t-U\t" + localizedMessages.getMessage("usageProxyUserName", "Specifies the user name required for authentication ofthe web proxy, if applicable"));
        System.err.println("\t-W\t" + localizedMessages.getMessage("usageWeeklyPatchService", "Schedules the patch service to run on a weekly basison\n\t\tday-of-week"));
        System.err.println("\t-x\t" + localizedMessages.getMessage("usageProxyServer", "Specifies the local web proxy server to use where host is\n\t\tthe host name and port is the port number"));
    }

    public void changeSchedule(String string, String[] stringArray, String string2) throws IllegalArgumentException {
        block14: {
            String string3 = this.properties.getProperty("patchpro.installdir.ppro");
            String string4 = string3 == null || string3.equals("") ? "" : string3 + File.separator + "bin" + File.separator;
            String string5 = this.properties.getProperty("patchpro.patch.install.patchtype");
            String string6 = string2 != null ? "pprosvc -c " + string2 + " -n -i" : "pprosvc -n -i";
            String string7 = string4 + string6;
            int n = stringArray.length;
            String string8 = new String("com.sun.patchpro.util." + Host.getOSName() + "ScheduleService");
            try {
                Class<?> clazz = Class.forName(string8);
                ScheduleService scheduleService = (ScheduleService)clazz.newInstance();
                if (n != 0) {
                    if (string.compareTo("none") == 0) {
                        throw new IllegalArgumentException("\"-C\" is incompatible with other schedule arguments.");
                    }
                    char c = stringArray[0].charAt(0);
                    switch (c) {
                        case 'D': {
                            scheduleService.daily(string7, string);
                            break block14;
                        }
                        case 'W': {
                            scheduleService.weekly(string7, string, stringArray[1]);
                            break block14;
                        }
                        case 'M': {
                            scheduleService.monthly(string7, string, stringArray[1]);
                            break block14;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
                if (string.compareTo("none") != 0) {
                    scheduleService.begin(string7, string);
                } else {
                    scheduleService.clear(string6);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("ClassNotFoundException " + classNotFoundException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                System.err.println("InstantiationException " + instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("IllegalAccessException " + illegalAccessException.getMessage());
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    public void changeDirectoryLocation(String string) {
        String string2 = "patchpro.patch.download.directory";
        try {
            File file = new File(string);
            String string3 = this.properties.getProperty(string2);
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                    string2 = "patchpro.patch.install.directory";
                    this.setAppropriateProperty(string2, string);
                    this.properties.update(string2, string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalDownloadDirectory", "Specified download directory is identical to the one in effect - No action necessary."));
                displayMsg = false;
            }
        }
        catch (Exception exception) {
            System.err.println(this.msgcat.getMessage("errChangeDownloadDirectory", "Error - failed to change download directory location"));
            displayMsg = false;
        }
    }

    public void changeBackoutLocation(String string) {
        String string2 = "patchpro.patch.backout.directory";
        try {
            File file = new File(string);
            String string3 = this.properties.getProperty(string2);
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalBackoutDirectory", "Specified backout directory is identical to the one in effect - No action necessary."));
                displayMsg = false;
            }
        }
        catch (Exception exception) {
            System.err.println(this.msgcat.getMessage("errChangeBackoutDirectory", "Error - failed to change backout directory location"));
            displayMsg = false;
        }
    }

    public void changeSequesterLocation(String string) {
        String string2 = "patchpro.patch.sequester.directory";
        try {
            File file = new File(string);
            String string3 = this.properties.getProperty(string2);
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalSequesterDirectory", "Specified sequester directory is identical to the one in effect - No action necessary."));
                boolean bl = false;
            }
        }
        catch (Exception exception) {
            System.err.println(this.msgcat.getMessage("errChangeSequesterDirectory", "Error - failed to change sequester directory location"));
            boolean bl = false;
        }
    }

    public void changePatchServer(String string) {
        String string2 = "patchpro.patch.server.url";
        try {
            int n;
            String string3 = this.properties.getProperty(string2);
            if (string3 == null) {
                string3 = "";
            }
            try {
                n = string.indexOf(58);
                if (n == -1) {
                    System.err.println(this.msgcat.getMessage("PatchProSetup.MALFORMED_URL", "Failed to change patch server URL - malformed URL.)"));
                    System.exit(1);
                } else {
                    String string4 = "";
                    string4 = string.substring(0, n);
                    if (string4.compareTo("https") == 0 || string4.compareTo("http") == 0 || string4.compareTo("file") == 0) {
                        int n2 = n + 1;
                        int n3 = n + 3;
                        if (string.substring(n2, n3).compareTo("//") != 0) {
                            System.err.println(this.msgcat.getMessage("PatchProSetup.MALFORMED_URL", "Failed to change patch server URL - malformed URL.)"));
                            System.exit(1);
                        }
                    } else {
                        System.err.println(this.msgcat.getMessage("PatchProSetup.UNSUPPORTED_PROTOCOL", "Failed to change patch server URL - specified protocol not supported.)"));
                        System.exit(1);
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(this.msgcat.getMessage("PatchProSetup.FAILED_CHANGING_PATCH_SERVER", "Failed to change patch server URL.)"));
                System.exit(1);
            }
            n = string.length();
            if (string.substring(n - 1, n).compareTo("/") != 0) {
                string = string + "/";
            }
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalPatchServer", "Specified patch server is identical to the one in effect - No action necessary."));
                displayMsg = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void changeAdminEmail(String string) {
        String string2 = "patchpro.error.email";
        try {
            String string3 = this.properties.getProperty(string2);
            if (string3 != null) {
                if (string3.compareTo(string) != 0) {
                    try {
                        this.setAppropriateProperty(string2, string);
                        this.properties.update(string2, string);
                        string2 = "patchpro.download.email";
                        this.setAppropriateProperty(string2, string);
                        this.properties.update(string2, string);
                        string2 = "patchpro.install.email";
                        this.setAppropriateProperty(string2, string);
                        this.properties.update(string2, string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.err.println(fileNotFoundException.getMessage());
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException.getMessage());
                    }
                    catch (Exception exception) {
                        System.err.println(exception.getMessage());
                    }
                } else {
                    System.out.println(this.msgcat.getMessage("isIdenticalAdminEmail", "Specified admin email address is identical to the one in effect - No action necessary."));
                    displayMsg = false;
                }
            } else {
                System.err.println(this.msgcat.getMessage("errChangeAdminEmail", "Error - failed to change admin E-Mail."));
                displayMsg = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void changeMediaType() {
        System.out.println(this.msgcat.getMessage("media", "TBD - Change media type"));
    }

    public void changePatchType(String string) {
        String string2 = "patchpro.patch.install.patchtype";
        String string3 = this.properties.getProperty(string2);
        if (this.isValidPatchType(string)) {
            if (string == null || string.equals("none")) {
                string = "";
            }
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalPatchType", "Specified patch type is identical to the one in effect - No action necessary."));
                displayMsg = false;
            }
        } else {
            System.err.println(this.msgcat.getMessage("errChangePatchType", "Error - failed to change patch type."));
            System.err.println(this.msgcat.getMessage("validPatchTypes", "Valid patch types : "));
            for (int i = 0; i < validPatchTypes.length; ++i) {
                System.err.println("\t\"" + validPatchTypes[i] + "\"");
            }
            displayMsg = false;
        }
    }

    public void changeInteractivePatchType(String string) {
        String string2 = "patchpro.patch.interactive.patchtype";
        String string3 = this.properties.getProperty(string2);
        if (this.isValidInteractivePatchType(string)) {
            if (string == null || string.equals("none")) {
                string = "";
            }
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalPatchType", "Specified patch type is identical to the one in effect - No action necessary."));
                displayMsg = false;
            }
        } else {
            System.err.println(this.msgcat.getMessage("errChangePatchType", "Error - failed to change patch type."));
            System.err.println(this.msgcat.getMessage("validPatchTypes", "Valid patch types : "));
            for (int i = 0; i < validInteractivePatchTypes.length; ++i) {
                System.err.println("\t\"" + validInteractivePatchTypes[i] + "\"");
            }
            displayMsg = false;
        }
    }

    public void listProperties() {
        String string = null;
        for (int i = 0; i < propertyNamesForList.length; ++i) {
            String string2 = this.properties.getProperty(propertyNamesForList[i]);
            Object[] objectArray = new String[]{string2};
            string = propertyNamesForList[i].equals("patchpro.log.file") ? (string2.equals("system") ? "Log file location:\tSystem log file (consult /etc/syslog.conf for exact location)" : "Log file location:\t" + string2) : (propertyNamesForList[i].equals("patchpro.log.size") ? "Log file size:\t\t" + string2 : (propertyNamesForList[i].equals("patchpro.patch.download.directory") ? "Download directory:\t" + string2 : (propertyNamesForList[i].equals("patchpro.patch.sequester.directory") ? "Sequester directory:\t" + string2 : (propertyNamesForList[i].equals("patchpro.proxyserver.host") ? "Proxy server name:\t" + string2 : (propertyNamesForList[i].equals("patchpro.proxyserver.port") ? "Proxy server port:\t" + string2 : (propertyNamesForList[i].equals("patchpro.patch.server.url") ? "Server URL:\t\t" + string2 : (propertyNamesForList[i].equals("patchpro.database.source.url") ? "Database URL:\t\t" + string2 : "Detectors URL:\t\t" + string2)))))));
            if (propertyNamesForList[i].equals("patchpro.log.file") && string2.equals("system")) {
                System.out.println(this.msgcat.getMessage(propertyNamesForList[i] + ".listing.label2", string));
                continue;
            }
            System.out.println(this.msgcat.getMessage(propertyNamesForList[i] + ".listing.label", objectArray, string));
        }
    }

    private boolean isValidPatchType(String string) {
        boolean bl = false;
        if (string != null) {
            for (int i = 0; i < validPatchTypes.length; ++i) {
                if (!string.equals(validPatchTypes[i])) continue;
                bl = true;
                break;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean isValidInteractivePatchType(String string) {
        boolean bl = true;
        Vector<String> vector = new Vector<String>();
        if (string.indexOf("none") != -1 && !string.equals("none")) {
            System.out.println(this.msgcat.getMessage("nonetypeusage", "\"none\" cannot be specified with other patch types."));
            displayMsg = false;
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (string != null) {
            for (int i = 0; i < validInteractivePatchTypes.length; ++i) {
                vector.addElement(validInteractivePatchTypes[i]);
            }
            stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2 == null || vector.contains(string2)) continue;
                bl = false;
                break;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public void changeHardware() {
        System.out.println(this.msgcat.getMessage("changeHwConfiguration", "Change Hardware Configuration"));
        RenderInteractionSetImpl renderInteractionSetImpl = new RenderInteractionSetImpl();
        try {
            this.patchPro.addListener(this);
            this.done = false;
            this.patchPro.generateAbbreviatedHost();
            System.out.println(this.msgcat.getMessage("analyzingComputer", "Analyzing this computer."));
            while (!this.done) {
                Thread.sleep(2000L);
                System.out.print(".");
            }
            System.out.println("");
            this.patchPro.initializeInteractiveDetectors();
            while (true) {
                try {
                    while (true) {
                        InteractionSet interactionSet;
                        if ((interactionSet = this.patchPro.nextInteractiveDetector()) == null) {
                            System.out.println(this.msgcat.getMessage("nullXnSet", "Null Interaction Set."));
                            continue;
                        }
                        renderInteractionSetImpl.render(interactionSet);
                        this.patchPro.setInteractionSet(interactionSet);
                    }
                }
                catch (DetectorFailedException detectorFailedException) {
                    System.err.println(this.msgcat.getMessage("noHardware", "No hardware on your system."));
                    detectorFailedException.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (NoMoreDetectorsException noMoreDetectorsException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void changeProxyServer(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "patchpro.proxyserver.host";
        String string5 = "patchpro.proxyserver.port";
        boolean bl = false;
        boolean bl2 = false;
        if (string == null || string.equals("")) {
            bl = true;
            bl2 = true;
        } else {
            int n;
            int n2 = string.indexOf(58);
            if (n2 != -1 && n2 == (n = string.lastIndexOf(58))) {
                string2 = string.substring(0, n2);
                string3 = string.substring(n2 + 1);
                bl2 = true;
                try {
                    long l = Long.parseLong(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    bl2 = false;
                }
            }
        }
        if (bl2) {
            String string6 = this.properties.getProperty(string4);
            String string7 = this.properties.getProperty(string5);
            this.setAppropriateProperty(string4, string2);
            this.setAppropriateProperty(string5, string3);
            try {
                this.properties.update(string4, string2);
                this.properties.update(string5, string3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        } else {
            System.err.println(this.msgcat.getMessage("wrongProxyServerFormat", "Proxy server format is incorrect."));
            displayMsg = false;
        }
    }

    public void patchproProgress(PatchProEvent patchProEvent) {
    }

    public void patchproDone(PatchProEvent patchProEvent) {
        this.done = true;
    }

    public void patchproFailed(PatchProEvent patchProEvent) {
        Object object = patchProEvent.getSource();
        Throwable throwable = null;
        if (object instanceof PatchProModel) {
            throwable = ((PatchProModel)object).getPatchProFailure();
            System.err.println(this.msgcat.getMessage("patchProFailed", "Error: PatchPro failed: ") + throwable.getMessage());
        } else {
            System.err.println("Error: Event source not PatchProModel");
        }
        this.done = true;
    }

    public void changeUserName(String string) {
        String string2 = "patchpro.sunsolve.identity";
        String string3 = this.properties.getProperty(string2);
        if (string3 != null) {
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalUserName", "Specified user name is identical to the one in effect - No action necessary."));
                displayMsg = false;
            }
        } else {
            System.err.println(this.msgcat.getMessage("errChangeUserName", "Error - failed to change user name."));
            displayMsg = false;
        }
    }

    private void setAppropriateProperty(String string, String string2) {
        if (this.hasAssociate) {
            this.properties.setProperty(this.associateStr, string, string2);
        } else {
            this.properties.setProperty(string, string2);
        }
    }

    public void changeProxyUserName(String string) {
        String string2 = "patchpro.proxy.identity";
        String string3 = this.properties.getProperty(string2);
        if (string3 != null && string3.compareTo(string) == 0) {
            System.out.println(this.msgcat.getMessage("isIdenticalProxyUserName", "Specified proxy user name is identical to the one in effect - No action necessary."));
            displayMsg = false;
            return;
        }
        try {
            this.properties.update(string2, string);
            this.properties.setProperty(string2, string);
        }
        catch (Exception exception) {
            System.err.println(this.msgcat.getMessage("errDefineProxyUserName", "Error - failed to define proxy user name."));
            System.err.println(exception.getMessage());
        }
    }

    static {
        displayMsg = true;
    }
}

