/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.analysis;

import com.sun.patchpro.analysis.BaseDataDetector;
import com.sun.patchpro.analysis.ConfigurationReader;
import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.DetectorListener;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.parser.StoradeXmlTranslator;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.Percentage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Locale;

public class SunOSTargetInfo
implements BaseDataDetector {
    private PatchProProperties properties;
    private Host targetHost;
    private PatchProLog log = PatchProLog.getInstance();
    private Locale locale;
    private StoradeXmlTranslator storadeXmlTranslator;
    private LocalizedMessages catalog;
    private InetAddress iNetAddr = null;

    public SunOSTargetInfo() {
        this.properties = PatchProProperties.getInstance();
    }

    public void run() {
        block24: {
            Object object;
            String string = this.properties.getProperty("test.patchpro.operatingSystem");
            if (string == null) {
                this.targetHost.setOperatingSystem("SunOS");
            } else {
                this.targetHost.setOperatingSystem(string);
            }
            string = this.properties.getProperty("test.patchpro.OSRelease");
            if (string == null) {
                this.targetHost.setOSRelease(System.getProperty("os.version"));
            } else {
                this.targetHost.setOSRelease(string);
            }
            string = this.properties.getProperty("test.patchpro.arch");
            if (string == null) {
                this.targetHost.setArchitecture(Host.getOSArchitectureName());
            } else {
                this.targetHost.setArchitecture(string);
            }
            String string2 = this.properties.getProperty("patchpro.hdw.read.path");
            File file = new File(string2);
            if (file != null && file.exists() && file.canRead()) {
                object = new ConfigurationReader(string2);
                ((ConfigurationReader)object).readConfig(this.targetHost);
            }
            try {
                string = this.properties.getProperty("test.patchpro.platform");
                if (string == null) {
                    this.targetHost.setPlatform(this.getPlatform());
                } else {
                    this.targetHost.setPlatform(string);
                }
            }
            catch (DetectorFailedException detectorFailedException) {
                // empty catch block
            }
            try {
                this.iNetAddr = InetAddress.getLocalHost();
                string = this.properties.getProperty("test.patchpro.hostip");
                if (string == null) {
                    this.targetHost.setAddress(this.iNetAddr.getHostAddress());
                } else {
                    this.targetHost.setAddress(string);
                }
                string = this.properties.getProperty("test.patchpro.hostname");
                if (string == null) {
                    this.targetHost.setHostName(this.iNetAddr.getHostName());
                } else {
                    this.targetHost.setHostName(string);
                }
                object = Runtime.getRuntime();
                String string3 = this.properties.getProperty("patchpro.storade.command.get.inventory");
                if (string3 == null) break block24;
                this.log.println(this, 7, "The storade command is: " + string3);
                String string4 = this.properties.getProperty("patchpro.default.storade.xml.inventory", "/var/opt/SUNWstade/DATA/inventory.xml");
                this.log.println(this, 7, "The storade xml file is at: " + string4);
                try {
                    int n = -1;
                    InputStream inputStream = null;
                    InputStream inputStream2 = null;
                    Process process = ((Runtime)object).exec(string3);
                    inputStream = process.getInputStream();
                    inputStream2 = process.getErrorStream();
                    n = process.waitFor();
                    if (n == 0) {
                        this.storadeXmlTranslator = new StoradeXmlTranslator(string4, this.targetHost);
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
                catch (IOException iOException) {
                    this.log.println(this, 7, "Cannot find StorAde.");
                }
                catch (SecurityException securityException) {
                    this.log.println(this, 7, "Not permitted to execute StorAde inventory.");
                }
                catch (InterruptedException interruptedException) {
                    this.log.println(this, 7, "Interrupted while executing StorAde inventory.");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setHost(Host host) {
        this.targetHost = host;
    }

    private String getPlatform() throws DetectorFailedException {
        InputStream inputStream = null;
        byte[] byArray = new byte[100];
        try {
            Process process = Runtime.getRuntime().exec("/usr/bin/uname -i");
            InputStream inputStream2 = process.getInputStream();
            inputStream = process.getErrorStream();
            int n = inputStream2.read(byArray, 0, 100);
            if (inputStream != null) {
                inputStream.close();
            }
            if (inputStream2 != null) {
                inputStream2.close();
            }
            if (n == -1) {
                this.log.println(this, 4, "SunOSBaseData.getPlatform(): No platform data found.");
                throw new DetectorFailedException("No platform data found.");
            }
            if (n == 100) {
                this.log.println(this, 4, "SunOSBaseData.getPlatform(): Platform data makes no sense.");
                throw new DetectorFailedException("Platform data makes no sense.");
            }
            return new String(byArray).trim();
        }
        catch (IOException iOException) {
            throw new DetectorFailedException(iOException.getMessage());
        }
    }

    public String getMessage() {
        return this.catalog.getMessage("SunOSTargetInfoMessage", "Looking for Basic target information ...");
    }

    public Percentage percentComplete() {
        return new Percentage(100);
    }

    public void addListener(DetectorListener detectorListener) {
    }

    public void removeListener(DetectorListener detectorListener) {
    }
}

