/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.analysis;

import com.sun.patchpro.analysis.BaseDataDetector;
import com.sun.patchpro.analysis.DetectorEvent;
import com.sun.patchpro.analysis.DetectorListener;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchInfoImpl;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.Percentage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class SolarisPatchScanner
implements BaseDataDetector {
    static final String PATCHSTRING = "Patch: ";
    static final String OBSOLETESTRING = "Obsoletes: ";
    static final String REQUIRESSTRING = "Requires: ";
    static final String INCOMPATIBLESSTRING = "Incompatibles: ";
    static final String PACKAGESSTRING = "Packages: ";
    private PatchProProperties properties;
    private PatchProLog log;
    private Vector listeners = new Vector();
    private Locale locale;
    private LocalizedMessages catalog;
    private PatchImpl currentPatch;
    private Host targetHost;
    private int progress;
    private long fivePercent;
    private long totalPatchCount;
    private long loadedPatchCount;
    private boolean bestGuessProgress = true;
    private long startTime = System.currentTimeMillis();
    private long currentDuration;
    private long currentProgressSector;

    public SolarisPatchScanner() {
        this.log = PatchProLog.getInstance();
        this.properties = PatchProProperties.getInstance();
        this.catalog = new LocalizedMessages(Locale.ENGLISH);
        this.initializeProgress();
    }

    public SolarisPatchScanner(Host host, Locale locale) {
        this.log = PatchProLog.getInstance();
        this.properties = PatchProProperties.getInstance();
        this.setHost(host);
        this.setLocale(locale);
        this.initializeProgress();
    }

    public void setHost(Host host) {
        this.targetHost = host;
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.catalog = new LocalizedMessages(locale);
        }
    }

    public String getMessage() {
        return this.catalog.getMessage("SolarisPatchScannerMessage", "Looking for Sun Patches ...");
    }

    public void run() {
        Runtime runtime = Runtime.getRuntime();
        try {
            try {
                InputStream inputStream = null;
                Process process = runtime.exec(this.getCommandAsArray(this.properties.getProperty("SunOS.command.get.patch.data", "/usr/bin/showrev -p")));
                inputStream = process.getErrorStream();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
                if (this.bestGuessProgress) {
                    this.progress = 20;
                    this.incrementProgress(false);
                }
                this.buildDatabase(bufferedInputStream);
                bufferedInputStream.close();
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                this.log.println(this, 4, "SolarisPatchScanner.run: " + exception + " thrown trying to run primary " + "patch query command.");
                try {
                    Process process = runtime.exec(this.getCommandAsArray(this.properties.getProperty("SunOS.command.get.patch.data.alt", "/usr/bin/showrev -p")));
                }
                catch (Exception exception2) {
                    this.log.println(this, 3, "SolarisPatchScanner.run: " + exception2 + " thrown trying to run secondary " + "patch query command. Patch scanning failed.");
                    this.dispatchErrorEvent(new DetectorEvent(this, "SolarisPatchScanner: Could not find utility."));
                }
            }
        }
        catch (Exception exception) {
            this.log.println(this, 2, "SolarisPatchScanner: Threw " + exception.getMessage() + " while verifying privilege.");
            this.dispatchErrorEvent(new DetectorEvent(this, "SolarisPatchScanner: Threw " + exception.getMessage() + " while verifying privilege."));
        }
        this.incrementProgress(true);
        this.progress = 100;
        this.dispatchDoneEvent(new DetectorEvent(this));
    }

    private String[] getCommandAsArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public Percentage percentComplete() {
        return new Percentage(this.progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DetectorListener detectorListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(detectorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DetectorListener detectorListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(this.listeners);
        }
    }

    private void initializeProgress() {
        try {
            File file = new File("/var/sadm/pkg");
            this.progress = 0;
            String string = this.properties.getProperty("SunOS.patch.process.time", "150");
            long l = new Long(string);
            this.fivePercent = (long)file.list().length * l / 20L;
            this.bestGuessProgress = false;
        }
        catch (Exception exception) {
            this.progress = 20;
            this.fivePercent = 1L;
        }
        this.currentProgressSector = 0L;
        this.totalPatchCount = 0L;
    }

    private void incrementProgress(boolean bl) {
        ++this.loadedPatchCount;
        this.currentDuration = System.currentTimeMillis() - this.startTime;
        if (this.currentDuration > this.currentProgressSector || bl) {
            if (!bl) {
                this.progress += 5;
                this.currentProgressSector += this.fivePercent;
                if (this.progress > 85) {
                    this.progress = 85;
                }
            } else {
                this.progress = 100;
            }
            this.dispatchProgressEvent(new DetectorEvent(this));
        }
    }

    private void buildDatabase(BufferedInputStream bufferedInputStream) {
        boolean bl = false;
        char[] cArray = new char[200];
        int n = 0;
        try {
            int n2;
            while ((n2 = bufferedInputStream.read()) != -1) {
                if (n2 == 10) {
                    try {
                        this.currentPatch = this.makePatch(cArray);
                        this.targetHost.addPatchID(this.currentPatch.getPatchID());
                        this.log.println(this, 7, "SolarisPatchScanner.buildDatabase(): added " + this.currentPatch.getPatchID().getPatchID());
                        if (!this.bestGuessProgress) {
                            this.incrementProgress(false);
                        }
                    }
                    catch (Exception exception) {
                        this.log.println(this, 4, "SolarisPatchScanner.buildDatabase: " + exception + " thrown trying to add " + new String(cArray) + " to the host.");
                    }
                    n = 0;
                    cArray = new char[200];
                    continue;
                }
                bl = false;
                if (n >= 200) continue;
                cArray[n++] = (char)n2;
            }
        }
        catch (Exception exception) {
            this.log.println(this, 4, "SolarisPatchScanner.buildDatabase: " + exception + " thrown trying to build database.");
            this.log.printStackTrace(this, 4, exception);
        }
    }

    private PatchImpl makePatch(char[] cArray) throws MalformedPatchException {
        String string = new String(cArray);
        int n = string.indexOf(PATCHSTRING) + PATCHSTRING.length();
        int n2 = string.indexOf(OBSOLETESTRING) - 1;
        int n3 = string.indexOf(OBSOLETESTRING) + OBSOLETESTRING.length();
        int n4 = string.indexOf(REQUIRESSTRING) - 1;
        int n5 = string.indexOf(REQUIRESSTRING) + REQUIRESSTRING.length();
        int n6 = string.indexOf(INCOMPATIBLESSTRING) - 1;
        int n7 = string.indexOf(INCOMPATIBLESSTRING) + INCOMPATIBLESSTRING.length();
        int n8 = string.indexOf(PACKAGESSTRING) - 1;
        if (n != -1 && n2 > n) {
            PatchID patchID = new PatchID(string.substring(n, n2).trim());
            PatchInfoImpl patchInfoImpl = new PatchInfoImpl();
            if (n3 != -1 && n4 > n3) {
                patchInfoImpl.setObsolesces(string.substring(n3, n4).replace(',', ' '));
            }
            if (n5 != -1 && n6 > n5) {
                patchInfoImpl.setRequires(string.substring(n5, n6).replace(',', ' '));
            }
            if (n7 != -1 && n8 > n7) {
                patchInfoImpl.setIncompat(string.substring(n7, n8).replace(',', ' '));
            }
            patchInfoImpl.setOS("SunOS");
            patchInfoImpl.setProperties(new PatchProperties(""));
            return new PatchImpl(patchInfoImpl, patchID);
        }
        throw new MalformedPatchException("Could not decode patch entry");
    }

    private void dispatchProgressEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorProgress(detectorEvent);
        }
    }

    private void dispatchDoneEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorDone(detectorEvent);
        }
    }

    private void dispatchErrorEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorFailed(detectorEvent);
        }
    }
}

