/* -*- Mode: C -*- */
/*
 *
 * $Id: am_web.h,v 1.61 2004/01/15 22:06:42 pv108971 Exp $
 * Copyright  2002 Sun Microsystems, Inc. All rights reserved.
 *
 * U.S. Government Rights - Commercial software. Government users are
 * subject to the Sun Microsystems, Inc. standard license agreement and
 * applicable provisions of the FAR and its supplements. Use is subject to
 * license terms. Sun, Sun Microsystems, the Sun logo and Sun ONE are
 * trademarks or registered trademarks of Sun Microsystems, Inc. in the
 * U.S. and other countries.
 *
 * Copyright  2002 Sun Microsystems, Inc. All rights reserved.
 *
 * U.S. Government Rights - Commercial software. Government users are
 * subject to the Sun Microsystems, Inc. standard license agreement and
 * applicable provisions of the FAR and its supplements. Use is subject to
 * license terms. Sun, Sun Microsystems, the Sun logo and Sun ONE are
 * trademarks or registered trademarks of Sun Microsystems, Inc. in the
 * U.S. and other countries.
 *
 * Copyright  2002 Sun Microsystems, Inc. Tous droits rservs.
 *
 * Droits du gouvernement amricain, utlisateurs gouvernmentaux - logiciel
 * commercial. Les utilisateurs gouvernmentaux sont soumis au contrat de
 * licence standard de Sun Microsystems, Inc., ainsi qu aux dispositions en
 * vigueur de la FAR [ (Federal Acquisition Regulations) et des supplments
 *  celles-ci.
 *
 * Distribu par des licences qui en restreignent l'utilisation. Sun, Sun
 * Microsystems, le logo Sun et Sun ONE sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 *
 */

#ifndef AM_WEB_H
#define AM_WEB_H

#if     defined(WINNT)
#if     defined(AM_BUILDING_LIB)

#define AM_WEB_EXPORT    __declspec(dllexport)
#else /* if defined(AM_BUILDING_LIB) */
#define AM_WEB_EXPORT    __declspec(dllimport)
#endif
#else /* if defined(WINNT) */
#define AM_WEB_EXPORT
#define AM_WEB_ALLOW_USER_MSG            "User %s was allowed access to %s."
#define AM_WEB_DENIED_USER_MSG            "User %s was denied access to %s."
#endif

#include <stdlib.h>
#include <am.h>
#include "am_policy.h"
#define AM_RESERVED NULL

AM_BEGIN_EXTERN_C

/**
 *                     -------- constants --------
 */


#define AM_WEB_ACTION_ALLOWED		"allow"
#define AM_WEB_ACTION_DENIED		"deny"

/*
 * Constants used in looking up HTTP headers or request attributes.
 *
 * NOTE:  These constants must be all lowercase or the lookup will fail.
 */
#define CONTENT_LENGTH_HDR      	"content-length"
#define COOKIE_HDR              	"cookie"
#define HOST_HDR                	"host"
#define PATH_INFO               	"path-info"
#define REQUEST_IP_ADDR         	"ip"
#define REQUEST_METHOD          	"method"
#define REQUEST_QUERY           	"query"
#define REQUEST_URI             	"uri"
#define AUTH_USER_VAR           	"auth-user"
#define AUTH_TYPE_VAR           	"auth-type"
#define GOTO_PARAMETER          	"goto"
#define REQUEST_METHOD_TYPE     	"sunwMethod"
#define REFERER_SERVLET         	"refererservlet"
#define FORM_METHOD_POST        	"POST"
#define FORM_METHOD_GET         	"GET"

#define HTTP_PROTOCOL_STR       	"http://"
#define HTTP_PROTOCOL_STR_LEN   	(sizeof(HTTP_PROTOCOL_STR) - 1)
#define HTTPS_PROTOCOL_STR      	"https://"
#define HTTPS_PROTOCOL_STR_LEN  	(sizeof(HTTPS_PROTOCOL_STR) - 1)


#define AM_WEB_PROPERTY_PREFIX		"com.sun.am.policy.agents."
#define AM_WEB_CHECK_CLIENT_IP_PROPERTY		AM_WEB_PROPERTY_PREFIX "client_ip_validation_enable"
#define AM_WEB_ACCESS_DENIED_URL_PROPERTY AM_WEB_PROPERTY_PREFIX "accessDeniedURL"
#define AM_WEB_UNAUTHENTICATED_USER AM_WEB_PROPERTY_PREFIX "unauthenticatedUser"
#define AM_WEB_ANON_REMOTE_USER_ENABLE AM_WEB_PROPERTY_PREFIX "anonRemoteUserEnabled"
#define AM_WEB_URL_REDIRECT_PARAM AM_WEB_PROPERTY_PREFIX "urlRedirectParam"
#define AM_WEB_INSTANCE_NAME_PROPERTY	AM_WEB_PROPERTY_PREFIX "instanceName"
#define AM_WEB_NOT_ENFORCED_LIST_PROPERTY AM_WEB_PROPERTY_PREFIX "notenforcedList"
#define AM_WEB_REVERSE_NOT_ENFORCED_LIST AM_WEB_PROPERTY_PREFIX "reverse_the_meaning_of_notenforcedList"
#define AM_WEB_NOT_ENFORCED_IPADDRESS AM_WEB_PROPERTY_PREFIX "notenforced_client_IP_address_list"
#define AM_WEB_DO_SSO_ONLY AM_WEB_PROPERTY_PREFIX "do_sso_only"
#define AM_WEB_CDSSO_ENABLED_PROPERTY AM_WEB_PROPERTY_PREFIX "cdsso-enabled"
#define AM_WEB_CDC_SERVLET_URL_PROPERTY AM_WEB_PROPERTY_PREFIX "cdcservletURL"

#define AM_WEB_POST_CACHE_CLEANPUP_INTERVAL AM_WEB_PROPERTY_PREFIX "postcachecleanupinterval"
#define AM_WEB_POST_CACHE_ENTRY_LIFETIME AM_WEB_PROPERTY_PREFIX "postcacheentrylifetime"
#define AM_WEB_POST_CACHE_DATA_PRESERVE AM_WEB_PROPERTY_PREFIX "is_postdatapreserve_enabled"
#define AM_WEB_URI_PREFIX AM_WEB_PROPERTY_PREFIX "agenturiprefix"
#define AM_LOG_ACCESS_TYPE_PROPERTY  AM_WEB_PROPERTY_PREFIX "logAccessType"

#define AM_WEB_FQDN_MAP AM_WEB_PROPERTY_PREFIX "fqdnMap"
#define AM_WEB_FQDN_DEFAULT AM_WEB_PROPERTY_PREFIX "fqdnDefault"

#define AM_WEB_COOKIE_RESET_ENABLED AM_WEB_PROPERTY_PREFIX "cookie_reset_enabled"
#define AM_WEB_COOKIE_RESET_LIST AM_WEB_PROPERTY_PREFIX "cookie_reset_list"
#define AM_WEB_COOKIE_DOMAIN_LIST AM_WEB_PROPERTY_PREFIX "cookieDomainList"
#define AM_WEB_LOGOUT_URL_PROPERTY AM_WEB_PROPERTY_PREFIX "logout.url"
#define AM_WEB_LOGOUT_COOKIE_RESET_PROPERTY AM_WEB_PROPERTY_PREFIX "logout.cookie_reset_list"



/*
 * Enough space to hold PRTime key in a string
 */
#define	AM_WEB_MAX_POST_KEY_LENGTH	64

/*
 * Enough space to hold a formatted TCP port number and terminating NULL.
 */
#define	AM_WEB_MAX_PORT_STR_LEN		6

/*
 * Return values of am_web_is_cookie_present
 */
#define AM_WEB_COOKIE_EXIST             2
#define AM_WEB_COOKIE_MODIFIED          1
#define AM_WEB_COOKIE_ABSENT            0
#define AM_WEB_COOKIE_ERROR            -1

/*
 * Auth-Type identifier for Identity Server authentication.
 */
#define	AM_WEB_AUTH_TYPE_VALUE		"DSAME"

/*
 * Auth-Type ACCESS status.
 */
typedef enum {
    AM_ACCESS_DENY = 0,
    AM_ACCESS_ALLOW
} am_web_access_t;



/**
 *                   -------- policy methods --------
 */

/**
 * Method to initialize the Agent Toolkit.
 */
AM_WEB_EXPORT am_status_t am_web_init(const char *config_file);

/**
 * Method to clean up the Agent Toolkit
 */
AM_WEB_EXPORT am_status_t am_web_cleanup();

/*
 * Evaluates the access control policies for a specified web-resource and
 * action.
 *
 * Parameters:
 *   sso_token	The sso_token from the Identity Server cookie.  This
 *		parameter may be NULL if there is no cookie present.
 *
 *   url	The URL whose accessibility is being determined.
 *		This parameter may not be NULL.
 *
 *   action_name
 *		The action (GET, POST, etc.) being performed on the
 *		specified URL.  This parameter may not be NULL.
 *
 *   client_ip
 *		The IP address of the client attempting to access the
 *		specified URL.  If client IP validation is turned on,
 *		then this parameter may not be NULL.
 *
 *   env_parameter_map
 *		A map containing additional information about the user
 *		attempting to access the specified URL.  This parameter
 *		may not be NULL.
 *
 *   advices_map_ptr
 *		An output parameter where an am_map_t can be stored
 *		if the policy evaluation produces any advice information.
 *		This parameter may not be NULL.
 *
 * Returns:
 *   AM_SUCCESS
 *		if the evaluation was performed successfully and access
 *		is to be allowed to the specified resource
 *
 *   AM_NO_MEMORY
 *		if the evaluation was not successfully completed due to
 *		insufficient memory being available
 *
 *   AM_INVALID_ARGUMENT
 *		if any of the url, action_name, env_parameter_map, or
 *		advices_map_ptr parameters is NULL or if client IP validation
 *		is enabled and the client_ip parameter is NULL.
 *
 *   AM_INVALID_SESSION
 *		if the specified sso_token does not refer to a currently
 *		valid session
 *
 *   AM_ACCESS_DENIED
 *		if the policy information indicates that the user does
 *		not have permission to access the specified resource or
 *		any error is detected other than the ones listed above
 */
AM_WEB_EXPORT am_status_t
am_web_is_access_allowed(const char *sso_token, const char *url,
			 const char *path_info, const char *action_name,
			 const char *client_ip, const am_map_t env_parameter_map,
			 am_policy_result_t *result);

/*
 * Determines whether the request contains is an Identity Server
 * notification message intended for the policy SDK.
 */
AM_WEB_EXPORT boolean_t am_web_is_notification(const char *request_url);

/*
 * Returns true if the URL being accessed by the user is in the not
 * enforced list.
 */
AM_WEB_EXPORT boolean_t am_web_is_in_not_enforced_list(const char *url,
						       const char *path_info);

/*
 * Returns true if the given IP address is present in the list of
 * not enforced IP addresses.
 */
AM_WEB_EXPORT boolean_t am_web_is_in_not_enforced_ip_list(const char *ip);

/*
 * Returns if the requested URL is a Valid FQDN resource.
 */
AM_WEB_EXPORT boolean_t am_web_is_valid_fqdn_url(const char *url);


/*
 * Handles notification data received by an agent.  This code handles
 * generating logging messages for the event and any error that may
 * occur during the processing of the notification.
 */
AM_WEB_EXPORT void am_web_handle_notification(const char *data,
					    size_t data_length);

/*
 * This function returns a string representing the URL for redirection that
 * is appropriate to the provided status code and advice map returned by
 * the Policy SDK.  This may either redirect the user to the login URL or
 * the access denied URL.  If the redirection is to the login URL then the
 * URL will include any exsisting information specified in the URL from the
 * configuration file, like org value etc., followed by the specified goto
 * parameter value, which will be used by Identity Server after the user has
 * successfully authenticated.
 *
 * The function am_web_get_redirect_url(), has been deprecated and
 * must not be used.  It is supported only for backward compatibility
 * reasons.
 * The last parameter reserved must be passed with NULL.
 *
 * Note: If the redirect_url returned is NOT NULL, the caller of this function
 * must call am_web_free_memory(void *) to free the pointer.
 */
AM_WEB_EXPORT am_status_t am_web_get_url_to_redirect(am_status_t status,
					 	     const am_map_t advice_map,
					  	     const char *goto_url,
						     const char* method,
						     void *reserved,
					  	     char ** redirect_url);

/*
 * This function sets the LDAP attributes in header.
 * The method will be called when ldapattribute.mode is set to "HEADER"
 *
 * Parameters:
 *   key	    key whose value to be set.
 *
 *   attrValues     The value string that will be set.
 *
 *   args           container specific argument containing request.
 *
 * Returns:
 *   AM_SUCCESS
 *		    if the setting is successful.
 *
 */
typedef am_status_t (*am_web_result_set_header_func_t)(
                         const char *key,
                         const char *attrValues, 
                         void **args); 

/*
 * This function sets the LDAP attributes in header through cookie in response.
 * The method will be called when ldapattribute.mode is set to "COOKIE"
 *
 * Parameters:
 *   cookieValues   The string containing cookie value that will be set.
 *
 *   args           container specific argument containing request.
 *
 * Returns:
 *   AM_SUCCESS
 *		    if the setting is successful.
 */
typedef am_status_t (*am_web_result_set_header_attr_in_response_func_t)(
                         const char *cookieValues,
                         void **args); 

/*
 * This function sets the LDAP attributes in header through cookie in request.
 * The method will be called when ldapattribute.mode is set to "COOKIE"
 *
 * Parameters:
 *   cookieValues   The string containing cookie value that will be set.
 *
 *   args           container specific argument containing request.
 *
 * Returns:
 *   AM_SUCCESS
 *		    if the setting is successful.
 */
typedef am_status_t (*am_web_result_set_header_attr_in_request_func_t)(
                         const char *cookieValues,
                         void **args); 

/*
 * This function at present is DUMMY. will be needed for cookie synchronization.
 * has been added to get the interface.
 *
 * Parameters:
 *   cookieName     Name of the cookie to be synchronized with.
 *
 *   dproCookie     
 *
 *   args           container specific argument containing request.
 *
 * Returns:
 *   AM_SUCCESS
 *		    if the setting is successful.
 */
typedef am_status_t (*am_web_get_cookie_sync_func_t)(
                         const char *cookieName,
                         char **dproCookie,
                         void **args); 

/*
 * NOTE - This function replaces am_web_do_result_attr_map_set() in the 
 * previous version of the library. The old interface is still provided 
 * in the library but deprecated. Users need to explicity declare it as 
 * follows to use it. 
 *         am_status_t am_web_do_result_attr_map_set(
 *                              am_policy_result *result,
 *                              am_status_t (*setFunc)(const char *,
 *                                                     const char *,	
 *                                                     void **),
 *                              void **args);
 *
 * This function processes attr_response_map of am_policy_result_t
 * and performs the appropriate set action that is passed in. 
 * 
 */
AM_WEB_EXPORT am_status_t
am_web_result_attr_map_set(
              am_policy_result_t *result,
              am_web_result_set_header_func_t setHeaderFunc,
              am_web_result_set_header_attr_in_response_func_t setCookieRespFunc,
              am_web_result_set_header_attr_in_request_func_t  setCookieReqFunc,
              am_web_get_cookie_sync_func_t  getCookieSyncFunc,
              void **args);

/*
 * This function the reset_cookie headers for the cookies
 * specified in the configuration file and invokes the  set action
 * that caller (i.e. the agent) passes in for each of them.
 */
AM_WEB_EXPORT am_status_t
am_web_do_cookies_reset(am_status_t (*setFunc)(const char *, void **),
			void **args);


/*
 * This function sets the iPlanetDirectoryPro cookie for each domain 
 * configured in the com.sun.am.policy.agents.cookieDomainList property.
 * It builds the set-cookie header for each domain specified in the 
 * property, and calls the callback function 'setFunc' in the first 
 * argument to actually set the cookie.
 * This function is called by am_web_check_cookie_in_query() and 
 * am_web_check_cookie_in_post() which are called in CDSSO mode 
 * to set the iPlanetDirectoryPro cookie in the cdsso response. 
 */
AM_WEB_EXPORT am_status_t
am_web_do_cookie_domain_set(am_status_t (*setFunc)(const char *, void **),
			    void **args, const char *cookie);


/*
 * This function is used to get the cookie sent in the SAML assertion
 * from the Identity Server
 */

AM_WEB_EXPORT am_status_t
am_web_get_token_from_assertion(char *assertion, char **token);

AM_WEB_EXPORT am_status_t
am_web_remove_parameter_from_query(const char* inpString, const char *remove_str, char **outString );

AM_WEB_EXPORT am_status_t
am_web_get_parameter_value(const char *inpQuery, const char *param_name, char **param_value);

AM_WEB_EXPORT boolean_t
am_web_is_cdsso_enabled();

AM_WEB_EXPORT am_status_t am_web_check_cookie_in_post(
		void ** args, char ** dpro_cookie, 
		char ** request_url, 
		char **orig_req, char *method,
		char *response,
		boolean_t responseIsCookie,
		am_status_t (*set_cookie)(const char *, void **),
		void (*set_method)(void **, char *)
		);
AM_WEB_EXPORT am_status_t am_web_check_cookie_in_query(
		void **args, char **dpro_cookie,
		const char *query, char **request_url, 
		char ** orig_req, char *method,
		am_status_t (*set_cookie)(const char *, void **),
		void (*set_method)(void **, char *)
		);



		
/*
 * Free memory previously allocated by a am_web_* routine.
 */
AM_WEB_EXPORT void am_web_free_memory(void *memory);

/*
 * Method to retrieve the name of the Identity Server cookie.
 */

AM_WEB_EXPORT const char *am_web_get_cookie_name();

/*
 * Method to retrieve the name of the Identity Server notification Url.
 */
AM_WEB_EXPORT const char *am_web_get_notification_url();


/*
 * Method to retrieve the name of the Agent Server Host.
 */
AM_WEB_EXPORT const char *am_web_get_agent_server_host();

/*
 * Method to retrieve the name of the Agent Server Port.
 */
AM_WEB_EXPORT int am_web_get_agent_server_port();


/**
 *                        -------- logging --------
 */

AM_WEB_EXPORT boolean_t am_web_is_debug_on();
AM_WEB_EXPORT boolean_t am_web_is_max_debug_on();

AM_WEB_EXPORT void am_web_log_always(const char *fmt, ...);
AM_WEB_EXPORT boolean_t am_web_log_auth(am_web_access_t access_type, const char *fmt, ...);
AM_WEB_EXPORT void am_web_log_error(const char *fmt, ...);
AM_WEB_EXPORT void am_web_log_warning(const char *fmt, ...);
AM_WEB_EXPORT void am_web_log_info(const char *fmt, ...);
AM_WEB_EXPORT void am_web_log_debug(const char *fmt, ...);
AM_WEB_EXPORT void am_web_log_max_debug(const char *fmt, ...);

AM_WEB_EXPORT char *am_web_http_decode(const char *string, size_t len);


/*
 *		         --------- POST cache preservation -------
 */

/*
 * Temporary structure to store post data before it is inserted in
 * POST hash table
 * Members :
 *     value
 *         String value for POST data
 *     url
 *         Destination URL for the POST request
 */

typedef struct am_web_postcache_data {
    char *value;
    char *url;
} am_web_postcache_data_t;

/*
 * Temporary structure to hold dummy url, action url
 * POST preservation key. All three of these variables
 * are required for POST preservation. Client passes
 * in the request URL for POST to public function
 * am_web_create_post_preserve_urls which creates
 * this structure and returns a pointer to the client
 *
 * Members :
 *     dummy_url
 *         Dummy URL for redirect for POST preservation
 *     action_url
 *         Destination URL for POST request
 *     post_time_key
 *         Unique key to tag POST data entry
 */

typedef struct post_urls {
    char *dummy_url;
    char *action_url;
    char *post_time_key;
} post_urls_t;


/*
 * Method to find out if POST data preservation is enabled
 * by clients through AMAgent.Properties
 * Returns :
 *    boolean_t
 *        True or False depending on whether POST
 *        preservation is switched on or off.
 *
 */
AM_WEB_EXPORT boolean_t am_web_is_postpreserve_enabled();

/*
 * Method to insert POST data entry in the POST cache
 * Parameters:
 *    key
 *        POST data preservation key for every entry
 *    value
 *        Structure to store POST data value and redirect URL
 *
 * Returns:
 *    boolean_t
 *        True or False depending on whether insertion was
 *        successful or a failure
 *
 */
AM_WEB_EXPORT boolean_t am_web_postcache_insert(const char *key,
						const am_web_postcache_data_t *value);

/*
 * Method to lookup POST data in the POST cache
 *
 * Parameters:
 *     key
 *         Key to search POST data entry in POST data structure
 *
 * Returns:
 *     am_web_postcache_data_t
 *         Data structure containing POST data and redirect URL
 *
 */

AM_WEB_EXPORT boolean_t
am_web_postcache_lookup(const char *key,
			am_web_postcache_data_t *postdata_entry);

/*
 * Method to remove POST data from the POST cache
 *
 * Parameters:
 *     key
 *         Key to remove an entry from POST data structure
 *
 * Returns:
 *
 */
AM_WEB_EXPORT void am_web_postcache_remove(const char *key);


/*
 * Method to construct dummy post url, action url and unique key
 *
 * Parameters:
 *    request_url
 *        The request URL for POST in the HTTP request
 *
 * Returns:
 *    post_urls_t
 *        Data structure that contains Dummy redirect URL, POST destination
 *        URL and POST preservation key. Dummy redirect URL is filtered by
 *        web server SAF to identify POST preservation redirects from general
 *        redirects. All three of these variables are required for POST
 *        preservation.
 *
 */
AM_WEB_EXPORT post_urls_t * am_web_create_post_preserve_urls(const
							     char *request_url);

/*
 * Method to clean up datastructure containing dummy post url, action url and
 * unique key
 *
 * Paramaters:
 *     posturl_struct
 *         Pointer to POST preservation URL data structure post_urls_t
 *
 * Returns
 *
 */
AM_WEB_EXPORT void am_web_clean_post_urls(post_urls_t *posturl_struct);

/*
 * Method to clean up data structure containing post string value,
 * redirect url
 *
 * Paramaters:
 *     const am_web_postcache_data_t
 *         Pointer to POST data entry
 *
 * Returns
 *
 */
AM_WEB_EXPORT void
am_web_postcache_data_cleanup(am_web_postcache_data_t * const postentry_struct);


/*
 * Create the html form with the javascript that submits the POST
 * with the invisible name value pairs
 *
 * Parameters:
 *     key
 *         Unique key to identify POST data entry. It is used to
 *         remove post data once the page is re-posted
 *     postdata
 *         POST data entry as a browser encoded string
 *     actionurl
 *         POST destination URL
 *
 * Returns
 *     char *
 *         POST form to be resubmitted
 *
*/
AM_WEB_EXPORT char * am_web_create_post_page(const char *key,
					     const char *postdata,
					     const char *actionurl);

/*
 * Create the html form with the javascript that submits the POST
 * with the invisible name value pairs
 *
 * Parameters:
 *     key
 *         Unique key to identify POST data entry. It is used to
 *         remove post data once the page is re-posted
 *     postdata
 *         POST data entry as a browser encoded string
 *     actionurl
 *         POST destination URL
 *
 * Returns
 *     char *
 *         POST form to be resubmitted
 *
 */
AM_WEB_EXPORT int am_web_is_cookie_present(const char *cookie, 
                                                 const char *value,
                                                 char **new_cookie);

/* 
 * Resets the cookie configured to be reset on logout. 
 * The reset function passed in is called for each cookie that is configured.
 * If the function failed for any cookie, the last failed status is returned.
 */
AM_WEB_EXPORT am_status_t
am_web_logout_cookies_reset(am_status_t (*setFunc)(const char *, void **),
                            void **args);



/*
 * Returns true if url is a logout url, false otherwise.
 */
AM_WEB_EXPORT boolean_t am_web_is_logout_url(const char *url);


/**
 * When a user comes back from the CDSSO authentication, there are a
 * list of Liberty parameters added when the user was redirected
 * for authentication.  This function removes those extra parameters, so
 * that the request could be forwarded to the applications as it came
 * from the browser.
 *
 * Parameter:
 *    inpString: Request URL that was recieved after authentication
 *               containing Liberty attributes.
 *    outString: Address of output string where all the Liberty
 *               attributes are cleaned up. Must be pre-allocated 
 *               by caller with same size as inpString.
 *                
 *
 * Returns:
 *  am_status_t:
 *               AM_SUCCESS if operation was successful, appropriate
 *               error codes otherwise.
 */
AM_WEB_EXPORT am_status_t
am_web_remove_authnrequest(char *inpString, char **outString);

AM_END_EXTERN_C

#endif	/* not AM_WEB_H */
