/* -*- Mode: C -*-
 * $Id: am.h,v 1.43 2004/02/06 23:56:48 lh25513 Exp $
 * Copyright  2002 Sun Microsystems, Inc. All rights reserved.
 *
 * U.S. Government Rights - Commercial software. Government users are
 * subject to the Sun Microsystems, Inc. standard license agreement and
 * applicable provisions of the FAR and its supplements. Use is subject to
 * license terms. Sun, Sun Microsystems, the Sun logo and Sun ONE are
 * trademarks or registered trademarks of Sun Microsystems, Inc. in the
 * U.S. and other countries.
 *
 * Copyright  2002 Sun Microsystems, Inc. Tous droits rservs.
 *
 * Droits du gouvernement amricain, utlisateurs gouvernmentaux - logiciel
 * commercial. Les utilisateurs gouvernmentaux sont soumis au contrat de
 * licence standard de Sun Microsystems, Inc., ainsi qu aux dispositions en
 * vigueur de la FAR [ (Federal Acquisition Regulations) et des supplments
 *  celles-ci.
 *
 * Distribu par des licences qui en restreignent l'utilisation. Sun, Sun
 * Microsystems, le logo Sun et Sun ONE sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 *
 */

/*
 * Abstract:
 *
 * General utility routines provided by the Sun ONE Identity Server Access
 * Management library.
 *
 */

#ifndef AM_H
#define AM_H

#include <am_types.h>

AM_BEGIN_EXTERN_C

#define AM_COMMON_PROPERTY_PREFIX	"com.sun.am."
#define	AM_POLICY_PROPERTY_PREFIX	"com.sun.am.policy.am."
#define AM_AUTH_PROPERTY_PREFIX         "com.sun.am.auth."
#define AM_SSO_PROPERTY_PREFIX          "com.sun.am.sso."
#define AM_LOG_PROPERTY_PREFIX          "com.sun.am.log."

/* Common Properties */
#define	AM_COMMON_SSL_CERT_DIR_PROPERTY AM_COMMON_PROPERTY_PREFIX "sslCertDir"
#define AM_COMMON_CERT_DB_PREFIX_PROPERTY AM_COMMON_PROPERTY_PREFIX "certDbPrefix"
#define AM_COMMON_LOG_FILE_PROPERTY		AM_COMMON_PROPERTY_PREFIX "logFile"
#define AM_COMMON_LOG_REMOTE_BUFFER_SIZE_PROPERTY		AM_LOG_PROPERTY_PREFIX "remoteBufferSize"
#define AM_COMMON_SERVER_LOG_FILE_PROPERTY   AM_COMMON_PROPERTY_PREFIX "serverLogFile"
#define AM_COMMON_LOG_LEVELS_PROPERTY	AM_COMMON_PROPERTY_PREFIX "logLevels"
#define AM_COMMON_TRUST_SERVER_CERTS_PROPERTY AM_COMMON_PROPERTY_PREFIX "trustServerCerts"
#define	AM_COMMON_COOKIE_NAME_PROPERTY	AM_COMMON_PROPERTY_PREFIX "cookieName"
#define	AM_COMMON_COOKIE_NAME_ENCODED_PROPERTY	AM_COMMON_PROPERTY_PREFIX "cookieEncoded"
#define AM_COMMON_CERT_DB_PASSWORD_PROPERTY AM_COMMON_PROPERTY_PREFIX "certDBPassword"
#define	AM_COMMON_NAMING_URL_PROPERTY	AM_COMMON_PROPERTY_PREFIX "namingURL"
#define AM_COMMON_NOTIFICATION_ENABLED_PROPERTY AM_COMMON_PROPERTY_PREFIX "notificationEnabled"
#define AM_COMMON_NOTIFICATION_URL_PROPERTY	AM_COMMON_PROPERTY_PREFIX "notificationURL"
#define AM_COMMON_CLIENT_IP_CHECK_ENABLED_PROPERTY   AM_COMMON_PROPERTY_PREFIX "clientCheckEnabled"
#define AM_COMMON_LOADBALANCE_PROPERTY    AM_COMMON_PROPERTY_PREFIX "loadBalancer_enable"

/* Authentication Properties */
#define AM_AUTH_ORGANIZATION_NAME_PROPERTY AM_AUTH_PROPERTY_PREFIX "orgName"
#define AM_AUTH_CERT_ALIAS_PROPERTY AM_AUTH_PROPERTY_PREFIX "certificateAlias"
#define AM_AUTH_SERVICE_URLS_PROPERTY AM_AUTH_PROPERTY_PREFIX "authServiceURL"

/* Policy Properties */
#define	AM_POLICY_HASH_BUCKET_SIZE_PROPERTY	AM_POLICY_PROPERTY_PREFIX "hashBucketSize"
#define AM_POLICY_HASH_TIMEOUT_MINS_PROPERTY AM_POLICY_PROPERTY_PREFIX "cacheEntryLifeTime"
#define	AM_POLICY_LOGIN_URL_PROPERTY	AM_POLICY_PROPERTY_PREFIX "loginURL"
#define	AM_POLICY_LIBRARY_LOGIN_URL_PROPERTY	AM_POLICY_PROPERTY_PREFIX "library.loginURL"
#define AM_POLICY_PASSWORD_PROPERTY		AM_POLICY_PROPERTY_PREFIX "password"
#define AM_POLICY_URL_COMPARISON_CASE_IGNORE_PROPERTY AM_POLICY_PROPERTY_PREFIX "urlComparison.caseIgnore"
#define AM_POLICY_USER_NAME_PROPERTY	AM_POLICY_PROPERTY_PREFIX "username"
#define AM_POLICY_ORG_NAME_PROPERTY	AM_POLICY_PROPERTY_PREFIX "orgname"
#define AM_POLICY_MODULE_NAME_PROPERTY	AM_POLICY_PROPERTY_PREFIX "authModule"
#define AM_POLICY_MAX_THREADS_PROPERTY      AM_POLICY_PROPERTY_PREFIX "maxThreads"
#define AM_POLICY_LDAPATTR_MODE AM_POLICY_PROPERTY_PREFIX "ldapattribute.mode"
#define AM_POLICY_LDAPATTR_COOKIE_PFX AM_POLICY_PROPERTY_PREFIX "ldapattribute.cookiePrefix"
#define AM_POLICY_LDAPATTR_COOKIE_MAX_AGE AM_POLICY_PROPERTY_PREFIX "ldapattribute.cookieMaxAge"
#define AM_POLICY_HEADER_ATTRS_PROPERTY   AM_POLICY_PROPERTY_PREFIX "headerAttributes"
#define AM_POLICY_USER_ID_PARAM_PROPERTY AM_POLICY_PROPERTY_PREFIX "userIdParam"

#define AM_POLICY_SLBCOOKIE_PROPERTY      AM_POLICY_PROPERTY_PREFIX "ias_SLB_cookie_name"
#define AM_POLICY_FETCH_FROM_ROOT_RSRC_PROPERTY      AM_POLICY_PROPERTY_PREFIX "fetchFromRootResource"

#define	AM_SSO_HASH_BUCKET_SIZE_PROPERTY	AM_SSO_PROPERTY_PREFIX "hashBucketSize"
#define AM_SSO_HASH_TIMEOUT_MINS_PROPERTY   AM_SSO_PROPERTY_PREFIX "cacheEntryLifeTime"
#define AM_SSO_MAX_THREADS_PROPERTY   AM_SSO_PROPERTY_PREFIX "maxThreads"
#define AM_SSO_CHECK_CACHE_INTERVAL_PROPERTY AM_SSO_PROPERTY_PREFIX "checkCacheInterval"
#define AM_SSO_DEFAULT_SESSION_URL   AM_SSO_PROPERTY_PREFIX "defaultSessionURL"

/* Followings are for the Header attribute modes */
#define AM_POLICY_LDAPATTR_MODE_COOKIE "COOKIE"
#define AM_POLICY_LDAPATTR_MODE_HEADER "HEADER"
#define AM_POLICY_LDAPATTR_MODE_NONE "NONE"

/*
 * This function must be called at the end of the program to
 * release memory used by am_sso_init, am_auth_init, and/or am_policy_init().
 *
 * This should be called only once.
 *
 * Any properties input parameter given to the init functions am_sso_init()
 * am_auth_init() or am_policy_init() should be destroyed only after
 * am_cleanup is called.
 *
 * Parameters:
 *   xmlmsg
 *		XML message containing the notification message.
 *
 *   policy_handle_t
 *              The policy handle created from am_policy_service_init().
 *
 *              NULL if policy is not initialized or not used.
 *
 * Returns:
 *   AM_SUCCESS
 *              if XML message was successfully parsed and processed.
 *
 *   AM_INVALID_ARGUMENT
 *		if any input parameter is invalid.
 *
 *   AM_FAILURE
 *		if any other error occurred.
 */
AM_EXPORT am_status_t
am_cleanup(void);

AM_END_EXTERN_C

#endif	/* not AM_H */
