#!/usr/local/pkg/perl/bin/perl
# 
# Copyright \251 2002 Sun Microsystems, Inc. All rights reserved.
# Use is subject to license terms.
# 
#
# This Perl script will create a LDIF file that can be used to update the base root
# of the DIT. It is to be used on an existing tree when installing Sun Java System Identity Server.
# If you plan on installing Sun Java System Identity Server against a clean directory server.
# If you are unsure of the necessary steps, please read the 
# README file. 
#
# Before running this script, you need to update the values in the 'variables' section 
# at the top of the script.
#
# Variables
#
#  - base root which Sun Java System Identity Server is being installed against
$base = "ROOT_SUFFIX";

#set these variables to the path of your ldapsearch and ldapmodify commands.
$LDAP_SEARCH="/opt/SUNWam/bin/ldapsearch";
$LDAP_MODIFY="/usr/iplanet/servers/shared/bin/ldapmodify";


sub readInput {
    my ($message, $datatype, $defaultvalue) = @_;

    $datatype = 'String' if $datatype eq '';

    $correct = 'true';
    do {
        if($defaultvalue eq '') {
            print "$message:";
        } else {
            print "$message \[$defaultvalue]:";
        }

        $_ = <STDIN>;
        chomp;

        # Check if the data type is correct
        if($datatype eq 'String') {
            if($_ eq '') {
                if($defaultvalue eq '') {
                    if($#_ < 2) {
                        $correct = 'false';
                    } else {
                        $correct = 'true';
                    }
                } else {
                    $correct = 'true';
                    $_ = $defaultvalue;
                }
            } else {
                $correct = 'true';
            }
        }

        if($datatype eq 'Integer') {
            if($_ eq '') {
                if($defaultvalue eq '') {
                    $correct = 'false';
                } else {
                    $correct='true';
                    $_ = $defaultvalue;
                }
            } else {
                if(/\D/) {
                    $correct = 'false';
                } else {
                    $correct = 'true';
                }
            }
        }

        if($datatype eq 'Password') {
            if($_ eq '') {
                if($defaultvalue eq '') {
                    if($#_ < 2) {
                        $correct = 'false';
                        print "\n";
                    } else {
                        $correct = 'true';
                    }
                } else {
                    $_ = $defaultvalue;
                }
            } else {
                $correct = 'true';
            }
        } else {
            $correct = 'true';
        }
    } until ($correct eq 'true');
    $_;
}

$host = readInput('Enter Host name', 'String', 'DIRECTORY_SERVER');
$bind_user = readInput('Enter Bind User name', 'String', 'cn=directory manager');
$bind_pwd = readInput('Enter Bind password', 'Password', '');
$port = readInput('Enter port number', 'Integer', 'DIRECTORY_PORT');
# Start of main program
#
# run search to find all org units, putting their DNs in to a file
system("$LDAP_SEARCH -h \"$host\" -p \"$port\" -D \"$bind_user\" -w \"$bind_pwd\" -b \"$base\" -s one -T \"(&(objectclass=organizationalUnit)(!(objectclass=iplanet-am-*))(!(objectclass=iPlanetService))(!(ou=services)))\" dn > orgunit-updated.dn");

# open DN file for reading
open (stdin, "orgunit-updated.dn") || die "can't open listing of user DNs $!";
open (UUL, ">orgunit-updated.ldif");

while (<>) {

  $line = $_;
  chomp ($line);

  ($attribute, $the_rest) = split (/\:/, $line);
  ($uid, $p_or_g, $domain, $affiliates, $siroe, $messaging, $root) = split (/,/, $the_rest);


  # remove the 'ou=' from before the actual domain value
  ($garbage, $final_domain) = split (/=/, $domain);

  #print "y$final_domain" . "y\n";

  if ($attribute eq "dn") {
    print UUL "$line\n";
    print UUL "changetype: modify\n";
    print UUL "add: objectclass\n";
    print UUL "objectclass: iplanet-am-managed-org-unit\n";
    print UUL "objectclass: sunNameSpace\n";
    print UUL "objectclass: inetDomain\n";
    print UUL "\n";
  }
}

close UUL;
#system("$LDAP_MODIFY -h'$host' -p'$port' -D'$bind_user' -w'$bind_pwd' -a -c -f orgunit-updated.ldif");
