#!/usr/bin/perl
# 
# Copyright  2002 Sun Microsystems, Inc. All rights reserved. 
# 
# U.S. Government Rights - Commercial software. Government users are subject 
# to the Sun Microsystems, Inc. standard license agreement and applicable 
# provisions of the FAR and its supplements. 
#
# Use is subject to license terms. 
#
#---------------------------------------------------------------------------
# This perl script is used to convert the iPlanetAMProviderConfigService 1.0 
# data in Identity Server 6.1 to iPlanetAMProviderConfigService 1.1 data in 
# Identity Server 2004Q2 
# The original iPlanetAMProviderConfigService 1.0 data is assumed to be stored
# in file is61meta.ldif. The converted result will be stored in file is62meta.ldif
# which can later be imported into Identity Server 2004Q2 directory using ldapmodify. 
#


# open is61meta.ldif file for reading
open(OLDDATA, "is61meta.ldif") || die "can't open listing of 6.1 data $!";
# open is62meta.ldif file for writing
open(NEWDATA, ">is62meta.ldif") || die "can't create ldif file for 2004Q2 data $!";

$prependdn = "";

while (<OLDDATA>) {
    $line1 = $_;
    chomp($line1);

    ($attr1, $the_rest1) = split (/\:/, $line1);
    if ($attr1 eq "dn") {
        $the_rest1 = substr($line1, 3);
        $the_rest1 =~ s/^ *//;
        ($dncomp1, $dncomp2, $dncomp3, $dncomp4, $the_rest2) = split (/\,/, $the_rest1);
        if ($dncomp1 ne "ou=default") {
            if ($dncomp2 eq "ou=default") {
                $the_rest1 =~ s/\,ou=1.0\,/\,ou=1.1\,/;
                print NEWDATA "dn: $the_rest1\n";
                print NEWDATA "sunsmspriority: 0\n";
                print NEWDATA "objectClass: top\n";
                print NEWDATA "objectClass: sunServiceComponent\n";
                print NEWDATA "sunserviceid: EntityDescriptor\n";
                print NEWDATA "sunkeyvalue: sunIdentityServerEntityType=urn:liberty:iff:provider\n";
                $ou_attr = $dncomp1;
                $ou_attr =~ s/^ou\=/ou: /;
                print NEWDATA "$ou_attr\n";
                print NEWDATA "\n";
               
                $prependdn=$dncomp1;
                $the_rest1 =~ s/\,ou=default\,/\,$prependdn\,ou=default\,/;
                print NEWDATA "dn: $the_rest1\n";  
                print NEWDATA "sunkeyvalue: sunIdentityServerAssertionConsumerServiceUrlisDefault=false\n";
            } else {
                $the_rest1 =~ s/\,ou=1.0\,/\,ou=1.1\,/;
                $the_rest1 =~ s/\,ou=default\,/\,$prependdn\,ou=default\,/;
                print NEWDATA "dn: $the_rest1\n";
            }
            while (<OLDDATA>) {
                $line2 = $_;
                chomp($line2);
                if ($line2 eq "") {
                    last;
                }
                print NEWDATA "$line2\n";
            }
            print NEWDATA "\n";
        }
    }
}

close OLDDATA;
close NEWDATA;

