<%--
    Copyright  2004 Sun Microsystems, Inc. All rights reserved
    Use is subject to license terms.
--%>


<html>
<%@include file="../base/AMBase.jsp" %>
<%@page info="AMNameValue" language="java"%>
<%@taglib uri="/WEB-INF/jato.tld" prefix="jato"%>
<%@taglib uri="/WEB-INF/console.tld" prefix="console"%>
<jato:useViewBean className="com.iplanet.am.console.base.AMNameValueViewBean">
<jsp:useBean id="viewBean" type="com.iplanet.am.console.base.AMNameValueViewBean" />

<head>
<title><jato:text name="titleHtmlPage" /></title>
<link rel="stylesheet" href="<%= consoleUrl %>css/adminstyle.css">

<script language="javascript" src="<%= consoleUrl %>js/consolecomp.js"></script>
<script language="javascript">
    function addToList() {
	var frm = document.forms["AMNameValue"];
	var list = frm.elements["AMNameValue.cbEntries"];
	var key = strTrim(frm.elements["key"].value);
	var value = strTrim(frm.elements["value"].value);

	if ((key != '') && (value != '')) {
	    var optList = list.options;
	    value = key + "=" + value;
	    var idx = getItemInList(list, key);

	    if (idx != -1) {
		optList[idx] = null;
	    }
	    optList[optList.length] = new Option(value, value);
	}
    }

    function getItemInList(list, name) {
	var optList = list.options;
	for (var i = 0; i < optList.length; i++) {
	    var value = optList[i].value;
	    var idx = value.indexOf('=');
	    if ((idx != -1) && (value.substring(0, idx) == name)) {
		return i;
	    }
	}
	return -1;
    }

    function setKeyValue() {
	var frm = document.forms["AMNameValue"];
	var list = frm.elements["AMNameValue.cbEntries"];
	var optList = list.options;

	for (var i = 0; i < optList.length; i++) {
	    var opt = optList[i];

	    if (opt.selected) {
		var idx = opt.value.indexOf('=');

		if (idx == -1) {
		    frm.elements["key"].value = opt.value;
		    frm.elements["value"].value = "";
		} else {
		    frm.elements["key"].value = opt.value.substring(0, idx);
		    frm.elements["value"].value = opt.value.substring(idx+1);
		}
		break;
	    }
	}
    }

    function updateValues() {
	var frm = document.forms["AMNameValue"];
	var values = concatenateValues(frm);

	if (values == "") {
	    alert("<jato:text name="msgListEmpty" />");
	    return;
	}

	var frmName = frm.elements['AMNameValue.fldForm'].value;
	var attrName = frm.elements['AMNameValue.fldAttr'].value;
	var type = frm.elements['AMNameValue.fldType'].value;
	var prevValue = frm.elements['AMNameValue.fldPrevValue'].value;
	var succeed = false;
	var profileFrm = null;
	var profileElm = null;

	if ((type == "edit") && (values == prevValue)) {
	    alert("<jato:text name="msgNoChange" />");
	    return;
	}

	if (window.opener) {
	    profileFrm = window.opener.document.forms[frmName];

	    if (profileFrm) {
		profileElm = profileFrm.elements[attrName];

		if (profileElm) {
		    succeed = true;
		}
	    }
	}

	if (succeed) {
	    if ((type == "add") || (type == "copy")) {
		window.opener.addNameValueAttr(frmName, attrName, values);
	    } else {
		window.opener.updateNameValueAttr(
		    frmName, attrName, prevValue, values);
	    }
	} else {
	    alert("<jato:text name="msgClosedProfileWin" />");
	}
	window.opener.focus();
	window.close();
    }

    function concatenateValues(frm) {
	var values = "";
	var list = frm.elements["AMNameValue.cbEntries"];
	var optList = list.options;

	for (var i = 0; i < optList.length; i++) {
	    if (optList[i].value != "") {
		if (values != "") {
		    values += "|";
		}
		values += optList[i].value;
	    }
	}

	return values;
    }
</script>
</head>

<body class="default-body" leftMargin="0" rightMargin="0" topMargin="0"
    marginheight="0" marginwidth="0">
<script language="javascript">
var pageLoaded = 0;
</script>
<console:form name="AMNameValue" method="post">
<jato:hidden name="fldForm" />
<jato:hidden name="fldAttr" />
<jato:hidden name="fldType" />
<jato:hidden name="fldPrevValue" />

<!-- page title -->
<console:dialogtitle name="lblSvcAttrName" imageURI="<%= consoleImages %>" />


<table border=0 cellspacing=2 cellpadding=2>
    <tr>
        <td colspan=3>
            <img src="../console/images/spacer.gif" height=10 alt="">
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td nowrap>
            <jato:text name="lblKey" />:
        </td>
        <td>
            <input name="key" size="12" type="text">
        </td>
        <td>
            <jato:text name="lblValue" />:
        </td>
        <td>
            <input name="value" size="12" type="text">
        </td>
        <td>
            <console:button name="btnAdd" type="mini" onClick="addToList(); return false;" />
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td>&nbsp;</td>
        <td colspan=3>
    	    <jato:listbox name="cbEntries" extraHtml="id='AMNameValue.cbEntries'" multiple="true" size="8" onChange="setKeyValue()" />
    	</td>
    	<td>
    	    <console:button name="btnDelete" type="mini" onClick="removeSelFromList('AMNameValue', 'AMNameValue.cbEntries'); return false;" />
    	</td>
    </tr>
</table>

<table border=0 cellspacing=0 cellpadding=0>
    <tr>
        <td width="1%">
            <img src="../console/images/spacer.gif" width=10 alt="">
        </td>
        <td width="98%" colspan=2>
            <hr noshade size="1">
        </td>
        <td width="1%">
            <img src="../console/images/spacer.gif" width=10 alt="">
        </td>
    </tr>
    <tr>
        <td width="1%">
            <img src="../console/images/spacer.gif" width=10 alt="">
        </td>
        <td width="97%" align="right">
            <console:button name="btnDone" onClick="updateValues(); return false;"/>
        </td>
        <td>
            <console:button name="btnCancel" onClick="window.close(); return false;"/>
        </td>
        <td width="1%">
            <img src="../console/images/spacer.gif" width=10 alt="">
        </td>
    </tr>
</table>

</console:form>
</body>
<script language="javascript">
pageLoaded = 1;
</script>

</jato:useViewBean>

</html>

