# Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
# 
# Sun Microsystems, Inc. has intellectual property rights relating to
# technology embodied in the product that is described in this document.
# In particular, and without limitation, these intellectual property rights
# may include one or more of the U.S. patents listed at
# http://www.sun.com/patents and one or more additional patents or pending
# patent applications in the U.S. and in other countries.
# 
# U.S. Government Rights - Commercial software. Government users are subject
# to the Sun Microsystems, Inc. standard license agreement and applicable
# provisions of the FAR and its supplements.
# 
# Use is subject to license terms. 
# 
# This distribution may include materials developed by third parties. Sun,
# Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
# registered trademarks of Sun Microsystems, Inc. in the U.S. and other
# countries. 
# 
# Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
# Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
#  la technologie incorpore dans le produit qui est dcrit dans ce document.
# En particulier, et ce sans limitation, ces droits de proprit
# intellectuelle peuvent inclure un ou plus des brevets amricains lists
#  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
# ou les applications de brevet en attente aux Etats - Unis et dans les
# autres pays.
# 
# L'utilisation est soumise aux termes du contrat de licence.
# 
# Cette distribution peut comprendre des composants dvelopps par des
# tierces parties.
# 
# Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
# de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
# Etats-Unis et dans d'autres pays.


    kill_nice() {
	    pid=$1

#	    eval /bin/kill $pid $LOG
	    /bin/kill $pid > $LOG 2>&1

	    count=0
	    max=10
	    while [ $count -lt $max ]; do
#		    eval /bin/ps -p $pid $LOG
		    /bin/ps -p $pid > $LOG 2>&1
		    if [ $? -ne 0 ]; then
			    return 0
		    else 
			    sleep 1
		    fi
		    count=`expr $count + 1`
	    done

#	    eval /bin/kill -9 $pid $LOG
	    /bin/kill -9 $pid > $LOG 2>&1
	    return 0
    }

    kill_list() {
	    for pid in "$@"; do
		    kill_nice $pid
	    done
    }

    stop_ws_instance() {
	check_for_ws
	if [ "$ws" = "no" ]; then
	    return
	fi

	server_base=$1
	server_instance=$2

	#
	# give ws stop script a chance to work
	#
#	eval $server_base/stop $LOG
	$server_base/stop > $LOG 2>&1
        if [ $? -ne 0 ]; then
          echo "`$gettext 'can not stop..may not be running...'`"
        fi

    }

    check_ssl() {
	CHECKIT=`grep com.iplanet.am.server.protocol $AMCONFIG | sed -e "s/com.iplanet.am.server.protocol=//"`	
	if [ "$CHECKIT" = "https" ]; then
	    ssl="on"
	else
	    ssl="off"
	fi
    }

    get_ssl_passphrase() {
      #echo "enter ssl passphrase: "    
      #read ssl_passphrase
      
      auto_ssl="off"
      if [ -f "$WTPASSFILE" ]; then
	ssl_passphrase=`cat $WTPASSFILE`
	auto_ssl="on"
      fi
    }

    start_ws_instance() {
	success=1
	server_base=$1
	server_instance=$2

	check_for_ws
	if [ "$ws" = "no" ]; then
	    return 1
	fi

#       check_ssl
#	if [ "$ssl" = "on" ] ; then
	    get_ssl_passphrase

#	    (eval $server_base/start $LOG) <<EOF
#$ssl_passphrase
#EOF
#	else
#	    (eval $server_base/start $LOG)&
#	fi
	if [ "$auto_ssl" = "on" ]; then
	    $server_base/start > $LOG 2>&1 << EOF
$ssl_passphrase
EOF
	else
	    $server_base/start
	fi
	if [ $? -eq 0 ]; then
	   success=0
	else
	   success=1
	fi

	return $success
    }
