/**
 * $Id: SampleUserOperations.java,v 1.6 2004/02/05 17:55:10 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

package com.iplanet.am.samples.sdk;

import java.io.*;
import java.net.*;
import java.util.*;
import com.iplanet.sso.*;
import com.iplanet.am.sdk.*;
import com.sun.identity.authentication.internal.*;
import javax.servlet.*;
import javax.servlet.http.*;


public class SampleUserOperations {

    SSOToken token = null;

    /**
     * This user will be used for further sample operations on the
     * same object
     */
    private static AMUser contextUser = null;
    private static String passWord = null;
    private static String uid = null;
    private static String lastName = null;
    private static String firstName = null;
    String userDN = null;

    private static Map scuObjMap = new HashMap();

    public static AMStoreConnection amsc = null;
    public static SampleUserOperations suo;

    public static void main(String args[]) {
        try {
            SSOTokenManager manager = SSOTokenManager.getInstance();
            SSOToken token = manager.createSSOToken(new AuthPrincipal("uid=amadmin,ou=People,o=iplanet.com,o=isp"), "netscape");
            suo = getSampleUserOperations(token);
            amsc = new AMStoreConnection(token);
            System.out.println(suo.createUser(amsc));
        } catch (Exception e) {
            System.out.println("Exception Message: " + e.getMessage());
            e.printStackTrace();
        }
    }


    /* Basic Constructor */

    public SampleUserOperations(SSOToken token) {
        this.token = token;
        scuObjMap.put(token, this);
    }

    /* Use the same  object for multiple operations */

    public static SampleUserOperations getSampleUserOperations(SSOToken token) {
        SampleUserOperations scuObj = (SampleUserOperations)scuObjMap.get(token);
        if (scuObj == null ) {
            scuObj = new SampleUserOperations(token);
        }
        return scuObj;
    }

  /**
   * This method will describe the SDK usage for creating a user.
   * It uses AMStoreConnection to get the organization object
   * It also uses the Set Parameters to store the different attributes of
   * the user. This method is used for command line.
   * It throws an AMException  if it's unble to create it and we throw
   * message "unable to create" to the GUI by catching the same
   */

    public String createUser(AMStoreConnection conn) {
        try {
            Map userAttributeMap = new HashMap();
                uid = "user";
                storeUserAttributes("uid", uid, userAttributeMap);
                firstName = "user";
                storeUserAttributes("givenname", firstName, userAttributeMap);
                lastName = "one";
                storeUserAttributes("sn", lastName, userAttributeMap);
                passWord = "userone";
                storeUserAttributes("userPassword", passWord, userAttributeMap);

            Map userMap1 = new HashMap();
            userMap1.put(uid, userAttributeMap);
            /**
             * Provide the DN according to the DIT
             */
            String dn = "ou=People,o=iplanet.com,o=isp";
            AMPeopleContainer ampc = conn.getPeopleContainer(dn);
            ampc.createUsers(userMap1);
            userDN = "uid=" + uid + "," + dn;
            /*
             * This is to keep the context of the user
             */
            contextUser = conn.getUser(userDN);
            return "Successfully added the user: " + uid;
        } catch (Exception ex) {
            ex.printStackTrace();
        }
          return "Unable to create";
    }

  /**
   * This method will describe the SDK usage for creating a user.
   * It uses AMStoreConnection to get the organization object
   * It also uses the Set Parameters to store the different attributes of 
   * the user.
   * It throws an AMException  if it's unble to create it and we throw
   * message "unable to create" to the GUI by catching the same
   */

    public String createUser(HttpServletRequest req, Set parameters, AMStoreConnection conn) {
        try {
            Map userAttributeMap = new HashMap();
            if (parameters.contains("uid")) {
                uid = req.getParameter("uid");
                storeUserAttributes("uid", uid, userAttributeMap);
            }
            if(parameters.contains("firstname")) {
                firstName = req.getParameter("firstname");
                storeUserAttributes("givenname", firstName, userAttributeMap);
            }
            if(parameters.contains("lastname")) {
                lastName = req.getParameter("lastname");
                storeUserAttributes("sn", lastName, userAttributeMap);
            }
            if(parameters.contains("password")) {
                passWord = req.getParameter("userPassword");
                storeUserAttributes("userPassword", passWord, userAttributeMap);
            }

            Map userMap1 = new HashMap();
            userMap1.put(uid, userAttributeMap);
            String orgDN = req.getParameter("orgName");
            String dn = "ou=People" + "," + orgDN;
            AMPeopleContainer ampc = conn.getPeopleContainer(dn);
            ampc.createUsers(userMap1);
            userDN = "uid=" + uid + "," + dn;
            /*
             * This is to keep the context of the user
             */
            contextUser = conn.getUser(userDN);
            return showCreateUserSuccess();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
          return "Unable to create";
    }

    /**
     * This method describes the SDK usage for modifying the user.
     */

    public String modifyUser(HttpServletRequest req) {
        HashMap modifyMap = new HashMap();
        lastName = req.getParameter("lastname");
        storeUserAttributes("sn", lastName, modifyMap);
        firstName = req.getParameter("firstname");
        storeUserAttributes("givenname", firstName, modifyMap);
        passWord = req.getParameter("userpassword");
        storeUserAttributes("userPassword", passWord, modifyMap);

        try {
            contextUser.setAttributes(modifyMap);
            contextUser.store();
            return showModifyUserSuccess();
        } catch (Exception ex) {
            System.out.println("Exception occured");
        }
        return "Unable to modify";
    }

    /**
     * This method describes the SDK usage for deleting the user.
     */

    public String deleteUser() {
        try {
            contextUser.delete(false);
            return "Deleted successfully";
        } catch (Exception ex) {
            System.out.println("Exception occured");
        }
        return "Unable to delete";
    }

    /* This method is for the GUI purposes */

    public String showCreateUser() {
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML>");
        sb.append("<HEAD>");
        sb.append("</HEAD>");
        sb.append("<BODY>");
        sb.append("<FORM name=\"allattributes\" METHOD=POST ACTION=\"/amserver/sdksample\">");
        sb.append("<TABLE>");
        sb.append("<TR>");
        sb.append("<TD ALIGN=LEFT VALIGN=MIDDLE><B>Login ID</B></TD>");
        sb.append("<TD VALIGN=MIDDLE><INPUT TYPE=\"text\" NAME=\"uid\" VALUE=\"\" SIZE=32 MAXLENGTH=64></TD><TD><B>Under Organization</B></TD>");
        sb.append("<TD VALIGN=MIDDLE><INPUT TYPE=\"text\" NAME=\"orgName\" VALUE=\"\" SIZE=32 MAXLENGTH=64></TD>");
        sb.append("</TR>");
        sb.append("<TR>");
        sb.append("<TD ALIGN=LEFT VALIGN=MIDDLE><B>First Name</B></TD>");
        sb.append("<TD VALIGN=MIDDLE><INPUT TYPE=\"text\" NAME=\"firstname\" VALUE=\"\" SIZE=32 MAXLENGTH=64></TD>");
        sb.append("</TR>");
        sb.append("<TR>");
        sb.append("<TD ALIGN=LEFT VALIGN=MIDDLE><B>Last Name</B></TD>");
        sb.append("<TD VALIGN=MIDDLE><INPUT TYPE=\"text\" NAME=\"lastname\" VALUE=\"\" SIZE=32 MAXLENGTH=64></TD>");
        sb.append("</TR>");
        sb.append("<TR>");
        sb.append("<TD ALIGN=LEFT VALIGN=MIDDLE><B>Password</B></TD>");
        sb.append("<TD VALIGN=MIDDLE><INPUT TYPE=\"password\" NAME=\"userpassword\" VALUE=\"\" SIZE=12></TD>");
        sb.append("</TR>");
        sb.append("<TR>");
        sb.append("<TD ALIGN=LEFT VALIGN=MIDDLE><B>Confirm Password</B></TD>");
        sb.append("<TD VALIGN=MIDDLE><INPUT TYPE=\"password\" NAME=\"passwordagain\" VALUE=\"\" SIZE=12></TD>");
        sb.append("</TR>");
        sb.append("<TR>");
        sb.append("<TD><input type=SUBMIT NAME=\"usersubmit\">");
        sb.append("</TD></TR>");
        sb.append("</TABLE>");
        sb.append("</FORM>");
        sb.append("</BODY>");
        sb.append("</HTML>");
        return sb.toString();
    }

    private void storeUserAttributes(String attribute, String value, Map userMap) {
        Set userSet = new HashSet();
        userSet.add(value);
        userMap.put(attribute, userSet);
    }

    /* This method is for the GUI purposes */

    private String showCreateUserSuccess() {
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML>");
        sb.append("<HEAD>");
        sb.append("</HEAD>");
        sb.append("<BODY>");
        sb.append("Created Successfully");
        sb.append("<FORM name=\"usersuccessful\" METHOD=POST ACTION=\"/amserver/sdksample\">");
        sb.append("<TABLE>");
        sb.append("<TR>");
        sb.append("<TD><input type=SUBMIT NAME=\"modifyuser\" VALUE=\"Modify\">");
        sb.append("</TD></TR>");
        sb.append("</TABLE>");
        sb.append("</FORM>");
        sb.append("</BODY>");
        sb.append("</HTML>");
        return sb.toString();
    }

    /* This method is for the GUI purposes */

    public String showModifyUser() {
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML>");
        sb.append("<HEAD>");
        sb.append("</HEAD>");
        sb.append("<BODY>");
        sb.append("uid:" + uid);
        sb.append("<FORM name=\"showmodify\" METHOD=POST ACTION=\"/amserver/sdksample\">");
        sb.append("<TABLE>");
        sb.append("<TR>");
        sb.append("<TD ALIGN=LEFT VALIGN=MIDDLE><B>First Name</B></TD>");
        sb.append("<TD VALIGN=MIDDLE><INPUT TYPE=\"text\" NAME=\"firstname\" VALUE=\"");
        sb.append(firstName + "\" SIZE=32 MAXLENGTH=64></TD>");
        sb.append("</TR>");
        sb.append("<TR>");
        sb.append("<TD ALIGN=LEFT VALIGN=MIDDLE><B>Last Name</B></TD>");
        sb.append("<TD VALIGN=MIDDLE><INPUT TYPE=\"text\" NAME=\"lastname\" VALUE=\"");
        sb.append(lastName + "\" SIZE=32 MAXLENGTH=64></TD>");
        sb.append("</TR>");
        sb.append("<TR>");
        sb.append("<TD ALIGN=LEFT VALIGN=MIDDLE><B>Password</B></TD>");
        sb.append("<TD VALIGN=MIDDLE><INPUT TYPE=\"password\" NAME=\"userpassword\" VALUE=\"");
        sb.append(passWord + "\" SIZE=12></TD>");
        sb.append("</TR>");
        sb.append("<TR>");
        sb.append("<TD><input type=SUBMIT NAME=\"modifyusersubmit\">");
        sb.append("</TD></TR>");
        sb.append("</TABLE>");
        sb.append("</FORM>");
        sb.append("</BODY>");
        sb.append("</HTML>");
        return sb.toString();
    }

    /* This method is for the GUI purposes */

    private String showModifyUserSuccess() {
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML>");
        sb.append("<HEAD>");
        sb.append("</HEAD>");
        sb.append("<BODY>");
        sb.append("Modified Successfully");
        sb.append("<FORM name=\"modifyusersuccessful\" METHOD=POST ACTION=\"/amserver/sdksample\">");
        sb.append("<TABLE>");
        sb.append("<TR>");
        sb.append("<TD><input type=SUBMIT NAME=\"deleteusersubmit\" VALUE=\"Delete\">");
        sb.append("</TD></TR>");
        sb.append("</TABLE>");
        sb.append("</FORM>");
        sb.append("</BODY>");
        sb.append("</HTML>");
        return sb.toString();
    }

    /* This method is for the GUI purposes */

    public String showDeleteUser() {
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML>");
        sb.append("<HEAD>");
        sb.append("</HEAD>");
        sb.append("<BODY>");
        sb.append("<FORM name=\"showdelete\" METHOD=POST ACTION=\"/amserver/sdksample\">");
        sb.append("<TABLE>");
        sb.append("<TR>");
        sb.append("<TD><input type=SUBMIT NAME=\"deleteusersubmit\">");
        sb.append("</TD></TR>");
        sb.append("</TABLE>");
        sb.append("</FORM>");
        sb.append("</BODY>");
        sb.append("</HTML>");
        return sb.toString();
    }

}
