/**
 * $Id: SDKSampleServlet.java,v 1.5 2004/02/05 17:55:10 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

package com.iplanet.am.samples.sdk;

import java.net.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;
import com.iplanet.sso.*;
import com.iplanet.services.ldap.*;
import com.iplanet.am.sdk.*;
import com.iplanet.am.util.Debug;
import com.iplanet.am.samples.sdk.*;


public class SDKSampleServlet extends HttpServlet {

    ServletOutputStream out;
    public static SampleUserOperations suo;
    public static SampleRoleOperations sro;
    public static SampleOrgOperations soo;
    public static AMStoreConnection amsc = null;
    String attrName = null;
    String attrValue = null;
    Debug debug = Debug.getInstance("amAuth");


    public void init() throws ServletException {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response){
       doGetPost(request, response);
    }
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
    doGetPost(request, response);
    }

    public void doGetPost(HttpServletRequest request, HttpServletResponse response){
     
        Set paramsSet = new HashSet();
        try {
	    response.setContentType("text/html");
            out = response.getOutputStream();
	    out.println("\n");


            /* create the sso token from http requeest */
            SSOTokenManager manager = SSOTokenManager.getInstance();
            SSOToken token = manager.createSSOToken(request);

            /* use isValid to method to check if the token is valid or not
             * this method retuns true for valid token, false otherise
             */
            if (manager.isValidToken(token)) {
	        amsc = new AMStoreConnection(token);
                Enumeration parameters = request.getParameterNames();
	        while(parameters.hasMoreElements()) {
		    paramsSet.add((String)parameters.nextElement());
		 }
 		 if(paramsSet.isEmpty()) {
		     showAllOptions();
		 }

		 if (paramsSet.contains("createuser")) {
		     suo = SampleUserOperations.getSampleUserOperations(token);
		     out.println(suo.showCreateUser());
		 } else if (paramsSet.contains("modifyuser")) {
		     suo = SampleUserOperations.getSampleUserOperations(token);
		     out.println(suo.showModifyUser());
		 } else if (paramsSet.contains("usersubmit")) { 
		     suo = SampleUserOperations.getSampleUserOperations(token);
		     out.println(suo.createUser(request, paramsSet, amsc));
		 } else if (paramsSet.contains("modifyusersubmit")) {
		     suo = SampleUserOperations.getSampleUserOperations(token);
		     out.println(suo.modifyUser(request));
	         } else if (paramsSet.contains("deleteusersubmit")) {
		     suo = SampleUserOperations.getSampleUserOperations(token);
		     out.println(suo.deleteUser());
		 } else if (paramsSet.contains("createroleform")) {
		     sro = SampleRoleOperations.getSampleRoleOperations(token);
	             out.println(sro.showCreateRole());
		 } else if (paramsSet.contains("createrole")) {
		     sro = SampleRoleOperations.getSampleRoleOperations(token);
	             out.println(sro.createRole(request, paramsSet, amsc));
		 } else if (paramsSet.contains("addusertorole")) {
		     sro = SampleRoleOperations.getSampleRoleOperations(token);
	             out.println(sro.addUsertoRole(request));
		 } else if (paramsSet.contains("createorgform")) {
		     soo = SampleOrgOperations.getSampleOrgOperations(token);
		     out.println(soo.showCreateOrg());
		 } else if (paramsSet.contains("createorg")) {
		     soo = SampleOrgOperations.getSampleOrgOperations(token);
		     out.println(soo.createOrg(request, amsc));
                 } else if (paramsSet.contains("addservice")) {
                      soo = SampleOrgOperations.getSampleOrgOperations(token);
                      out.println(soo.registerService(request, amsc));
                 } else if (paramsSet.contains("getregisteredservice")) {
                      soo = SampleOrgOperations.getSampleOrgOperations(token);
                      out.println(soo.getRegisteredServices(request, amsc));
                 }
            }  
            out.flush();
        } catch (Exception e) {
            System.out.println("Exception Message: " + e.getMessage());
            e.printStackTrace();
        }
    } 

    /* This method is for the GUI purposes */

    public void showAllOptions() {

        try {
            StringBuffer sb = new StringBuffer();
            sb.append("<HTML>");
            sb.append("<BODY>");
            sb.append("<FORM name=\"userbased\" METHOD+POST ACTION=\"/amserver/sdksample\">");
            sb.append("<TABLE>");
            sb.append("<TR>");
            sb.append("<TD><input type=SUBMIT NAME=\"createuser\" VALUE=\"Create User\"></TD>");
            sb.append("<TD><input type=SUBMIT NAME=\"createorgform\" VALUE=\"Create Organization\"></TD>");
            sb.append("<TD><input type=SUBMIT NAME=\"createroleform\" VALUE=\"Create Role\"></TD>");
            sb.append("</TABLE>");
            sb.append("</BODY></HTML>");
            out.println(sb.toString());
        } catch (Exception ex) {
	    System.out.println("Failed");
        }
    }

}
