/**
 * $Id: TestHttpsClient.java,v 1.5 2004/02/05 17:55:13 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

import java.net.*;
import java.io.*;
import com.iplanet.services.comm.https.*;

/**
 * This example will describe the usage of Https Client for the SSL Configured
 * DSAME Server. We need to form an URL with custom ssl protocol handler before
 * opening an http url connection. 
 * Please include am_sdk.jar, jss3.jar AMConfig.properties and 
 * amUtilMessages.properties in the classpath
 * set LD_LIBRARY_PATH to jss libraries (i.e. Webserver lib directory, $PRODUCT
 * DIR/servers/bin/https/lib if it is web server, or $PRODUCT_DIR/lib/solaris/
 * sparc/lib/ias if it is iAS
 */



public class TestHttpsClient {

    TestHttpsClient() {
    }

    // Get the protol handler from the one supplied by the dsame
    public Handler getHandler() {
       return new Handler();
    }

    public static void main(String[] args) {
      
      try {
	  TestHttpsClient th = new TestHttpsClient();
	  OutputStream out = null;
	  /* 
           * form the url with https protocol handler
           */
          URL url = new URL(null, "https://shivalik.red.iplanet.com:8080/amconsole", th.getHandler());

          HttpURLConnection conn = (HttpURLConnection)url.openConnection();
          conn.setDoOutput(true);
	  out = conn.getOutputStream();
          out.write("test".getBytes("UTF-8"));
	  out.flush();

	  BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));

	  System.out.println("Has it worked");
      } catch (Exception ex) {
	  ex.printStackTrace();
          System.out.println("Excfeption occured");
      }
    }
}
