/**
 * $Id: SSOTokenSampleServlet.java,v 1.7 2004/02/05 17:55:13 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

import java.net.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.iplanet.sso.*;

/**
 * This Sample serves as a basis for using SSO API. It demonstrates creating
 * a SSO Token, calling various methods from the token, setting up event 
 * listeners and getting called on event listeners. For detailed info refer to the
 * Readme.txt
 *
 * @see com.iplanet.sso.SSOToken
 * @see com.iplanet.sso.SSOTokenID
 * @see com.iplanet.sso.SSOTokenManager
 * @see com.iplanet.sso.SSOTokenEvent
 * @see com.iplanet.sso.SSOTokenListener
 */

public class SSOTokenSampleServlet extends HttpServlet {

    public void init() throws ServletException {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response){
     
        ServletOutputStream out = null;
        try {

            out = response.getOutputStream();
            /* create the sso token from http requeest */
            SSOTokenManager manager = SSOTokenManager.getInstance();
            SSOToken token = manager.createSSOToken(request);

            /* use isValid to method to check if the token is valid or not
             * this method retuns true for valid token, false otherise
             */
            if (manager.isValidToken(token)) {
                /* let us get all the values from the token */

                String host = token.getHostName();
                java.security.Principal principal = token.getPrincipal();
                String authType = token.getAuthType();
                int level = token.getAuthLevel();
                InetAddress ipAddress = token.getIPAddress();
                long maxTime = token.getMaxSessionTime();
                long idleTime = token.getIdleTime();
                long maxIdleTime = token.getMaxIdleTime();
                long timeLeft = token.getTimeLeft();
                out.println("SSOToken host name: " + host);
                out.println("SSOToken Principal name: " + principal.getName());
                out.println("Authentication type used: " + authType);
                out.println("IPAddress of the host: " + 
                          ipAddress.getHostAddress());
            }  
            /* let us try to validate the token again, with another method 
             * if token is invalid, this method throws excpetion
             */
            manager.validateToken(token);

            /* let us get the SSOTokenID associated with the token */
            SSOTokenID tokenId = token.getTokenID();
   
            String id = tokenId.toString();

            /* print the string representation of the token */

            out.println("The token id is " + id);

            /* let us set some properties in the token. We can get the values
             * of set properties later
             */
            token.setProperty("Company", "Sun Microsystems");
            token.setProperty("Country", "USA");
            String name = token.getProperty("Company");
            String country = token.getProperty("Country");

            out.println("Property: Company is - " + name); 
            out.println("Property: Country is - " + country); 

            out.println("SSO Token Validation test Succeeded");
            /* let us add a listener to the SSOToken. Whenever a token
             * event arrives, ssoTokenChanged method of the listener will
             * get called.
             */
            SSOTokenListener myListener = new SampleTokenListener();

            token.addSSOTokenListener(myListener);
                 out.flush();
        } catch (com.iplanet.sso.SSOException e) {
            try {
                out.println("SSO Exception Invalid Session: " + e.getMessage());
                e.printStackTrace();
                out.flush();
            }catch (Exception ee) {
            }
        } catch (Exception e) {
            try {
                out.println("rException Message: " + e.getMessage());
                out.println("Exception Message: " + e);
                e.printStackTrace();
                out.flush();
            }catch (Exception ee) {
            }
        }
    }    

}
