/**
 * $Id: SDKCommandLineSSO.java,v 1.3 2004/02/05 17:55:12 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

import java.net.*;
import com.iplanet.sso.*;
import com.sun.identity.authentication.internal.*;
import com.sun.identity.authentication.AuthContext;
import com.iplanet.am.sdk.*;
import java.util.*;

public class SDKCommandLineSSO {

    public static void main(String args[]) throws Exception {

        // Direct LDAP bind to create an SSOToken. This type of SSO does
        // not create a session in the Identity Session Server. This
        // session will not live outside this process.

        SSOTokenManager manager = SSOTokenManager.getInstance();
        SSOToken token = manager.createSSOToken(new AuthPrincipal(args[0]), args[1]);
        String userDN = token.getPrincipal().getName();
        System.out.println("User : " + userDN);

        // Get a connection to the Identity Store and retrieve the attributes for
        // the user DN in the token. The userDN could be any user DN to which the
        // user in the SSOToken has read access. We use the authenticated user
        // as a sample.

        AMStoreConnection conn = new AMStoreConnection(token);
        AMUser user = conn.getUser(userDN);
        Map attrs = user.getAttributes();

        System.out.println("Attrs: " + attrs);
        System.exit(1);
    }
}
