/**
 * $Id: CreateSignature.java,v 1.5 2004/02/05 17:55:08 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */
import java.io.*;
import java.util.*;
import java.security.KeyStore;
import java.security.cert.*;
import java.security.PrivateKey;
import java.security.PublicKey; 
import java.security.cert.X509Certificate;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.xml.sax.SAXException;
import org.xml.sax.InputSource;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.c14n.*;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.*;
import org.apache.xml.security.keys.*;
import org.apache.xml.security.keys.content.*;
import org.apache.xml.security.keys.content.x509.*;
import org.apache.xml.security.keys.storage.*;
import org.apache.xml.security.keys.storage.implementations.*;
import org.apache.xml.security.utils.*;
import org.apache.xml.security.transforms.*;
import org.apache.xml.security.Init;
import com.sun.identity.saml.common.*;
import com.sun.identity.saml.xmlsig.*;
import com.sun.identity.saml.assertion.*; 
import com.iplanet.am.util.SystemProperties;

public class CreateSignature {  
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        String Filename = "assertion.xml"; 
        String signatureFile = "signature.xml";  
        switch  (args.length) {
            case 1: 
                Filename = args[0];
                break; 
            case 2: 
                Filename = args[0]; 
                signatureFile = args[1]; 
                break; 
        }
            
        try {
            Assertion assertion = null;       
            // call default keyprovider, user can plug in their own keyprovider. 
            JKSKeyProvider keys= new JKSKeyProvider();
            // call default signatureprovider, user can plug in their own 
            // signature provider. 
            AMSignatureProvider asp = new AMSignatureProvider(); 
            XMLSignatureManager sm = XMLSignatureManager.getInstance(keys, asp);
  
            //build xml block 
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            DocumentBuilder _documentBuilder = null;
            fac.setNamespaceAware(true);
            _documentBuilder = fac.newDocumentBuilder();
            
            //Read xml file 
            InputSource is = new InputSource(new FileReader(Filename));
            Document doc = _documentBuilder.parse(is);
            Element element = doc.getDocumentElement();
            if (element == null) {
                System.out.println("Error: Input element is null");
                return;
            }      
          
            Assertion assertionInstance = new Assertion(element);
            System.out.println("=====The original input to be signed: ===="); 
            System.out.println(assertionInstance.toString(true, true)); 
            System.out.println("==========================================");    
            
            /**
             * call signXML(doc, certalias) 
             */
            System.out.println("Start signing ......"); 
            Element ele = sm.signXML(doc, SystemProperties.get(
                          "com.sun.identity.saml.xmlsig.certalias"));
            element.appendChild(ele); 
            FileOutputStream f = new FileOutputStream(signatureFile);
            org.apache.xml.security.utils.XMLUtils.outputDOMc14nWithComments(doc, f);
            f.close();
            System.out.println("Complete siging.");
            System.out.println("Signature is saved in " + signatureFile + 
                               " file.");
        } catch (Exception ex) {
            System.out.println("CreateSignature Error: " + ex.getMessage());
            ex.printStackTrace(); 
            System.exit(0);
        }
        System.exit(0);
    }
}
