/**
 * $Id: SampleAttributeMapper.java,v 1.5 2004/02/05 17:55:06 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

import com.sun.identity.saml.plugins.*;
import com.sun.identity.saml.assertion.*;
import com.sun.identity.saml.protocol.AttributeQuery;
import com.sun.identity.saml.common.*;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOException;

import com.iplanet.am.sdk.*;
import com.sun.identity.sm.*;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.MissingResourceException;

/**
 * The class <code>SampleAttributeMapper</code> provide a sample
 * implementation of the <code>AttributeMapper</code> interface. 
 */
public class SampleAttributeMapper implements AttributeMapper {

    /**
     * Default Constructor
     */
    public SampleAttributeMapper() {}

    /**
     * This method exams the SubjectConfirmation of the Subject in the
     * AttributeQuery. If it has only one ConfirmationMethod, and this
     * ConfirmationMethod equals to "urn:com:sun:identity"; and its
     * SubjectConfirmationData contains TEXT node only, then the method
     * returns the concatenated string of all the TEXT nodes. Otherwise,
     * it returns null.
     * <p>
     * @see com.sun.identity.saml.plugins.AttributeMapper#getSSOTokenID
     */
    public String getSSOTokenID(AttributeQuery query) {
	if (query == null) {
	    return null;
	}
	SubjectConfirmation sc = query.getSubject().getSubjectConfirmation();
	if (sc == null) {
	    return null;
	}

	Set cmSet = sc.getConfirmationMethod();
	if ((cmSet == null) || (cmSet.size() != 1)) {
	    return null;
	}

	String conMethod = (String) cmSet.iterator().next();
	if ((conMethod == null) ||
	    (!conMethod.equals("urn:com:sun:identity")))
	{
	    return null;
	}

	Element scData = sc.getSubjectConfirmationData();
	if (scData == null) {
	    return null;
	}
	StringBuffer sb = new StringBuffer(1000);
	try {
	    NodeList nl = scData.getChildNodes();
	    Node child = null;
	    for (int i = 0, length = nl.getLength(); i < length; i++) {
		child = nl.item(i);
		if (child.getNodeType() == Node.TEXT_NODE ) {
		    sb.append(child.getNodeValue());
		} else {
		    return null;
		}
	    }
	} catch (Exception e) {
	    return null;
	}

	return sb.toString().trim();
    }

    /**
     * This method exams the SubjectConfirmationData of the Subject in the
     * AttributeQuery. It returns the first Assertion that contains at least
     * one AuthenticationStatement.
     * <p>
     * @see com.sun.identity.saml.plugins.AttributeMapper#getSSOAssertion
     */
    public Assertion getSSOAssertion(AttributeQuery query) {
	if (query == null) {
	    return null;
	}
	SubjectConfirmation sc = query.getSubject().getSubjectConfirmation();
	if (sc == null) {
	    return null;
	}
	Element scData = sc.getSubjectConfirmationData();
	if (scData == null) {
	    return null;
	}
	Assertion assertion = null;
	try {
	    NodeList nl = scData.getChildNodes();
	    Node child = null;
	    for (int i = 0, length = nl.getLength(); i < length; i++) {
		child = nl.item(i);
		if (child.getNodeType() == Node.ELEMENT_NODE ) {
		    try {
			assertion = new Assertion((Element) child);
			if (isAuthNAssertion(assertion)) {
			    return assertion;
			}
		    } catch (SAMLException se) {}
		}
	    }
	} catch (Exception e) {}
	return null;
    }

    private boolean isAuthNAssertion(Assertion assertion) {
	if (assertion == null) {
	    return false;
	}

	if ((!assertion.isTimeValid()) || (!assertion.isSignatureValid())) {
	    return false;
	}

	Set statements = assertion.getStatement();
	Statement statement = null;
	Iterator iterator = statements.iterator();
	while (iterator.hasNext()) {
	    statement = (Statement) iterator.next();
	    if (statement.getStatementType() ==
					Statement.AUTHENTICATION_STATEMENT)
	    {
		return true;
	    }
	} // loop through statements
	return false;
    }

    /**
     * This method first find the user name from the Subject in the query.
     * In this sample implementation, the Subject must contain a NameIdentifier.
     * It then calls the User Management API to obtain the attribute value
     * using the SSOToken and the attribute name in the AttributeDesignator(s)
     * of the query. If there is no AttributeDesignator in the query,
     * attributes from iPlanetAMUserService will be returned.
     * <p>
     * @see com.sun.identity.saml.plugins.AttributeMapper#getAttributes
     */
    public List getAttributes(AttributeQuery query, String sourceID,
				SSOToken token) throws SAMLException
    {
	if ((query == null) || (sourceID == null) || (token == null)) {
	    throw new SAMLException("input is null.");
	}

	NameIdentifier ni = query.getSubject().getNameIdentifier();
	String name = null;
	if ((ni == null) || ((name = ni.getName()) == null)) {
	    throw new SAMLException("Cannot find user name.");
	}

	AMUser user = null;
	try {
	    AMStoreConnection conn = new AMStoreConnection(token);
	    user = conn.getUser(name);
	} catch (SSOException ssoe) {
	    throw new SAMLException(ssoe.getMessage());
	}

	List attributes = new ArrayList();
	Attribute attribute = null;
	Set valueSet = null;
	Iterator valueIter = null;
	List designators = query.getAttributeDesignator();
	if ((designators == null) || (designators.isEmpty())) {
	    Map valueMap = null;
	    String service = "iPlanetAMUserService";
	    try {
		Set userAttributes = new HashSet();
		ServiceSchemaManager ssm = new ServiceSchemaManager(
							service, token);
		ServiceSchema sm = ssm.getSchema(SchemaType.USER);
		if (sm != null) {
		    userAttributes.addAll(sm.getAttributeSchemaNames());
		}
		sm = ssm.getSchema(SchemaType.DYNAMIC);
		if (sm != null) {
		    userAttributes.addAll(sm.getAttributeSchemaNames());
		}
		valueMap = user.getAttributes(userAttributes);
	    } catch (Exception e) {
		throw new SAMLException(e.getMessage());
	    }
	    Set keySet = valueMap.keySet();
	    String keyName = null;
	    Iterator keyIter = keySet.iterator();
	    while (keyIter.hasNext()) {
		keyName = (String) keyIter.next();
		valueSet = (Set) valueMap.get(keyName);
		if (valueSet.isEmpty()) {
		    continue;
		}
		valueIter = valueSet.iterator();
		attribute = new Attribute(keyName, service,
						(String) valueIter.next());
		while (valueIter.hasNext()) {
		    attribute.addAttributeValue((String) valueIter.next());
		}
		attributes.add(attribute);
	    }
	} else {
	    Iterator iter = designators.iterator();
	    AttributeDesignator designator = null;
	    String attrName = null;
	    while (iter.hasNext()) {
		designator = (AttributeDesignator) iter.next();
		attrName = (String) designator.getAttributeName();
		try {
		    valueSet = user.getAttribute(attrName);
		} catch (Exception e) {
		    throw new SAMLException(e.getMessage());
		}

		if (valueSet.isEmpty()) {
		    continue;
		}
		valueIter = valueSet.iterator();
		attribute = new Attribute(attrName,
			designator.getAttributeNamespace(),
			(String) valueIter.next());
		while (valueIter.hasNext()) {
		    attribute.addAttributeValue((String) valueIter.next());
		}
		attributes.add(attribute);
	    }
	}
	return attributes;
    }
}
