/**
 * $Id: SAMLQueryServlet.java,v 1.5 2004/02/05 17:55:06 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

import java.net.*;
import java.io.*;
import java.text.*;
import java.util.*;

import javax.servlet.http.*;
import javax.servlet.*;

import javax.xml.messaging.*;
import javax.xml.soap.*;

import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.common.*;
import com.sun.identity.saml.protocol.*;
import com.sun.identity.saml.assertion.*;
import com.sun.identity.sm.*;
import com.iplanet.sso.*;

import org.w3c.dom.*;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;


/**
 * This is a sample to test SAML query. Please see the README file in the
 * same directory as this file for more explanation.
 */
public class SAMLQueryServlet extends HttpServlet {
    StringBuffer retval = null;
    
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init( servletConfig );
    }
    
    public void doGet(HttpServletRequest req, HttpServletResponse resp)
    throws ServletException {
        
        retval = new StringBuffer(1000);
	retval.append("<html><H4>");
        ServletOutputStream sos=null;

        try {
            sos = resp.getOutputStream();
	    resp.setContentType("text/html");

            // create the sso token from http request
            SSOTokenManager manager = SSOTokenManager.getInstance();
            SSOToken token = manager.createSSOToken(req);

	    // form an AuthenticationQuery
	    NameIdentifier ni = new NameIdentifier(
					token.getPrincipal().getName(),
					token.getProperty("Organization"));
	    SubjectConfirmation sc = new SubjectConfirmation(
					"urn:com:sun:identity");
	    sc.setSubjectConfirmationData(token.getTokenID().toString());
	    Subject subject = new Subject(ni, sc);
	    AuthenticationQuery authNQuery = new AuthenticationQuery(subject);
	    List contents = new ArrayList();
	    contents.add(authNQuery);
	    // passing null so SAML sdk could create requestID
	    Request request = new Request(null, contents);
	    retval.append("The SAML Request to be sent is:\n").
		append(displayXML(request.toString()));
	    SOAPMessage msg = FormMessageRequest(request);

	    // Create an endpoint for the recipient of the message.
	    // In this sample, it is the IS server that hosts this servlet.
            StringBuffer urlSB=new StringBuffer();
            urlSB.append(req.getScheme()).append("://").
		  append(req.getServerName());
            urlSB.append( ":" ).append( req.getServerPort() ).
		  append( req.getContextPath() );
            String reqBase=urlSB.toString();
            String receiverURL = reqBase+"/SAMLSOAPReceiver";
	    retval.append("\n<HR>\nThe SOAP endpoint is: ").append(receiverURL);
            URLEndpoint urlEndpoint  = new URLEndpoint(receiverURL);

	    // send the SOAP message and get the reply
	    SOAPMessage reply = sendMessage(msg, urlEndpoint);

	    // get the SAML response
	    Response response = processAndPrintReply(reply);
	    if (response == null) {
		retval.append("</H4></html>");
	    } else {
		retval.append("\n<HR>\nThe response received is:\n").
		    append(displayXML(response.toString()));
		// prepare the Attribute Query
		Iterator iter = response.getAssertion().iterator();
		StringBuffer assertionStr = new StringBuffer(1000);
		while (iter.hasNext()) {
		    assertionStr.append(
			((Assertion) iter.next()).toString(true, true));
		} 
		sc.setSubjectConfirmationData(assertionStr.toString());
		AttributeQuery attrQuery = new AttributeQuery(subject);
		contents = new ArrayList();
		contents.add(attrQuery);
		request = new Request(null, contents);
		retval.append("\n<HR>\nThe SAML Request to be sent is:\n").
		    append(displayXML(request.toString()));
		msg = FormMessageRequest(request);
		// send the SOAP message and get the reply
		reply = sendMessage(msg, urlEndpoint);
		// get the SAML response
		response = processAndPrintReply(reply);
		if (response == null) {
		    retval.append("</H4></html>");
		} else {
		    retval.append("\n<HR>\nThe response received is:\n").
			append(displayXML(response.toString())).
			append("</H4></html>");
		}
	    }
        } catch(Exception e) {
            retval.append("\nThere was an error ").
		append("in constructing or sending message.").
		append("The exception was: ").append(e.getMessage()).
		append("</H4> </html>");
        }
        try {
            sos.println(retval.toString());
            sos.flush();
            sos.close();
        } catch (IOException e) {
            retval.append("\nThere was an error ").
		append("in constructing or sending message.").
		append("The exception was: ").append(e.getMessage()).
		append("</H4> </html>");
        }
    }

    private SOAPMessage FormMessageRequest(Request request) {
	SOAPMessage msg = null;
	MimeHeaders mimeHeaders = new MimeHeaders();
        mimeHeaders.addHeader("Content-Type","text/xml");
	try {
	    StringBuffer sb = new StringBuffer(1000);
	    sb.append("<soap-env:Envelope xmlns:soap-env=").
		append("\"http://schemas.xmlsoap.org/soap/envelope/\">\n").
		append("<soap-env:Body>\n").
		append(request.toString()).
		append("</soap-env:Body>\n</soap-env:Envelope>\n");
	    ByteArrayOutputStream bop = new ByteArrayOutputStream();
	    bop.write(sb.toString().getBytes("UTF-8"));
            MessageFactory fac = MessageFactory.newInstance();
	    msg = fac.createMessage(mimeHeaders, new ByteArrayInputStream(
			bop.toByteArray()));
	} catch (Exception e ) {
	    retval.append("\ncould not build request:").append(e.getMessage());
	}
        return msg; 
    }
    
    private SOAPMessage sendMessage(SOAPMessage msg, URLEndpoint endPoint)
    {
	SOAPMessage reply = null;
        try {
	    SOAPConnectionFactory scf = SOAPConnectionFactory.newInstance();
            SOAPConnection con = scf.createConnection();
	    reply = con.call(msg, endPoint);
        } catch(Exception e) {
	    retval.append("\ncould not send or receive the message:").
		append(e.getMessage());
	    reply = null;
        }
	return reply;
    }

    private Response processAndPrintReply(SOAPMessage reply) {
	Response response = null;
	try {
            if (reply != null) {
		ByteArrayOutputStream bop = new ByteArrayOutputStream();
		reply.writeTo(bop);
		String xmlString = bop.toString("UTF-8");
		Document doc = toDOMDocument(xmlString);
		Element elt = doc.getDocumentElement();
	        String rootName  = elt.getLocalName();
	        if ((rootName == null) || (rootName.equals(""))) {
		    retval.append("\nSOAP-ENV:Evelope tag is missing in the").
			append(" message that replied by the SOAP-Receiver."); 
                    return null;
	        }
	        if (!(rootName.equals("Envelope")) ||
	           (!(elt.getNamespaceURI().equals(
			"http://schemas.xmlsoap.org/soap/envelope/"))))
		{
		    retval.append("\nSOAP-ENV:Evelope tag or the namespace is").
			append(" wrong in the message that replied by ").
			append("SOAP-Receiver."); 
		    return null;
		}
            
                //exam the children elements of <SOAP-ENV:Envelope>
                org.w3c.dom.NodeList  nodes = elt.getChildNodes();
                int nodeCount = nodes.getLength();
                if (nodeCount <= 0) {
                    retval.append("\nSOAP-ENV:Evelope does not contain a ").
		        append("SOAP body."); 
                    return null;
                }
                for (int i = 0; i < nodeCount; i++) {
                    org.w3c.dom.Node currentNode = nodes.item(i);
                    if (currentNode.getNodeType() == 
			org.w3c.dom.Node.ELEMENT_NODE) 
		    {
                        String tagName = currentNode.getLocalName();
                        String tagPrefix = 
			    currentNode.getPrefix().toUpperCase(); 
                        if ((tagName == null) || tagName.equals("") ||
                           (tagPrefix == null) || tagPrefix.equals(""))
			{
                            retval.append("\nChild tag name is missing");
                            return null; 
                        }
                        if (tagName.equals("Body")) {
                            org.w3c.dom.NodeList cNodes = 
				currentNode.getChildNodes(); 
                            int cnodeCount = nodes.getLength(); 
                            for (int j = 0; j < cnodeCount; j++) {
                                org.w3c.dom.Node cnode = cNodes.item(i); 
                                if (cnode.getNodeType() == 
				    org.w3c.dom.Node.ELEMENT_NODE) 
				{
                                    String ctagName = cnode.getLocalName();
                                    if ((ctagName == null) || 
					 ctagName.equals("")) 
				    {
                                        retval.append("\nSOAPReceiver Error: ").
					    append("Child tag name is missing").
					    append(" inside <SOAP-ENV:Body>");
                                        return null;
                                    }
                                    
                                    if (ctagName.equals("Fault")) {
					retval.append("\nreceived Fault ").
					    append("SOAPMessage.");
                                        return null; 
                                    } else if (ctagName.equals("Response")) {
                                        Response samlresponse =
					    new Response((Element) cnode); 
				        return samlresponse;
                                    } else {
                                        retval.append("\nSOAPReceiver Error:").
					    append("SOAPBody does not contain").
					    append(" Fault or Response."); 
                                        return null; 
                                    }
                                }
                            } // end of for loop 
			} else if (!tagName.equals("Header"))
			{
                            retval.append("\nSOAPReceiver Error: SOAP-ENV ").
                                append("contain element other than Body and ").
				append("Header"); 
                            return null; 
                        }
                    } // end of if (currentNode.getNodeType() 
		      // == Node.ELEMENT_NODE) 
                }
            } else {
                retval.append("\nno reply was received.");
            }
        } catch (Exception e ) {
	    retval.append("\nerror when processing the response: ").
		append(e.getMessage());
	}
	return response;
    }

    private Document toDOMDocument(String xmlString) throws SAMLException {
	if (xmlString == null) {
	    throw new SAMLException("input xmlString is null.");
	}

	try {
	    DocumentBuilderFactory dbFactory =
					DocumentBuilderFactory.newInstance();
	    dbFactory.setNamespaceAware(true);
	    dbFactory.setValidating(false);
	    DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
	    docBuilder.setErrorHandler(new SampleErrorHandler());
	    ByteArrayInputStream is = new ByteArrayInputStream(
		xmlString.getBytes("UTF-8"));
	    return docBuilder.parse(is); 
	} catch (Exception e) {
	    throw new SAMLException("Parsing error:" + e.getMessage());
	}
    }

    // SampleErrroHandler inner class
    private static class SampleErrorHandler implements org.xml.sax.ErrorHandler
    {
	/** Warning. */
	public void warning(SAXParseException ex) throws SAXException {
	    throw ex;
	}

	/** Error. */
	public void error(SAXParseException ex) throws SAXException {
	    throw ex;
	}

	/** Fatal error. */
	public void fatalError(SAXParseException ex) throws SAXException {
	    throw ex;
	}
    }

    // This is a utility function used to hack up an HTML display of an XML
    // string.
    private String displayXML(String input) {
        StringCharacterIterator iter = new StringCharacterIterator(input);
        StringBuffer buf = new StringBuffer(); 
        
        for(char c = iter.first();c != CharacterIterator.DONE;c = iter.next()) {       
            if (c=='>') {
                buf.append("&gt;");
            } else if (c=='<') {
                buf.append("&lt;");
            } else if (c=='\n'){
                buf.append("<BR>\n");
            } else {
                buf.append(c);
            }
        }
        return buf.toString();
    }
}
