/**
 * $Id: AssertionArtifactSample.java,v 1.6 2004/02/05 17:55:04 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

import java.net.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;
import org.w3c.dom.*;
import com.sun.identity.sm.*;
import com.sun.identity.saml.common.*;
import com.sun.identity.saml.assertion.*;
import com.sun.identity.saml.protocol.*;
import com.sun.identity.saml.*;
import com.iplanet.sso.*;
import com.iplanet.services.util.Base64;

/**
 * This Sample serves as a basis for using SAMLClient API. It demonstrates
 * creating an Assertion and AssertionArtifact on a server site, forwarding
 * the AssertionArtifact string to a remote site. Then a servlet running on 
 * the remote site calls SAMLClient API to retrieve the Assertion from the 
 * server site. 
 * For detailed info refer to the README file
 *
 * @see com.sun.identity.saml.assertion.*
 * @see com.sun.identity.saml.protocol.*
 * @see com.sun.identity.saml.SAMLClient
 * @see com.sun.identity.saml.AssertionManager
 * @see com.sun.identity.saml.common.*
 */

public class AssertionArtifactSample extends HttpServlet {
    
    public void init() throws ServletException {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response){
        /* SAMLClient location 
           For example: 
         "http://dsame.red.iplanet.com:58080/amserver/SAMLClientSample" 
         "http://dsame-test.red.iplanet.com:80/servlet/SAMLClientSample"
         */
        String clientLocation = null; 
      
        /* SourceId of the destionation site */
        String destionationID = null; 
        ServletOutputStream out = null; 
        /*If the user chooses different Artifact name, please modify the  
          line below */
        String artifactName = "SAMLart"; 
        response.setContentType("text/html");  
        
        try {
            out = response.getOutputStream();
            clientLocation = request.getParameter("target");     
            /* Source id from the console in base64 encoded format. Therefore,
               we should decode here. */
            destionationID = getDecodedSourceIDString(
                                         request.getParameter("sourceid"));
            if (clientLocation == null || clientLocation.equals("") ||
                destionationID == null || destionationID.equals("")) {
                out.println("Missing either target or sourceid in the url.");
                out.flush();
                return;
            }
          
            /* create the sso token from http request */
            SSOTokenManager manager = SSOTokenManager.getInstance();
            SSOToken token = manager.createSSOToken(request);

            /* use isValid to method to check if the token is valid or not
             * this method retuns true for valid token, false otherise.
             */
            if (!manager.isValidToken(token)) {
		out.println("SSOToken is invalid.");
		out.flush();
		return;
            }  

            /* create AssertionManager instance */
	    AssertionManager am = AssertionManager.getInstance();
	    
	    List attributeList = new ArrayList();
	    List attrValueList = new ArrayList();
	    
            /*Attribute 1: */
	    Attribute attr1 = new Attribute("attName1", "attNamespace1", 
                                             "first Attribute");
	    attributeList.add(attr1);

	    /* Attribute 2: */
	    Attribute attr2 = new Attribute("attName2", "attNamespace2",
                                              "second Attribute");
	    attributeList.add(attr2);

	    /* create an Assertion */
	    Assertion assertion = null;
	    try {
		assertion = am.createAssertion(token, attributeList);
	    } catch (Exception e) {
                out.println("Failed in createAssertion(ssotoken, attributes)." 
                            + e.getMessage());
		out.flush();
                return;
            }
        
	    /* create an AssertionArtifact associated with the above Assertion*/ 
	    AssertionArtifact art = null;
            try {      
                art = am.createAssertionArtifact(assertion, destionationID);
	    } catch (Exception e) {
                out.println("Failed in createAssertionArtifact(assertion," +
                            " destID)." + e.getMessage());
		out.flush();
                return;
            }
            String aarti = art.getAssertionArtifact();  
            String redirectLocation= clientLocation + 
                                     "?TARGET=http://www.sun.com&" +artifactName 
                                     + "=" + URLEncoder.encode(aarti);
            out.println("<html>\n");
            out.println("<head>\n");
            out.println("<title>AssertionArtifactSample on machine 1" + 
                        "</title>\n");
            out.println("</head>\n");
            out.println("<body>\n");
            out.println("<H1>AssertionArtifactSample servlet on machine 1 " + 
                        "</H1>\n");
            out.println("<P>Created an Assertion. \n"); 
            out.println("<HR>\n");
            out.println("Created an AssertionArtifact: " + aarti + "\n");
            out.println("<HR>\n");
            out.println("Click on the link below. You will be redirected to" + 
                        " SAMLClientSample servlet on machine 2. \n"); 
            out.println("<BR>\n"); 
            out.println("<A href=\"" + redirectLocation + "\">" + 
                        "Goto SAMLClientSample on machine 2" + "</A>"); 
            out.println("</P>\n"); 
            out.println("<BR>\n");
            out.println("</body>\n");
            out.println("</html>\n");     
            out.flush();
        } catch (Exception e) {
            try {
                out.println("Exception in AssertionManagerSampleServlet" +
                        e.getMessage());
                out.flush();
            } catch (Exception ee) {
            }
        } 
    }
    
    private String getDecodedSourceIDString(String encodedID) {
	String result = null;
	if (encodedID == null) {
	    return null;
	}
	try {
            byte[] bytes = Base64.decode(encodedID); 
            char chars[] = new char[bytes.length];
            for (int i = 0; i < bytes.length; i++) {
                chars[i] = (char) bytes[i];
            }
	    result = new String(chars); 
	} catch (Exception e) {
	    return null;
	}
	
	return result;
    }
}