/**
 * $Id: PolicyCreator.java,v 1.3 2004/02/05 17:55:02 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ReferralTypeManager;
import com.sun.identity.policy.SubjectTypeManager;
import com.sun.identity.policy.ConditionTypeManager;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.interfaces.Referral;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.policy.PolicyException;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOException;

import java.util.Set;
import java.util.HashSet;
import java.util.Map;
import java.util.HashMap;

public class PolicyCreator {

    public static final String DNS_NAME="DnsName";
    public static final String DNS_VALUE="*.red.iplanet.com";
    public static final String START_TIME="StartTime";
    public static final String START_TIME_VALUE="08:00";
    public static final String END_TIME="EndTime";
    public static final String END_TIME_VALUE="21:00";
    public static final String AUTH_LEVEL="AuthLevel";
    public static final String AUTH_LEVEL_VALUE="0";
    public static final String AUTH_SCHEME="AuthScheme";
    public static final String AUTH_SCHEME_VALUE="LDAP";


    private String orgDN;
    private SSOToken ssoToken;
    private PolicyManager pm;

    private PolicyCreator() throws PolicyException, SSOException {
        BaseUtils.loadProperties();
        orgDN = BaseUtils.getProperty("pe.orgname");
        System.out.println("orgDN = " + orgDN);
        ssoToken = BaseUtils.getToken();
        pm = new PolicyManager(ssoToken, orgDN);
    }

    public static void main(String[] args) {
        try {
            PolicyCreator pc = new PolicyCreator();
            pc.addReferralPolicy();
            pc.addNormalPolicy();
            System.exit(0);
        } catch(Exception e) {
            e.printStackTrace();
        }
    }

    private void addNormalPolicy() throws PolicyException, SSOException {
        System.out.println("Creating normal policy in org:" + orgDN);
        PolicyManager pm = new PolicyManager(ssoToken, orgDN);
        SubjectTypeManager stm = pm.getSubjectTypeManager();
        ConditionTypeManager ctm = pm.getConditionTypeManager();

        Policy policy = new Policy("policy1", "policy1 description");
        Map actions = new HashMap(1);
        Set values = new HashSet(1);
        values.add("allow");
        actions.put("GET", values);
        String resourceName = "http://myhost.com:80/hello.html";
        Rule rule = new Rule("rule1", "iPlanetAMWebAgentService", 
                resourceName, actions);
        policy.addRule(rule);

        Subject subject = stm.getSubject("Organization");
        Set subjectValues = new HashSet(1);
        subjectValues.add(orgDN);
        subject.setValues(subjectValues);
        policy.addSubject("organization", subject);

        subject = stm.getSubject("LDAPUsers");
        subjectValues = new HashSet(1);
        String userDN = "uid=user1,ou=people" + "," + orgDN;
        subjectValues.add(userDN);
        subject.setValues(subjectValues);
        policy.addSubject("ldapusers", subject);

        subject = stm.getSubject("LDAPGroups");
        subjectValues = new HashSet(1);
        String groupDN = "cn=group1,ou=groups" + "," + orgDN;
        subjectValues.add(groupDN);
        subject.setValues(subjectValues);
        policy.addSubject("ldapgroups", subject);

        subject = stm.getSubject("LDAPRoles");
        subjectValues = new HashSet(1);
        String roleDN = "cn=role1" + "," + orgDN;
        subjectValues.add(roleDN);
        subject.setValues(subjectValues);
        policy.addSubject("ldaproles", subject);

        subject = stm.getSubject("IdentityServerRoles");
        subjectValues = new HashSet(1);
        roleDN = "cn=role1" + "," + orgDN;
        subjectValues.add(roleDN);
        subject.setValues(subjectValues);
        policy.addSubject("is-roles", subject);

        Condition condition = ctm.getCondition("IPCondition");
        Map conditionProperties = new HashMap(1);
        Set propertyValues = new HashSet(1);
        propertyValues.add(DNS_VALUE);
        conditionProperties.put(DNS_NAME, propertyValues);
        condition.setProperties(conditionProperties);
        policy.addCondition("ip_condition", condition);

        condition = ctm.getCondition("SimpleTimeCondition");
        conditionProperties = new HashMap(1);
        propertyValues = new HashSet(1);
        propertyValues.add(START_TIME_VALUE);
        conditionProperties.put(START_TIME, propertyValues);
        propertyValues = new HashSet(1);
        propertyValues.add(END_TIME_VALUE);
        conditionProperties.put(END_TIME, propertyValues);
        condition.setProperties(conditionProperties);
        policy.addCondition("time_condition", condition);

        condition = ctm.getCondition("AuthLevelCondition");
        conditionProperties = new HashMap(1);
        propertyValues = new HashSet(1);
        propertyValues.add(AUTH_LEVEL_VALUE);
        conditionProperties.put(AUTH_LEVEL, propertyValues);
        condition.setProperties(conditionProperties);
        policy.addCondition("auth_level_condition", condition);


        condition = ctm.getCondition("AuthSchemeCondition");
        conditionProperties = new HashMap(1);
        propertyValues = new HashSet(1);
        propertyValues.add(AUTH_SCHEME_VALUE);
        conditionProperties.put(AUTH_SCHEME, propertyValues);
        condition.setProperties(conditionProperties);
        policy.addCondition("auth_scheme_condition", condition);


        pm.addPolicy(policy);

        System.out.println("Created  normal policy");
    }

    private void addReferralPolicy() 
            throws PolicyException, SSOException {
        System.out.println("Creating referral policy for org1");
        ReferralTypeManager rtm = pm.getReferralTypeManager();
        String subOrgDN = "o=org1" +  "," + orgDN;
        Policy policy = new Policy("refpolicy1", "ref to org1", 
                true);
        Map actions = new HashMap(1);
        Rule rule = new Rule("rule1", "iPlanetAMWebAgentService", 
                "http://myhost.com:80/org1", actions);
        policy.addRule(rule);
        Referral referral = rtm.getReferral("SubOrgReferral");
        Set referralValues = new HashSet(1);
        referralValues.add(subOrgDN);
        referral.setValues(referralValues);
        policy.addReferral("ref to org1" , referral);
        pm.addPolicy(policy);
        System.out.println("Created referral policy for org1");
    }

}
