/**
 * $Id: BaseUtils.java,v 1.7 2004/02/05 17:55:02 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

import java.util.*;
import java.io.*;
import java.net.*;
import java.security.Principal;
import javax.security.auth.*;
import javax.security.auth.login.*;
import javax.security.auth.callback.*;

import com.sun.identity.authentication.AuthContext;
import com.sun.identity.policy.*;
import com.iplanet.sso.*;


public class BaseUtils {

    static final int EXIT_STATUS_NOERROR = 0;
    static final int EXIT_STATUS_ERROR = 1;
    static final String PROPERTIES = "PolicyEvaluation.properties";
    static final String SEPARATOR = ":";
    
    static SSOToken ssoToken = null;
    static Properties properties = new Properties();
    static AuthContext lc = null;

    static void loadProperties()
    {
        try {
            InputStream is = new FileInputStream(PROPERTIES);
            if (is == null) {
                System.err.println(PROPERTIES + " not found");
                System.exit(EXIT_STATUS_ERROR);
            }
            properties.load(is);
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(EXIT_STATUS_ERROR);
        }
    }


    static String getProperty(String key)
    {
        return properties.getProperty(key);
    }


    static Set getPropertyValues(String name) {
        Set values = new HashSet();
        String value = getProperty(name);
        if ( value != null ) {
            StringTokenizer st = new StringTokenizer(value, SEPARATOR);
            while ( st.hasMoreTokens() ) {
               values.add(st.nextToken());
            }
        }
        return values;
    }


    static SSOToken getToken()
    {
        authenticate();
        SSOToken token = null;
        try {
            token = lc.getSSOToken();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return token;  
    }


    
    static void authenticate() 
    {
        String orgName = getProperty("pe.orgname");
        try {
            lc = new AuthContext(orgName);
            lc.login();
        } catch (LoginException le) {
            le.printStackTrace();
            return;
        }
       
        try { 
            Callback[] callbacks = null;
            // Get the information requested by the plug-ins
            while (lc.hasMoreRequirements()) {
                callbacks = lc.getRequirements();
                
                if (callbacks != null) {
                    addLoginCallbackMessage(callbacks);
                    lc.submitRequirements(callbacks);
                }
            }
                    
            if (lc.getStatus() == AuthContext.Status.SUCCESS) {
                System.out.println("Authentication has SUCCEEDED!");
            } else if (lc.getStatus() == AuthContext.Status.FAILED) {
                System.out.println("Authentication has FAILED");
            } else {
                System.out.println("Unknown status: " + lc.getStatus());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    
    static void addLoginCallbackMessage(Callback[] callbacks) 
         throws UnsupportedCallbackException 
    {
        int i = 0;
        try {
            for (i = 0; i < callbacks.length; i++) {
                if (callbacks[i] instanceof NameCallback) {
                    // prompt the user for a username
                    NameCallback nc = (NameCallback) callbacks[i];
                    String userName = getProperty("pe.username");
                    nc.setName(userName);
                    
                } else if (callbacks[i] instanceof PasswordCallback) {
                    // prompt the user for sensitive information
                    PasswordCallback pc = (PasswordCallback) callbacks[i];
                    String password = getProperty("pe.password");
                    pc.setPassword(password.toCharArray());
                    
                } else {
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
} 

