<%--
    Copyright  2004 Sun Microsystems, Inc. All rights reserved
    Use is subject to license terms.
--%>


<%@page import="java.io.*,java.util.*,com.sun.identity.saml.common.*,com.sun.identity.liberty.ws.dst.*,com.sun.identity.liberty.ws.disco.jaxb.*,javax.xml.bind.*,javax.xml.transform.stream.*,com.sun.identity.liberty.ws.idpp.jaxb.FNElement, com.sun.identity.liberty.ws.interaction.*, com.sun.identity.liberty.ws.soapbinding.*, com.iplanet.sso.*, com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken, com.sun.identity.liberty.ws.security.*" %>
<html xmlns="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<head><title>IDPP Modify</title></head>
<body bgcolor="white">
    <h1>IDPP Modify</h1>
<%
    if (request.getMethod().equals("GET")) {
        String resend = request.getParameter(
                        InteractionManager.RESEND_MESSAGE);
        if (resend != null) {
            // resend message after interaction
            try {
                // resend message
                Message ret = InteractionManager.getInstance().resendRequest(
                    request.getRequestURL().toString(), request, response);
                %>
                    <pre><%= SAMLUtils.displayXML(ret.toString()) %></pre>
                    <p><a href="index.jsp">Return to index.jsp</a></p>
                <%
            } catch (Throwable t) {
                t.printStackTrace();
                StringWriter buf = new StringWriter();
                t.printStackTrace(new PrintWriter(buf));
                %>
                    ERROR: caught exception:
                    <pre><%= SAMLUtils.displayXML(buf.toString()) %></pre>
                <%
            }
        } else {
            String soapEndPoint = "";
            String resourceID = "";
            List mechs = null;
            String ppRO = request.getParameter("idppResourceOffering");
            String providerID = request.getParameter("providerID");
            if (ppRO != null) {
                // parse the ResourceOffering String to get SOAP
                // endpoint and user's pp resource ID
                ResourceOfferingType offering;
                try {
                    JAXBContext jc = JAXBContext.newInstance(
                            "com.sun.identity.liberty.ws.disco.jaxb");
                    Unmarshaller unmarshaller = jc.createUnmarshaller();
                    Marshaller marshaller = jc.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output",
                                    Boolean.TRUE);
                    StreamSource src =
                            new StreamSource(new StringReader(ppRO));
                    Object o = unmarshaller.unmarshal(src);
                    if (o instanceof ResourceOfferingType) {
                        // get resourceID
                        ResourceIDType resourceIDType =
                            ((ResourceOfferingType) o).getResourceID();
                        resourceID = resourceIDType.getValue();
                        // get SOAP end point
                        ServiceInstanceType si =
                            ((ResourceOfferingType) o).getServiceInstance();
                        DescriptionType dt =
                            (DescriptionType) si.getDescription().get(0);
                        soapEndPoint = dt.getEndpoint();
                        // get supported security mechanisms
                        mechs = dt.getSecurityMechID(); 
                    }
                } catch (Throwable t) {
                    t.printStackTrace();
                    StringWriter buf = new StringWriter();
                    t.printStackTrace(new PrintWriter(buf));
                    %>
                        ERROR: caught exception:
                        <pre><%= SAMLUtils.displayXML(buf.toString()) %></pre>
                    <%
                }
            }
            %>
            <form method="POST">
                <table>
                    <tr>
                        <td>User's Personal Profile Service Resource ID</td>
                        <td><input type="text" size="20" name="resourceID"
                            value='<%= resourceID %>' /></td>
                    </tr>
                    <tr>
                        <td>SOAP End Point (for personal profile service)</td>
                        <td><input type="text" size="20" name="soapEndPoint"
                                 value='<%= soapEndPoint %>' /></td>
                    </tr>
                    <tr>
                        <td>Authentication Mechanism</td>
                        <td>
                <%
                int len = mechs.size(); 
                for (int i = 0; i < len; i++) {
                    %>
                    <input type='radio' name="authMech"
                        value='<%= mechs.get(i) %>'/> <%= mechs.get(i) %><br>
                    <% 
                } 
                %>
                        </td>
                    </tr>
                    <tr>
                        <td>XPath Expression</td>
                        <td><input type="text" name="queryStr" 
                            value="/IDPP/CommonName/AnalyzedName/FN" /></td>
                    </tr>
                    <tr>
                        <td>Value</td>
                        <td><input type="text" name="valueStr" /></td>
                    </tr>
                </table>
                <input type="hidden" name="providerID" 
                    value="<%= providerID %>">
                <input type="submit" value="Send PP Modify Request" />
            </form>
            <%
       } 
    } else {
        String soapEndPoint = request.getParameter("soapEndPoint");
        String queryString = request.getParameter("queryStr");
        String valueString = request.getParameter("valueStr");
        String resourceID = request.getParameter("resourceID");
        String authMech = request.getParameter("authMech");
        String providerID = request.getParameter("providerID");
        if (soapEndPoint == null || soapEndPoint.equals("")) {
            %>ERROR: resource offering missing<%
        } else if (authMech == null || authMech.equals("")) {
            %>ERROR: Authentication Mechianism missing<%
        } else if (resourceID == null || resourceID.equals("")) {
            %>ERROR: PP resource ID missing<%
        } else {
            try {
                DSTClient client = null;
                if (authMech.endsWith("null")) {
                    client = new DSTClient(soapEndPoint, providerID, 
                        request, response);
                } else if (authMech.endsWith("X509")) {
                    SSOToken ssoToken = 
                        SSOTokenManager.getInstance().createSSOToken(request);
                    SecurityTokenManager manager = 
                        new SecurityTokenManager(ssoToken);
                    BinarySecurityToken authToken = 
                        manager.getX509CertificateToken(); 

                    client = new DSTClient(authToken, soapEndPoint, 
                        providerID, request, response);
                } else {
                    %>ERROR: Unsupported Authentication Mechianism<%
                    // clear queryString, so no action to be performed
                    queryString = null;
                }
                if ((queryString != null) && !(queryString.equals(""))) {
                    client.setResourceID(resourceID);
                    List items = new ArrayList();
                    DSTModification item = new DSTModification();
                    item.setNameSpaceURI(DSTConstants.IDPP_SERVICE_TYPE);
                    item.setSelect(queryString);
                    item.setOverrideAllowed(true);
                    item.setId("modify-item-#1");
                    if ((valueString != null) && !(valueString.equals(""))) {
                         String xml = "<FN xmlns =\"" + 
                                DSTConstants.IDPP_SERVICE_TYPE + "\">" +
                                valueString + "</FN>";
                        List values = new ArrayList();
                        values.add(DSTUtils.parseXML(xml));
                        item.setNewDataValue(values);
                    }
                    items.add(item);
                    DSTModifyResponse response1 = client.modify(items);
                    %>
                        <h2>Got result:</h2>
                        <pre><%= SAMLUtils.displayXML(response1.toString()) %>
                        </pre>
                    <%
                }
            } catch (Throwable t) {
                t.printStackTrace();
                StringWriter buf = new StringWriter();
                t.printStackTrace(new PrintWriter(buf));
                %>
                    ERROR: caught exception:
                    <pre><%= SAMLUtils.displayXML(buf.toString()) %></pre>
                <%
            }
        }
%>
        <p><a href="index.jsp">Return to index.jsp</a></p>
<%
    } 
%>
    <hr/>
    </body>
</html>
