<%--
    Copyright  2004 Sun Microsystems, Inc. All rights reserved
    Use is subject to license terms.
--%>

<%@page import="java.io.*, java.util.*, com.sun.identity.saml.common.*, com.sun.identity.liberty.ws.disco.*, com.sun.identity.liberty.ws.disco.common.*,javax.xml.transform.stream.*,com.iplanet.sso.*" %>

<html xmlns="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
    <head><title>Discovery Service Query Sample</title></head>
    <body bgcolor="white">
        <h1>Discovery Service Query Sample</h1>
<%
        if (request.getMethod().equals("GET")) {
            String resourceOffering = 
                request.getParameter("discoveryResourceOffering");
            String providerID = request.getParameter("providerID");
            if (resourceOffering == null) {
                resourceOffering= "";
            } 
%>
            <form method="POST">
                <table>
                    <tr>
                        <td>ResourceOffering (for discovery service itself)</td>
                        <td>
                             <textarea rows="20" cols="60" name="resourceOffering"><%= resourceOffering %></textarea>
                         </td>
                    </tr>
                    <tr>
                        <td>ServiceType to look for</td>
                        <td><input type="text" name="serviceType" /></td>
                    </tr>
                </table>
                <input type="hidden" name="providerID" 
                    value='<%= providerID %>'>
                <input type="submit" value="Send Discovery Lookup Request" />
            </form>
<%
        } else {
            String resourceXML = request.getParameter("resourceOffering");
            String serviceType = request.getParameter("serviceType");
            String providerID = request.getParameter("providerID");
            if (resourceXML == null || resourceXML.equals("")) {
                %>ERROR: resource offering missing<%
            } else {
                ResourceOffering offering;
                try {
		    offering = new ResourceOffering(
				DiscoUtils.parseXML(resourceXML));
                    DiscoveryClient client = new DiscoveryClient(
				offering,
				SSOTokenManager.getInstance().createSSOToken(
                                                                request),
				providerID);
                    List types = new ArrayList();
                    if ((serviceType != null) && !(serviceType.equals("")))
                    {
                        types.add(serviceType);
                    }
		    QueryResponse result = client.getResourceOffering(types);
                    List results = result.getResourceOffering();
		    if ((results == null) || (results.size() == 0)) {
			%>
			<h2>Query result:</h2>
			 No ResourceOffering found.
			<p><a href="index.jsp">Return to index.jsp</a></p>
			<%
		    } else {
                    	int itemSize = results.size();
                    	for (int i = 0; i < itemSize; i ++) {
                    	    ResourceOffering offer =
				(ResourceOffering) results.get(i);
                            %>
<h2>Query result :</h2>
<pre><%= SAMLUtils.displayXML(offer.toString()) %></pre>
<form method="GET" action="id-sis-pp-query.jsp">
<input type='hidden' name='providerID' value='<%= providerID %>'>
<input type='hidden' name='idppResourceOffering'
    value='<%= offer.toString() %>'>
<input type="submit" name="Submit" value="Send PP Query" />
</form>

<p>

<form method="GET" action="id-sis-pp-modify.jsp">
<input type='hidden' name='providerID' value='<%= providerID %>'>
<input type='hidden' name='idppResourceOffering'
   value='<%= offer.toString() %>'>
<input type="submit" name="Submit" value="Send PP Modify" />
</form>
<hr>
                            <%
			}
                    }
                } catch (Throwable t) {
                    t.printStackTrace();
                    StringWriter buf = new StringWriter();
                    t.printStackTrace(new PrintWriter(buf));
                    %>
                        ERROR: caught exception:
                        <pre><%= SAMLUtils.displayXML(buf.toString()) %></pre>
                    <%
                }
            }
        } 
%>
        <hr />
    </body>
</html>
