<%--
    Copyright  2004 Sun Microsystems, Inc. All rights reserved
    Use is subject to license terms.
--%>

<%@page import="java.io.*,java.util.*,com.sun.identity.saml.common.*,com.sun.identity.liberty.ws.disco.*,com.sun.identity.liberty.ws.disco.common.*,javax.xml.transform.stream.*, com.sun.identity.liberty.ws.idpp.plugin.IDPPResourceIDMapper,com.iplanet.sso.*" %>
<html xmlns="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<head><title>Discovery Service Modification</title></head>
<body bgcolor="white">
<h1>Discovery Service Modification</h1>
<%
    if (request.getMethod().equals("GET")) {
        String resourceOffering =
            request.getParameter("discoveryResourceOffering");
        if (resourceOffering == null) {
            resourceOffering= "";
        }
        String ppProviderID = 
	    "http://www.idp1.com:IDP_SERVER_PORT/SERVICE_DEPLOY_URI/Liberty/idpp";
        String userDN = request.getParameter("userDN");
        String ppResourceID = (new IDPPResourceIDMapper()).getResourceID(
            ppProviderID, userDN);
        String providerID = request.getParameter("providerID");
        String newPPRO = "";
        if (userDN != null && !userDN.equals("")){
            newPPRO = 
                "<ResourceOffering xmlns=\"urn:liberty:disco:2003-08\">\n" 
                + "  <ResourceID>" + ppResourceID + "</ResourceID>\n"
                + "  <ServiceInstance>\n"
                + "    <ServiceType>urn:liberty:idpp:2003-08</ServiceType>\n"
                + "    <ProviderID>" + ppProviderID + "</ProviderID>\n"
                + "    <Description>\n"
                + "      <SecurityMechID>urn:liberty:security:2003-08:null:null"
                + "</SecurityMechID>\n" 
                + "      <SecurityMechID>urn:liberty:security:2003-08:TLS:null"
                + "</SecurityMechID>\n" 
                + "      <SecurityMechID>urn:liberty:security:2003-08:null:X509"
                + "</SecurityMechID>\n" 
                + "      <SecurityMechID>urn:liberty:security:2003-08:TLS:X509"
                + "</SecurityMechID>\n" 
                + "      <Endpoint>" + ppProviderID + "</Endpoint>\n"
                + "    </Description>\n"
                + "  </ServiceInstance>\n"
                + "  <Abstract>This is xyz </Abstract>\n"
                + "</ResourceOffering>";
        }
%>
<form method="POST">
<table>
<tr>
<td>ResourceOffering (for discovery service itself)</td>
<td>
<textarea rows="20" cols="60" name="resourceOffering"><%= resourceOffering %></textarea>
</td>
</tr>
<tr>
<td>PP ResourceOffering to add</td>
<td>
<textarea rows="20" cols="60" name="insertStr"><%= newPPRO %></textarea>
</td>
</tr>
</table>
<input type="hidden" name="providerID" value="<%= providerID %>" />
<input type="submit" value="Send Discovery Update Request" />
</form>
<%
    } else {
        try {
            String resourceXML = request.getParameter("resourceOffering");
            String insertString = request.getParameter("insertStr");
            String providerID = request.getParameter("providerID");
            if (resourceXML == null || resourceXML.equals("")) {
                %>ERROR: resource offering missing<%
            } else {
                ResourceOffering offering;
                try {
                    offering = new ResourceOffering(DiscoUtils.parseXML(
						resourceXML));
                    DiscoveryClient client = new DiscoveryClient(
				offering,
				SSOTokenManager.getInstance().createSSOToken(
							request),
				providerID);
                    Modify mod = new Modify();
                    mod.setResourceID(offering.getResourceID());
                    if ((insertString != null) &&
                            !(insertString.equals("")))
                    {
			InsertEntry insert = new InsertEntry(
			    new ResourceOffering(
					DiscoUtils.parseXML(insertString)),
			    null);
			List inserts = new ArrayList();
			inserts.add(insert);
			mod.setInsertEntry(inserts);
                        if ((mod.getInsertEntry() == null) &&
                                (mod.getRemoveEntry() == null))
                        {
                            %>ERROR: empty Modify<%
                        } else {
                            %>
                                <h2>Formed Modify :</h2>
                                <pre><%= SAMLUtils.displayXML(mod.toString()) %></pre>
                            <%
                                ModifyResponse resp2 = client.modify(mod);
                            %>
                                    <h2>Got result:</h2>
                                    <pre><%= SAMLUtils.displayXML(resp2.toString()) %></pre>
                            <%
                        }
                    }
                } catch (Throwable t) {
                    t.printStackTrace();
                    StringWriter buf = new StringWriter();
                    t.printStackTrace(new PrintWriter(buf));
                    %>
                        ERROR: caught exception:
                        <pre>
                    <% 
                              out.println(buf.toString());
                    %>
                        </pre>
                    <%
                }
            }
%>
            <p><a href="index.jsp">Return to index.jsp</a></p>
<%
        } catch (Throwable e) {
            e.printStackTrace();
            StringWriter buf = new StringWriter();
            e.printStackTrace(new PrintWriter(buf));
            %>
                ERROR: oocaught exception:
                <pre>
            <%
                out.println(buf.toString());
            %>
                </pre>
            <%
        }
    } 
%>
        <hr/>
    </body>
</html>
