/**
 * $Id: IDEPUtils.java,v 1.3 2004/02/05 17:54:59 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

package ep;

import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.List;
import java.util.HashSet;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.lang.Class;
import java.security.SecureRandom;
import com.iplanet.am.util.Locale; 
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.Locale;
import com.iplanet.services.util.Base64;
import ep.jaxb.QueryElement;
import ep.jaxb.DSTString;
import ep.jaxb.QueryResponseElement;
import ep.jaxb.QueryResponseType;
import ep.jaxb.ObjectFactory; // new line
import ep.jaxb.QueryType;
import ep.jaxb.ResourceIDElement;
import com.sun.identity.saml.common.SAMLUtils;
import javax.xml.bind.JAXBException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.JAXBContext;

/**
 * This class <code>IDEPUtils</code> is utility class used by IDEP service
 * for any common functionality in various modules.
 */

public class IDEPUtils {

     public static Debug debug = Debug.getInstance("amLibertyIDEP");
     public static ResourceBundle bundle = 
            Locale.getInstallResourceBundle("amLibertyEmployeeProfile");
     private static ObjectFactory idepFactory = new ObjectFactory();
     //This needs to change it as configurable.
     private static final String idepPrefix = "idep";
     private static HashMap idepElementTypes = new HashMap();
     public static HashMap idepIDSMap = new HashMap();
     private static DocumentBuilderFactory dbf = null;
     private static DocumentBuilder documentBuilder = null;
     private static Marshaller marshaller = null;
     private static Unmarshaller unmarshaller = null;
    
     static {
         try {
             dbf = DocumentBuilderFactory.newInstance();
             dbf.setNamespaceAware(true);
             documentBuilder = dbf.newDocumentBuilder();
             JAXBContext jc = JAXBContext.newInstance(
             IDEPConstants.IDEP_JAXB_PKG);
             marshaller = jc.createMarshaller();
             unmarshaller = jc.createUnmarshaller();
         } catch (Exception e) {
             IDEPUtils.debug.error("IDEPUtils:static initialization" +
             " Failed.", e);
         }
    }

     //Default constructor
     public IDEPUtils() {
     }
    
     /**
      * Convience method for the PAOS API to create a Query Request
      * element given a set of query expressions.
      * @param List queryExpressions. 
      * @return QueryElement JAXB object.
      */
/*
     public static QueryElement createQueryElement(List queryExpressions, 
                                                   String resourceID,
                                                   boolean includeCommonAttr)
     throws JAXBException, IDEPException {
         QueryElement query = idepFactory.createQueryElement(); 
         if(queryExpressions == null || resourceID == null
            || queryExpressions.size() == 0) {
            debug.error("IDEPUtils:createQueryElement: Either query" +
            " expressions or resource id is null.");
            throw new IDEPException("ResourceID or query expressions are null");
         }
         query.setResourceID(createResourceIDElement(resourceID));
         query.setId(SAMLUtils.generateID());
         for (int i =0; i < queryExpressions.size(); i++) {
              QueryType.QueryItemType item = 
              idepFactory.createQueryTypeQueryItemType();
              item.setId(SAMLUtils.generateID()); 
              item.setIncludeCommonAttributes(includeCommonAttr);
              item.setItemID(SAMLUtils.generateID());
              item.setSelect(addIDPPPrefix((String)queryExpressions.get(i)));
              query.getQueryItem().add(item);
         }
         return query; 
     }
*/
     /**
      * Convience method for the PAOS API to get the data element given
      * a Query Response.
      * @param QueryResponseElement response 
      * @return List of data elements.
      * TODO - should we extend this method to give the list of respective
      * JAXB objects for the given query expressions???
      */
     public static List getQueryDataElements(QueryResponseElement response)
      throws JAXBException, IDEPException {
         if(response == null) {
            debug.error("IDEPUtils:getQueryDataElements:response is null");
            throw new IDEPException("response is null");
         }
         return response.getData();
     }
     
     /**
      * Creates Discovery resource id type.
      * @param ResourceID string.
      * @return ResourceIDType JAXB object.
      */
     public static ResourceIDElement createResourceIDElement (String resourceID)
      throws JAXBException, IDEPException {
         if(resourceID == null) {
            debug.error("IDEPUtils:ResourceIDType: Resource id is null");
            throw new IDEPException("ResourceID is null");
         }
         ResourceIDElement resourceIDElement = 
               idepFactory.createResourceIDElement();
         resourceIDElement.setValue(resourceID);
         return resourceIDElement;
     }

     /**
      * Adds prefix "idpp" to the expression. This should be configurable
      * Also, need a name space prefix mapper.
      */
    /*
     private static String addIDPPPrefix(String expression) {
         if(expression == null || expression.length() == 0) {
            return expression;
         }
         if(expression.indexOf("/") == -1) {
            debug.error("IDPPUtils:addIDPPPrefix:Not a valid expression");
            return expression;
         }
         StringBuffer sb = new StringBuffer(100);
         StringTokenizer st = new StringTokenizer(expression, "/");
         while(st.hasMoreTokens()) {
              String temp = (String)st.nextToken();
              String prefixedStr = "/" + idppPrefix + ":" + temp;
              sb.append(prefixedStr);
         }
         return sb.toString();
     }
     */
     /**
      * This method looks for the expression context. For e.g. if the expression
      * is /idpp:IDPP/idpp:IDPPCommonName/idpp:AnalyzedName/idpp:FN, then
      * it one returns "FN".
      * @param select string.
      * @return context string.
      */
    /*
     public static String getExpressionContext(String select) {
        if(select == null || select.indexOf("/") == -1) {
           return null;
        }
        int i = select.lastIndexOf("/");
        if(i != -1) {
           select = select.substring(i+1);
        }
        if((i = select.indexOf(":")) == -1) {
           return select;
        } else {
          return select.substring(i+1);
        }
     }
     */
     /**
      * This method is used to return the user attribute values.
      * @param SSOToken token.
      * @param userDN string.
      * @param set of required attributes.
      * @return user attribute value map.
      */
     public static Map getUserAttributes(SSOToken token,
                                         String userDN,
                                         Set requiredSet)
      throws IDEPException {
         if(token == null || userDN == null || requiredSet == null) {
            debug.error("IDPPUtils:getUserAttributes: Null values");
            throw new IDEPException("null values.");
         }
         try {
             AMStoreConnection conn = new AMStoreConnection(token);
             AMUser user = conn.getUser(userDN);
             return user.getAttributes(requiredSet);
         } catch(AMException ae) {
             debug.error("IDEPUtils:getUserAttributes: Error retrieving" +
             " user attributes.", ae); 
             throw new IDEPException(ae);
         } catch(SSOException se) {
             debug.error("IDEPUtils:getUserAttributes: Invalid credentials.");
             throw new IDEPException(se);
         }
     } 

     /**
      * This method is to store the user attribute values in the data store.
      * @param SSOToken token
      * @param String userDN
      * @param user attribute value map
      */
     public static void setUserAttributes(SSOToken token,
                                          String userDN, 
                                          Map map)
      throws IDEPException {

         if(token == null || userDN == null || map == null || map.isEmpty()) {
            debug.error("IDEPUtils:setUserAttributes: Null values");
            throw new IDEPException("null values.");
         }
         try {
             AMStoreConnection connection = new AMStoreConnection(token);
             AMUser user = connection.getUser(userDN);
             user.setAttributes(map);
             user.store();
         } catch(AMException ae) {
             debug.error("IDEPUtils:storeUserAttributes:Error while storing" +
             "user attributes.", ae);
             throw new IDEPException(ae);
         } catch(SSOException se) {
             debug.error("IDEPUtils:storeUserAttributes:Invalid credentials.");
             throw new IDEPException(se);
         }
     }
     
     /**
      * removes user attribute values from the data store.
      * @param SSOToken token.
      * @param String userDN. 
      * @param Set set of user attributes to be removed.
      */
    /*
     public static void removeUserAttributes(SSOToken token,
                                             String userDN,
                                             Set set) 
     throws IDPPException {
         if(token == null || userDN == null || set == null || set.isEmpty()) {
            debug.error("IDPPUtils:removeUserAttributes:Null Values");
            throw new IDPPException("null values.");
         }
         try {
             AMStoreConnection connection = new AMStoreConnection(token);
             AMUser user = connection.getUser(userDN);
             user.removeAttributes(set);
         } catch(AMException ae) {
             debug.error("IDPPUtils:removeUserAttributes:Error while removing" +
             "user attributes.", ae);
             throw new IDPPException(ae);
         } catch(SSOException se) {
             debug.error("IDPPUtils:removeUserAttributes:Invalid credentials.");
             throw new IDPPException(se);
         }

     }
     */
     /**
      * This method checks for if the user attribute values exist
      * for a given set.
      * @param SSOToken token
      * @param String userDN.
      * @param Set set of user attributes that require check.
      * @return true if any of the user attibute values found.
      */
    
    
     public static boolean checkForUserAttributes(SSOToken token,
                                                  String userDN,
                                                  Set set)
     throws IDEPException {

         Map map = getUserAttributes(token, userDN, set);
         if(map == null || map.isEmpty()) {
            return false;
         }
         return true;
     }
     
    
     /**
      * Checks is the user exists or not.
      * @param token SSOToken
      * @return true if the user exists.
      */
     public static boolean userExists(SSOToken token, String userDN) {
         try {
             AMStoreConnection connection = new AMStoreConnection(token);
             AMUser user = connection.getUser(userDN);
             return user.isExists();
         } catch (Exception e) {
             return false;
         }
     }

     /**
      * Gets the IDPPFactory JAXB Object.
      * @param none
      * @return ObjectFactory JAXB IDPP Factory Object.
      */
     public static ObjectFactory getIDEPFactory() {
         return idepFactory;
     }

     /**
      * Gets the marshaller
      * @return Marshaller JAXB Marshaller Object.
      */
     public static Marshaller getMarshaller() {
         return marshaller;
     }

     /**
      * Get the unmarshaller object.
      * @return Unmarshaller JAXB unmarshaller object.
      */
     public static Unmarshaller getUnmarshaller() {
         return unmarshaller;
     }

     /**
      * Get the document builder.
      * @return DocumentBuilder dom document builder
      */
     public static DocumentBuilder getDocumentBuilder() {
        return documentBuilder;
     }

}
