/**
 * $Id: EmployeeProfile.java,v 1.4 2004/02/05 17:54:59 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

package ep;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Document;
import javax.xml.bind.JAXBException;
//import org.w3c.dom.xpath.XPathEvaluator;
//import org.w3c.dom.xpath.XPathNSResolver;
//import org.w3c.dom.xpath.XPathResult;
//import org.apache.xpath.domapi.XPathEvaluatorImpl;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import java.util.HashSet;
import java.util.Map;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Iterator;
import java.util.Calendar;
import java.util.Date;
import java.text.DateFormat;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.sso.SSOException;
import com.iplanet.am.util.AdminUtils;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.liberty.ws.dst.DSTQueryItem;
import com.sun.identity.liberty.ws.dst.DSTModification;

import ep.jaxb.*;

import com.iplanet.services.util.Crypt;

/**
 * This class <code>EmployeeProfile</code> is an implementation of 
 * <code>LibertyDataService</code>. The default implementation of Employee 
 * Profile leverages the XPATH technology for the queries. Inorder to make 
 * sense for the XPath expressions, the user profile needs to be in XML blob.
 * The current approach is to parse the select expression, build a container
 * level XML blob instead of the entire user profile.
 * A WSC SSOToken may not have enough priveleges to write or read the
 * user profile data since the policy evaluation is driven through Webservices
 * POLICY component rather than through ACI driven. So, currently, we use
 * admin token for both queries and updates, but the authorization check
 * will be done for a WSC credential. 
 */

public class EmployeeProfile {

      private static final String SLASH = "/";
      private static final String LEFTBR= "[";
      private static final String COLON= ":";
      private static SSOToken adminToken = null;
    //private static IDPPServiceManager serviceManager = null;

      static {
         try {
	     //      serviceManager = IDPPServiceManager.getInstance();
             String adminDN = AdminUtils.getAdminDN();
             String adminPW = new String(AdminUtils.getAdminPassword());
             SSOTokenManager ssoManager = SSOTokenManager.getInstance();
             adminToken = ssoManager.createSSOToken(
                          new AuthPrincipal(adminDN), adminPW);
         } catch( Exception ex) {
             IDEPUtils.debug.error("EmployeeProfile:Initialization " + 
                                                        "failed", ex);
         }
      }

      /**
       * Default constructor for personal profile.
       */
      public EmployeeProfile() {
         IDEPUtils.debug.message("EmployeeProfile:Init");
      }

     /**
      * Query for the data for a specific resourceID.
      * @param credential credentials of the requesting WSC.
      * @param dstQueryItems list of DSTQueryItems.
      * @param request query DOM request. 
      * @return Map map of processed query items and the correspoding list 
      * of results.
      * @exception IDEPException.
      */
      public Map queryData(Object credential,
			   String resourceID, 
			   List dstQueryItems,
			   Document request)  // TODO: this might not be needed
      throws IDEPException {

         IDEPUtils.debug.message("EmployeeProfile: query init");
         if(credential == null || resourceID == null ||
            dstQueryItems == null || request == null) {
            IDEPUtils.debug.error("EmployeeProfile:queryData: null input");
            throw new IDEPException(
            IDEPUtils.bundle.getString("nullInputParams"));
         }
         // validate the credentials of requesting WSC.
         try {
             SSOToken token = (SSOToken)credential;
             SSOTokenManager.getInstance().validateToken(token);
         } catch (SSOException se) {
             IDEPUtils.debug.error("EmployeeProfile:queryData:Invalid WSC"+
             "credentials");
             throw new IDEPException(IDEPUtils.bundle.getString(
             "invalidWSCCredentials"));
         }

         String userDN = resourceID; //getUserDN(resourceID);
         if (userDN == null) {
            if(IDEPUtils.debug.messageEnabled()) {
               IDEPUtils.debug.message("EmployeeProfile: queryData:userDN" +
               "is null for a given resourceID.");
            }
            throw new IDEPException(IDEPUtils.bundle.getString("noResourceID"));
         }
         if(IDEPUtils.debug.messageEnabled()) {
            IDEPUtils.debug.message("EmployeeProfile:queryData: userDN=" + 
            userDN);
         }

         // Get the User data from DS for all the given query items.
         Map userMap = null;
         try {
	   userMap = getUserData(userDN, null); //dstQueryItems);
         } catch(IDEPException ie) {
             IDEPUtils.debug.error("EmployeeProfile:queryData:Error while"+
             "retrieving user data.", ie);
             throw new IDEPException(ie);
         }
         if(userMap == null || userMap.isEmpty()) {
            if(IDEPUtils.debug.messageEnabled()) {
               IDEPUtils.debug.message("EmployeeProfile:queryData:no data:" +
               "for the requested pp attributes.");
            }
            throw new IDEPException(IDEPUtils.bundle.getString("noData"));
         }
         if(IDEPUtils.debug.messageEnabled()) {
            IDEPUtils.debug.message("EmployeeProfile:queryData:requested Data "
            + userMap);
         }

	 System.out.println("******userMap====>"+userMap);

         //Process each DSTQueryItem
         Map results = new HashMap();
         Iterator iter = dstQueryItems.iterator();
         while(iter.hasNext()) {
            DSTQueryItem item = (DSTQueryItem)iter.next();
            List queryResults = new ArrayList();
            String queryExpression = item.getSelect();

	    Object obj = getJAXBObject(queryExpression, userMap);

	    queryResults.add(obj);
            results.put(item, queryResults);
         }
         return results;
      }

      /**
       * Get the user data for given list of DST Query items.
       * @param String userDN.
       * @param List list of DSTQueryItems.
       * @return Map of user attribute value pairs.
       * @throws IDEPException.
       */
      private Map getUserData(String userDN, List dstQueryItems) 
      throws IDEPException {

         if(userDN == null) { // || dstQueryItems == null) {
            throw new IDEPException(
            IDEPUtils.bundle.getString("nullInputParams"));
         }

         // Get all the required user attributes from all query items.
         Set querySet = new HashSet();

	 querySet.add("sunIdentityServerEPEmployeeID");
	 querySet.add("sunIdentityServerEPAltEmployeeID");
	 querySet.add("sunIdentityServerEPDateOfHire");
	 querySet.add("sunIdentityServerEPJobStartDate");
	 querySet.add("sunIdentityServerEPEmployeeStatus");
	 querySet.add("sunIdentityServerEPEmployeeType");
	 querySet.add("sunIdentityServerEPInternalJobTitle");
	 querySet.add("sunIdentityServerEPOU");
	 querySet.add("sunIdentityServerEPCorpCommonNameCN");
	 querySet.add("sunIdentityServerEPCorpCommonNameAltCN");
	 querySet.add("sunIdentityServerEPCorpLegalIdentityLegalName");
	 querySet.add("sunIdentityServerEPCorpLegalIdentityVATIDValue");
	 querySet.add("sunIdentityServerEPCorpLegalIdentityVATIDType");
	 querySet.add("sunIdentityServerEPCorpLegalIdentityAltIDIDValue");
	 querySet.add("sunIdentityServerEPCorpLegalIdentityAltIDIDType");
	 querySet.add("sunIdentityServerEPManagerEmployeeID");
	 querySet.add("sunIdentityServerEPSubalternateEmployeeID");
	 
         // use admin token to get all the user attributes.
         return IDEPUtils.getUserAttributes(adminToken, userDN, querySet);
      }

     /**
      * Checks if the resource id is valid.
      * @param String resourceID.
      * @return true if the resource id is valid.
      */
     public boolean isResourceIDValid(String resourceID) {
        IDEPUtils.debug.message("EmployeeProfile:isResourceIDValid:Init");
        return IDEPUtils.userExists(adminToken, 
                                      getUserDN(resourceID)); 
     }

     /**
      * Checks if the WSC is authorized for the specified action.
      * @param Object credential object.
      * @param String action.
      * @param String select.
      * @param String resourceID.
      * @return true if the WSC is authorized.
      */
     public boolean isWSCAuthorized(Object credential, 
                                    String action,
                                    String select, 
                                    String resourceID) {
         IDEPUtils.debug.message("EmployeeProfile:isWSCAuthorized:Init");
         return true;
     }

     /**
      * Get the user dn for a specified resource id.
      * @param String resourceID.
      * @return String userDN.
      */
     public String getUserDN(String resourceID) {
        IDEPUtils.debug.message("EmployeeProfile:getUserDN:Init");
        return Crypt.decode(resourceID);
     }
 

  public Object getJAXBObject(String select, Map userMap) {

    if (select.endsWith("ManagerEmployeeID")) {
      return getManagerEmployeeID(userMap);
    }

    if (select.endsWith("SubalternateEmployeeID")) {
      return getSubalternateEmployeeID(userMap);
    }

    if (select.endsWith("AltEmployeeID")) {
      return getAltEmployeeID(userMap);
    }
    
    if (select.endsWith("EmployeeID")) {
      return getEmployeeID(userMap);
    }
    
    if (select.endsWith("DateOfHire")) {
      return getDateOfHire(userMap);
    }
    
    if (select.endsWith("JobStartDate")) {
      return getJobStartDate(userMap);
    }
    
    if (select.endsWith("EmployeeStatus")) {
      return getEmployeeStatus(userMap);
    }

    if (select.endsWith("EmployeeType")) {
      return getEmployeeType(userMap);
    }

    if (select.endsWith("InternalJobTitle")) {
      return getInternalJobTitle(userMap);
    }

    if (select.endsWith("OU")) {
      return getOU(userMap);
    }

    if (select.endsWith("CN")) {
      return getCN(userMap);
    }

    // TODO: should return a list
    if (select.endsWith("AltCN")) {
      return getAltCN(userMap);
    }

    if (select.endsWith("CorpCommonName")) {
      return getCorpCommonName(userMap);
    }
    
    if (select.endsWith("LegalName")) {
      return getLegalName(userMap);
    }

    if (select.endsWith("IDValue")) {

      if (select.indexOf("VAT") != -1) {
	return getVATIDValue(userMap);
      } else {
	return getAltIDIDValue(userMap);
      }
    }

    if (select.endsWith("IDType")) {

      if (select.indexOf("VAT") != -1) {
	return getVATIDType(userMap);
      } else {
	return getAltIDIDType(userMap);
      }
    }
    
    if (select.endsWith("VAT")) {
      return getVAT(userMap);
    }

    if (select.endsWith("AltID")) {
      return getAltID(userMap);
    }

    if (select.endsWith("CorpLegalIdentity")) {
	return getCorpLegalIdentity(userMap);
    }

    if (select.endsWith("EP")) {
      return getEP(userMap);
    }

    return null;
  }

  private ManagerEmployeeIDElement getManagerEmployeeID(Map userMap) {

      ManagerEmployeeIDElement result = null;
      try {
	result =
	  IDEPUtils.getIDEPFactory().createManagerEmployeeIDElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }
      Set data = (Set) userMap.get("sunidentityserverepmanageremployeeid");
      if (data != null) {
	Iterator i = data.iterator();
	if (i.hasNext()) {
	  result.setValue((String)i.next());
	}
      }
      return result;
  }
    
  private SubalternateEmployeeIDElement getSubalternateEmployeeID(Map userMap) {

      SubalternateEmployeeIDElement result = null;
      try {
	result = 
	  IDEPUtils.getIDEPFactory().createSubalternateEmployeeIDElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }
      Set data = (Set) userMap.get("sunidentityserverepsubalternateemployeeid");
      if (data != null) {
	Iterator i = data.iterator();
	if (i.hasNext()) {
	  result.setValue((String)i.next());
	}
      }
      return result;
  }

  private AltEmployeeIDElement getAltEmployeeID(Map userMap) {

      AltEmployeeIDElement result = null;
      try {
	result =
	  IDEPUtils.getIDEPFactory().createAltEmployeeIDElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }
      Set data = (Set) userMap.get("sunidentityserverepaltemployeeid");
      if (data != null) {
	Iterator i = data.iterator();
	if (i.hasNext()) {
	  result.setValue((String)i.next());
	}
      }
      return result;
  }

  private EmployeeIDElement getEmployeeID(Map userMap) {

      EmployeeIDElement result = null;
      try {
	result =
	  IDEPUtils.getIDEPFactory().createEmployeeIDElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }
      Set data = (Set) userMap.get("sunidentityserverepemployeeid");
      if (data != null) {
	Iterator i = data.iterator();
	if (i.hasNext()) {
	  result.setValue((String)i.next());
	}
      }
      return result;
  }

  private DateOfHireElement getDateOfHire(Map userMap) {

      DateOfHireElement result = null;
      try {
	result =
	  IDEPUtils.getIDEPFactory().createDateOfHireElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }
      Set data = (Set) userMap.get("sunidentityserverepdateofhire");
      if (data != null) {
	Iterator i = data.iterator();
	if (i.hasNext()) {
	  String dateStr = (String) i.next();
	  Calendar cal = getCalFromDateStr(dateStr);
	  result.setValue(cal);
	}
      }
      return result;
  }

  private Calendar getCalFromDateStr(String dateStr) {
  
    Date date = null;
    try {
      date = DateFormat.getDateInstance(DateFormat.MEDIUM).parse(dateStr);
    } catch (java.text.ParseException pe) {
      IDEPUtils.debug.error("EmployeeProfile.getCalFromDateStr: cannot parse date str: " + pe.getMessage());
      return null;
    }
    Calendar cal = Calendar.getInstance();
    cal.setTime(date);
    return cal;
  }

  private JobStartDateElement getJobStartDate(Map userMap) {

      JobStartDateElement result = null;
      try {
	result =
	  IDEPUtils.getIDEPFactory().createJobStartDateElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }
      Set data = (Set) userMap.get("sunidentityserverepjobstartdate");
      if (data != null) {
	Iterator i = data.iterator();
	if (i.hasNext()) {
	  String dateStr = (String) i.next();
	  Calendar cal = getCalFromDateStr(dateStr);
	  result.setValue(cal);
	}
      }
      return result;
  }

  private EmployeeStatusElement getEmployeeStatus(Map userMap) {

      EmployeeStatusElement result = null;
      try {
	result =
	  IDEPUtils.getIDEPFactory().createEmployeeStatusElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }
      Set data = (Set) userMap.get("sunidentityserverepemployeestatus");
      if (data != null) {
	Iterator i = data.iterator();
	if (i.hasNext()) {
	  result.setValue((String)i.next());
	}
      }
      return result;
  }

  private EmployeeTypeElement getEmployeeType(Map userMap) {

      EmployeeTypeElement result = null;
      try {
	result =
	  IDEPUtils.getIDEPFactory().createEmployeeTypeElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }
      Set data = (Set) userMap.get("sunidentityserverepemployeetype");
      if (data != null) {
	Iterator i = data.iterator();
	if (i.hasNext()) {
	  result.setValue((String)i.next());
	}
      }
      return result;
  }

  private InternalJobTitleElement getInternalJobTitle(Map userMap) {

      InternalJobTitleElement result = null;
      try {
	result =
	  IDEPUtils.getIDEPFactory().createInternalJobTitleElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }
      Set data = (Set) userMap.get("sunidentityserverepinternaljobtitle");
      if (data != null) {
	Iterator i = data.iterator();
	if (i.hasNext()) {
	  result.setValue((String)i.next());
	}
      }
      return result;
  }

  private OUElement getOU(Map userMap) {

      OUElement result = null;
      try {
	result =
	  IDEPUtils.getIDEPFactory().createOUElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }
      Set data = (Set) userMap.get("sunidentityserverepou");
      if (data != null) {
	Iterator i = data.iterator();
	if (i.hasNext()) {
	  result.setValue((String)i.next());
	}
      }
      return result;
  }

  private CNElement getCN(Map userMap) {

      CNElement result = null;
      try {
	result =
	  IDEPUtils.getIDEPFactory().createCNElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }
      Set data = (Set) userMap.get("sunidentityserverepcorpcommonnamecn");
      if (data != null) {
	Iterator i = data.iterator();
	if (i.hasNext()) {
	  result.setValue((String)i.next());
	}
      }
      return result;
  }

  private AltCNElement getAltCN(Map userMap) {

      AltCNElement result = null;
      try {
	result =
	  IDEPUtils.getIDEPFactory().createAltCNElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }
      Set data = (Set) userMap.get("sunidentityserverepcorpcommonnamealtcn");
      if (data != null) {
	Iterator i = data.iterator();
	if (i.hasNext()) {
	  result.setValue((String)i.next());
	}
      }
      return result;
  }

  private CorpCommonNameElement getCorpCommonName(Map userMap) {

      CorpCommonNameElement result = null;
 
      try {
	result =
	  IDEPUtils.getIDEPFactory().createCorpCommonNameElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }

      result.setCN(getCN(userMap));

      // TODO: AltCN is a list, should have stored it as a list
      result.getAltCN().add(getAltCN(userMap));

      return result;
  }

  private LegalNameElement getLegalName(Map userMap) {

      LegalNameElement result = null;
      try {
	result =
	  IDEPUtils.getIDEPFactory().createLegalNameElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }
      Set data = (Set) userMap.get("sunidentityserverepcorplegalidentitylegalname");
      if (data != null) {
	Iterator i = data.iterator();
	if (i.hasNext()) {
	  result.setValue((String)i.next());
	}
      }
      return result;
  }

  private IDValueElement getVATIDValue(Map userMap) {

      IDValueElement result = null;
      try {
	result =
	  IDEPUtils.getIDEPFactory().createIDValueElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }
      Set data = (Set) userMap.get("sunidentityserverepcorplegalidentityvatidvalue");
      if (data != null) {
	Iterator i = data.iterator();
	if (i.hasNext()) {
	  result.setValue((String)i.next());
	}
      }
      return result;
  }

  private IDValueElement getAltIDIDValue(Map userMap) {

      IDValueElement result = null;
      try {
	result =
	  IDEPUtils.getIDEPFactory().createIDValueElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }
      Set data = (Set) userMap.get("sunidentityserverepcorplegalidentityaltididvalue");
      if (data != null) {
	Iterator i = data.iterator();
	if (i.hasNext()) {
	  result.setValue((String)i.next());
	}
      }
      return result;
  }

  private IDTypeElement getVATIDType(Map userMap) {

      IDTypeElement result = null;
      try {
	result =
	  IDEPUtils.getIDEPFactory().createIDTypeElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }
      Set data = (Set) userMap.get("sunidentityserverepcorplegalidentityvatidtype");
      if (data != null) {
	Iterator i = data.iterator();
	if (i.hasNext()) {
	  result.setValue((String)i.next());
	}
      }
      return result;
  }

  private IDTypeElement getAltIDIDType(Map userMap) {

      IDTypeElement result = null;
      try {
	result =
	  IDEPUtils.getIDEPFactory().createIDTypeElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }
      Set data = (Set) userMap.get("sunidentityserverepcorplegalidentityaltididtype");
      if (data != null) {
	Iterator i = data.iterator();
	if (i.hasNext()) {
	  result.setValue((String)i.next());
	}
      }
      return result;
  }

  private VATElement getVAT(Map userMap) {

      VATElement result = null;
 
      try {
	result =
	  IDEPUtils.getIDEPFactory().createVATElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }

      result.setIDValue(getVATIDValue(userMap));
      result.setIDType(getVATIDType(userMap));

      return result;
  }

  private AltIDElement getAltID(Map userMap) {

      AltIDElement result = null;
 
      try {
	result =
	  IDEPUtils.getIDEPFactory().createAltIDElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }

      result.setIDValue(getAltIDIDValue(userMap));
      result.setIDType(getAltIDIDType(userMap));

      return result;
  }

  private CorpLegalIdentityElement getCorpLegalIdentity(Map userMap) {

      CorpLegalIdentityElement result = null;
 
      try {
	result =
	  IDEPUtils.getIDEPFactory().createCorpLegalIdentityElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }

      result.setLegalName(getLegalName(userMap));
      result.setVAT(getVAT(userMap));
      result.getAltID().add(getAltID(userMap));

      return result;
  }

  private EPElement getEP(Map userMap) {

      EPElement result = null;
 
      try {
	result =
	  IDEPUtils.getIDEPFactory().createEPElement();
      } catch (javax.xml.bind.JAXBException e) {
	IDEPUtils.debug.error("EmployeeProfile.getJAXBObject: cannot create JAXBObject");
	return null;
      }

      result.setEmployeeID(getEmployeeID(userMap));
      // TODO: store AltEmployeeID as list
      result.getAltEmployeeID().add(getAltEmployeeID(userMap));
      result.setDateOfHire(getDateOfHire(userMap));
      result.setJobStartDate(getJobStartDate(userMap));
      result.setEmployeeStatus(getEmployeeStatus(userMap));
      result.setEmployeeType(getEmployeeType(userMap));
      result.setInternalJobTitle(getInternalJobTitle(userMap));
      result.setOU(getOU(userMap));
      result.setCorpCommonName(getCorpCommonName(userMap));
      result.setCorpLegalIdentity(getCorpLegalIdentity(userMap));
      result.setManagerEmployeeID(getManagerEmployeeID(userMap));
      result.getSubalternateEmployeeID().add(getSubalternateEmployeeID(userMap));

      return result;
  }

  private void setUserAttr(String attrKey, Object obj, Set userSet, Map userMap) {

      if(obj != null) {
	  String value = null;
	  if(obj instanceof DSTString) {
              DSTString str = (DSTString)obj;
              value = str.getValue();
           } else if (obj instanceof DSTURI) {
	       DSTURI uri = (DSTURI)obj;
	       value = uri.getValue();
           } else if (obj instanceof DSTDate) {
	       DSTDate date = (DSTDate)obj;
	       Calendar cal = date.getValue();
	       if(cal != null) {
		   value = DateFormat.getDateInstance().format(cal.getTime());
	       }
           }
	  if(value != null) {
	      userSet.add(value);
	  }
      }
      userMap.put(attrKey, userSet);
  }
    
  /**
   * Process modify request and update new data.
   * @param credential credential of a WSC.
   * @param resourceID resource id string
   * @param dstModifications list of DSTModification objects.
   * @param Document original request.
   * @return true if successful in modifying the data.
   * @exception IDEPException.
   */
  public boolean modifyData(Object credential,
			    String resourceID,
			    List dstModifications,
			    Document request)
  throws IDEPException {
 
      if(credential == null || resourceID == null || 
	 dstModifications == null || dstModifications.isEmpty()) {
	  //request is not being used in the case of modify, there for
	  // the interface purposes. 
	  IDEPUtils.debug.error("EmployeeProfile:modifyData:null input");
	  throw new IDEPException(
	      IDEPUtils.bundle.getString("nullInputParamters"));
      }
      try {
	  SSOToken token = (SSOToken)credential;
	  SSOTokenManager.getInstance().validateToken(token);
      } catch (SSOException se) {
	  IDEPUtils.debug.error("EmployeeProfile:queryData:Invalid WSC"+
				"credentials");
	  throw new IDEPException(IDEPUtils.bundle.getString(
	      "invalidWSCCredentials"));
      }
      String userDN = resourceID; // getUserDN(resourceID);
      if(userDN == null) {
	  if(IDEPUtils.debug.messageEnabled()) {
	      IDEPUtils.debug.message("EmployeeProfile: modifyData:userDN" +
				      "is null for a given resourceID.");
	  }
	  throw new IDEPException(IDEPUtils.bundle.getString("noResourceID"));
      }
      if(IDEPUtils.debug.messageEnabled()) {
	  IDEPUtils.debug.message("EmployeeProfile:modifyData:userDN ="+
				  userDN);
      }
      
      // Modifiable user map.
      Map modifyMap = new HashMap();
      Set userSet = new HashSet();
      Iterator iter = dstModifications.iterator();
      if (!iter.hasNext()) {
	  return false;
      }
      DSTModification modification = (DSTModification)iter.next(); 
      String select = modification.getSelect();
      boolean override = modification.isOverrideAllowed();
      List dataObjects = modification.getNewDataValue();
      
      Object obj = dataObjects.get(0);
      
      if (select.endsWith("ManagerEmployeeID")) {
	  setUserAttr("sunIdentityServerEPManagerEmployeeID", obj, userSet, modifyMap);
      }
      if (select.endsWith("SubalternateEmployeeID")) {
	  setUserAttr("sunIdentityServerEPSubalternateEmployeeID", ((List)obj).get(0), userSet, modifyMap);
      }
      if (select.endsWith("AltEmployeeID")) {
	  setUserAttr("sunIdentityServerEPAltEmployeeID", ((List)obj).get(0), userSet, modifyMap);
      }
      if (select.endsWith("EmployeeID")) {
	  setUserAttr("sunIdentityServerEPEmployeeID", obj, userSet, modifyMap);
      }
      if (select.endsWith("DateOfHire")) {
	  setUserAttr("sunIdentityServerEPDateOfHire", obj, userSet, modifyMap);
      }
      if (select.endsWith("JobStartDate")) {
	  setUserAttr("sunIdentityServerEPJobStartDate", obj, userSet, modifyMap);
      }
      if (select.endsWith("EmployeeStatus")) {
	  setUserAttr("sunIdentityServerEPEmployeeStatus", obj,userSet, modifyMap);
      }
      if (select.endsWith("EmployeeType")) {
	  setUserAttr("sunIdentityServerEPEmployeeType", obj, userSet, modifyMap);
      }
      if (select.endsWith("InternalJobTitle")) {
	  setUserAttr("sunIdentityServerEPInternalJobTitle", obj, userSet, modifyMap);
      }
      if (select.endsWith("OU")) {
	  setUserAttr("sunIdentityServerEPOU", obj, userSet, modifyMap);
      }
      if (select.endsWith("CN")) {
	  setUserAttr("sunIdentityServerEPCorpCommonNameCN", obj, userSet, modifyMap);
      }
      // TODO: should return a list
      if (select.endsWith("AltCN")) {
	  setUserAttr("sunIdentityServerEPCorpCommonNameAltCN", ((List)obj).get(0), userSet, modifyMap);
      }
      if (select.endsWith("LegalName")) {
	  setUserAttr("sunIdentityServerEPCorpLegalIdentityLegalName", obj, userSet, modifyMap);
      }
      if (select.endsWith("IDValue")) {
	  
	  if (select.indexOf("VAT") != -1) {
	      setUserAttr("sunIdentityServerEPCorpLegalIdentityVATIDValue", obj, userSet, modifyMap);
	  } else {
	      setUserAttr("sunIdentityServerEPCorpLegalIdentityAltIDIDValue", obj, userSet, modifyMap);
	  }
      }
      if (select.endsWith("IDType")) {
	  
	  if (select.indexOf("VAT") != -1) {
	      setUserAttr("sunIdentityServerEPCorpLegalIdentityVATIDType", obj, userSet, modifyMap);
	  } else {
	      setUserAttr("sunIdentityServerEPCorpLegalIdentityAltIDIDType", obj, userSet, modifyMap);
	  }
      }
      if(!override && IDEPUtils.checkForUserAttributes(adminToken, 
						       userDN, userSet)) {
	  if(IDEPUtils.debug.messageEnabled()) {
	      IDEPUtils.debug.message("EmployeeProfile:modifyData:" +
				      "override set to false and data Already exists.");
	  }
	  return false;
      }
      if(modifyMap == null || modifyMap.isEmpty()) {
	  IDEPUtils.debug.error("EmployeeProfile:modifyData:map is null");
	  return false;
      }
      try {
	  IDEPUtils.setUserAttributes(adminToken, userDN, modifyMap);
	  return true;
      } catch (IDEPException ie) {
	  IDEPUtils.debug.error("EmployeeProfile:modifyMap:Error while" +
				"modifying the user data.", ie);            
	  return false;
      }
  }
}




