/**
 * $Id: EPRequestHandler.java,v 1.5 2004/02/05 17:54:59 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

package ep;

import ep.jaxb.QueryResponseElement;
import ep.jaxb.QueryElement;
import ep.jaxb.QueryType;
import ep.jaxb.QueryResponseType;

import ep.jaxb.*;

import com.sun.identity.liberty.ws.dst.DSTQueryItem;
import com.sun.identity.liberty.ws.dst.DSTModification;
import com.sun.identity.liberty.ws.dst.DSTConstants;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.service.DSTRequestHandler;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.liberty.ws.soapbinding.NamespacePrefixMapperImpl;
import com.sun.identity.saml.common.SAMLUtils;
import com.iplanet.am.util.XMLUtils;
import java.util.List;
import java.util.Set;
import java.util.Iterator;
import java.util.Map;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import javax.xml.bind.JAXBException;
import org.w3c.dom.Document;


/**
 * The class <code>EPRequestHandler</code> is used to process the
 * query (or later on, modify) requests for a employee profile service.
 */ 

public class EPRequestHandler extends DSTRequestHandler {

    private EmployeeProfile ep;

    //Default constructor
    public EPRequestHandler() {
       ep = new EmployeeProfile();
       providerID = "temporary";
    }

    /**
     * Processes query/modify request.
     * @param request query or modify object.
     * @return Object processed response object.
     * @exception SOAPFaultException for the interaction redirects 
     * @exception Exception for any failure.
     */
    public Object processDSTRequest(Object request)
    throws SOAPFaultException, DSTException {
       
        IDEPUtils.debug.message("EPRequestHandler:processRequest:Init");
        try {
            if(request instanceof QueryElement) {
               QueryElement query = (QueryElement)request;
               Document doc = IDEPUtils.getDocumentBuilder().newDocument();
               IDEPUtils.getMarshaller().setProperty(
                         "com.sun.xml.bind.namespacePrefixMapper",
                         new NamespacePrefixMapperImpl());
               IDEPUtils.getMarshaller().marshal(query, doc);
               return processQueryRequest(query, doc);
             } else if (request instanceof ModifyElement) {
               ModifyElement modify = (ModifyElement)request;
	       Document doc = IDEPUtils.getDocumentBuilder().newDocument();
	       IDEPUtils.getMarshaller().setProperty(
		   "com.sun.xml.bind.namespacePrefixMapper",
		   new NamespacePrefixMapperImpl());
	       IDEPUtils.getMarshaller().marshal(modify, doc);
	       return processModifyRequest(modify, doc);
             } else {
               IDEPUtils.debug.error("PPRequestHandler:processRequest:invalid" +
               " Request."); 
               throw new DSTException(
               IDEPUtils.bundle.getString("invalidRequest"));
             }
        } catch (JAXBException je) {
             IDEPUtils.debug.error("PPRequestHandler:processRequest fail",je);
             throw new DSTException(
             IDEPUtils.bundle.getString("jaxbFailure"));
        } catch(IDEPException ie) {
             IDEPUtils.debug.error("PPRequestHandler:processRequest fail",ie);
             throw new DSTException(ie);
        }

    }

    /**
     * Processes Query Request.
     * @param query JAXBQ QueryElement Object
     * @param request queryRequest.
     * @param credential credentials of WSC.
     * @param requestMsg SOAP request message (for the interaction)
     *                   TODO: might want to delete this 
     * @return QueryResponseElement response.
     * @exception IDEPException for a failure in processing the request
     * @exception SOAPFaultException if the interaction is required
     */
    public QueryResponseElement 
    processQueryRequest(QueryElement query, 
                        Document request)
     throws IDEPException, SOAPFaultException {

        IDEPUtils.debug.message("EPRequestHandler:processQueryRequest:Init");
        if(query == null || request == null) {
           IDEPUtils.debug.error("EPRequestHandler:processQueryRequest:" +
           "null values ");
           throw new IDEPException(
           IDEPUtils.bundle.getString("nullInputParams"));
        }
        if(IDEPUtils.debug.messageEnabled()) {
           IDEPUtils.debug.message("EPRequestHandler:processQueryRequest:" +
           "request received:" + XMLUtils.print(request.getDocumentElement()));
        }
        QueryResponseElement response = getQueryResponse(query);

        String resourceID = getResourceID(query.getResourceID());

	System.out.println("************resourceID="+resourceID);
	
	/*
	if (resourceID == null) {
	  System.out.println("****************************resourceID is null");
	}
        else if (!ep.isResourceIDValid(resourceID)) {
	  System.out.println("****************************resourceID is invalid");
           if(IDEPUtils.debug.messageEnabled()) {
              IDEPUtils.debug.message("EPRequestHandler:processQuery" +
              "Request: resource id is invalid.");
           }
           response.setStatus(setStatusType(DSTConstants.NO_RESOURCE, 
           IDEPUtils.bundle.getString("invalidResourceID")));
           return response;
        }
	*/
        List queryItems = query.getQueryItem();
        if (queryItems.size() == 0) {
            if(IDEPUtils.debug.warningEnabled()) {
               IDEPUtils.debug.warning("EPRequestHandler:processQuery" +
               "Request: The request does not have any query items.");
            }
            response.setStatus(setStatusType(DSTConstants.FAILED, 
            IDEPUtils.bundle.getString("nullQueryItems")));
            return response;
        }

	List dstQueryItems = new ArrayList();
	int queryItemsSize = queryItems.size();
	for(int i= 0; i < queryItemsSize; i++) {
	  boolean isQueryItemValid = true;
	  QueryType.QueryItemType item =
	    (QueryType.QueryItemType)queryItems.get(i);
	  String select = item.getSelect();

	  System.out.println("***********select=>"+select);

	  /*******************
	  if((select == null) || (select.length() == 0)) {
	    if(IDEPUtils.debug.warningEnabled()) {
	      IDEPUtils.debug.warning("EPRequestHandler:process"+
				      "QueryRequest: There is no Select in the request.");
	    }
	    response.setStatus(
			       setStatusType(DSTConstants.MISSING_SELECT, 
					     IDEPUtils.bundle.getString("missingSelect")));
	    isQueryItemValid = false;
	  }
	  if(!ep.isSelectDataSupported(select)) {
	    if(IDEPUtils.debug.warningEnabled()) {
	      IDEPUtils.debug.warning("EPRequestHandler:process"+
				      "QueryRequest: Data not supported");
	    }
	    response.setStatus(setStatusType(DSTConstants.INVALID_SELECT, 
					     IDEPUtils.bundle.getString("invalidSelect")));
	    isQueryItemValid = false;
	  }
	  if(!ep.isWSCAuthorized(credential, DSTConstants.QUERY_ACTION, 
				 resourceID, select)) {
	    response.setStatus(setStatusType(DSTConstants.FAILED, 
					     IDEPUtils.bundle.getString("notAuthroized")));
	    isQueryItemValid = false;
	  }
	  ***************************/
	  if(isQueryItemValid) {
	    Calendar changedSince = item.getChangedSince();
	    Date date = null;
	    if(changedSince != null) {
	      date = changedSince.getTime();
	    }
	    DSTQueryItem dstQueryItem = new DSTQueryItem(select, 
							 item.isIncludeCommonAttributes(),
							 date,
							 IDEPConstants.XMLNS_IDEP);
	    dstQueryItems.add(dstQueryItem);
	  }
	}
        Map queryResults = ep.queryData(requestMsg.getToken(), resourceID, 
					dstQueryItems, request);
        List data = getData(queryResults);
        if(data != null && !data.isEmpty()) {
           response.getData().addAll(data); 
        }
        return response;
     }

     /**
      * Get the data from the queried results
      * @param queryResults map of DSTQueryItems and the corresponding results.
      * @return List queried data.
      * @exception IDEPException.
      */
     private List getData(Map queryResults) throws IDEPException {
 
        IDEPUtils.debug.message("EPRequestHandler:getData:Init");
        List  dataResults = new ArrayList();
        Set queryItems = queryResults.keySet();
        Iterator iter = queryItems.iterator();
        while(iter.hasNext()) {
           QueryResponseType.DataType data = null;
           try {
               data = IDEPUtils.getIDEPFactory().
                       createQueryResponseTypeDataType();
            } catch (JAXBException je) {
                IDEPUtils.debug.error("EPRequestHandler:getData:jaxb fail", je);
                throw new IDEPException(
                IDEPUtils.bundle.getString("jaxbFailure"));
            }
            DSTQueryItem dstQueryItem = (DSTQueryItem)iter.next();
            List values = (List)queryResults.get(dstQueryItem);
            if(values.isEmpty()) {
               continue;
            }
            data.getAny().addAll(values);
            data.setItemIDRef(dstQueryItem.getItemID());
            data.setId(dstQueryItem.getId());
            dataResults.add(data);
        }
        return dataResults;
    }

    /**
     * sets the response status.
     * @param statusCode status code.
     * @param comment.
     * @return StatusType JAXB Object.
     * @exception IDEPException for any failure
     */
    private StatusType setStatusType(String statusCode, String comment)
    throws IDEPException {
        IDEPUtils.debug.message("EPRequestHandler:setStatusType:Init");
        if(statusCode == null) {
           throw new IDEPException(IDEPUtils.bundle.getString("nullInputParams"));
        }
        try {
            StatusType status = IDEPUtils.getIDEPFactory().createStatusType();
            QName qName = new QName(IDEPConstants.XMLNS_IDEP, statusCode);
            status.setCode(qName);
            if(comment != null) {
               status.setComment(comment);
            }
            return status;
        } catch (JAXBException je) {
            IDEPUtils.debug.error("EPRequestHandler:setStatusType:" +
            "jaxb failure:" , je);
            throw new IDEPException(IDEPUtils.bundle.getString("jaxbFailure"));
        }
    }

    /**
     * Process modify request.
     * @param modify ModifyElement JAXB Object
     * @param request modify request
     * @return ModifyResponseElement response JAXB Object
     * @exception IDEPException for failure in processing the request
     * @exception SOAPFaultException for interaction redirect
     */ 
    public ModifyResponseElement
    processModifyRequest(ModifyElement modify,
                         Document request)
     throws IDEPException, SOAPFaultException {

        IDEPUtils.debug.message("EPRequestHandler:processModifyRequest:Init");
        if(modify == null) {
           IDEPUtils.debug.error("EPRequestHandler:processModify"+
           "Request. null values");
           throw new IDEPException(
           IDEPUtils.bundle.getString("nullInputParams"));
        }
        if(IDEPUtils.debug.messageEnabled()) {
           IDEPUtils.debug.message("EPRequestHandler:processModifyRequest:"+
           "request received:" + XMLUtils.print(request.getDocumentElement()));
        }
//        interactedData = new HashMap();
        ModifyResponseElement response = getModifyResponse(modify);
        String resourceID = getResourceID(modify.getResourceID());
        if(resourceID == null) { // || !pp.isResourceIDValid(resourceID)) {
           if(IDEPUtils.debug.warningEnabled()) {
              IDEPUtils.debug.warning("EPRequestHandler:processModify" +
              "Request: resource id is invalid.");
           }
           response.setStatus(setStatusType(DSTConstants.NO_RESOURCE,
           IDEPUtils.bundle.getString("invalidResourceID")));
           return response;
        }
        List modificationElements = modify.getModification();
        if(modificationElements.size() == 0) {
           IDEPUtils.debug.error("EPRequestHandler:process" +
           "ModifyRequest: Modification elements are null");
           response.setStatus(setStatusType(DSTConstants.FAILED, 
           IDEPUtils.bundle.getString("nullModifications"))); 
           return response;
        }

//        Map interactSelects = new HashMap();
        List dstModifications = new ArrayList();
        int size = modificationElements.size();
        for (int i=0; i < size; i++) {
             ModifyType.ModificationType modificationType =
             (ModifyType.ModificationType)modificationElements.get(i);
             String select = modificationType.getSelect();
             if(select == null || select.length() == 0) {
                if(IDEPUtils.debug.warningEnabled()) {
                   IDEPUtils.debug.warning("PersonalProfileService:process"+
                   "ModifyRequest: select is null");
                }
                response.setStatus(setStatusType(DSTConstants.MISSING_SELECT, 
                IDEPUtils.bundle.getString("missingSelect")));
                return response;
             }
//              if(!ep.isSelectDataSupported(select)){
//                 if(IDEPUtils.debug.warningEnabled()) {
//                    IDEPUtils.debug.warning("PersonalProfileService:process"+
//                    "ModifyRequest: Data not supported");
//                 }
//                 response.setStatus(setStatusType(DSTConstants.INVALID_SELECT, 
//                 IDEPUtils.bundle.getString("invalidSelect")));
//                 return response;
//              }
             //Check for authorization & interaction.
//              String resource = IDEPUtils.getResourceExpression(select);
//              String authZAction = pp.getAuthZAction(requestMsg.getToken(),
//              DSTConstants.MODIFY_ACTION, resource, getPolicyEnvMap(resourceID));
//              if(authZAction == null || authZAction.equalsIgnoreCase(
//                 IDEPConstants.AUTHZ_DENY)) {
//                 response.setStatus(setStatusType(DSTConstants.FAILED,
//                 IDEPUtils.bundle.getString("notAuthorized")));
//                 return response;
//              }

//              if(authZAction.equalsIgnoreCase(
//                 IDEPConstants.INTERACT_FOR_CONSENT)||
//                 authZAction.equalsIgnoreCase(
//                 IDEPConstants.INTERACT_FOR_VALUE)) {

//                  if(isInteractionResponseExists(requestMsg)) {
//                     if(!processInteractionResponse(false, requestMsg, 
//                        select, authZAction)) {
//                        response.setStatus(setStatusType(DSTConstants.FAILED,
//                        IDEPUtils.bundle.getString("interactionFailed")));
//                        return response;
//                     }
//                  } else {
//                     interactSelects.put(resource,  authZAction);
//                  }
//              }

             boolean override = modificationType.isOverrideAllowed();
             ModifyType.ModificationType.NewDataType newData =
                        modificationType.getNewData();
             DSTModification dstModification = new DSTModification();
             dstModification.setSelect(select);
             dstModification.setOverrideAllowed(override);
             dstModification.setId(modificationType.getId());
             dstModifications.add(dstModification);
             if(newData != null && newData.getAny() != null && 
                newData.getAny().size() != 0) {
                dstModification.setNewDataValue(newData.getAny());
             }
        }

        //Check for interfaction before processing the actual response.
//         if(interactSelects != null && !interactSelects.isEmpty()) {
//            initInteraction(false, interactSelects, requestMsg);
//         }

        if(ep.modifyData(requestMsg.getToken(),resourceID, 
			 dstModifications, request)) { //interactedData, request)) {
           return response;
        } else {
           response.setStatus(setStatusType(DSTConstants.FAILED, 
           IDEPUtils.bundle.getString("modifyFailed")));
           return response;
        }
    }
    /**
     * Process modify request.
     * @param modify ModifyElement JAXB Object
     * @param request modify request
     * @param credential Credentials of WSC
     * @param requestMsg SOAP message( for the interaction)
     * @return ModifyResponseElement response JAXB Object
     * @exception IDEPException for failure in processing the request
     * @exception SOAPFaultException for interaction redirect
     */ 
//     public ModifyResponseElement
//     processModifyRequest(ModifyElement modify,
//                          Document request,
//                          Object credential,
//                          Message requestMsg)
//      throws IDEPException, SOAPFaultException {

//         IDEPUtils.debug.message("EPRequestHandler:processModifyRequest:Init");
//         if(modify == null) {
//            IDEPUtils.debug.error("EPRequestHandler:processModify"+
//            "Request. null values");
//            throw new IDEPException(IDEPUtils.bundle.getString("nullInputParams"));
//         }
//         if(IDEPUtils.debug.messageEnabled()) {
//            IDEPUtils.debug.message("EPRequestHandler:processModifyRequest:"+
//            "request received:" + XMLUtils.print(request.getDocumentElement()));
//         }
//         ModifyResponseElement response = getModifyResponse(modify);
//         String resourceID = getResourceID(modify.getResourceID());
//         if(resourceID == null || !ep.isResourceIDValid(resourceID)) {
//            if(IDEPUtils.debug.warningEnabled()) {
//               IDEPUtils.debug.warning("EPRequestHandler:processModify" +
//               "Request: resource id is invalid.");
//            }
//            response.setStatus(setStatusType(DSTConstants.NO_RESOURCE,
//            IDEPUtils.bundle.getString("invalidResourceID")));
//            return response;
//         }
//         List modificationElements = modify.getModification();
//         if(modificationElements.size() == 0) {
//            IDEPUtils.debug.error("EPRequestHandler:process" +
//            "ModifyRequest: Modification elements are null");
//            response.setStatus(setStatusType(DSTConstants.FAILED, 
//            IDEPUtils.bundle.getString("nullModifications"))); 
//            return response;
//         }
//         List dstModifications = new ArrayList();
//         int size = modificationElements.size();
//         for (int i=0; i < size; i++) {
//              ModifyType.ModificationType modificationType =
//              (ModifyType.ModificationType)modificationElements.get(i);
//              String select = modificationType.getSelect();
//              if(select == null || select.length() == 0) {
//                 if(IDEPUtils.debug.warningEnabled()) {
//                    IDEPUtils.debug.warning("PersonalProfileService:process"+
//                    "ModifyRequest: select is null");
//                 }
//                 response.setStatus(setStatusType(DSTConstants.MISSING_SELECT, 
//                 IDEPUtils.bundle.getString("missingSelect")));
//                 return response;
//              }
//              if(!ep.isSelectDataSupported(select)){
//                 if(IDEPUtils.debug.warningEnabled()) {
//                    IDEPUtils.debug.warning("PersonalProfileService:process"+
//                    "ModifyRequest: Data not supported");
//                 }
//                 response.setStatus(setStatusType(DSTConstants.INVALID_SELECT, 
//                 IDEPUtils.bundle.getString("invalidSelect")));
//                 return response;
//              }
//              boolean override = modificationType.isOverrideAllowed();
//              ModifyType.ModificationType.NewDataType newData =
//                         modificationType.getNewData();
//              DSTModification dstModification = new DSTModification();
//              dstModification.setSelect(select);
//              dstModification.setOverrideAllowed(override);
//              dstModifications.add(dstModification);
//              if(newData != null && newData.getAny() != null && 
//                 newData.getAny().size() != 0) {
//                 dstModification.setNewDataValue(newData.getAny());
//              }
//         }
//         if(ep.modifyData(credential,resourceID, dstModifications, request)) {
//            return response;
//         } else {
//            response.setStatus(setStatusType(DSTConstants.FAILED, 
//            IDEPUtils.bundle.getString("modifyFailed")));
//            return response;
//         }
//     }

    /**
     * Gets the query response and set the status to OK.
     * @param query JAXB query object.
     * @return QueryResponseElement JAXB query response.
     * @exception IDEPException
     */
    public QueryResponseElement getQueryResponse(QueryElement query)
    throws IDEPException {
        if(query == null) {
           IDEPUtils.debug.error("EPRequestHandler:getQueryResponse:" +
           "Query is null.");
           throw new IDEPException(IDEPUtils.bundle.getString("nullInputParams"));
        }
        try {
            QueryResponseElement response =
                   IDEPUtils.getIDEPFactory().createQueryResponseElement();
            response.setStatus(setStatusType(DSTConstants.OK, null));
            response.setId(SAMLUtils.generateID());
            response.setTimeStamp(Calendar.getInstance());
            response.setItemIDRef(query.getItemID());
            return response;
        } catch (JAXBException je) {
            IDEPUtils.debug.error("EPRequestHandler:getQueryResponse:" +
            "JAXB failure.", je);
            throw new IDEPException(IDEPUtils.bundle.getString("jaxbFailure"));
        }

    }

    /**
     * Gets the modify response and set the status to OK.
     * @param modify JAXB modify object.
     * @return ModifyResponseElement JAXB modify response.
     * @exception IDEPException
     */
    public ModifyResponseElement getModifyResponse(ModifyElement modify)
    throws IDEPException {
        if(modify == null) { 
           IDEPUtils.debug.error("EPRequestHandler:getModifyResponse:" +
           "Modify is null.");
           throw new IDEPException(
           IDEPUtils.bundle.getString("nullInputParams"));
        }
        try {
            ModifyResponseElement response =
                   IDEPUtils.getIDEPFactory().createModifyResponseElement();
            response.setStatus(setStatusType(DSTConstants.OK, null));
            response.setId(SAMLUtils.generateID());
            response.setTimeStamp(Calendar.getInstance(
                     TimeZone.getTimeZone("UTC")));;
            response.setItemIDRef(modify.getItemID());
            return response;
        } catch (JAXBException je) {
            IDEPUtils.debug.error("EPRequestHandler:getModifyResponse:" +
            "JAXB failure.", je);
            throw new IDEPException(IDEPUtils.bundle.getString("jaxbFailure"));
        }

    }

}

