<%--
    Copyright  2004 Sun Microsystems, Inc. All rights reserved
    Use is subject to license terms.
--%>


<%@page import="java.io.*,java.util.*,com.sun.identity.saml.common.*,com.sun.identity.liberty.ws.dst.*,com.sun.identity.liberty.ws.disco.jaxb.*,javax.xml.bind.*,javax.xml.transform.stream.*" %>
<html xmlns="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<head><title>IDEP Modify</title></head>
<body bgcolor="white">
    <h1>IDEP Modify</h1>
<%
    if (request.getMethod().equals("GET")) {
        String soapEndPoint = "";
        String resourceID = "";
        String epRO = request.getParameter("idepResourceOffering");
	String providerID = request.getParameter("providerID");
        if (epRO != null) {
            // parse the ResourceOffering String to get SOAP
            // endpoint and user's ep resource ID
            ResourceOfferingType offering;
            try {
                JAXBContext jc = JAXBContext.newInstance(
                            "com.sun.identity.liberty.ws.disco.jaxb");
                Unmarshaller unmarshaller = jc.createUnmarshaller();
                Marshaller marshaller = jc.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output",
                                    Boolean.TRUE);
                StreamSource src =
                            new StreamSource(new StringReader(epRO));
                Object o = unmarshaller.unmarshal(src);
                if (o instanceof ResourceOfferingType) {
                    // get resourceID
                    ResourceIDType resourceIDType =
                        ((ResourceOfferingType) o).getResourceID();
                    resourceID = resourceIDType.getValue();
                    // get SOAP end point
                    ServiceInstanceType si =
                        ((ResourceOfferingType) o).getServiceInstance();
                    DescriptionType dt =
                        (DescriptionType) si.getDescription().get(0);
                    soapEndPoint = dt.getEndpoint();
                }
            } catch (Throwable t) {
                t.printStackTrace();
                StringWriter buf = new StringWriter();
                t.printStackTrace(new PrintWriter(buf));
                %>
                    ERROR: caught exception:
                    <pre><%= SAMLUtils.displayXML(buf.toString()) %></pre>
                <%
            }
        }
%>
        <form method="POST">
            <table>
                <tr>
                    <td>User's Employee Profile Service Resource ID</td>
                    <td><input type="text" size="20" name="resourceID"
                        value='<%= resourceID %>' /></td>
                </tr>
                <tr>

                    <td>SOAP End Point (for employee profile service)</td>
                    <td><input type="text" size="20" name="soapEndPoint"
                             value='<%= soapEndPoint %>' /></td>
                </tr>
                <tr>
                    <td>XPath Expression</td>
                    <td><input type="text" name="queryStr" value="/EP/EmployeeID" /></td>
                </tr>
                <tr>
                    <td>Value</td>
                    <td><input type="text" name="valueStr" /></td>
                </tr>
            </table>
            <input type="hidden" name="providerID" 
                 value="<%= providerID %>">
            <input type="submit" value="Send EP Modify Request" />
        </form>
<%
    } else {
        String soapEndPoint = request.getParameter("soapEndPoint");
        String queryString = request.getParameter("queryStr");
        String valueString = request.getParameter("valueStr");
        String resourceID = request.getParameter("resourceID");
        String providerID = request.getParameter("providerID");
        if (soapEndPoint == null || soapEndPoint.equals("")) {
            %>ERROR: resource offering missing<%
        } else if (resourceID == null || resourceID.equals("")) {
            %>ERROR: EP resource ID missing<%
        } else {
            try {
                DSTClient client = new DSTClient(soapEndPoint, providerID);
                client.setResourceID(resourceID);
                if ((queryString != null) && !(queryString.equals(""))) {
                    List items = new ArrayList();
                    DSTModification item = new DSTModification();
                    item.setNameSpaceURI("urn:liberty:id-sis-ep:2003-08");
                    item.setSelect(queryString);
                    item.setOverrideAllowed(true);
                    item.setId("modify-item-#1");
                    if ((valueString != null) && !(valueString.equals(""))) {
                         String xml = "<EmployeeID xmlns =\"urn:liberty:id-sis-ep:2003-08\">" +
                                valueString + "</EmployeeID>";
                        List values = new ArrayList();
                        values.add(DSTUtils.parseXML(xml));
                        item.setNewDataValue(values);
                    }
                    items.add(item);
                    DSTModifyResponse response1 = client.modify(items);
                    %>
                        <h2>Got result:</h2>
                        <pre><%= SAMLUtils.displayXML(response1.toString()) %>
                        </pre>
                    <%
                }
            } catch (Throwable t) {
                t.printStackTrace();
                StringWriter buf = new StringWriter();
                t.printStackTrace(new PrintWriter(buf));
                %>
                    ERROR: caught exception:
                    <pre><%= SAMLUtils.displayXML(buf.toString()) %></pre>
                <%
            }
        }
%>
        <p><a href="index.jsp">Return to index.jsp</a></p>
<%
    } 
%>
    <hr/>
    </body>
</html>
