/**
 * $Id: PAOSServer.java,v 1.2 2004/02/05 17:54:55 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

import java.io.*;
import java.net.*;
import com.sun.identity.liberty.ws.idpp.common.IDPPConstants;

public class PAOSServer {

  static String PAOS_VERSION = "ver=\"urn:libety:paos:2003-08\"";
    
  public static void main (String argv[]) {

    if (argv.length != 1) {
      System.out.println("Usage: PAOSServer <destination_url>");
      return;
    }

    URL url = null;

    try {
      url = new URL(argv[0]);
    } catch (MalformedURLException me) {
      me.printStackTrace();
      return;
    }

    URLConnection con = null;
    try {
      con = url.openConnection();
    } catch (IOException ioe1) {
      ioe1.printStackTrace();
      return;
    }

    con.setRequestProperty("Accept", "application/vnd.paos+xml");

    String paosHeaderStr = PAOS_VERSION+"; \""+ IDPPConstants.XMLNS_IDPP+"\"";

    con.setRequestProperty("PAOS", paosHeaderStr);    

    InputStream is = null;
    try {
      is = con.getInputStream();
    } catch (IOException ioe2) {
      ioe2.printStackTrace();
      return;
    }

    BufferedReader in = new BufferedReader(new InputStreamReader(is));

    String inputLine = null;
    String origSOAPmessageID = null;
    String origPAOSmessageID = null;
    String idppItemID = null;
    String timestamp = null;
    boolean flag = true;

    System.out.println("PAOS request from HTTP server side ------------>");
    while (flag) {
      try {
	inputLine = in.readLine();
      } catch (IOException ioe3) {
	ioe3.printStackTrace();
	return;
      }
      if (inputLine != null) {
	System.out.println(inputLine);
	int first = inputLine.indexOf("messageID=");
	int space1 = inputLine.indexOf(" ", first);
	origSOAPmessageID=inputLine.substring(first+10, space1);
	int second = inputLine.indexOf("itemID=", space1);
	if (second > 0) {
	  int end = inputLine.indexOf(">", second);
	  idppItemID=inputLine.substring(second+7, end);
	}
	int third = inputLine.indexOf("timestamp=");
	if (third > 0) {
	  int end = inputLine.indexOf(">", third);
	  timestamp = inputLine.substring(third+10, end);
	}
      }
      else 
	flag = false;
    }

    try {
      is.close();
    } catch (IOException ioe4) {
      ioe4.printStackTrace();
      return;
    }

    // assume responseConsumerURL is the same
    
    try {
      con = url.openConnection();
    } catch (IOException ioe) {
      ioe.printStackTrace();
      return;
    }
    
    con.setDoOutput(true);
    con.setRequestProperty("Accept", "text/html; application/vnd.paos+xml");
    con.setRequestProperty("PAOS", paosHeaderStr);
    con.setRequestProperty("Content-Type", "application/vnd.paos+xml");

    String response = "<S:Envelope xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:sb=\"urn:liberty:sb:2003-08\"><S:Header><sb:Correlation id=\"SOAPmessageID\" messageID=\"SOAPmessageID\" timestamp="+timestamp+" refToMessageID="+origSOAPmessageID+"></sb:Correlation><sb:Provider S:actor=\"http://schemas.xmlsoap.org/soap/actor/next\" S:mustUnderstand=\"true\" providerID=\"temp\"></sb:Provider></S:Header><S:Body><idpp:QueryResponse id=\"idppQueryResponseID\" xmlns:idpp=\""+IDPPConstants.XMLNS_IDPP+"\"><idpp:Status code=\"idpp:ok\"></idpp:Status><idpp:Data itemIDRef="+idppItemID+"><idpp:Birthday>-05-09</idpp:Birthday></idpp:Data></idpp:QueryResponse></S:Body></S:Envelope>";

    System.out.println("PAOS response to HTTP server side ------------>");
    System.out.println(response);

    try {
      PrintWriter out = new PrintWriter(con.getOutputStream());
      out.println(response);
      out.close();
    
      in = new BufferedReader(new InputStreamReader(con.getInputStream()));
      
      System.out.println("HTTP response from HTTP server side ------------>");
      while ((inputLine = in.readLine()) != null)
	System.out.println(inputLine);
      
      in.close();
    } catch (Exception exception) {
      exception.printStackTrace();
    }
  }
}

