/**
 * $Id: LogSample.java,v 1.2 2004/02/05 17:54:54 vs125812 Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

import java.io.*;
import java.util.*;

import com.iplanet.sso.SSOTokenManager;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOException;

import com.sun.identity.log.Logger;
import com.sun.identity.log.LogRecord;

public class LogSample {

    private static String USAGE =
	"Usage: LogSample -u <userSessionID> -n <logName> -m <message>" + 
        " -l <loggedBySessionID>";
    static final int INVALID = 0;
    static final int USER_SID = 1;
    static final int LOG_NAME = 2;
    static final int MESSAGE = 3;
    static final int LOGGED_BY_SID = 4;
    static Map OPTIONS = new HashMap();
    
    static {
        OPTIONS.put("-u", new Integer(USER_SID));
        OPTIONS.put("-n", new Integer(LOG_NAME));
        OPTIONS.put("-m", new Integer(MESSAGE));
        OPTIONS.put("-l", new Integer(LOGGED_BY_SID));
    }
    private static int getToken(String arg) {
        try {
            return(((Integer)OPTIONS.get(arg)).intValue());
        } catch (Exception e) {
            return 0;
        }
    }
    private static void showUsage() {
        System.err.println(USAGE);
        System.exit(1);
    }

    public static void main(String[] args) {
        
	if (args.length == 0) {
            showUsage();
        }
        int userSID = 0;
        int logName = 0;
        int message = 0;
        int loggedBySID = 0;
        int i = 0;
        while (i < args.length) {
            int opt = getToken(args[i]);

            switch(opt) {
                case USER_SID:
                    i++;
                    userSID = i;
                    break;
                case LOG_NAME:
                    i++;
                    logName = i;
                    break;
                case MESSAGE:
                    i++;
                    message = i;
                    break;
                case LOGGED_BY_SID:
                    i++;
                    loggedBySID = i;
                    break;
                default:
                    showUsage();
            }
            i++;
        }
        
        if (logName == 0 ) {
            System.err.println("LogSample: logName is null");
            showUsage();
        }
        if (loggedBySID == 0 ) {
            System.err.println("LogSample: loggedBySessionID is null");
            showUsage();
        }
        try {
            SSOTokenManager manager = SSOTokenManager.getInstance();
        
            LogRecord logRecord = null;
            if(userSID == 0) {
                logRecord = new LogRecord(java.util.logging.Level.INFO, args[message]);
            } else {
                SSOToken userToken = manager.createSSOToken(args[userSID]);
                logRecord = new LogRecord(java.util.logging.Level.INFO, args[message], userToken);
            }

            logRecord.addLogInfo("ModuleName", "MyModule");
        
            SSOToken loggedByToken = manager.createSSOToken(args[loggedBySID]);
            Logger logger = (Logger)Logger.getLogger(args[logName]);
            logger.log(logRecord, loggedByToken);

            System.out.println("LogSample: Logging Successful !!!");
        
            System.exit(0);
        } catch (SSOException ssoe) {
            System.err.println("LogSample: SSOException: " + ssoe.getMessage());
            System.err.println("LogSample: Logging Failed !!!");
        }
    }
}
